/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.action.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import jp.morpho.config.Configuration;
import jp.morpho.util.ConversionList;
import jp.morpho.util.PrimitiveHolderList;
import jp.morpho.webapp.PluginContext;
import jp.morpho.webapp.PluginException;
import jp.morpho.webapp.action.AbstractActionMappingManager;
import jp.morpho.webapp.action.ActionHandler;
import jp.morpho.webapp.action.ActionHandlerChain;
import jp.morpho.webapp.action.ActionMappingNotFoundException;
import jp.morpho.webapp.action.impl.ActionHandlerChainImpl;
import jp.morpho.webapp.action.impl.ActionHandlerEntry;
import jp.morpho.webapp.action.impl.ActionServletPath;
import jp.morpho.webapp.action.impl.ActionViewEntry;
import jp.morpho.webapp.servlet.http.HttpActionRequest;

public class ActionMappingManagerImpl
extends AbstractActionMappingManager {
    Logger log;
    private PluginContext pluginContext;
    private PrimitiveHolderList configPathList;
    private String statusParameterName;
    private String actionParameterName;
    private Map actionServletPaths;
    private String actionRequestFactoryName;
    private String actionResponseFactoryName;
    static /* synthetic */ Class class$0;

    public ActionMappingManagerImpl() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.morpho.webapp.action.impl.ActionMappingManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = Logger.getLogger(clazz.getName());
        this.pluginContext = null;
        this.configPathList = new ConversionList();
        this.statusParameterName = null;
        this.actionParameterName = null;
        this.actionServletPaths = new HashMap();
    }

    public synchronized void removeAllConfigurationFilePaths() {
        this.configPathList.clear();
    }

    public synchronized void addConfigurationFilePath(String path) {
        this.configPathList.add(path);
    }

    public synchronized String[] getConfigurationFilePaths() {
        String[] paths = new String[this.configPathList.size()];
        return this.configPathList.toArray(paths);
    }

    public synchronized String getStatusParameterName() {
        return this.statusParameterName;
    }

    public synchronized void setStatusParameterName(String statusParameterName) {
        this.statusParameterName = statusParameterName;
    }

    public synchronized String getActionParameterName() {
        return this.actionParameterName;
    }

    public synchronized void setActionParameterName(String actionParameterName) {
        this.actionParameterName = actionParameterName;
    }

    public synchronized void setActionRequestFactory(String name) {
        this.actionRequestFactoryName = name;
    }

    public synchronized void setActionResponseFactory(String name) {
        this.actionResponseFactoryName = name;
    }

    public synchronized ActionHandlerChain getActionHandlerChain(HttpActionRequest request) {
        return new ActionHandlerChainImpl(this, request);
    }

    public synchronized ActionHandler[] getActionHandlers(HttpActionRequest request) throws ActionMappingNotFoundException {
        ActionServletPath asp = this.getActionServletPath(request);
        if (asp == null) {
            return new ActionHandler[0];
        }
        ActionHandlerEntry entry = asp.getActionHandlerEntry(request.getStatus(), request.getAction());
        if (entry == null || entry.size() == 0) {
            return new ActionHandler[0];
        }
        ArrayList<ActionHandler> actionHandlers = new ArrayList<ActionHandler>();
        int i = 0;
        while (i < entry.size()) {
            String className = (String)entry.get(i);
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = this.getClass().getClassLoader();
                }
                actionHandlers.add((ActionHandler)cl.loadClass(className).newInstance());
            }
            catch (Exception e) {
                this.log.warning("ActionHandler class not found: " + className);
                String string = "ActionHandler class not found: " + className;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("jp.morpho.webapp.action.impl.ActionMappingManagerImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ActionMappingNotFoundException(string, clazz.getName());
            }
            ++i;
        }
        return actionHandlers.toArray(new ActionHandler[actionHandlers.size()]);
    }

    public synchronized String getActionView(HttpActionRequest request) throws ActionMappingNotFoundException {
        ActionServletPath asp = this.getActionServletPath(request);
        if (asp == null) {
            StringBuffer msg = new StringBuffer();
            msg.append("servletPath not found: ");
            msg.append("servletPath=");
            msg.append(this.getRelativePath(request));
            msg.append(",status=");
            msg.append(request.getStatus());
            String string = msg.toString();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.morpho.webapp.action.impl.ActionMappingManagerImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new ActionMappingNotFoundException(string, clazz.getName());
        }
        ActionViewEntry entry = asp.getActionViewEntry(request.getStatus());
        if (entry == null) {
            StringBuffer msg = new StringBuffer();
            msg.append("ActionViewEntry not found: ");
            msg.append("servletPath=");
            msg.append(this.getRelativePath(request));
            msg.append(",status=");
            msg.append(request.getStatus());
            String string = msg.toString();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.morpho.webapp.action.impl.ActionMappingManagerImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new ActionMappingNotFoundException(string, clazz.getName());
        }
        String path = entry.getPath();
        this.log.finest("ActionView[ServletPath=" + this.getRelativePath(request) + ", Status=" + request.getStatus() + "]=" + path);
        return path;
    }

    public synchronized void addActionServletPath(ActionServletPath asp) {
        String key = asp.getServletPath();
        if (this.actionServletPaths.containsKey(key)) {
            throw new IllegalArgumentException("ActionServletPath already exists: " + key);
        }
        this.actionServletPaths.put(key, asp);
    }

    public synchronized ActionServletPath getActionServletPath(HttpActionRequest request) {
        String servletPath = this.getRelativePath(request);
        String[] paths = new String[this.actionServletPaths.size()];
        paths = this.actionServletPaths.keySet().toArray(paths);
        int i = 0;
        while (i < paths.length) {
            String path = paths[i];
            if (path.endsWith("*")) {
                String starts = path.substring(0, path.length() - 1);
                if (servletPath.startsWith(starts)) {
                    this.log.finest("ActionServletPath[servletPath=" + servletPath + ", match=" + path + "]");
                    return (ActionServletPath)this.actionServletPaths.get(path);
                }
            } else if (path.equals(servletPath)) {
                this.log.finest("ActionServletPath[servletPath=" + servletPath + ", match=" + path + "]");
                return (ActionServletPath)this.actionServletPaths.get(path);
            }
            ++i;
        }
        this.log.finest("ActionServletPath[servletPath=" + servletPath + ", match=null]");
        return null;
    }

    protected String getRelativePath(HttpActionRequest request) {
        String servletPath = null;
        servletPath = request.getAttribute("javax.servlet.include.request_uri") != null ? (String)request.getAttribute("javax.servlet.include.servlet_path") : request.getServletPath();
        if (servletPath == null || servletPath.equals("")) {
            servletPath = "/";
        }
        return servletPath;
    }

    public void setPluginContext(PluginContext fc) throws PluginException {
        this.pluginContext = fc;
    }

    public void pluginActivate() throws PluginException {
        ServletContext sc = this.pluginContext.getFrameworkContext().getServletContext();
        String[] paths = this.getConfigurationFilePaths();
        int i = 0;
        while (i < paths.length) {
            Exception e3;
            Object var7_8;
            InputStream in = null;
            try {
                try {
                    URL url = sc.getResource(paths[i]);
                    in = url.openStream();
                    Configuration config = new Configuration();
                    config.configure(this, in);
                }
                catch (Exception e2) {
                    this.log.log(Level.WARNING, e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                var7_8 = null;
                try {
                    in.close();
                }
                catch (Exception e3) {
                    // empty catch block
                }
                throw throwable;
            }
            var7_8 = null;
            try {
                in.close();
            }
            catch (Exception e3) {
                // empty catch block
            }
            ++i;
        }
        sc.setAttribute("jp.morpho.webapp.servlet.ServletContext.actionRequestFactory", (Object)this.actionRequestFactoryName);
        sc.setAttribute("jp.morpho.webapp.servlet.ServletContext.actionResponseFactory", (Object)this.actionResponseFactoryName);
    }

    public void pluginRemove() throws PluginException {
        this.pluginContext = null;
    }
}

