/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jp.morpho.util.Coder;

public class CoderOutputStream
extends FilterOutputStream {
    private Coder coder = null;

    public CoderOutputStream(OutputStream out, Coder coder) {
        super(out);
        this.coder = coder;
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public void flush() throws IOException {
        byte[] coded = null;
        try {
            coded = this.coder.doFinal();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        if (coded != null) {
            this.out.write(coded);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        byte[] coded = null;
        try {
            coded = this.coder.update(b, off, len);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        if (coded != null) {
            this.out.write(coded);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }
}

