/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.morpho.webapp.FrameworkContext;
import jp.morpho.webapp.resource.MessageResourceManager;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.validator.FieldValidator;
import jp.morpho.webapp.validator.FieldValidatorEntry;
import jp.morpho.webapp.validator.FieldValidatorList;
import jp.morpho.webapp.validator.ValidationException;
import jp.morpho.webapp.validator.ValidationState;
import jp.morpho.webapp.validator.ValidatorException;

public class ValidatorSequence
extends ArrayList
implements FieldValidatorList {
    Logger log;
    private String name;
    static /* synthetic */ Class class$0;

    public ValidatorSequence() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.morpho.webapp.validator.ValidatorSequence");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = Logger.getLogger(clazz.getName());
        this.name = null;
    }

    public void setFieldName(String name) {
        this.name = name;
    }

    public String getFieldName() {
        return this.name;
    }

    public void validate(HttpActionRequest request) throws ValidationException, ValidatorException {
        int errorCount = 0;
        String errorFieldName = null;
        String validatorName = null;
        int i = 0;
        while (i < this.size()) {
            block8: {
                FieldValidatorEntry entry = (FieldValidatorEntry)this.get(i);
                FieldValidator validator = entry.getValidator();
                String messageId = entry.getMessageId();
                try {
                    validator.validate(request);
                }
                catch (ValidationException e) {
                    this.log.log(Level.FINEST, "Validation error", e);
                    ++errorCount;
                    errorFieldName = validator.getFieldName();
                    validatorName = validator.getClass().getName();
                    if (validator.getFieldName() == null) break block8;
                    String message = null;
                    if (messageId != null) {
                        message = this.getMessage(request, validator, messageId);
                    }
                    ValidationState vs = ValidationState.getInstance(request);
                    vs.addInvalidField(validator.getFieldName(), message);
                }
            }
            ++i;
        }
        if (errorCount > 0) {
            String string = "Validation error count: " + errorCount;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.morpho.webapp.validator.ValidatorSequence");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new ValidationException(string, clazz.getName());
        }
    }

    private String getMessage(HttpActionRequest request, FieldValidator validator, String messageId) {
        try {
            FrameworkContext fc = FrameworkContext.getInstance(request.getSession().getServletContext());
            MessageResourceManager mrm = (MessageResourceManager)fc.get("jp.morpho.webapp.resource.MessageResourceManager");
            Locale locale = (Locale)request.getSession().getAttribute("jp.morpho.webapp.servlet.http.HttpSession.locale");
            if (locale == null) {
                locale = request.getLocale();
            }
            String message = mrm.getMessage(messageId, null, locale);
            Pattern formatPattern = Pattern.compile("[{][^}]*[}]");
            Matcher formatMatcher = formatPattern.matcher(message);
            StringBuffer messageBuf = new StringBuffer();
            ArrayList<Object> messageArgList = new ArrayList<Object>();
            int j = 0;
            while (formatMatcher.find()) {
                String format = message.substring(formatMatcher.start(), formatMatcher.end());
                Pattern fieldPattern = Pattern.compile("[^{][^,}]*");
                Matcher fieldMatcher = fieldPattern.matcher(format);
                fieldMatcher.find();
                String argumentName = format.substring(fieldMatcher.start(), fieldMatcher.end()).trim();
                String messageFormat = fieldMatcher.replaceFirst("" + j);
                formatMatcher.appendReplacement(messageBuf, messageFormat);
                String methodName = "get";
                if (argumentName.length() == 1) {
                    methodName = String.valueOf(methodName) + argumentName.toUpperCase();
                } else if (argumentName.length() > 1) {
                    methodName = String.valueOf(methodName) + argumentName.substring(0, 1).toUpperCase() + argumentName.substring(1);
                }
                Method method = validator.getClass().getMethod(methodName, null);
                Object messageArg = method.invoke((Object)validator, null);
                if (argumentName.equalsIgnoreCase("fieldName") || argumentName.equalsIgnoreCase("compareFieldName")) {
                    messageArg = mrm.getFieldName((String)messageArg, locale);
                } else if (argumentName.equalsIgnoreCase("compareOperator")) {
                    messageArg = mrm.getMessage("validator.compareOperator." + (String)messageArg, null, locale);
                }
                messageArgList.add(messageArg);
                ++j;
            }
            if (messageArgList.size() > 0) {
                formatMatcher.appendTail(messageBuf);
                MessageFormat mf = new MessageFormat(messageBuf.toString());
                message = mf.format(messageArgList.toArray());
            }
            return message;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }
}

