/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.config;

import java.io.InputStream;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * <P>
 * Υ饹ϡһҤѤƥ֥Ȥޤ
 * ֥ȤˤϡXML ǵҤ줿һҤϥȥ꡼ȷ֥ȤϤơconfigure ᥽åɤƤӽФޤ
 * </P>
 * <P>
 * Υ饹ϡһҤ˵Ҥ줿Ȥ˥֥ȤΥ᥽åɤƤӽФꡢ֥Ȥ뤳Ȥˤꡢconfigure ᥽åɤϤ줿֥Ȥޤ
 * </P>
 * @author Kumiko Hiroi
 */
public class Configuration
	extends DefaultHandler
{

	/** ȥåץ٥ΥΡɡ̾ configure ΥΡ */
	private Node topNode = null;

	/** ɤ߹ΥΡ */
	private Node currentNode = null;

	/** SAX ѡ */
	private SAXParser parser;

	/**
	 * <P>
	 * Configuration ֥Ȥޤ
	 * </P>
	 * @param validating ѡ XML ɥȤ򸡾ڤ褦ꤵƤ trueǤʤ false
	 */
	public Configuration(boolean validating)
	{
		try
		{
			SAXParserFactory factory = SAXParserFactory.newInstance();
			factory.setValidating(validating);
			parser = factory.newSAXParser();
		}
		catch (Exception e)
		{
			throw new Error(e.toString());
		}
	}

	/**
	 * <P>
	 * Configuration ֥Ȥޤ
	 * </P>
	 */
	public Configuration()
	{
		this(true);
	}

	/**
	 * <P>
	 * XML һҤѤƥ֥Ȥޤ
	 * </P>
	 * @param obj 륪֥
	 * @param in XML һҤϥȥ꡼
	 * @exception ConfigureException ֥ȤǤʤä
	 */
	public void configure(Object obj, InputStream in) throws ConfigureException
	{
		try
		{
			parser.parse(in, this);
//			configure(obj, topNode, 0);
			topNode.configure(obj, 0);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ConfigureException(e);
		}
	}

	/**
	 * <P>
	 * ǤγΤޤ
	 * </P>
	 * <P>
	 * μˤꡢƼΡɤޤ
	 * </P>
	 * @param uri ̾ URI
	 * @param localName ֽҤޤޤʤֽ̾̾Ԥʤ϶ʸ
	 * @param qName ֽҤĽ̾̾ѤǤʤ϶ʸ
	 * @param attributes ꤵ줿°ޤϥǥեȤ°
	 * @exception SAXException SAX 㳰ۤ㳰åפƤǽ
	 */
	public void startElement(String uri, String localName, String qName, Attributes attributes)
		throws SAXException
	{
		try
		{
			String name = (uri == null || uri.equals("")) ? qName : localName;
			int tag = NodeTypes.getTag(name);
			Node node = null;
			switch (tag)
			{
				case NodeTypes.SET:
					node = new SetNode(currentNode, attributes);
					break;
				case NodeTypes.GET:
					node = new GetNode(currentNode, attributes);
					break;
				case NodeTypes.CALL:
					node = new CallNode(currentNode, attributes);
					break;
				case NodeTypes.PUT:
					node = new PutNode(currentNode, attributes);
					break;
				case NodeTypes.NEW:
					node = new NewNode(currentNode, attributes);
					break;
				case NodeTypes.ARG:
					node = new ArgNode(currentNode, attributes);
					break;
				case NodeTypes.SYSTEMPROPERTY:
					node = new SystemPropertyNode(currentNode, attributes);
					break;
				case NodeTypes.CONFIGURE:
					node = new ConfigureNode(currentNode, attributes);
					break;
				case NodeTypes.ADD:
					node = new AddNode(currentNode, attributes);
					break;
			}
			if (topNode == null)
			{
				topNode = node;
			}
			else
			{
				currentNode.add(node);
			}
			currentNode = node;
		}
		catch (Exception e)
		{
			throw new SAXException(e);
		}
	}

	/**
	 * <P>
	 * ǤνλΤޤ
	 * </P>
	 * @param uri ̾ URI
	 * @param localName ֽҤޤޤʤֽ̾̾Ԥʤ϶ʸ
	 * @param qName ֽҤ XML 1.0 ̾̾ѤǤʤ϶ʸ
	 * @exception SAXException SAX 㳰ۤ㳰åפƤǽ
	 */
	public void endElement(String uri, String localName, String qName) throws SAXException
	{
		currentNode = currentNode.getParent();
	}

	/**
	 * <P>
	 * ʸǡΤޤ
	 * </P>
	 * <P>
	 * ʸǡꡢΡɤ˳Ǽޤ
	 * </P>
	 * @param ch ʸ
	 * @param start ʸγϰ
	 * @param length ʸ󤫤Ѥʸ
	 * @exception SAXException SAX 㳰ۤ㳰åפƤǽ
	 */
	public void characters(char[] ch, int start, int length) throws SAXException
	{
		currentNode.add(new String(ch, start, length));
	}
}
