/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

import org.xml.sax.Attributes;

/**
 * <P>
 * SetNode 饹ϡset ɽޤ
 * set ˤϡ#PCDATA call new  SystemProperty ޤ뤳ȤǤޤ
 * </P>
 * <P>
 * 㤨 set ϡΤ褦һ˵Ҥޤ
 * </P>
 * <P>
 * <PRE>
 *     &lt;set name="someMethod"&gt;someValue&lt;/set&gt;
 * </PRE>
 * </P>
 * <P>
 * ϡΤ褦ʥɤ񤯤ȤƱǤ
 * </P>
 * <P>
 * <PRE>
 *     obj.setSomeMethod("someValue");
 * </PRE>
 * </P>
 * @author Kumiko Hiroi
 */
public class SetNode extends Node
{
	private String prefix = null;

	/** ץߥƥַ */
	private static Class[] primitiveTypes =
	{
		Boolean.TYPE,
		Character.TYPE,
		Byte.TYPE,
		Short.TYPE,
		Integer.TYPE,
		Long.TYPE,
		Float.TYPE,
		Double.TYPE,
		Void.TYPE
	};

	/** ץߥƥַΥå */
	private static Class[] primitiveWrappers =
	{
		Boolean.class,
		Character.class,
		Byte.class,
		Short.class,
		Integer.class,
		Long.class,
		Float.class,
		Double.class,
		Void.class
	};

	/**
	 * <P>
	 * ƥΡɤȥΡɤ°ꤷ SetNode ֥Ȥޤ
	 * </P>
	 * @param parent ΥΡɤοƥΡ
	 * @param attributes ΥΡɤ°
	 */
	public SetNode(Node parent, Attributes attributes)
	{
		this(parent, attributes, "set");
	}

	/**
	 * <P>
	 * ƥΡɤȥΡɤ°᥽åɤΥץեå (㤨 set) ꤷ SetNode ֥Ȥޤ
	 * Υ󥹥ȥ饯ϡSetNode 饹Ʊ褦ư򤹤륵֥饹ͭǤ
	 * </P>
	 * @param parent ΥΡɤοƥΡ
	 * @param attributes ΥΡɤ°
	 * @param prefix ᥽åɤΥץեå (㤨 set)
	 */
	protected SetNode(Node parent, Attributes attributes, String prefix)
	{
		super(parent, attributes);
		this.prefix = prefix;
	}

	/**
	 * <P>
	 * ֤ͤޤ
	 * </P>
	 * @return 
	 * @see jp.morpho.config.Node#getTag()
	 */
	public int getTag()
	{
		return NodeTypes.SET;
	}

	/**
	 * <P>
	 * ꤵ줿֥Ȥޤ
	 * 饹ˤ褦ˡ֥ obj  set ᥽åɤƤӽФޤ
	 * </P>
	 * @param obj 륪֥
	 * @return 줿֥
	 * @exception ConfigureException ֥ȤǤʤä
	 * @see jp.morpho.config.Node#configure(Object)
	 */
	public Object configure(Object obj) throws ConfigureException
	{
		try
		{
			String name = getNodeName();
			String methodName = prefix + name;
			Object value = getValue(obj);
			Object[] arg = { value };

			Class objCls = getNodeClass();
			if (objCls != null)
			{
				obj = null;
			}
			else
			{
				objCls = obj.getClass();
			}

			Class[] argCls = { Object.class };
			if (value != null)
			{
				argCls[0] = value.getClass();
			}

			try
			{
				Method method = objCls.getMethod(methodName, argCls);
				method.invoke(obj, arg);
				return null;
			}
			catch (IllegalArgumentException e)
			{
			}
			catch (IllegalAccessException e)
			{
			}
			catch (NoSuchMethodException e)
			{
			}

			try
			{
				Field type = argCls[0].getField("TYPE");
				argCls[0] = (Class) type.get(null);
				Method method = objCls.getMethod(methodName, argCls);
				method.invoke(obj, arg);
				return null;
			}
			catch (NoSuchFieldException e)
			{
			}
			catch (IllegalArgumentException e)
			{
			}
			catch (IllegalAccessException e)
			{
			}
			catch (NoSuchMethodException e)
			{
			}

			Method[] methods = objCls.getMethods();
			Method method = null;
			for (int s = 0; methods != null && s < methods.length; s++)
			{
				if (methodName.equals(methods[s].getName()) && methods[s].getParameterTypes().length == 1)
				{
					try
					{
						method = methods[s];
						methods[s].invoke(obj, arg);
						return null;
					}
					catch (IllegalArgumentException e)
					{
					}
					catch (IllegalAccessException e)
					{
					}
				}
			}

			if (method != null)
			{
				try
				{
					Class paramCls = method.getParameterTypes()[0];
					if (paramCls.isPrimitive())
					{
						for (int t = 0; t < primitiveTypes.length; t++)
						{
							if (paramCls.equals(primitiveTypes[t]))
							{
								paramCls = primitiveWrappers[t];
								break;
							}
						}
					}
					Constructor cons = paramCls.getConstructor(argCls);
					arg[0] = cons.newInstance(arg);
					method.invoke(obj, arg);
					return null;
				}
				catch (NoSuchMethodException e)
				{
				}
				catch (IllegalAccessException e)
				{
				}
				catch (InstantiationException e)
				{
				}
			}

			throw new NoSuchMethodException(objCls + "." + methodName + "(" + argCls[0] + ")");
		}
		catch (Exception e)
		{
			throw new ConfigureException(e);
		}
	}

}
