/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.action.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * <P>
 * Υ饹ϡ׵륵֥åȤΥѥΥȥɽޤ
 * ֥åȤ׵äݤˡǤդΥޥåԥ󥰤򤵤褦ˤ뤿ˡޥåԥ󥰥ޥ͡ˤΥȥɲäޤ
 * </P>
 * <P>
 * ֥åȤ׵äݤˡǤդΥޥåԥ󥰤򤵤褦ˤ뤿ˡ2 ĤΥ᥽å  addActionHandlerEntry(ActionHandlerEntry) addActionViewEntry(ActionViewEntry) Ѥƥȥɲäɬפޤ
 * Ԥ׵륢ϥɥΥȥɲäԤ׵ɽ̤ɽӥ塼Υȥɲäޤ
 * </P>
 * <P>
 * setServletPath(String) ᥽åɤǻꤹ륵֥åȤ URL ϡweb.xml ˤ֤֥åȤ URL  Ǥ
 * </P>
 * @author Kumiko Hiroi
 */
public class ActionServletPath
	implements Serializable
{
	/** null Υޥåԥ󥰤б URL */
	private static final String NULL_SERVLETPATH = "";

	/** null Υơ */
	private static final String NULL_STATUS = "";

	/** null Υ */
	private static final String NULL_ACTION = "";

	/** ޥåԥ󥰤б URL */
	private String servletPath = null;

	/** ϥɥ饨ȥΥޥå */
	private Map actionHandlerEntries = new HashMap();

	/** ӥ塼ȥΥޥå */
	private Map actionViewEntries = new HashMap();

	/**
	 * <P>
	 * ActionServletPath ޤ
	 * </P>
	 */
	public ActionServletPath()
	{
		super();
	}

	/**
	 * <P>
	 * ޥåԥ󥰤б륵֥åȤ URL ޤ
	 * </P>
	 * @return ޥåԥ󥰤б륵֥åȤ URL
	 */
	public synchronized String getServletPath()
	{
		return (servletPath != null) ? servletPath : NULL_SERVLETPATH;
	}

	/**
	 * <P>
	 * ޥåԥ󥰤б륵֥åȤ URL ꤷޤ
	 * </P>
	 * @param servletPath ޥåԥ󥰤б륵֥åȤ URL
	 */
	public synchronized void setServletPath(String servletPath)
	{
		this.servletPath = servletPath;
	}

	/**
	 * <P>
	 * ǤƱΥϥɥ饨ȥ꤬ɲäƤ뤫ɤȽꤷޤ
	 * ϥɥ饨ȥΥޥåפΥΥޥåԥ󥰤ݻ硢㳰 IllegalArgumentException 򥹥ޤ
	 * </P>
	 * @param key ޥåפˤ뤫ɤȽꤵ륭
	 * @exception IllegalArgumentException ϥɥ饨ȥΥޥåפΥΥޥåԥ󥰤ݻƤ
	 */
	private synchronized void checkActionHandlerMapping(String key)
	{
		if (actionHandlerEntries.containsKey(key))
		{
			throw new IllegalArgumentException("ActionHandlerEntry Mapping Key already exists: " + key);
		}
	}

	/**
	 * <P>
	 * ǤƱΥӥ塼ȥ꤬ɲäƤ뤫ɤȽꤷޤ
	 * ӥ塼ȥΥޥåפΥΥޥåԥ󥰤ݻ硢㳰 IllegalArgumentException 򥹥ޤ
	 * </P>
	 * @param key ޥåפˤ뤫ɤȽꤵ륭
	 * @exception IllegalArgumentException ӥ塼ȥΥޥåפΥΥޥåԥ󥰤ݻƤ
	 */
	private synchronized void checkActionViewMapping(String key)
	{
		if (this.actionViewEntries.containsKey(key))
		{
			throw new IllegalArgumentException("ActionViewEntry Mapping Key already exists: " + key);
		}
	}

	/**
	 * <P>
	 * ꤵ줿ϥɥ饨ȥɲäޤ
	 * </P>
	 * @param entry ɲä륢ϥɥ饨ȥ
	 */
	public synchronized void addActionHandlerEntry(
		ActionHandlerEntry entry)
	{
		String key = generateActionHandlerMappingKey(entry.getStatus(), entry.getAction());
		checkActionHandlerMapping(key);
		actionHandlerEntries.put(key, entry);
	}

	/**
	 * <P>
	 * ϥɥ饨ȥޤ
	 * </P>
	 * @param status ׵륹ơ
	 * @param action ׵륢
	 * @return ϥɥ饨ȥꡣ줬ʤ null
	 */
	public synchronized ActionHandlerEntry getActionHandlerEntry(
		String status, String action)
	{
		return (ActionHandlerEntry)actionHandlerEntries.get(generateActionHandlerMappingKey(status, action));
	}

	/**
	 * <P>
	 * ꤵ줿ӥ塼ȥɲäޤ
	 * </P>
	 * @param entry ɲä륢ӥ塼ȥ
	 */
	public synchronized void addActionViewEntry(
		ActionViewEntry entry)
	{
		String key = generateActionViewMappingKey(entry.getStatus());
		checkActionViewMapping(key);
		actionViewEntries.put(key, entry);
	}

	/**
	 * <P>
	 * ӥ塼ȥޤ
	 * </P>
	 * @param status ׵륹ơ
	 * @return ӥ塼ȥꡣ줬ʤ null
	 */
	public synchronized ActionViewEntry getActionViewEntry(String status)
	{
		return (ActionViewEntry)actionViewEntries.get(generateActionViewMappingKey(status));
	}

	/**
	 * <P>
	 * ϥɥ饨ȥޥåץ֥Ȥ˴Ϣդ뤿Υޤ
	 * </P>
	 * <P>
	 * ϼΤ褦ʥޤ
	 * <CODE>
	 * ActionHandlerEntry[status=<I>ơ</I>,action=<I></I>]
	 * </CODE>
	 * </P>
	 * @param status ׵륹ơ
	 * @param action ׵륢
	 * @return ϥɥ饨ȥΥ
	 */
	public synchronized String generateActionHandlerMappingKey(String status, String action)
	{
		StringBuffer buf = new StringBuffer();
		buf.append("ActionHandlerEntry[");
		buf.append("status=").append((status != null) ? status : NULL_STATUS);
		buf.append(",");
		buf.append("action=").append((action != null) ? action : NULL_ACTION);
		buf.append("]");

		return buf.toString();
	}

	/**
	 * <P>
	 * ӥ塼ȥޥåץ֥Ȥ˴Ϣդ뤿Υޤ
	 * </P>
	 * <P>
	 * ϼΤ褦ʥޤ
	 * <CODE>
	 * ActionViewEntry[status=<I>ơ</I>]
	 * </CODE>
	 * </P>
	 * @param status ׵륹ơ
	 * @return ӥ塼ȥΥ
	 */
	public synchronized String generateActionViewMappingKey(String status)
	{
		StringBuffer buf = new StringBuffer();
		buf.append("ActionViewEntry[");
		buf.append("status=").append((status != null) ? status : NULL_STATUS);
		buf.append("]");

		return buf.toString();
	}

}
