/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.impl;

import jp.morpho.webapp.FrameworkContext;
import jp.morpho.webapp.PluginContext;

/**
 * <P>
 * PluginContext μǤ
 * PluginContext 󥿥եϡե졼ץ饰󥤥󥹥󥹤󶡤¹Իץ饰󥳥ƥȤ˥Ǥ褦ˤޤ
 * FrameworkContext ˥ץ饰Υ󥹥󥹤ɲäȡե졼 PluginContext 󥿥ե򤽤Υ󥹥󥹤Ϥޤ
 * </P>
 * @author Kenichi Fukuda
 */
public class PluginContextImpl implements PluginContext
{
	/** 󥹥󥹤ɲä FrameworkContext ֥ */
	private FrameworkContext fc = null;

	/**
	 * <P>
	 * PluginContextImpl ۤޤ
	 * </P>
	 */
	public PluginContextImpl()
	{
		super();
	}

	/**
	 * <P>
	 * 󥹥󥹤ɲä FrameworkContext ֥ȤؤλȤޤ
	 * </P>
	 * <P>
	 * ץ饰Υ󥹥󥹤ǤϡpluginActivate() ᥽åɤ pluginRemove() ᥽åɤޤǤδ (pluginActivate() ᥽åɤ pluginRemove() ᥽åɤޤ) ΤĤǤ⤳Υ᥽åɤƤӽФȤǤޤ
	 * </P>
	 * @return Υ󥹥󥹤ɲä FrameworkContext ֥
	 * @see jp.morpho.webapp.PluginContext#getFrameworkContext()
	 */
	public synchronized FrameworkContext getFrameworkContext()
	{
		return fc;
	}

	/**
	 * <P>
	 * 󥹥󥹤ɲä FrameworkContext ֥ȤؤλȤꤷޤ
	 * </P>
	 * @param fc Υ󥹥󥹤ɲä FrameworkContext ֥
	 */
	public synchronized void setFrameworkContext(FrameworkContext fc)
	{
		this.fc = fc;
	}

}
