/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Logger;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import jp.morpho.io.OutputStreamFactory;
import jp.morpho.io.UploadFile;
import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.FrameworkContext;
import jp.morpho.webapp.FrameworkException;
import jp.morpho.webapp.PluginKeys;
import jp.morpho.webapp.action.ActionMappingManager;
import jp.morpho.webapp.servlet.http.HttpActionRequest;

/**
 * <P>
 * ֥åȤؤ׵ᤫեǡޤ
 * </P>
 * @author Kumiko Hiroi
 */
public class FormDataParseFilter
	extends AbstractFilter
{
	/**  */
	private Logger log = Logger.getLogger("jp.morpho");

	/** ʸ "multipart/form-data" */
	private static final String CONST_MULTIPART_FORM_DATA = "multipart/form-data";

	/** ʸ "boundary=" */
	private static final String CONST_BOUNDARY = "boundary=";

	/** ʸ "content-disposition:" */
	private static final String CONST_CONTENT_DISPOSITION = "content-disposition:";

	/** ʸ "name=" */
	private static final String CONST_NAME = "name=";

	/** ʸ "filename=" */
	private static final String CONST_FILENAME = "filename=";

	/** ʸ "content-type:" */
	private static final String CONST_CONTENT_TYPE = "content-type:";

	/** åץɥǥ쥯ȥ */
	private static final String INITPARAM_UPLOADDIRECTORY = "uploadDirectory";

	/** ʸ󥨥󥳡ǥ */
	private static final String DEFAULT_CHARACTERENCODING = "ISO8859_1";

	/**
	 * <P>
	 * FormDataParseFilter ۤޤ
	 * </P>
	 */
	public FormDataParseFilter()
	{
		super();
	}

	/**
	 * <P>
	 * ֥åȤؤ׵ᤫեǡޤ
	 * </P>
	 * @param request 饤Ȥ֥åȤ˹Ԥ׵ޤ ServletRequest ֥
	 * @param response ֥åȤ饤Ȥޤ ServletResponse ֥
	 * @param chain ե륿
	 * @exception IOException ե륿׵Ȥˡϥ顼Ф줿
	 * @exception ServletException ׵Ǥʤä
	 * @see javax.servlet.Filter#doFilter(ServletRequest, ServletResponse, FilterChain)
	 */
	public void doFilter(
		ServletRequest request,
		ServletResponse response,
		FilterChain chain)
		throws IOException, ServletException
	{
		log.fine("doFilter");
		HttpActionRequest actioinRequest = new HttpActionRequest((HttpServletRequest)request);

		String contentType = request.getContentType();
		int contentLength = request.getContentLength();

		try
		{
			if (contentType == null || !contentType.toLowerCase().startsWith(CONST_MULTIPART_FORM_DATA))
			{
				getParameters(actioinRequest);
			}
			else
			{
				parseMultipartFormData(actioinRequest);
			}

			FrameworkContext fc = FrameworkContext.getInstance(this.getServletContext());
			ActionMappingManager amm = (ActionMappingManager)fc.get(PluginKeys.actionMappingManager);

			//ơȥ
			String status = ((ConversionMap)actioinRequest.getParameterMap()).getString(amm.getStatusParameterName());
			String action = ((ConversionMap)actioinRequest.getParameterMap()).getString(amm.getActionParameterName());

			//ơ򹹿
			actioinRequest.setStatus(status);

			//HttpServletRequest˥ꤹ
			actioinRequest.setAction(action);

			//ơȥեࡦѥ᡼
			((ConversionMap)actioinRequest.getParameterMap()).remove(amm.getStatusParameterName());
			((ConversionMap)actioinRequest.getParameterMap()).remove(amm.getActionParameterName());
		}
		catch (FrameworkException e)
		{
		}
		catch (Exception e)
		{
		}
		chain.doFilter(request, response);
	}

	/**
	 * <P>
	 * ֥åȤؤ׵ᤫեǡޤ
	 * </P>
	 * <P>
	 * getParameterValues(String) ᥽åɤѤƻꤵ줿׵ᥪ֥Ȥեǡ塢setParameterMap(Map) ᥽åɤƤӽФ׵ᥪ֥Ȥ˥եǡΥޥåפǼޤ
	 * </P>
	 * @param actioinRequest եǡ׵ᥪ֥
	 */
	protected void getParameters(HttpActionRequest actioinRequest)
	{
		ConversionMap formValue = new ConversionMap();

		Enumeration paramNames = actioinRequest.getParameterNames();
		while (paramNames.hasMoreElements())
		{
			String paramName = (String)paramNames.nextElement();
			String[] paramValues = actioinRequest.getParameterValues(paramName);
			if (paramValues.length > 1)
			{
				formValue.setObject(paramName, paramValues);
			}
			else
			{
				formValue.setString(paramName, paramValues[0]);
			}
		}

		actioinRequest.setParameterMap(formValue);
	}

	/**
	 * <P>
	 * ֥åȤؤ׵ᤫեǡޤ
	 * </P>
	 * <P>
	 * եǡΥƥķ multipart/form-data ξˡ׵ᥪ֥Ȥϥȥ꡼ƥեǡޤ
	 * եǡϤ٤ƥޥåפ˳ǼsetParameterMap(Map) ᥽åɤƤӽФ׵ᥪ֥Ȥ˳Ǽޤ
	 * </P>
	 * @param actioinRequest եǡ׵ᥪ֥
	 * @exception IOException ե륿׵Ȥˡϥ顼Ф줿
	 */
	protected void parseMultipartFormData(HttpActionRequest actioinRequest) throws IOException
	{
		ConversionMap formValue = new ConversionMap();
		int sPos = 0;
		int ePos = 0;
		byte[] buff = new byte[1024];
		int result = 0;
		long parseStartTime = 0;
		long parseEndTime = 0;
		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
		OutputStreamFactory osf = new OutputStreamFactory();

		ConversionMap parameters = ConversionMap.valueOf(this.getInitParameterMap());

		//åץɥǥ쥯ȥ
		File uploadDirectory = null;
		if (parameters.getString(INITPARAM_UPLOADDIRECTORY).length() == 0)
		{
			uploadDirectory = new File(System.getProperty("java.io.tmpdir"));
		}
		else
		{
			uploadDirectory = new File(parameters.getString(INITPARAM_UPLOADDIRECTORY));
			if (!uploadDirectory.canWrite())
			{
				uploadDirectory = new File(System.getProperty("java.io.tmpdir"));
			}
		}

		//֥饦å
		int ind = actioinRequest.getContentType().indexOf(CONST_BOUNDARY);
		if (ind == -1)
		{
			throw new IOException("Invalid form data");
		}
		String boundary = actioinRequest.getContentType().substring(ind + CONST_BOUNDARY.length());

		ByteArrayOutputStream paramValue = new ByteArrayOutputStream();

		ServletInputStream in = actioinRequest.getInputStream();

		parseStartTime = new Date().getTime();
		while ((result = in.readLine(buff, 0, buff.length)) != -1)
		{
			String text = new String(buff, 0, result);

			//ѡȤλϤޤ
			if (text.toLowerCase().indexOf(CONST_CONTENT_DISPOSITION) > -1)
			{
				String paramName = "";
				paramValue.reset();
				String paramContentType = "";
				String fileName = "";
				boolean isFile = false;

				//ȥ̾
				sPos = text.toLowerCase().indexOf(CONST_NAME + "\"");
				if (sPos > -1)
				{
					sPos += (CONST_NAME + "\"").length();
					ePos = text.toLowerCase().indexOf("\"", sPos);
					paramName = text.substring(sPos, ePos);
					isFile = false;
				}

				//ե̾
				sPos = text.toLowerCase().indexOf(CONST_FILENAME + "\"");
				if (sPos > -1)
				{
					sPos += (CONST_FILENAME + "\"").length();
					ePos = text.toLowerCase().indexOf("\"", sPos);
					fileName = text.substring(sPos, ePos);
					isFile = true;
				}

				//ȥ̾å
				if (paramName.trim().length() == 0)
				{
					//̾ΤꤵƤʤСΥѡȤ
					continue;
				}

				//Ԥˤʤޤɤʶڤ򸫤Ĥ
				while ((result = in.readLine(buff, 0, buff.length)) != -1)
				{
					text = new String(buff, 0, result);
					if (text.trim().length() == 0)
					{
						break;
					}

					//ƥȥ׼
					sPos = text.toLowerCase().indexOf(CONST_CONTENT_TYPE);
					if (sPos > -1)
					{
						sPos += CONST_CONTENT_TYPE.length();
						paramContentType = text.substring(sPos).trim();
					}
				}
				if (result == -1)
				{
					throw new IOException("Reset by peer");
				}

				//ǡɤ߹
				while ((result = in.readLine(buff, 0, buff.length)) != -1)
				{
					text = new String(buff, 0, result);

					//λʼΥѡȤء
					if (text.toLowerCase().indexOf("--" + boundary) > -1)
					{
						break;
					}

					paramValue.write(buff, 0, result);
				}

				//ꥯȥѥ᡼¸
				if (!isFile)
				{
					//ƥ
					if (formValue.containsKey(paramName))
					{
						if (formValue.isArray(paramName))
						{
							ArrayList arry = new ArrayList(Arrays.asList((Object[])formValue.getObject(paramName)));
							arry.add(new String(paramValue.toByteArray(), 0, paramValue.size() - 2, DEFAULT_CHARACTERENCODING));
							formValue.setObject(paramName, arry.toArray(new String[arry.size()]));
						}
						else
						{
							ArrayList arry = new ArrayList();
							arry.add(formValue.getString(paramName));
							arry.add(new String(paramValue.toByteArray(), 0, paramValue.size() - 2, DEFAULT_CHARACTERENCODING));
							formValue.setObject(paramName, arry.toArray(new String[arry.size()]));
						}
					}
					else
					{
						formValue.setString(paramName, new String(paramValue.toByteArray(), 0, paramValue.size() - 2, DEFAULT_CHARACTERENCODING));
					}
				}
				else
				{
					//
					if (fileName.trim().length() > 0)
					{
						File tempFile = File.createTempFile(formatter.format(new Date()), null, uploadDirectory);
						OutputStream outputStream = osf.getOutputStream(tempFile);
						outputStream.write(paramValue.toByteArray(), 0, paramValue.size() - 2);
						outputStream.close();

						UploadFile uploadFile = new UploadFile(tempFile.getAbsolutePath());
						uploadFile.setClientPath(fileName);
						uploadFile.setContentType(paramContentType);

						formValue.setObject(paramName, uploadFile);
					}
					else
					{
						formValue.setObject(paramName, null);
					}
				}

				//ǸΥѡȤξϽλե饰򥪥ˤ
				if (text.toLowerCase().indexOf("--" + boundary + "--") > -1)
				{
					break;
				}
			}
		}

		//Хåե
		paramValue.close();

		parseEndTime = new Date().getTime();

		actioinRequest.setParameterMap(formValue);
	}

}
