/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.action.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.morpho.webapp.action.AbstractActionMappingManager;
import jp.morpho.webapp.action.ActionHandler;
import jp.morpho.webapp.action.ActionHandlerChain;
import jp.morpho.webapp.action.ActionMappingNotFoundException;
import jp.morpho.webapp.action.impl.ActionHandlerChainImpl;
import jp.morpho.webapp.action.impl.ActionHandlerEntry;
import jp.morpho.webapp.action.impl.ActionServletPath;
import jp.morpho.webapp.action.impl.ActionViewEntry;

public class ActionMappingManagerImpl
extends AbstractActionMappingManager {
    private String statusParameterName = null;
    private String actionParameterName = null;
    private Map actionServletPaths = new HashMap();

    public synchronized String getStatusParameterName() {
        return this.statusParameterName;
    }

    public synchronized void setStatusParameterName(String statusParameterName) {
        this.statusParameterName = statusParameterName;
    }

    public synchronized String getActionParameterName() {
        return this.actionParameterName;
    }

    public synchronized void setActionParameterName(String actionParameterName) {
        this.actionParameterName = actionParameterName;
    }

    public synchronized ActionHandlerChain getActionHandlerChain(String servletPath, String status, String action) {
        return new ActionHandlerChainImpl(this, servletPath, status, action);
    }

    public synchronized ActionHandler[] getActionHandlers(String servletPath, String status, String action) throws ActionMappingNotFoundException {
        ActionServletPath asp = this.getActionServletPath(servletPath);
        if (asp == null) {
            return new ActionHandler[0];
        }
        ActionHandlerEntry entry = asp.getActionHandlerEntry(status, action);
        if (entry == null || entry.size() == 0) {
            return new ActionHandler[0];
        }
        ArrayList<ActionHandler> actionHandlers = new ArrayList<ActionHandler>();
        int i = 0;
        while (i < entry.size()) {
            String className = (String)entry.get(i);
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = this.getClass().getClassLoader();
                }
                actionHandlers.add((ActionHandler)cl.loadClass(className).newInstance());
            }
            catch (Exception e) {
                throw new ActionMappingNotFoundException(e.getMessage());
            }
            ++i;
        }
        return actionHandlers.toArray(new ActionHandler[actionHandlers.size()]);
    }

    public synchronized String getActionView(String servletPath, String status) throws ActionMappingNotFoundException {
        ActionServletPath asp = this.getActionServletPath(servletPath);
        if (asp == null) {
            StringBuffer msg = new StringBuffer();
            msg.append("servletPath not found: ");
            msg.append("servletPath=");
            msg.append(servletPath);
            msg.append(",status=");
            msg.append(status);
            throw new ActionMappingNotFoundException(msg.toString());
        }
        ActionViewEntry entry = asp.getActionViewEntry(status);
        if (entry == null) {
            StringBuffer msg = new StringBuffer();
            msg.append("ActionViewEntry not found: ");
            msg.append("servletPath=");
            msg.append(servletPath);
            msg.append(",status=");
            msg.append(status);
            throw new ActionMappingNotFoundException(msg.toString());
        }
        return entry.getPath();
    }

    public synchronized void addActionServletPath(ActionServletPath asp) {
        String key = asp.getServletPath();
        if (this.actionServletPaths.containsKey(key)) {
            throw new IllegalArgumentException("ActionServletPath already exists: " + key);
        }
        this.actionServletPaths.put(key, asp);
    }

    public synchronized ActionServletPath getActionServletPath(String servletPath) {
        return (ActionServletPath)this.actionServletPaths.get(servletPath);
    }
}

