/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.config;

import java.util.Map;

import org.xml.sax.Attributes;

/**
 * <P>
 * PutNode 饹ϡput ɽޤ
 * put ˤϡ#PCDATA call new  SystemProperty ޤ뤳ȤǤޤ
 * </P>
 * <P>
 * 㤨 put ϡΤ褦һ˵Ҥޤ
 * </P>
 * <P>
 * <PRE>
 *     &lt;put name="someKey"&gt;someValue&lt;/put&gt;
 * </PRE>
 * </P>
 * <P>
 * ϡΤ褦ʥɤ񤯤ȤƱǤ
 * </P>
 * <P>
 * <PRE>
 *     obj.put("someKey", "someValue");
 * </PRE>
 * </P>
 * @author Kumiko Hiroi
 */
public class PutNode extends Node
{

	/**
	 * <P>
	 * ƥΡɤȥΡɤ°ꤷ PutNode ֥Ȥޤ
	 * </P>
	 * @param parent ΥΡɤοƥΡ
	 * @param attributes ΥΡɤ°
	 */
	public PutNode(Node parent, Attributes attributes)
	{
		super(parent, attributes);
	}

	/**
	 * <P>
	 * ֤ͤޤ
	 * </P>
	 * @return 
	 * @see jp.morpho.config.Node#getTag()
	 */
	public int getTag()
	{
		return NodeTypes.PUT;
	}

	/**
	 * <P>
	 * ꤵ줿֥Ȥޤ
	 * 饹ˤ褦ˡ֥ obj  put ᥽åɤƤӽФޤ
	 * </P>
	 * <P>
	 * ΥΡɤϡConversionMap ֥ȤΤߥݡȤޤ
	 * ConversionMap ֥ȰʳΥ֥Ȥ PutNode ΡɤѤ줿硢㳰 ConfigureException ޤ
	 * </P>
	 * @param obj 륪֥
	 * @return 줿֥
	 * @exception ConfigureException ֥ȤǤʤä
	 * @see jp.morpho.config.Node#configure(Object)
	 */
	public Object configure(Object obj) throws ConfigureException
	{
		try
		{
			if (!(obj instanceof Map))
			{
				throw new IllegalArgumentException("Object is not a ConversionMap: " + obj);
			}
			Map map = (Map) obj;

			String name = getAttribute("name");
			Object value = getValue(obj);
			map.put(name, value);
			return null;
		}
		catch (Exception e)
		{
			throw new ConfigureException(e);
		}
	}

}
