/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;

/**
 * <P>
 * ϥȥ꡼եȥεǽޤ
 * ϥȥ꡼եȥϡϥȥ꡼ե롢ѥʸ󡢥ХΥURL ʤɤΥ֥Ȥ뤿˻Ѥޤ
 * </P>
 * @author Kumiko Hiroi
 */
public class OutputStreamFactory
{

	/**
	 * <P>
	 * OutputStreamFactory ֥Ȥޤ
	 * </P>
	 */
	public OutputStreamFactory()
	{
		super();
	}

	/**
	 * <P>
	 * ꤵ줿 File ֥Ȥɽե˽񤭹िΥեϥȥ꡼ޤ
	 * Υե³ɽˡ FileDescriptor ֥Ȥޤ
	 * </P>
	 * <P>
	 * ޤƥޥ͡㤬¸ߤ硢checkWrite ᥽åɤ file ˤäɽѥȤƸƤӽФޤ
	 * </P>
	 * <P>
	 * ե¸ߤ뤬̤ΥեǤϤʤǥ쥯ȥǤ硢ե¸ߤǤʤ硢ޤϤʤ餫ͳǳȤǤʤϡFileNotFoundException ޤ
	 * </P>
	 * @param file 񤭹ߤΤ˳ե
	 * @return ե˽񤭹िΥեϥȥ꡼ (BufferedOutputStream)
	 * @exception FileNotFoundException ե¸ߤ뤬̤ΥեǤϤʤǥ쥯ȥǤ硢ե¸ߤǤʤ硢ޤϤʤ餫ͳǳȤǤʤ
	 * @exception SecurityException ƥޥ͡㤬¸ߤcheckWrite ᥽åɤեؤν񤭹ߥݤ
	 */
	public synchronized OutputStream getOutputStream(File file) throws FileNotFoundException
	{
		return new BufferedOutputStream(new FileOutputStream(file));
	}

	/**
	 * <P>
	 * ꤵ줿 File ֥Ȥɽե˽񤭹िνϥե륹ȥ꡼ޤ
	 * 2 ܤΰ true ξ硢ХȤϥեƬǤϤʤǸ˽񤭹ޤޤ
	 * Υե³ɽˡ FileDescriptor ֥Ȥޤ
	 * </P>
	 * <P>
	 * ޤƥޥ͡㤬¸ߤ硢checkWrite ᥽åɤ file ˤäɽѥȤƸƤӽФޤ
	 * </P>
	 * <P>
	 * ե¸ߤ뤬̤ΥեǤϤʤǥ쥯ȥǤ硢ե¸ߤǤʤ硢ޤϤʤ餫ͳǳȤǤʤϡFileNotFoundException ޤ
	 * </P>
	 * @param file 񤭹ߤΤ˳ե
	 * @param append true ξ硢ХȤϥեƬǤϤʤǸ˽񤭹ޤ
	 * @return ե˽񤭹िΥեϥȥ꡼ (BufferedOutputStream)
	 * @exception FileNotFoundException ե¸ߤ뤬̤ΥեǤϤʤǥ쥯ȥǤ硢ե¸ߤǤʤ硢ޤϤʤ餫ͳǳȤǤʤ
	 * @exception SecurityException ƥޥ͡㤬¸ߤcheckWrite ᥽åɤեؤν񤭹ߥݤ
	 */
	public synchronized OutputStream getOutputStream(File file, boolean append) throws FileNotFoundException
	{
		return new BufferedOutputStream(new FileOutputStream(file, append));
	}

	/**
	 * <P>
	 * ꤵ줿 path Υե˽񤭹िνϥե륹ȥ꡼ޤ
	 * Υե³ɽˡ FileDescriptor ֥Ȥޤ
	 * </P>
	 * <P>
	 * ޤƥޥ͡㤬¸ߤ硢checkWrite ᥽åɤ name ȤƸƤӽФޤ
	 * </P>
	 * <P>
	 * ե¸ߤ뤬̤ΥեǤϤʤǥ쥯ȥǤ硢ե¸ߤǤʤ硢ޤϤʤ餫ͳǳȤǤʤϡFileNotFoundException ޤ
	 * </P>
	 * @param name ƥ˰¸ե̾
	 * @return ե˽񤭹िΥեϥȥ꡼ (BufferedOutputStream)
	 * @exception FileNotFoundException ե¸ߤ뤬̤ΥեǤϤʤǥ쥯ȥǤ硢ե¸ߤǤʤ硢ޤϤʤ餫ͳǳȤǤʤ
	 * @exception SecurityException ƥޥ͡㤬¸ߤcheckWrite ᥽åɤեؤν񤭹ߥݤ
	 */
	public synchronized OutputStream getOutputStream(String path) throws FileNotFoundException
	{
		return getOutputStream(new File(path));
	}

	/**
	 * <P>
	 * ꤵ줿 path Υե˽񤭹िνϥե륹ȥ꡼ޤ
	 * 2 ܤΰ true ξ硢ХȤϥեƬǤϤʤǸ˽񤭹ޤޤ
	 * Υե³ɽˡ FileDescriptor ֥Ȥޤ
	 * </P>
	 * <P>
	 * ޤƥޥ͡㤬¸ߤ硢checkWrite ᥽åɤ name ȤƸƤӽФޤ
	 * </P>
	 * <P>
	 * ե¸ߤ뤬̤ΥեǤϤʤǥ쥯ȥǤ硢ե¸ߤǤʤ硢ޤϤʤ餫ͳǳȤǤʤϡFileNotFoundException ޤ
	 * </P>
	 * @param name ƥ˰¸ե̾
	 * @param append true ξ硢ХȤϥեƬǤϤʤǸ˽񤭹ޤ
	 * @return ե˽񤭹िΥեϥȥ꡼ (BufferedOutputStream)
	 * @exception FileNotFoundException ե¸ߤ뤬̤ΥեǤϤʤǥ쥯ȥǤ硢ե¸ߤǤʤ硢ޤϤʤ餫ͳǳȤǤʤ
	 * @exception SecurityException ƥޥ͡㤬¸ߤcheckWrite ᥽åɤեؤν񤭹ߥݤ
	 */
	public synchronized OutputStream getOutputStream(String path, boolean append) throws FileNotFoundException
	{
		return getOutputStream(new File(path), append);
	}

	/**
	 * <P>
	 * Хȿǻꤵ줿ΥХåեġХϥȥ꡼򿷤ޤ
	 * </P>
	 * @param size 
	 * @return Хϥȥ꡼ (ByteArrayOutputStream)
	 */
	public synchronized OutputStream getOutputStream(int size)
	{
		return new ByteArrayOutputStream(size);
	}

	/**
	 * <P>
	 * url ؤ³Ω³˽񤭹ߤԤϥȥ꡼ޤ
	 * </P>
	 * @param url URL
	 * @return URL ³˽񤭹ߤԤϥȥ꡼ (BufferedOutputStream)
	 * @exception IOException 㳰ȯ
	 * @exception UnknownServiceException ץȥ뤬Ϥ򥵥ݡȤƤʤ
	 */
	public synchronized OutputStream getOutputStream(URL url) throws IOException
	{
		return new BufferedOutputStream(url.openConnection().getOutputStream());
	}
}
