/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.action;

import jp.morpho.webapp.Plugin;

/**
 * <P>
 * ե졼饤ȤΥꥯȤ򿶤ʬݤ˻Ѥ᥽åɰ켰ޤ
 * 㤨Хϥɥӥ塼μȤä᥽åɤǤ
 * </P>
 * <P>
 * ޥåԥ󥰥ޥ͡μ饹Ϥ٤ơɸŪʥ󥹥ȥ饯󶡤褦ˤƤ
 * ɸŪʥ󥹥ȥ饯Ȥϡvoid (ʤ) 󥹥ȥ饯ǤΥ󥹥ȥ饯϶Υޥåԥ󥰤ޤ
 * </P>
 * @author Kenichi Fukuda
 */
public interface ActionMappingManager
	extends Plugin
{

	/**
	 * <P>
	 * ׵륹ơΥѥ᡼֤̾ޤ
	 * </P>
	 * @return ׵륹ơΥѥ᡼̾
	 */
	public String getStatusParameterName();

	/**
	 * <P>
	 * ׵륢Υѥ᡼֤̾ޤ
	 * </P>
	 * @return ׵륢Υѥ᡼̾
	 */
	public String getActionParameterName();

	/**
	 * <P>
	 * ϥɥ֤ޤ
	 * ϥɥϡActionMappingManager  getActionHandlers(servletPath, status, action) ᥽åɤ getActionView(servletPath, status) ᥽åɤƤӽФޤ
	 * </P>
	 * @param servletPath ޥåԥ󥰤б URL
	 * @param status ׵륹ơ
	 * @param action ׵륢
	 * @return ϥɥ
	 */
	public ActionHandlerChain getActionHandlerChain(
		String servletPath, String status, String action);

	/**
	 * <P>
	 * ϥɥ֤ޤ
	 * ֤줿ϥɥϡϥɥ doActionHandler ᥽åɤǽ˸ƤӽФޤ
	 * </P>
	 * <P>
	 * Υ᥽åɤϡ׵륢ϥɥ뤿ˡϥɥ󤫤ƤӽФޤ
	 * </P>
	 * @param servletPath ޥåԥ󥰤б URL
	 * @param status ׵륹ơ
	 * @param action ׵륢
	 * @return ϥɥ
	 * @exception ActionMappingNotFoundException 饤ȤƤӽФ줿֥åȤ URL ơѤƥޥåԥ󥰤褦Ȥб륢ޥåԥ󥰤Ĥʤä
	 */
	public ActionHandler[] getActionHandlers(
		String servletPath, String status, String action)
		throws ActionMappingNotFoundException;

	/**
	 * <P>
	 * ӥ塼Υѥ (JSP ʤ) ֤ޤ
	 * ӥ塼ϡϥɥ doActionHandler ᥽åɤǡϥɥ餬ƤӽФ줿塢˥󥯥롼ɤޤ
	 * </P>
	 * <P>
	 * ơͤϡϥɥѹ뤳Ȥ뤿ᡢ֥åȤ׵äͤɬפޤ
	 * Υ᥽åɤϡϥɥ doActionHandler ᥽åɤǡ٤ƤΥϥɥ餬¹Ԥ줿˸ƤӽФޤ
	 * </P>
	 * @param servletPath ޥåԥ󥰤б URL
	 * @param status ׵륹ơ
	 * @return ӥ塼Υѥ
	 * @exception ActionMappingNotFoundException 饤ȤƤӽФ줿֥åȤ URL ơѤƥޥåԥ󥰤褦Ȥб륢ޥåԥ󥰤Ĥʤä
	 */
	public String getActionView(
		String servletPath, String status)
		throws ActionMappingNotFoundException;
}
