/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.action.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import jp.morpho.webapp.action.AbstractActionMappingManager;
import jp.morpho.webapp.action.ActionHandler;
import jp.morpho.webapp.action.ActionHandlerChain;
import jp.morpho.webapp.action.ActionMappingNotFoundException;

/**
 * <P>
 * ActionMappingManager μǤ
 * ǥեȤΥޥåԥ󥰥ޥ͡ǡActionMappingManager δưޤ
 * ɬפʤСΥ饹ĥ뤫ޤϿ ActionMappingManager ȼΥޥåԥ󥰥ޥ͡뤳ȤǤޤ
 * </P>
 * <P>
 *  ActionMappingManager ϡAbstractActionMappingManager 饹ĥɬפʥ᥽åɤޤ
 * </P>
 * @author Kumiko Hiroi
 */
public class ActionMappingManagerImpl
	extends AbstractActionMappingManager
{

	/** ׵륹ơΥѥ᡼̾ */
	private String statusParameterName = null;

	/** ׵륢Υѥ᡼̾ */
	private String actionParameterName = null;

	/** ׵륵֥åȤΥѥΥޥå */
	private Map actionServletPaths = new HashMap();

	/**
	 * <P>
	 * ActionMappingManagerImpl ޤ
	 * </P>
	 */
	public ActionMappingManagerImpl()
	{
		super();
	}

	/**
	 * <P>
	 * ׵륹ơΥѥ᡼֤̾ޤ
	 * </P>
	 * @return ׵륹ơΥѥ᡼̾
	 * @see jp.morpho.webapp.action.ActionMappingManager#getStatusParameterName()
	 */
	public synchronized String getStatusParameterName()
	{
		return statusParameterName;
	}

	/**
	 * <P>
	 * ׵륹ơΥѥ᡼̾ꤷޤ
	 * </P>
	 * @param statusParameterName ׵륹ơΥѥ᡼̾
	 */
	public synchronized void setStatusParameterName(String statusParameterName)
	{
		this.statusParameterName = statusParameterName;
	}

	/**
	 * <P>
	 * ׵륢Υѥ᡼֤̾ޤ
	 * </P>
	 * @return ׵륢Υѥ᡼̾
	 * @see jp.morpho.webapp.action.ActionMappingManager#getActionParameterName()
	 */
	public synchronized String getActionParameterName()
	{
		return actionParameterName;
	}

	/**
	 * <P>
	 * ׵륢Υѥ᡼̾ꤷޤ
	 * </P>
	 * @param actionParameterName ׵륢Υѥ᡼̾
	 */
	public synchronized void setActionParameterName(String actionParameterName)
	{
		this.actionParameterName = actionParameterName;
	}

	/**
	 * <P>
	 * ϥɥ֤ޤ
	 * ϥɥϡActionMappingManager  getActionHandlers(String, String, String) ᥽åɤ getActionView(String, String) ᥽åɤƤӽФޤ
	 * </P>
	 * @param servletPath ޥåԥ󥰤б URL
	 * @param status ׵륹ơ
	 * @param action ׵륢
	 * @return ϥɥ
	 * @see jp.morpho.webapp.action.ActionMappingManager#getActionHandlerChain(String, String, String)
	 */
	public synchronized ActionHandlerChain getActionHandlerChain(
		String servletPath,
		String status,
		String action)
	{
		return new ActionHandlerChainImpl(this, servletPath, status, action);
	}

	/**
	 * <P>
	 * ϥɥ֤ޤ
	 * ֤줿ϥɥϡϥɥ doActionHandler ᥽åɤǽ˸ƤӽФޤ
	 * </P>
	 * <P>
	 * Υ᥽åɤϡ׵륢ϥɥ뤿ˡϥɥ󤫤ƤӽФޤ
	 * </P>
	 * @param servletPath ޥåԥ󥰤б URL
	 * @param status ׵륹ơ
	 * @param action ׵륢
	 * @return ϥɥ
	 * @exception ActionMappingNotFoundException 饤ȤƤӽФ줿֥åȤ URL ơѤƥޥåԥ󥰤褦Ȥб륢ޥåԥ󥰤Ĥʤä
	 * @see jp.morpho.webapp.action.ActionMappingManager#getActionHandlers(String, String, String)
	 */
	public synchronized ActionHandler[] getActionHandlers(
		String servletPath,
		String status,
		String action)
		throws ActionMappingNotFoundException
	{
		//׵ä֥åȤΥѥޥåԥ󥰤ޤ
		//ǤʤäϡΥϥɥ֤ޤ
		ActionServletPath asp = getActionServletPath(servletPath);
		if (asp == null)
		{
			return new ActionHandler[0];
		}

		//ϥɥΥȥޥåԥ󥰤ޤ
		//ǤʤäϡΥϥɥ֤ޤ
		ActionHandlerEntry entry = asp.getActionHandlerEntry(status, action);
		if (entry == null || entry.size() == 0)
		{
			return new ActionHandler[0];
		}

		//ϥɥ饯饹ɤơϥɥ֤ޤ
		ArrayList actionHandlers = new ArrayList();
		for (int i = 0; i < entry.size(); i++)
		{
			String className = (String)entry.get(i);
			try
			{
				ClassLoader cl = Thread.currentThread().getContextClassLoader();
				if (cl == null)
				{
					cl = getClass().getClassLoader();
				}
				actionHandlers.add((ActionHandler)cl.loadClass(className).newInstance());
			}
			catch (Exception e)
			{
				throw new ActionMappingNotFoundException(e.getMessage());
			}
		}
		return (ActionHandler[])actionHandlers.toArray(new ActionHandler[actionHandlers.size()]);
	}

	/**
	 * <P>
	 * ӥ塼Υѥ (JSP ʤ) ֤ޤ
	 * ӥ塼ϡϥɥ doActionHandler ᥽åɤǡϥɥ餬ƤӽФ줿塢˥󥯥롼ɤޤ
	 * </P>
	 * <P>
	 * ơͤϡϥɥѹ뤳Ȥ뤿ᡢ֥åȤ׵äͤɬפޤ
	 * Υ᥽åɤϡϥɥ doActionHandler ᥽åɤǡ٤ƤΥϥɥ餬¹Ԥ줿˸ƤӽФޤ
	 * </P>
	 * @param servletPath ޥåԥ󥰤б URL
	 * @param status ׵륹ơ
	 * @return ӥ塼Υѥ
	 * @exception ActionMappingNotFoundException 饤ȤƤӽФ줿֥åȤ URL ơѤƥޥåԥ󥰤褦Ȥб륢ޥåԥ󥰤Ĥʤä
	 * @see jp.morpho.webapp.action.ActionMappingManager#getActionView(String, String)
	 */
	public synchronized String getActionView(String servletPath, String status)
		throws ActionMappingNotFoundException
	{
		//׵ä֥åȤΥѥޥåԥ󥰤ޤ
		//Ǥʤäϡ㳰򥹥ޤ
		ActionServletPath asp = getActionServletPath(servletPath);
		if (asp == null)
		{
			StringBuffer msg = new StringBuffer();
			msg.append("servletPath not found: ");
			msg.append("servletPath=");
			msg.append(servletPath);
			msg.append(",status=");
			msg.append(status);
			throw new ActionMappingNotFoundException(msg.toString());
		}

		//ӥ塼Υȥޥåԥ󥰤ޤ
		//Ǥʤäϡ㳰򥹥ޤ
		ActionViewEntry entry = asp.getActionViewEntry(status);
		if (entry == null)
		{
			StringBuffer msg = new StringBuffer();
			msg.append("ActionViewEntry not found: ");
			msg.append("servletPath=");
			msg.append(servletPath);
			msg.append(",status=");
			msg.append(status);
			throw new ActionMappingNotFoundException(msg.toString());
		}

		//ӥ塼Υѥ֤ޤ
		return entry.getPath();
	}

	/**
	 * <P>
	 * ׵륵֥åȤΥѥΥȥ˻Υȥɲäޤ
	 * </P>
	 * @param asp ׵륵֥åȤΥѥΥȥɲä륨ȥ
	 * @exception IllegalArgumentException ƱѥΥȥ꤬ä
	 */
	public synchronized void addActionServletPath(ActionServletPath asp)
	{
		String key = asp.getServletPath();
		if (actionServletPaths.containsKey(key))
		{
			throw new IllegalArgumentException("ActionServletPath already exists: " + key);
		}
		actionServletPaths.put(key, asp);
	}

	/**
	 * <P>
	 * ꤵ줿ѥ׵륵֥åȤΥѥΥȥ֤ޤ
	 * </P>
	 * @param servletPath ׵륵֥åȤΥѥ
	 */
	public synchronized ActionServletPath getActionServletPath(String servletPath)
	{
		return (ActionServletPath)actionServletPaths.get(servletPath);
	}

}
