/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import jp.morpho.webapp.servlet.jsp.tagext.BaseTag;

/**
 * <P>
 * åܥå饸ܥ󡢥˥塼ʤɤΥȥϥɥ뤿δ쥯饹Ǥ
 * </P>
 * @author Kumiko Hiroi
 */
public abstract class ControlTagSupport
	extends BaseTag
	implements Attrs
{
	/**
	 * <P>
	 * ǥեȤΥ󥹥ȥ饯Ǥ
	 * ٤ƤΥ֥饹ϡƱ˥㡼 public 󥹥ȥ饯ѡ饹Υ󥹥ȥ饯ƤӽФɬפޤ
	 * Υ󥹥ȥ饯ϡJSP ȥ󥹥졼ˤä줿ɤƤӽФޤ
	 * </P>
	 */
	public ControlTagSupport()
	{
		super();
	}

	/**
	 * <P>
	 * class °֤ޤ
	 * </P>
	 * @return class °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.CoreAttrs#getStyleClass()
	 */
	public String getStyleClass()
	{
		return getAttributeMap().getString("class");
	}

	/**
	 * <P>
	 * id °֤ޤ
	 * </P>
	 * @return id °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.CoreAttrs#getStyleId()
	 */
	public String getStyleId()
	{
		return getAttributeMap().getString("id");
	}

	/**
	 * <P>
	 * style °֤ޤ
	 * </P>
	 * @return style °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.CoreAttrs#getStyle()
	 */
	public String getStyle()
	{
		return getAttributeMap().getString("style");
	}

	/**
	 * <P>
	 * title °֤ޤ
	 * </P>
	 * @return title °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.CoreAttrs#getTitle()
	 */
	public String getTitle()
	{
		return getAttributeMap().getString("title");
	}

	/**
	 * <P>
	 * class °ꤷޤ
	 * </P>
	 * @param cls class °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.CoreAttrs#setStyleClass(String)
	 */
	public void setStyleClass(String cls)
	{
		getAttributeMap().setString("class", cls);
	}

	/**
	 * <P>
	 * id °ꤷޤ
	 * </P>
	 * @param id id °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.CoreAttrs#setStyleId(String)
	 */
	public void setStyleId(String id)
	{
		getAttributeMap().setString("id", id);
	}

	/**
	 * <P>
	 * style °ꤷޤ
	 * </P>
	 * @param style style °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.CoreAttrs#setStyle(String)
	 */
	public void setStyle(String style)
	{
		getAttributeMap().setString("style", style);
	}

	/**
	 * <P>
	 * title °ꤷޤ
	 * </P>
	 * @param title title °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.CoreAttrs#setTitle(String)
	 */
	public void setTitle(String title)
	{
		getAttributeMap().setString("title", title);
	}

	/**
	 * <P>
	 * onclick °֤ޤ
	 * </P>
	 * @return onclick °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnclick()
	 */
	public String getOnclick()
	{
		return getAttributeMap().getString("onclick");
	}

	/**
	 * <P>
	 * ondblclick °֤ޤ
	 * </P>
	 * @return ondblclick °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOndblclick()
	 */
	public String getOndblclick()
	{
		return getAttributeMap().getString("ondblclick");
	}

	/**
	 * <P>
	 * onkeydown °֤ޤ
	 * </P>
	 * @return onkeydown °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnkeydown()
	 */
	public String getOnkeydown()
	{
		return getAttributeMap().getString("onkeydown");
	}

	/**
	 * <P>
	 * onkeypress °֤ޤ
	 * </P>
	 * @return onkeypress °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnkeypress()
	 */
	public String getOnkeypress()
	{
		return getAttributeMap().getString("onkeypress");
	}

	/**
	 * <P>
	 * onkeyup °֤ޤ
	 * </P>
	 * @return onkeyup °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnkeyup()
	 */
	public String getOnkeyup()
	{
		return getAttributeMap().getString("onkeyup");
	}

	/**
	 * <P>
	 * onmousedown °֤ޤ
	 * </P>
	 * @return onmousedown °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnmousedown()
	 */
	public String getOnmousedown()
	{
		return getAttributeMap().getString("onmousedown");
	}

	/**
	 * <P>
	 * onmousemove °֤ޤ
	 * </P>
	 * @return onmousemove °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnmousemove()
	 */
	public String getOnmousemove()
	{
		return getAttributeMap().getString("onmousemove");
	}

	/**
	 * <P>
	 * onmouseout °֤ޤ
	 * </P>
	 * @return onmouseout °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnmouseout()
	 */
	public String getOnmouseout()
	{
		return getAttributeMap().getString("onmouseout");
	}

	/**
	 * <P>
	 * onmouseover °֤ޤ
	 * </P>
	 * @return onmouseover °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnmouseover()
	 */
	public String getOnmouseover()
	{
		return getAttributeMap().getString("onmouseover");
	}

	/**
	 * <P>
	 * onmouseup °֤ޤ
	 * </P>
	 * @return onmouseup °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnmouseup()
	 */
	public String getOnmouseup()
	{
		return getAttributeMap().getString("onmouseup");
	}

	/**
	 * <P>
	 * onclick °ꤷޤ
	 * </P>
	 * @param onclick onclick °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnclick(String)
	 */
	public void setOnclick(String onclick)
	{
		getAttributeMap().setString("onclick", onclick);
	}

	/**
	 * <P>
	 * ondblclick °ꤷޤ
	 * </P>
	 * @param ondblclick ondblclick °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOndblclick(String)
	 */
	public void setOndblclick(String ondblclick)
	{
		getAttributeMap().setString("ondblclick", ondblclick);
	}

	/**
	 * <P>
	 * onkeydown °ꤷޤ
	 * </P>
	 * @param onkeydown onkeydown °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnkeydown(String)
	 */
	public void setOnkeydown(String onkeydown)
	{
		getAttributeMap().setString("onkeydown", onkeydown);
	}

	/**
	 * <P>
	 * onkeypress °ꤷޤ
	 * </P>
	 * @param onkeypress onkeypress °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnkeypress(String)
	 */
	public void setOnkeypress(String onkeypress)
	{
		getAttributeMap().setString("onkeypress", onkeypress);
	}

	/**
	 * <P>
	 * onkeyup °ꤷޤ
	 * </P>
	 * @param onkeyup onkeyup °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnkeyup(String)
	 */
	public void setOnkeyup(String onkeyup)
	{
		getAttributeMap().setString("onkeyup", onkeyup);
	}

	/**
	 * <P>
	 * onmousedown °ꤷޤ
	 * </P>
	 * @param onmousedown onmousedown °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnmousedown(String)
	 */
	public void setOnmousedown(String onmousedown)
	{
		getAttributeMap().setString("onmousedown", onmousedown);
	}

	/**
	 * <P>
	 * onmousemove °ꤷޤ
	 * </P>
	 * @param onmousemove onmousemove °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnmousemove(String)
	 */
	public void setOnmousemove(String onmousemove)
	{
		getAttributeMap().setString("onmousemove", onmousemove);
	}

	/**
	 * <P>
	 * onmouseout °ꤷޤ
	 * </P>
	 * @param onmouseout onmouseout °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnmouseout(String)
	 */
	public void setOnmouseout(String onmouseout)
	{
		getAttributeMap().setString("onmouseout", onmouseout);
	}

	/**
	 * <P>
	 * onmouseover °ꤷޤ
	 * </P>
	 * @param onmouseover onmouseover °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnmouseover(String)
	 */
	public void setOnmouseover(String onmouseover)
	{
		getAttributeMap().setString("onmouseover", onmouseover);
	}

	/**
	 * <P>
	 * onmouseup °ꤷޤ
	 * </P>
	 * @param onmouseup onmouseup °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnmouseup(String)
	 */
	public void setOnmouseup(String onmouseup)
	{
		getAttributeMap().setString("onmouseup", onmouseup);
	}

	/**
	 * <P>
	 * dir °֤ޤ
	 * </P>
	 * @return dir °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.I18n#getDir()
	 */
	public String getDir()
	{
		return getAttributeMap().getString("dir");
	}

	/**
	 * <P>
	 * lang °֤ޤ
	 * </P>
	 * @return lang °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.I18n#getLang()
	 */
	public String getLang()
	{
		return getAttributeMap().getString("lang");
	}

	/**
	 * <P>
	 * dir °ꤷޤ
	 * </P>
	 * @param dir dir °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.I18n#setDir(String)
	 */
	public void setDir(String dir)
	{
		getAttributeMap().setString("dir", dir);
	}

	/**
	 * <P>
	 * lang °ꤷޤ
	 * </P>
	 * @param lang lang °
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.I18n#setLang(String)
	 */
	public void setLang(String lang)
	{
		getAttributeMap().setString("lang", lang);
	}

}
