/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

import jp.morpho.webapp.action.ActionMappingManager;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.http.impl.HttpActionRequestImpl;

/**
 * <P>
 * HTML ΥեϥɥǤ
 * </P>
 * <P>
 * HTML Υեϡʸΰʬ̾ƤȥޡդƥȥȸƤФ̤ǡˤ饳ȥΥ٥ޤߤޤ
 * ȥˤϥåܥå饸ܥ󡢥˥塼ʤɤޤ
 * 桼ϰ̤ˡƥȤɲä롢˥塼ܤ֡Ƥ饳ȥѹƥեִפθեΤ Web Ф᡼륵ΥȤؤȥեФޤ
 * </P>
 * <P>
 * FORM  HTML 4 ϼΤȤǤ
 * <PRE>
 * &lt;!ELEMENT FORM - - (%block;|SCRIPT)+ -(FORM) -- interactive form --&gt;
 * &lt;!ATTLIST FORM
 *   %attrs;                              -- %coreattrs, %i18n, %events --
 *   action      %URI;          #REQUIRED -- server-side form handler --
 *   method      (GET|POST)     GET       -- HTTP method used to submit the form--
 *   enctype     %ContentType;  "application/x-www-form-urlencoded"
 *   accept      %ContentTypes; #IMPLIED  -- list of MIME types for file upload --
 *   name        CDATA          #IMPLIED  -- name of form for scripting --
 *   onsubmit    %Script;       #IMPLIED  -- the form was submitted --
 *   onreset     %Script;       #IMPLIED  -- the form was reset --
 *   accept-charset %Charsets;  #IMPLIED  -- list of supported charsets --
 *   &gt;
 * </PRE>
 * </P>
 * @author Kumiko Hiroi
 */
public class FormTag extends ControlTagSupport
{

	/**
	 * <P>
	 * FormTag ޤ
	 * </P>
	 */
	public FormTag()
	{
		super();
	}

	/**
	 * <P>
	 * accept °֤ޤ
	 * </P>
	 * @return accept °
	 */
	public String getAccept()
	{
		return getAttributeMap().getString("accept");
	}

	/**
	 * <P>
	 * accept-charset °֤ޤ
	 * </P>
	 * @return accept-charset °
	 */
	public String getAcceptCharset()
	{
		return getAttributeMap().getString("accept-charset");
	}

	/**
	 * <P>
	 * action °֤ޤ
	 * </P>
	 * @return action °
	 */
	public String getAction()
	{
		return getAttributeMap().getString("action");
	}

	/**
	 * <P>
	 * enctype °֤ޤ
	 * </P>
	 * @return enctype °
	 */
	public String getEnctype()
	{
		return getAttributeMap().getString("enctype");
	}

	/**
	 * <P>
	 * method °֤ޤ
	 * </P>
	 * @return method °
	 */
	public String getMethod()
	{
		return getAttributeMap().getString("method");
	}

	/**
	 * <P>
	 * name °֤ޤ
	 * </P>
	 * @return name °
	 */
	public String getName()
	{
		return getAttributeMap().getString("name");
	}

	/**
	 * <P>
	 * onreset °֤ޤ
	 * </P>
	 * @return onreset °
	 */
	public String getOnreset()
	{
		return getAttributeMap().getString("onreset");
	}

	/**
	 * <P>
	 * onsubmit °֤ޤ
	 * </P>
	 * @return onsubmit °
	 */
	public String getOnsubmit()
	{
		return getAttributeMap().getString("onsubmit");
	}

	/**
	 * <P>
	 * accept °ꤷޤ
	 * </P>
	 * @param accept accept °
	 */
	public void setAccept(String accept)
	{
		getAttributeMap().setString("accept", accept);
	}

	/**
	 * <P>
	 * accept-charset °ꤷޤ
	 * </P>
	 * @param acceptCharset accept-charset °
	 */
	public void setAcceptCharset(String acceptCharset)
	{
		getAttributeMap().setString("accept-charset", acceptCharset);
	}

	/**
	 * <P>
	 * action °ꤷޤ
	 * </P>
	 * @param action action °
	 */
	public void setAction(String action)
	{
		getAttributeMap().setString("action", action);
	}

	/**
	 * <P>
	 * enctype °ꤷޤ
	 * </P>
	 * @param enctype enctype °
	 */
	public void setEnctype(String enctype)
	{
		getAttributeMap().setString("enctype", enctype);
	}

	/**
	 * <P>
	 * method °ꤷޤ
	 * </P>
	 * @param method method °
	 */
	public void setMethod(String method)
	{
		getAttributeMap().setString("method", method);
	}

	/**
	 * <P>
	 * name °ꤷޤ
	 * </P>
	 * @param name name °
	 */
	public void setName(String name)
	{
		getAttributeMap().setString("name", name);
	}

	/**
	 * <P>
	 * onreset °ꤷޤ
	 * </P>
	 * @param onreset onreset °
	 */
	public void setOnreset(String onreset)
	{
		getAttributeMap().setString("onreset", onreset);
	}

	/**
	 * <P>
	 * onsubmit °ꤷޤ
	 * </P>
	 * @param onsubmit onsubmit °
	 */
	public void setOnsubmit(String onsubmit)
	{
		getAttributeMap().setString("onsubmit", onsubmit);
	}

	/**
	 * <P>
	 * λνǤ
	 * </P>
	 * @return EVAL_PAGE
	 * @see javax.servlet.jsp.tagext.Tag#doEndTag()
	 */
	public int doEndTag() throws JspException
	{
		StringBuffer buf = new StringBuffer();
		buf.append("</form>");

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doEndTag();
	}

	/**
	 * <P>
	 * ϥνǤ
	 * </P>
	 * @return EVAL_BODY_BUFFERED
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException
	{
		HttpActionRequest req = new HttpActionRequestImpl((HttpServletRequest)pageContext.getRequest());

		//FORMޤ
		StringBuffer buf = new StringBuffer();
		buf.append("<form");

		//ꤵƤʤ°˥ǥեͤꤷޤ
		if (!this.getAttributeMap().containsKey("action"))
		{
			this.setAction(req.getRequestURI());
		}
		if (!this.getAttributeMap().containsKey("method"))
		{
			this.setMethod("post");
		}

		String keys[] = new String[this.getAttributeMap().size()];
		keys = (String[])this.getAttributeMap().keySet().toArray(keys);
		for (int i = 0; i < keys.length; i++)
		{
			buf.append(" ").append(keys[i]).append("=\"");
			if (!keys[i].equalsIgnoreCase("action"))
			{
				buf.append(this.getAttributeMap().getString(keys[i]));
			}
			else
			{
				HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
				String url = this.getAttributeMap().getString("action");
				buf.append(response.encodeURL(url));
			}
			buf.append("\"");
		}

		buf.append(">");

		ActionMappingManager amm = getActionMappingManager();

		//ơ hidden ޤ
		buf.append("<input type=\"hidden\" name=\"").append(amm.getStatusParameterName());
		buf.append("\" value=\"").append(req.getStatus());
		buf.append("\">");

		// hidden ޤ
		buf.append("<input type=\"hidden\" name=\"").append(amm.getActionParameterName());
		buf.append("\" value=\"\">");

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doStartTag();
	}

}
