/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

/**
 * <P>
 * OPTGROUP ǤˤäơԤܤŪ˥롼ײ뤳ȤǤޤ
 * 롼ײϡ桼ĹꥹȤӽФͤФʤʤ褦ʾäͭѤǤ
 * Ϣܤ롼ײƤñĴĹꥹȤ⡢İưפǤĳФ䤹ʤޤ
 * HTML 4 Ǥϡɤ OPTGROUP Ǥ SELECT ǤľܤλҤǤɬפޤ (ʤ롼פҤˤǤޤ)
 * </P>
 * <P>
 * OPTGROUP  HTML 4 ϼΤȤǤ
 * <PRE>
 * &lt;!ELEMENT OPTGROUP - - (OPTION)+ -- option group --&gt;
 * &lt;!ATTLIST OPTGROUP
 *   %attrs;                              -- %coreattrs, %i18n, %events --
 *   disabled    (disabled)     #IMPLIED  -- unavailable in this context --
 *   label       %Text;         #REQUIRED -- for use in hierarchical menus --
 *   &gt;
 * </PRE>
 * </P>
 * @author Kumiko Hiroi
 */
public class OptgroupTag extends ControlTagSupport
{

	/**
	 * <P>
	 * OptgroupTag ޤ
	 * </P>
	 */
	public OptgroupTag()
	{
		super();
	}

	/**
	 * <P>
	 * disabled °֤ޤ
	 * </P>
	 * @return disabled °
	 */
	public boolean getDisabled()
	{
		return getAttributeMap().getBoolean("disabled");
	}

	/**
	 * <P>
	 * label °֤ޤ
	 * </P>
	 * @return label °
	 */
	public String getLabel()
	{
		return getAttributeMap().getString("label");
	}

	/**
	 * <P>
	 * disabled °ꤷޤ
	 * </P>
	 * @param disabled disabled °
	 */
	public void setDisabled(boolean disabled)
	{
		getAttributeMap().setBoolean("disabled", disabled);
	}

	/**
	 * <P>
	 * label °ꤷޤ
	 * </P>
	 * @param label label °
	 */
	public void setLabel(String label)
	{
		getAttributeMap().setString("label", label);
	}

	/**
	 * <P>
	 * λνǤ
	 * </P>
	 * @return EVAL_PAGE
	 * @see javax.servlet.jsp.tagext.Tag#doEndTag()
	 */
	public int doEndTag() throws JspException
	{
		StringBuffer buf = new StringBuffer();

		buf.append("</optgroup>");

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doEndTag();
	}

	/**
	 * <P>
	 * ϥνǤ
	 * </P>
	 * @return EVAL_BODY_BUFFERED
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException
	{
		//OPTGROUP
		StringBuffer buf = new StringBuffer();
		buf.append("<optgroup");

		String keys[] = new String[this.getAttributeMap().size()];
		keys = (String[])this.getAttributeMap().keySet().toArray(keys);
		for (int i = 0; i < keys.length; i++)
		{
			if (keys[i].equals("disabled"))
			{
				if (this.getAttributeMap().getBoolean(keys[i]))
				{
					buf.append(" ").append(keys[i]);
				}
			}
			else
			{
				buf.append(" ").append(keys[i]).append("=\"").append(this.getAttributeMap().getString(keys[i])).append("\"");
			}
		}
		buf.append(">");

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doStartTag();
	}

}
