/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.servlet.jsp.tagext.TagManager;
import jp.morpho.webapp.servlet.jsp.tagext.TagTemplate;

/**
 * <P>
 * SELECT Ǥϥ˥塼ޤ
 * ˥塼γ OPTION Ǥˤä󼨤ޤ
 * 1 Ĥ SELECT ǤˤϺ 1 Ĥ OPTION ǤޤޤƤɬפޤ
 * </P>
 * <P>
 * SELECT  HTML 4 ϼΤȤǤ
 * <PRE>
 * &lt;!ELEMENT SELECT - - (OPTGROUP|OPTION)+ -- option selector --&gt;
 * &lt;!ATTLIST SELECT
 *   %attrs;                              -- %coreattrs, %i18n, %events --
 *   name        CDATA          #IMPLIED  -- field name --
 *   size        NUMBER         #IMPLIED  -- rows visible --
 *   multiple    (multiple)     #IMPLIED  -- default is single selection --
 *   disabled    (disabled)     #IMPLIED  -- unavailable in this context --
 *   tabindex    NUMBER         #IMPLIED  -- position in tabbing order --
 *   onfocus     %Script;       #IMPLIED  -- the element got the focus --
 *   onblur      %Script;       #IMPLIED  -- the element lost the focus --
 *   onchange    %Script;       #IMPLIED  -- the element value was changed --
 *   &gt;
 * </PRE>
 * </P>
 * @author Kumiko Hiroi
 */
public class SelectTag
	extends ControlTagSupport
	implements TagTemplate
{
	/**
	 * <P>
	 * SelectTag ޤ
	 * </P>
	 */
	public SelectTag()
	{
		super();
	}

	/**
	 * <P>
	 * disabled °֤ޤ
	 * </P>
	 * @return disabled °
	 */
	public boolean getDisabled()
	{
		return getAttributeMap().getBoolean("disabled");
	}

	/**
	 * <P>
	 * multiple °֤ޤ
	 * </P>
	 * @return multiple °
	 */
	public String getMultiple()
	{
		return getAttributeMap().getString("multiple");
	}

	/**
	 * <P>
	 * name °֤ޤ
	 * </P>
	 * @return name °
	 */
	public String getName()
	{
		return getAttributeMap().getString("name");
	}

	/**
	 * <P>
	 * onblur °֤ޤ
	 * </P>
	 * @return onblur °
	 */
	public String getOnblur()
	{
		return getAttributeMap().getString("onblur");
	}

	/**
	 * <P>
	 * onchange °֤ޤ
	 * </P>
	 * @return onchange °
	 */
	public String getOnchange()
	{
		return getAttributeMap().getString("onchange");
	}

	/**
	 * <P>
	 * onfocus °֤ޤ
	 * </P>
	 * @return onfocus °
	 */
	public String getOnfocus()
	{
		return getAttributeMap().getString("onfocus");
	}

	/**
	 * <P>
	 * size °֤ޤ
	 * </P>
	 * @return size °
	 */
	public String getSize()
	{
		return getAttributeMap().getString("size");
	}

	/**
	 * <P>
	 * tabindex °֤ޤ
	 * </P>
	 * @return tabindex °
	 */
	public String getTabindex()
	{
		return getAttributeMap().getString("tabindex");
	}

	/**
	 * <P>
	 * template °֤ޤ
	 * </P>
	 * @return template °
	 */
	public String getTemplate()
	{
		return getAttributeMap().getString("template");
	}

	/**
	 * <P>
	 * disabled °ꤷޤ
	 * </P>
	 * @param disabled disabled °
	 */
	public void setDisabled(boolean disabled)
	{
		getAttributeMap().setBoolean("disabled", disabled);
	}

	/**
	 * <P>
	 * multiple °ꤷޤ
	 * </P>
	 * @param multiple multiple °
	 */
	public void setMultiple(String multiple)
	{
		getAttributeMap().setString("multiple", multiple);
	}

	/**
	 * <P>
	 * name °ꤷޤ
	 * </P>
	 * @param name name °
	 */
	public void setName(String name)
	{
		getAttributeMap().setString("name", name);
	}

	/**
	 * <P>
	 * onblur °ꤷޤ
	 * </P>
	 * @param onblur onblur °
	 */
	public void setOnblur(String onblur)
	{
		getAttributeMap().setString("onblur", onblur);
	}

	/**
	 * <P>
	 * onchange °ꤷޤ
	 * </P>
	 * @param onchange onchange °
	 */
	public void setOnchange(String onchange)
	{
		getAttributeMap().setString("onchange", onchange);
	}

	/**
	 * <P>
	 * onfocus °ꤷޤ
	 * </P>
	 * @param onfocus onfocus °
	 */
	public void setOnfocus(String onfocus)
	{
		getAttributeMap().setString("onfocus", onfocus);
	}

	/**
	 * <P>
	 * size °ꤷޤ
	 * </P>
	 * @param size size °
	 */
	public void setSize(String size)
	{
		getAttributeMap().setString("size", size);
	}

	/**
	 * <P>
	 * tabindex °ꤷޤ
	 * </P>
	 * @param tabindex tabindex °
	 */
	public void setTabindex(String tabindex)
	{
		getAttributeMap().setString("tabindex", tabindex);
	}

	/**
	 * <P>
	 * template °ꤷޤ
	 * </P>
	 * @param template template °
	 */
	public void setTemplate(String template)
	{
		getAttributeMap().setString("template", template);
	}

	/**
	 * <P>
	 * ΥΥפ֤ޤ
	 * </P>
	 * @return ΥΥ
	 * @see jp.morpho.webapp.servlet.jsp.tagext.TagTemplate#getTagType()
	 */
	public String getTagType()
	{
		return "jp.morpho.webapp.servlet.jsp.tagext.html.SelectTag";
	}

	/**
	 * <P>
	 * λνǤ
	 * </P>
	 * @return EVAL_PAGE
	 * @see javax.servlet.jsp.tagext.Tag#doEndTag()
	 */
	public int doEndTag() throws JspException
	{
		StringBuffer buf = new StringBuffer();
		buf.append("</select>");

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doEndTag();
	}

	/**
	 * <P>
	 * ϥνǤ
	 * </P>
	 * @return EVAL_BODY_BUFFERED
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException
	{
		//SELECTޤ
		StringBuffer buf = new StringBuffer();
		buf.append("<select");

		//TagTemplateޤ
		TagManager tm = this.getTagManager();
		TagTemplate ttmp = null;
		if (this.getAttributeMap().containsKey("template"))
		{
			ttmp = tm.getTagTemplate(this.getTagType(), this.getTemplate());
		}
		else
		{
			ttmp = tm.getTagTemplate(this.getTagType(), this.getName());
		}

		ConversionMap attr = new ConversionMap();
		if (ttmp != null)
		{
			attr.putAll(ttmp.getAttributeMap());
		}
		attr.putAll(this.getAttributeMap());
		
		String keys[] = new String[attr.size()];
		keys = (String[])attr.keySet().toArray(keys);
		for (int i = 0; i < keys.length; i++)
		{
			if (keys[i].equals("template"))
			{
				//⤷ʤ
			}
			else if (keys[i].equals("disabled") ||
					keys[i].equals("readonly") ||
					keys[i].equals("checked") ||
					keys[i].equals("ismap"))
			{
				if (attr.getBoolean(keys[i]))
				{
					buf.append(" ").append(keys[i]);
				}
			}
			else if (keys[i].equals("value"))
			{
				buf.append(" ").append(keys[i]).append("=\"").append(attr.getString(keys[i])).append("\"");
			}
			else
			{
				buf.append(" ").append(keys[i]).append("=\"").append(attr.getString(keys[i])).append("\"");
			}
		}
		buf.append(">");

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doStartTag();
	}

}
