/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.http.impl.HttpActionRequestImpl;
import jp.morpho.webapp.servlet.jsp.tagext.TagManager;
import jp.morpho.webapp.servlet.jsp.tagext.TagTemplate;

/**
 * <P>
 * ʣԤΥƥϥȥޤ
 * </P>
 * <P>
 * TEXTAREA  HTML 4 ϼΤȤǤ
 * <PRE>
 * &lt;!ELEMENT TEXTAREA - - (#PCDATA)       -- multi-line text field --&gt;
 * &lt;!ATTLIST TEXTAREA
 *   %attrs;                              -- %coreattrs, %i18n, %events --
 *   name        CDATA          #IMPLIED
 *   rows        NUMBER         #REQUIRED
 *   cols        NUMBER         #REQUIRED
 *   disabled    (disabled)     #IMPLIED  -- unavailable in this context --
 *   readonly    (readonly)     #IMPLIED
 *   tabindex    NUMBER         #IMPLIED  -- position in tabbing order --
 *   accesskey   %Character;    #IMPLIED  -- accessibility key character --
 *   onfocus     %Script;       #IMPLIED  -- the element got the focus --
 *   onblur      %Script;       #IMPLIED  -- the element lost the focus --
 *   onselect    %Script;       #IMPLIED  -- some text was selected --
 *   onchange    %Script;       #IMPLIED  -- the element value was changed --
 *   &gt;
 * </PRE>
 * </P>
 * @author Kumiko Hiroi
 */
public class TextareaTag
	extends ControlTagSupport
	implements TagTemplate
{
	/**
	 * <P>
	 * TextareaTag ޤ
	 * </P>
	 */
	public TextareaTag()
	{
		super();
	}

	/**
	 * <P>
	 * accesskey °֤ޤ
	 * </P>
	 * @return accesskey °
	 */
	public String getAccesskey()
	{
		return getAttributeMap().getString("accesskey");
	}

	/**
	 * <P>
	 * cols °֤ޤ
	 * </P>
	 * @return cols °
	 */
	public String getCols()
	{
		return getAttributeMap().getString("cols");
	}

	/**
	 * <P>
	 * disabled °֤ޤ
	 * </P>
	 * @return disabled °
	 */
	public boolean getDisabled()
	{
		return getAttributeMap().getBoolean("disabled");
	}

	/**
	 * <P>
	 * name °֤ޤ
	 * </P>
	 * @return name °
	 */
	public String getName()
	{
		return getAttributeMap().getString("name");
	}

	/**
	 * <P>
	 * onblur °֤ޤ
	 * </P>
	 * @return onblur °
	 */
	public String getOnblur()
	{
		return getAttributeMap().getString("onblur");
	}

	/**
	 * <P>
	 * onchange °֤ޤ
	 * </P>
	 * @return onchange °
	 */
	public String getOnchange()
	{
		return getAttributeMap().getString("onchange");
	}

	/**
	 * <P>
	 * onfocus °֤ޤ
	 * </P>
	 * @return onfocus °
	 */
	public String getOnfocus()
	{
		return getAttributeMap().getString("onfocus");
	}

	/**
	 * <P>
	 * onselect °֤ޤ
	 * </P>
	 * @return onselect °
	 */
	public String getOnselect()
	{
		return getAttributeMap().getString("onselect");
	}

	/**
	 * <P>
	 * readonly °֤ޤ
	 * </P>
	 * @return readonly °
	 */
	public boolean getReadonly()
	{
		return getAttributeMap().getBoolean("readonly");
	}

	/**
	 * <P>
	 * rows °֤ޤ
	 * </P>
	 * @return rows °
	 */
	public String getRows()
	{
		return getAttributeMap().getString("rows");
	}

	/**
	 * <P>
	 * tabindex °֤ޤ
	 * </P>
	 * @return tabindex °
	 */
	public String getTabindex()
	{
		return getAttributeMap().getString("tabindex");
	}

	/**
	 * <P>
	 * template °֤ޤ
	 * </P>
	 * @return template °
	 */
	public String getTemplate()
	{
		return getAttributeMap().getString("template");
	}

	/**
	 * <P>
	 * accesskey °ꤷޤ
	 * </P>
	 * @param accesskey accesskey °
	 */
	public void setAccesskey(String accesskey)
	{
		getAttributeMap().setString("accesskey", accesskey);
	}

	/**
	 * <P>
	 * cols °ꤷޤ
	 * </P>
	 * @param cols cols °
	 */
	public void setCols(String cols)
	{
		getAttributeMap().setString("cols", cols);
	}

	/**
	 * <P>
	 * disabled °ꤷޤ
	 * </P>
	 * @param disabled disabled °
	 */
	public void setDisabled(boolean disabled)
	{
		getAttributeMap().setBoolean("disabled", disabled);
	}

	/**
	 * <P>
	 * name °ꤷޤ
	 * </P>
	 * @param name name °
	 */
	public void setName(String name)
	{
		getAttributeMap().setString("name", name);
	}

	/**
	 * <P>
	 * onblur °ꤷޤ
	 * </P>
	 * @param onblur onblur °
	 */
	public void setOnblur(String onblur)
	{
		getAttributeMap().setString("onblur", onblur);
	}

	/**
	 * <P>
	 * onchange °ꤷޤ
	 * </P>
	 * @param onchange onchange °
	 */
	public void setOnchange(String onchange)
	{
		getAttributeMap().setString("onchange", onchange);
	}

	/**
	 * <P>
	 * onfocus °ꤷޤ
	 * </P>
	 * @param onfocus onfocus °
	 */
	public void setOnfocus(String onfocus)
	{
		getAttributeMap().setString("onfocus", onfocus);
	}

	/**
	 * <P>
	 * onselect °ꤷޤ
	 * </P>
	 * @param onselect onselect °
	 */
	public void setOnselect(String onselect)
	{
		getAttributeMap().setString("onselect", onselect);
	}

	/**
	 * <P>
	 * readonly °ꤷޤ
	 * </P>
	 * @param readonly readonly °
	 */
	public void setReadonly(boolean readonly)
	{
		getAttributeMap().setBoolean("readonly", readonly);
	}

	/**
	 * <P>
	 * rows °ꤷޤ
	 * </P>
	 * @param rows rows °
	 */
	public void setRows(String rows)
	{
		getAttributeMap().setString("rows", rows);
	}

	/**
	 * <P>
	 * tabindex °ꤷޤ
	 * </P>
	 * @param tabindex tabindex °
	 */
	public void setTabindex(String tabindex)
	{
		getAttributeMap().setString("tabindex", tabindex);
	}

	/**
	 * <P>
	 * template °ꤷޤ
	 * </P>
	 * @param template template °
	 */
	public void setTemplate(String template)
	{
		getAttributeMap().setString("template", template);
	}

	/**
	 * <P>
	 * ΥΥפ֤ޤ
	 * </P>
	 * @return ΥΥ
	 * @see jp.morpho.webapp.servlet.jsp.tagext.TagTemplate#getTagType()
	 */
	public String getTagType()
	{
		return "jp.morpho.webapp.servlet.jsp.tagext.html.TextareaTag";
	}

	/**
	 * <P>
	 * λνǤ
	 * </P>
	 * @return EVAL_PAGE
	 * @see javax.servlet.jsp.tagext.Tag#doEndTag()
	 */
	public int doEndTag() throws JspException
	{
		StringBuffer buf = new StringBuffer();

		//Τʤ
		if (!isBodyExists())
		{
			HttpActionRequest req = new HttpActionRequestImpl((HttpServletRequest)pageContext.getRequest());
			ConversionMap param = ConversionMap.valueOf(req.getParameterMap());
			if (param.containsKey(this.getName()))
			{
				HtmlEncoder encoder = this.getTagManager().getHtmlEncoder();
				buf.append(encoder.encode(param.getString(this.getName())));
			}
		}
		buf.append("</textarea>");

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doEndTag();
	}

	/**
	 * <P>
	 * ϥνǤ
	 * </P>
	 * @return EVAL_BODY_BUFFERED
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException
	{
		//TEXTAREAޤ
		StringBuffer buf = new StringBuffer();
		buf.append("<textarea");

		//TagTemplateޤ
		TagManager tm = this.getTagManager();
		TagTemplate ttmp = null;
		if (this.getAttributeMap().containsKey("template"))
		{
			ttmp = tm.getTagTemplate(this.getTagType(), this.getTemplate());
		}
		else
		{
			ttmp = tm.getTagTemplate(this.getTagType(), this.getName());
		}

		ConversionMap attr = new ConversionMap();
		if (ttmp != null)
		{
			attr.putAll(ttmp.getAttributeMap());
		}
		attr.putAll(this.getAttributeMap());

		String keys[] = new String[attr.size()];
		keys = (String[])attr.keySet().toArray(keys);
		for (int i = 0; i < keys.length; i++)
		{
			if (keys[i].equals("template"))
			{
				//⤷ʤ
			}
			else if (keys[i].equals("disabled") ||
					keys[i].equals("readonly"))
			{
				if (attr.getBoolean(keys[i]))
				{
					buf.append(" ").append(keys[i]);
				}
			}
			else
			{
				buf.append(" ").append(keys[i]).append("=\"").append(attr.getString(keys[i])).append("\"");
			}
		}
		buf.append(">");

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doStartTag();
	}

}
