/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.validator.AbstractFieldValidator;
import jp.morpho.webapp.validator.ValidationException;

public class LongValidator
extends AbstractFieldValidator {
    private Long minimum = null;
    private Long maximum = null;

    public void validate(HttpActionRequest request) throws ValidationException {
        String value = request.getParameter(this.getFieldName());
        if (!this.isValidate(value)) {
            return;
        }
        this.validateRequired(value);
        long number = 0L;
        try {
            number = Long.parseLong(value);
        }
        catch (Exception e) {
            throw new ValidationException("value is not long");
        }
        if (this.minimum != null && this.minimum > number) {
            throw new ValidationException("out of range");
        }
        if (this.maximum != null && this.maximum < number) {
            throw new ValidationException("out of range");
        }
        if (this.getCompareFieldName() != null) {
            if (this.getCompareOperator() == null) {
                throw new ValidationException("compare operator is not set");
            }
            ConversionMap form = ConversionMap.valueOf(request.getParameterMap());
            long compareValue = form.getLong(this.getCompareFieldName());
            String ope = this.getCompareOperator().trim();
            if (ope.equals(">")) {
                if (number <= compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals(">=")) {
                if (number < compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("==")) {
                if (number != compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("<=")) {
                if (number > compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("<")) {
                if (number >= compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("!=")) {
                if (number == compareValue) {
                    throw new ValidationException("compare error");
                }
            } else {
                throw new ValidationException("compare operator is not supported:" + ope);
            }
        }
    }

    public void setMinimum(long value) throws ValidationException {
        this.minimum = new Long(value);
    }

    public void setMaximum(long value) throws ValidationException {
        this.maximum = new Long(value);
    }

    public long getMaximum() {
        return this.maximum != null ? this.maximum : 0L;
    }

    public long getMinimum() {
        return this.minimum != null ? this.minimum : 0L;
    }
}

