/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.morpho.webapp.FrameworkContext;
import jp.morpho.webapp.resource.MessageResourceManager;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.validator.FieldValidator;
import jp.morpho.webapp.validator.FieldValidatorEntry;
import jp.morpho.webapp.validator.ValidationException;
import jp.morpho.webapp.validator.ValidationState;

public class ValidatorSequence
extends ArrayList
implements FieldValidator {
    private String name = null;

    public void setFieldName(String name) {
        this.name = name;
    }

    public String getFieldName() {
        return this.name;
    }

    public void validate(HttpActionRequest request) throws ValidationException {
        boolean errorFlag = false;
        try {
            int i = 0;
            while (i < this.size()) {
                block7: {
                    FieldValidatorEntry entry = (FieldValidatorEntry)this.get(i);
                    FieldValidator validator = entry.getValidator();
                    String messageId = entry.getMessageId();
                    try {
                        validator.validate(request);
                    }
                    catch (Exception e) {
                        errorFlag = true;
                        if (validator.getFieldName() == null) break block7;
                        String message = null;
                        if (messageId != null) {
                            message = this.getMessage(request, validator, messageId);
                        }
                        ValidationState vs = ValidationState.getInstance(request);
                        vs.addInvalidField(validator.getFieldName(), message);
                    }
                }
                ++i;
            }
            if (errorFlag) {
                throw new ValidationException("");
            }
        }
        catch (Exception e) {
            throw new ValidationException(e.getMessage());
        }
    }

    private String getMessage(HttpActionRequest request, FieldValidator validator, String messageId) {
        try {
            FrameworkContext fc = FrameworkContext.getInstance(request.getSession().getServletContext());
            MessageResourceManager mrm = (MessageResourceManager)fc.get("jp.morpho.webapp.resource.MessageResourceManager");
            Locale locale = (Locale)request.getSession().getAttribute("jp.morpho.webapp.servlet.http.HttpSession.locale");
            if (locale == null) {
                locale = request.getLocale();
            }
            String message = mrm.getMessage(messageId, null, locale);
            Pattern formatPattern = Pattern.compile("[{][^}]*[}]");
            Matcher formatMatcher = formatPattern.matcher(message);
            StringBuffer messageBuf = new StringBuffer();
            ArrayList<Object> messageArgList = new ArrayList<Object>();
            int j = 0;
            while (formatMatcher.find()) {
                String format = message.substring(formatMatcher.start(), formatMatcher.end());
                Pattern fieldPattern = Pattern.compile("[^{][^,}]*");
                Matcher fieldMatcher = fieldPattern.matcher(format);
                fieldMatcher.find();
                String fieldName = format.substring(fieldMatcher.start(), fieldMatcher.end()).trim();
                String messageFormat = fieldMatcher.replaceFirst("" + j);
                formatMatcher.appendReplacement(messageBuf, messageFormat);
                String methodName = "get";
                if (fieldName.length() == 1) {
                    methodName = String.valueOf(methodName) + fieldName.toUpperCase();
                } else if (fieldName.length() > 1) {
                    methodName = String.valueOf(methodName) + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                }
                Method method = validator.getClass().getMethod(methodName, null);
                Object messageArg = method.invoke((Object)validator, null);
                if (fieldName.equalsIgnoreCase("fieldname") || fieldName.equalsIgnoreCase("compareFieldName")) {
                    messageArg = mrm.getFieldName((String)messageArg, locale);
                } else if (fieldName.equalsIgnoreCase("compareOperator")) {
                    messageArg = mrm.getMessage("compareOperator." + (String)messageArg, null, locale);
                }
                messageArgList.add(messageArg);
                ++j;
            }
            if (messageArgList.size() > 0) {
                formatMatcher.appendTail(messageBuf);
                MessageFormat mf = new MessageFormat(messageBuf.toString());
                message = mf.format(messageArgList.toArray());
            }
            return message;
        }
        catch (Exception e) {
            Logger log = Logger.getLogger("jp.morpho");
            log.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }
}

