/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * <P>
 * ̓Xg[ɋ@\Aɓ͂obt@Ɋi[@\ mark \bh reset \bhT|[g@\ǉ܂B
 * ExpandedInputStream 쐬ƁAobt@z񂪍쐬܂B
 * Xg[̃oCgǂݍ܂邩XLbvƁAi[Ă̓Xg[KvɉĈxɑ̃oCgobt@ɕ[܂B
 * mark Iy[V͓̓Xg[̓ʒuL܂B
 * reset Iy[V́Ai[Ă̓Xg[VoCg擾OɁAŌɎsꂽ mark Iy[Vȍ~ɓǂݍ܂ꂽׂẴoCgēǂݍ݂܂B
 * </P>
 * @author Kumiko Hiroi
 */
public class ExpandedInputStream
	extends BufferedInputStream
{

	/**
	 * <P>
	 * ExpandedInputStream 쐬Äł̓Xg[ in ƂŎgpł悤ɕۑ܂B
	 * obt@z񂪍쐬Abuf Ɋi[܂B
	 * </P>
	 * @param in {ƂȂ̓Xg[
	 */
	public ExpandedInputStream(InputStream in)
	{
		super(in);
	}

	/**
	 * <P>
	 * w肳ꂽobt@TCY ExpandedInputStream 쐬Äł̓Xg[ in ƂŎgpł悤ɕۑ܂B
	 *  size ̓obt@z񂪍쐬Abuf Ɋi[܂B
	 * </P>
	 * @param in {ƂȂ̓Xg[
	 * @param size obt@TCY
	 * @exception IllegalArgumentException size  0 ȉ̏ꍇ
	 */
	public ExpandedInputStream(InputStream in, int size)
	{
		super(in, size);
	}

	/**
	 * <P>
	 * ̓Xg[炷ׂĂ̓eǂݍ݂܂B
	 * </P>
	 * @exception IOException o̓G[ꍇ
	 */
	public synchronized byte[] readAll()
		throws IOException
	{
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		writeTo(out);

		return out.toByteArray();
	}

	/**
	 * <P>
	 * ̓Xg[ׂ̂Ă̓eAw肳ꂽo̓Xg[ɏ݂܂B
	 *  out.write(byte[], int, int) gďo̓Xg[ write \bhĂяôƓłB
	 * </P>
	 * @param out f[^ޏo̓Xg[
	 * @exception IOException o̓G[ꍇ
	 */
	public synchronized void writeTo(OutputStream out)
		throws IOException
	{
		byte[] b = new byte[buf.length];
		int len = 0;
		while ((len = read(b, 0, b.length)) != -1)
		{
			out.write(b, 0, len);
		}
	}

	/**
	 * <P>
	 * ExpandedInputStream 쐬Äł̓Xg[ in ƂŎgpł悤ɕۑ܂B
	 * in  ExpandedInputStream ̏ꍇ́AԂ܂B
	 * </P>
	 * @param in {ƂȂ̓Xg[
	 */
	public synchronized static ExpandedInputStream valueOf(InputStream in)
	{
		if (in instanceof ExpandedInputStream)
		{
			return (ExpandedInputStream)in;
		}
		else
		{
			return new ExpandedInputStream(in);
		}
	}
}
