/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import jp.morpho.util.ConversionMap;

/**
 * <P>
 * ̃NX́AFilter C^tF[X̃XPg񋟂ÃC^tF[X̂ɕKvȍƗʂŏɗ}܂B
 * Filter ́A\[X (T[ubgAÓIRec) ̗vA\[X̉A܂̗͂ɑ΂ătB^OƂsIuWFNgłB
 * </P>
 * <P>
 * Filter ́AdoFilter \bhɂătB^Os܂BׂĂ Filter  FilterConfig IuWFNgփANZXłÃIuWFNgAp[^ƁAtB^OɕKvȃ\[X̃[hȂǂɎgpł ServletContext ւ̎QƂ擾邱Ƃł܂B
 * </P>
 * <P>
 * Filter ́AWeb AvP[V̔zLqqŐݒ肳܂B
 * </P>
 * <P>
 * Filter ̗ɂ́Â̂܂B
 * <BR>1) F؃tB^
 * <BR>2) Oъč̃tB^
 * <BR>3) C[WϊtB^
 * <BR>4) f[^ktB^
 * <BR>5) ÍtB^
 * <BR>6) g[NtB^
 * <BR>7) \[Xւ̃ANZXCxg𔭐tB^
 * <BR>8) XSL/T tB^
 * <BR>9) MiME ^Cv`F|tB^
 * </P>
 * @author Kumiko Hiroi
 */
public abstract class AbstractFilter
	implements Filter
{

	/** p[^i[}bv */
	private ConversionMap parameters = null;

	/** T[ubgReLXg */
	private ServletContext sc = null;

	/**
	 * <P>
	 * AbstractFilter \z܂B
	 * </P>
	 */
	public AbstractFilter()
	{
		super();
		parameters = new ConversionMap();
	}

	/**
	 * <P>
	 * tB^T[rXJnԂɂȂۂɁAWeb ReiɂČĂяo܂B
	 * T[ubgReíAtB^CX^XɁAinit \bh 1 񂾂Ăяo܂B
	 * tB^ɃtB^OƂs悤ɗvɂ́Ainit \bhɏIĂȂ΂Ȃ܂B
	 * </P>
	 * <P>
	 * ̃\bh́AׂĂ̏p[^擾悤ɎĂ܂B
	 * 擾ꂽp[^́AgetInitParameterMap() \bh Map ƂĎ擾ł܂B
	 * ̃\bhI[o[Chꍇ́Asuper.init(filterConfig) ĂяoĂB
	 * </P>
	 * <P>
	 * init \bĥꂩ̏Ԃ̏ꍇAWeb Rei̓tB^T[rXԂɂł܂B
	 * <BR>1.ServletException X[
	 * <BR>2.Web ReiɂĒ`ꂽԓɁAAȂ
	 * </P>
	 * @param filterConfig T[ubgReiɂĎgptB^ݒ̂߂̃IuWFNg
	 * @exception ServletException tB^łȂꍇ
	 * @see javax.servlet.Filter#init(FilterConfig)
	 */
	public void init(FilterConfig filterConfig) throws ServletException
	{
		sc = filterConfig.getServletContext();
		for(Enumeration enum = filterConfig.getInitParameterNames(); enum.hasMoreElements();)
		{
			String name = (String)enum.nextElement();
			try
			{
				setInitParameter(name, filterConfig.getInitParameter(name));
			}
			catch (Exception e)
			{
			}
		}
	}

	/**
	 * <P>
	 * Filter  doFilter \bh́A`F[̏I[ɂ郊\[XNCAgv邱ƂƂāAvƉ̃yA`F|ɉēnĂƂɁAReiɌĂяo܂B
	 * ̃\bh֓n FilterChain ɂāAFilter ͗vƉ`F|̎̃GeBeBɓnƂł܂B
	 * </P>
	 * <P>
	 * <DL>
	 * <DD>Filter  doFilter \bh́A`F[̏I[ɂ郊\[XNCAgv邱ƂƂāAvƉ̃yA`F|ɉēnĂƂɁAReiɌĂяo܂B̃\bh֓n FilterChain ɂāAFilter ͗vƉ`F|̎̃GeBeBɓnƂł܂B
	 * <P>
	 * ̃\bh̓T^IȎ́Â悤ɍs܂B
	 * <BR>1. v
	 * <BR>2. IvVƂāA̓tB^OpɃRec܂̓wb_tB^OJX^ɂAvIuWFNgbv
	 * <BR>3. IvVƂāAo̓tB^OpɃRec܂̓wb_tB^OJX^ɂAIuWFNgbv
	 * <BR>4. a) FilterChain IuWFNggpă`F[̎̃GeBeBĂяo (chain.doFilter())
	 * <BR>4. b) ܂́Avɑ΂鏈ł؂邽߁AtB^`F[̎̃GeBeBɗvƉ̃yAnȂ
	 * <BR>5. tB^`F[̎̃GeBeBĂяoɁAɑ΂ăwb_𒼐ڐݒ肷
	 * </P>
	 * </DL>
	 * </P>
	 * <P>
	 * ̃\bh͋̒`Ă܂B
	 * KvłȂ AbstractFilter NX̃TuNXɂāÃ\bhł܂B
	 * </P>
	 * @param request NCAgT[ubgɍsv܂ ServletRequest IuWFNg
	 * @param response T[ubgNCAgɑM鉞܂ ServletResponse IuWFNg
	 * @param chain tB^`F[
	 * @exception IOException tB^vƂɁAo̓G[oꂽꍇ
	 * @exception ServletException vłȂꍇ
	 * @see javax.servlet.Filter#doFilter(ServletRequest, ServletResponse, FilterChain)
	 */
	public void doFilter(
		ServletRequest request,
		ServletResponse response,
		FilterChain chain)
		throws IOException, ServletException
	{
	}

	/**
	 * <P>
	 * tB^T[rXԂIۂɁAWeb ReiɂČĂяo܂B
	 * tB^ doFilter \bĥׂẴXbhIA܂̓^CAEgԂ߂ɂ̂݁Ã\bh͌Ăяo܂B
	 * ̃\bhĂяóAWeb Rei̓tB^̂̃CX^Xɑ΂ doFilter xƌĂяoƂ͂܂B
	 * </P>
	 * <P>
	 * ̃\bh́AAt@CnhAXbhȂǂ̕ێĂ郊\[X@AтׂĂ̎IԂƁÃtB^݂̌̏ԂƂ̓邽߂̋@񋟂܂B
	 * </P>
	 * <P>
	 * ̃\bh͋̒`Ă܂B
	 * KvłȂ AbstractFilter NX̃TuNXɂāÃ\bhł܂B
	 * </P>
	 * @see javax.servlet.Filter#destroy()
	 */
	public void destroy()
	{
	}

	/**
	 * <P>
	 * ׂĂ̏p[^̃}bsOi[ꂽ Map Ԃ܂B
	 * p[^݂Ȃꍇ́A Map Ԃ܂B
	 * </P>
	 * <P>
	 * Ԃ Map ̎́AConversionMap łB
	 * </P>
	 * @return ׂĂ̏p[^̃}bsOi[ꂽ Map
	 */
	public Map getInitParameterMap()
	{
		return parameters;
	}

	/**
	 * <P>
	 * p[^ Map Ɋi[܂B
	 * </P>
	 * @param name p[^̖O
	 * @param value p[^̒l
	 */
	private void setInitParameter(String name, String value)
	{
		parameters.putString(name, value);
	}

	/**
	 * <P>
	 * ĂяoݎsĂ ServletContext ւ̎QƂԂ܂B
	 * </P>
	 * @return ĂяoT[ubgReiƂ̑Θb̂߂ɎgpĂ ServletContext IuWFNg
	 */
	public ServletContext getServletContext()
	{
		return sc;
	}

}
