/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import jp.morpho.webapp.servlet.jsp.tagext.BaseTag;

/**
 * <P>
 * `FbN{bNXAWI{^Aj[Ȃǂ̃Rg[^Onh`邽߂̊NXłB
 * </P>
 * @author Kumiko Hiroi
 */
public abstract class ControlTagSupport
	extends BaseTag
	implements Attrs
{
	/**
	 * <P>
	 * ftHg̃RXgN^łB
	 * ׂẴTuNX́AVOj`[ public RXgN^`AX[p[NX̃RXgN^ĂяoKv܂B
	 * ̃RXgN^́AJSP gX[^ɂĐꂽR[hĂяo܂B
	 * </P>
	 */
	public ControlTagSupport()
	{
		super();
	}

	/**
	 * <P>
	 * class Ԃ܂B
	 * </P>
	 * @return class 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.CoreAttrs#getStyleclass()
	 */
	public String getStyleclass()
	{
		return getAttributeMap().getString("class");
	}

	/**
	 * <P>
	 * id Ԃ܂B
	 * </P>
	 * @return id 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.CoreAttrs#getStyleid()
	 */
	public String getStyleid()
	{
		return getAttributeMap().getString("id");
	}

	/**
	 * <P>
	 * style Ԃ܂B
	 * </P>
	 * @return style 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.CoreAttrs#getStyle()
	 */
	public String getStyle()
	{
		return getAttributeMap().getString("style");
	}

	/**
	 * <P>
	 * title Ԃ܂B
	 * </P>
	 * @return title 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.CoreAttrs#getTitle()
	 */
	public String getTitle()
	{
		return getAttributeMap().getString("title");
	}

	/**
	 * <P>
	 * class ݒ肵܂B
	 * </P>
	 * @param cls class 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.CoreAttrs#setStyleclass(String)
	 */
	public void setStyleclass(String cls)
	{
		getAttributeMap().putString("class", cls);
	}

	/**
	 * <P>
	 * id ݒ肵܂B
	 * </P>
	 * @param id id 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.CoreAttrs#setStyleid(String)
	 */
	public void setStyleid(String id)
	{
		getAttributeMap().putString("id", id);
	}

	/**
	 * <P>
	 * style ݒ肵܂B
	 * </P>
	 * @param style style 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.CoreAttrs#setStyle(String)
	 */
	public void setStyle(String style)
	{
		getAttributeMap().putString("style", style);
	}

	/**
	 * <P>
	 * title ݒ肵܂B
	 * </P>
	 * @param title title 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.CoreAttrs#setTitle(String)
	 */
	public void setTitle(String title)
	{
		getAttributeMap().putString("title", title);
	}

	/**
	 * <P>
	 * onclick Ԃ܂B
	 * </P>
	 * @return onclick 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnclick()
	 */
	public String getOnclick()
	{
		return getAttributeMap().getString("onclick");
	}

	/**
	 * <P>
	 * ondblclick Ԃ܂B
	 * </P>
	 * @return ondblclick 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOndblclick()
	 */
	public String getOndblclick()
	{
		return getAttributeMap().getString("ondblclick");
	}

	/**
	 * <P>
	 * onkeydown Ԃ܂B
	 * </P>
	 * @return onkeydown 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnkeydown()
	 */
	public String getOnkeydown()
	{
		return getAttributeMap().getString("onkeydown");
	}

	/**
	 * <P>
	 * onkeypress Ԃ܂B
	 * </P>
	 * @return onkeypress 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnkeypress()
	 */
	public String getOnkeypress()
	{
		return getAttributeMap().getString("onkeypress");
	}

	/**
	 * <P>
	 * onkeyup Ԃ܂B
	 * </P>
	 * @return onkeyup 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnkeyup()
	 */
	public String getOnkeyup()
	{
		return getAttributeMap().getString("onkeyup");
	}

	/**
	 * <P>
	 * onmousedown Ԃ܂B
	 * </P>
	 * @return onmousedown 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnmousedown()
	 */
	public String getOnmousedown()
	{
		return getAttributeMap().getString("onmousedown");
	}

	/**
	 * <P>
	 * onmousemove Ԃ܂B
	 * </P>
	 * @return onmousemove 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnmousemove()
	 */
	public String getOnmousemove()
	{
		return getAttributeMap().getString("onmousemove");
	}

	/**
	 * <P>
	 * onmouseout Ԃ܂B
	 * </P>
	 * @return onmouseout 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnmouseout()
	 */
	public String getOnmouseout()
	{
		return getAttributeMap().getString("onmouseout");
	}

	/**
	 * <P>
	 * onmouseover Ԃ܂B
	 * </P>
	 * @return onmouseover 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnmouseover()
	 */
	public String getOnmouseover()
	{
		return getAttributeMap().getString("onmouseover");
	}

	/**
	 * <P>
	 * onmouseup Ԃ܂B
	 * </P>
	 * @return onmouseup 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#getOnmouseup()
	 */
	public String getOnmouseup()
	{
		return getAttributeMap().getString("onmouseup");
	}

	/**
	 * <P>
	 * onclick ݒ肵܂B
	 * </P>
	 * @param onclick onclick 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnclick(String)
	 */
	public void setOnclick(String onclick)
	{
		getAttributeMap().putString("onclick", onclick);
	}

	/**
	 * <P>
	 * ondblclick ݒ肵܂B
	 * </P>
	 * @param ondblclick ondblclick 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOndblclick(String)
	 */
	public void setOndblclick(String ondblclick)
	{
		getAttributeMap().putString("ondblclick", ondblclick);
	}

	/**
	 * <P>
	 * onkeydown ݒ肵܂B
	 * </P>
	 * @param onkeydown onkeydown 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnkeydown(String)
	 */
	public void setOnkeydown(String onkeydown)
	{
		getAttributeMap().putString("onkeydown", onkeydown);
	}

	/**
	 * <P>
	 * onkeypress ݒ肵܂B
	 * </P>
	 * @param onkeypress onkeypress 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnkeypress(String)
	 */
	public void setOnkeypress(String onkeypress)
	{
		getAttributeMap().putString("onkeypress", onkeypress);
	}

	/**
	 * <P>
	 * onkeyup ݒ肵܂B
	 * </P>
	 * @param onkeyup onkeyup 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnkeyup(String)
	 */
	public void setOnkeyup(String onkeyup)
	{
		getAttributeMap().putString("onkeyup", onkeyup);
	}

	/**
	 * <P>
	 * onmousedown ݒ肵܂B
	 * </P>
	 * @param onmousedown onmousedown 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnmousedown(String)
	 */
	public void setOnmousedown(String onmousedown)
	{
		getAttributeMap().putString("onmousedown", onmousedown);
	}

	/**
	 * <P>
	 * onmousemove ݒ肵܂B
	 * </P>
	 * @param onmousemove onmousemove 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnmousemove(String)
	 */
	public void setOnmousemove(String onmousemove)
	{
		getAttributeMap().putString("onmousemove", onmousemove);
	}

	/**
	 * <P>
	 * onmouseout ݒ肵܂B
	 * </P>
	 * @param onmouseout onmouseout 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnmouseout(String)
	 */
	public void setOnmouseout(String onmouseout)
	{
		getAttributeMap().putString("onmouseout", onmouseout);
	}

	/**
	 * <P>
	 * onmouseover ݒ肵܂B
	 * </P>
	 * @param onmouseover onmouseover 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnmouseover(String)
	 */
	public void setOnmouseover(String onmouseover)
	{
		getAttributeMap().putString("onmouseover", onmouseover);
	}

	/**
	 * <P>
	 * onmouseup ݒ肵܂B
	 * </P>
	 * @param onmouseup onmouseup 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.Events#setOnmouseup(String)
	 */
	public void setOnmouseup(String onmouseup)
	{
		getAttributeMap().putString("onmouseup", onmouseup);
	}

	/**
	 * <P>
	 * dir Ԃ܂B
	 * </P>
	 * @return dir 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.I18n#getDir()
	 */
	public String getDir()
	{
		return getAttributeMap().getString("dir");
	}

	/**
	 * <P>
	 * lang Ԃ܂B
	 * </P>
	 * @return lang 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.I18n#getLang()
	 */
	public String getLang()
	{
		return getAttributeMap().getString("lang");
	}

	/**
	 * <P>
	 * dir ݒ肵܂B
	 * </P>
	 * @param dir dir 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.I18n#setDir(String)
	 */
	public void setDir(String dir)
	{
		getAttributeMap().putString("dir", dir);
	}

	/**
	 * <P>
	 * lang ݒ肵܂B
	 * </P>
	 * @param lang lang 
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.I18n#setLang(String)
	 */
	public void setLang(String lang)
	{
		getAttributeMap().putString("lang", lang);
	}

}
