/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.resource;

import java.io.IOException;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

import jp.morpho.webapp.FrameworkContext;
import jp.morpho.webapp.FrameworkException;
import jp.morpho.webapp.PluginKeys;
import jp.morpho.webapp.resource.MessageResourceManager;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.http.HttpSessionAttributeNames;
import jp.morpho.webapp.servlet.http.impl.HttpActionRequestImpl;
import jp.morpho.webapp.servlet.jsp.tagext.BaseTag;

/**
 * @author Kenichi Fukuda
 */
public class FieldNameTag
	extends BaseTag
{
	public FieldNameTag()
	{
		super();
	}

	public String getFieldname()
	{
		return getAttributeMap().getString("fieldname");
	}

	public void setFieldname(String fieldName)
	{
		getAttributeMap().putString("fieldname", fieldName);
	}

	public Locale getLocale()
	{
		return (Locale)getAttributeMap().getObject("locale");
	}

	public void setLocale(Locale locale)
	{
		getAttributeMap().putObject("locale", locale);
	}

	/**
	 * <P>
	 * Jn^ȌłB
	 * </P>
	 * @return EVAL_BODY_BUFFERED
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException
	{
		StringBuffer buf = new StringBuffer();

		HttpActionRequest request = new HttpActionRequestImpl((HttpServletRequest)pageContext.getRequest());
		try
		{
			FrameworkContext fc = FrameworkContext.getInstance(request.getSession().getServletContext());
			MessageResourceManager mrm = (MessageResourceManager)fc.get(PluginKeys.messageResourceManager);

			Locale locale = getLocale();
			if (locale == null)
			{
				locale = (Locale)request.getSession().getAttribute(HttpSessionAttributeNames.locale);
			}
			if (locale == null)
			{
				locale = request.getLocale();
			}

			String message = mrm.getFieldName(getFieldname(), locale);

			buf.append(message);
		}
		catch (FrameworkException e1)
		{
		}

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doStartTag();
	}

}
