/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.common;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.mosp.common.common.ActionInterface;
import jp.mosp.common.common.BaseDto;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.DBConnBean;
import jp.mosp.common.common.FileUploadUtility;
import jp.mosp.common.common.LogUtility;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.VoInterface;
import jp.mosp.common.dao.CmCodeDao;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmCodeDto;
import jp.mosp.common.dto.CmUserDto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseAction
extends DBConnBean
implements ActionInterface {
    private boolean needHeader = true;
    private boolean needSession = true;
    private boolean needAspUser = true;
    private boolean needUser = true;
    private boolean checkProcSeq = true;
    private boolean needProcSeq = true;
    private boolean checkAuth = true;
    private String application = "common";
    private ArrayList<String> authorized;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected HttpSession session;
    protected ServletContext ctx;
    protected Properties ctl;
    protected Properties cfg;
    protected Properties msg;
    protected Properties nam;
    protected CmAspUserDto aspUser;
    protected CmUserDto user;
    protected String cmd;
    protected String key1;
    protected String key2;
    protected String[] key;
    protected List<?> multipartFieldList;
    private VoInterface vo;
    private String url;
    private String nextCmd;

    @Override
    public void init(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.request = request;
        this.response = response;
        this.ctx = (ServletContext)request.getAttribute("ctx");
        this.ctl = (Properties)request.getAttribute("ctl");
        this.cfg = (Properties)request.getAttribute("cfg");
        this.msg = (Properties)request.getAttribute("msg");
        this.nam = (Properties)request.getAttribute("nam");
        this.cmd = (String)request.getAttribute("cmd");
        this.key1 = request.getParameter("key1");
        this.key2 = request.getParameter("key2");
        this.multipartFieldList = (List)request.getAttribute("multipartList");
        if (this.key1 == null && this.multipartFieldList != null) {
            this.key1 = FileUploadUtility.getMultipartField(this.multipartFieldList, "key1");
        }
        if (this.key2 == null && this.multipartFieldList != null) {
            this.key2 = FileUploadUtility.getMultipartField(this.multipartFieldList, "key2");
        }
        this.key = request.getParameterValues("key");
    }

    @Override
    public void doAction() throws Exception {
        try {
            this.preAction();
            LogUtility.log(this.request, 1, "\u30a2\u30af\u30b7\u30e7\u30f3", "\u958b\u59cb");
            this.action();
            LogUtility.log(this.request, 1, "\u30a2\u30af\u30b7\u30e7\u30f3", "\u7d42\u4e86");
            this.setParams();
        }
        catch (Exception e) {
            this.setParams();
            throw e;
        }
        finally {
            this.afterAction();
        }
    }

    private void preAction() throws Exception {
        String responseType = (String)this.request.getAttribute("resType");
        if (this.needHeader) {
            if (!responseType.equals("file")) {
                this.response.setHeader("Pragma", "no-cache");
                this.response.setHeader("Cache-Control", "no-cache");
                this.response.addHeader("Cache-Control", "no-store");
            }
            this.response.setDateHeader("Expires", 0L);
            this.response.setContentType("text/html; charset=Windows-31J");
        }
        if (this.needSession) {
            this.session = this.request.getSession(false);
            if (this.session == null) {
                this.nextCmd = this.getIndexCommand(false);
                this.addList(this.bringErrMessage(), MospUtility.getMessage(this.msg, "WC1011", ""));
                throw new MospException(1011);
            }
            int interval = Integer.parseInt(this.cfg.getProperty("app.interval"));
            this.session.setMaxInactiveInterval(interval);
        }
        if (this.needAspUser) {
            this.aspUser = (CmAspUserDto)this.session.getAttribute("aspUser");
            if (this.aspUser == null) {
                this.nextCmd = this.getIndexCommand(false);
                throw new MospException(1012);
            }
            this.request.setAttribute("aspUser", (Object)this.aspUser);
        }
        if (this.needUser) {
            this.user = (CmUserDto)this.session.getAttribute("user");
            if (this.user == null) {
                this.nextCmd = this.getIndexCommand(false);
                throw new MospException(1012);
            }
            this.request.setAttribute("user", (Object)this.user);
        }
        if (this.checkProcSeq) {
            String procSeq = (String)this.request.getAttribute("procSeq");
            if (procSeq == null && (procSeq = this.request.getParameter("procSeq")) == null && this.multipartFieldList != null) {
                procSeq = FileUploadUtility.getMultipartField(this.multipartFieldList, "procSeq");
            }
            if (procSeq == null) {
                throw new MospException(4004);
            }
            String storedProcSeq = (String)this.session.getAttribute("procSeq");
            if (!procSeq.equals(storedProcSeq)) {
                String rep = procSeq + "," + storedProcSeq;
                String message = MospUtility.replace("\u9001\u4fe1\u51e6\u7406\u30b7\u30fc\u30b1\u30f3\u30b9\uff1a%1% \u3068 \u4fdd\u6301\u51e6\u7406\u30b7\u30fc\u30b1\u30f3\u30b9\uff1a%2% \u304c\u7570\u306a\u308a\u307e\u3059\u3002", rep);
                LogUtility.log(this.request, 4, "MosP\u60c5\u5831", message);
                this.nextCmd = this.getIndexCommand(true);
                throw new MospException(1013);
            }
        }
        if (this.checkAuth) {
            boolean hasAuth = false;
            String auth = null;
            if (this.application.equals("common")) {
                auth = this.user.getMospAuthority();
            } else if (this.application.equals("payroll")) {
                auth = this.user.getPayrollAuthority();
            } else if (this.application.equals("expense")) {
                auth = this.user.getExpenseAuthority();
            } else if (this.application.equals("sales")) {
                auth = this.user.getSalesAuthority();
            } else if (this.application.equals("lease")) {
                auth = this.user.getExt1Authority();
            } else if (this.application.equals("ext2")) {
                auth = this.user.getExt2Authority();
            } else if (this.application.equals("ext3")) {
                auth = this.user.getExt3Authority();
            } else if (this.application.equals("ext4")) {
                auth = this.user.getExt4Authority();
            } else if (this.application.equals("ext5")) {
                auth = this.user.getExt5Authority();
            } else {
                throw new MospException(5004);
            }
            Iterator<String> it = this.authorized.iterator();
            while (it.hasNext()) {
                if (!it.next().equals(auth)) continue;
                hasAuth = true;
                break;
            }
            if (!hasAuth) {
                throw new MospException(4006);
            }
        }
    }

    protected void afterAction() throws SQLException {
        this.rollback();
        this.releaseConnection();
        if (this.session == null) {
            return;
        }
        String procSeq = null;
        procSeq = this.needProcSeq ? MospUtility.generateProcSeq(this.hasMospSeJar(), (String)this.session.getAttribute("procSeq")) : (String)this.session.getAttribute("procSeq");
        this.request.setAttribute("procSeq", (Object)procSeq);
        this.session.setAttribute("procSeq", (Object)procSeq);
        if (this.vo != null) {
            this.vo.setProcSeq(procSeq);
        }
    }

    protected void getConnection() throws ClassNotFoundException, SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            super.getConnection(this.aspUser.getDbDriver(), this.aspUser.getDbUrl(), this.aspUser.getDbUser(), this.aspUser.getDbPass());
        }
    }

    protected void authorize(String authority) {
        this.authorized = this.authorized != null ? this.authorized : new ArrayList();
        this.authorized.add(authority);
    }

    private void setParams() {
        if (this.nextCmd == null) {
            String message = (String)this.request.getAttribute("message");
            List<String> errMessage = this.bringErrMessage();
            if (message != null && this.vo != null) {
                this.vo.setMessage(message);
            }
            if (errMessage != null && this.vo != null) {
                for (int i = 0; i < errMessage.size(); ++i) {
                    this.vo.addErrMessage(errMessage.get(i));
                }
            }
            this.request.setAttribute("vo", (Object)this.vo);
            this.request.setAttribute("url", (Object)this.url);
        } else {
            this.request.setAttribute("url", (Object)"/srv/");
            this.request.setAttribute("nextCmd", (Object)this.nextCmd);
        }
    }

    protected void setMessage(String strMessage) {
        this.request.setAttribute("message", (Object)strMessage);
    }

    protected void addErrMessage(String strErrMessage) {
        this.addList(this.bringErrMessage(), strErrMessage);
    }

    private List<String> bringErrMessage() {
        Object obj = this.request.getAttribute("errMessage");
        if (obj != null && obj instanceof List) {
            return (List)obj;
        }
        ArrayList<String> list = new ArrayList<String>();
        this.request.setAttribute("errMessage", list);
        return list;
    }

    protected void storeVo(String key, VoInterface vo) {
        this.putMap(this.bringStoredVo(), key, vo);
        this.session.setAttribute("formerVo", (Object)vo);
    }

    protected VoInterface getStoredVo(String key) {
        return this.bringStoredVo().get(key);
    }

    protected void removeStoredVo(String key) {
        this.bringStoredVo().remove(key);
    }

    private Map<String, VoInterface> bringStoredVo() {
        Object obj = this.session.getAttribute("storeVo");
        if (obj != null && obj instanceof Map) {
            return (Map)obj;
        }
        HashMap<String, VoInterface> map = new HashMap<String, VoInterface>();
        this.session.setAttribute("storeVo", map);
        return map;
    }

    protected BaseVo prepareVo() throws MospException {
        return this.prepareVo(true);
    }

    protected BaseVo prepareVo(boolean useStoredVo) throws MospException {
        BaseVo baseVo = this.getSpecificVo();
        if (baseVo == null) {
            return null;
        }
        VoInterface storedVo = this.getStoredVo(baseVo.getClassName());
        if (storedVo != null && useStoredVo) {
            this.chkInstance(storedVo instanceof BaseVo);
            baseVo = (BaseVo)storedVo;
        }
        this.storeVo(baseVo.getClassName(), baseVo);
        baseVo.initVo(this.cfg, this.msg, this.nam, this.cmd, this.aspUser, this.user);
        baseVo.clearMessage();
        baseVo.clearErrField();
        this.setVo(baseVo);
        this.setUrl(baseVo.getRetUrl());
        return baseVo;
    }

    protected BaseVo getSpecificVo() {
        return new BaseVo();
    }

    protected void initStoredData() {
        this.session.removeAttribute("storeVo");
        this.session.removeAttribute("formerVo");
        this.session.removeAttribute("dto");
        this.session.removeAttribute("list");
    }

    protected void chkExist(BaseDto dto) throws MospException {
        if (dto == null) {
            throw new MospException(4007);
        }
    }

    protected void chkUpdate(BaseDto dto) throws MospException {
        if (dto == null) {
            throw new MospException(1022);
        }
    }

    protected void chkInsert(BaseDto dto) throws MospException {
        if (dto == null) {
            throw new MospException(1021);
        }
    }

    protected void chkDuplicate(BaseDto dto, VoInterface vo) throws MospException {
        if (dto != null) {
            vo.addErrMessage(MospUtility.getMessage(this.msg, "WC1023", ""));
            throw new MospException(1023);
        }
    }

    protected void chkExclusive(BaseDto formerDto, BaseDto currentDto, VoInterface vo) throws MospException {
        this.chkExist(currentDto);
        if (formerDto.getUpdateDate().compareTo(currentDto.getUpdateDate()) != 0) {
            vo.addErrMessage(MospUtility.getMessage(this.msg, "WC1024", ""));
            throw new MospException(1024);
        }
    }

    protected void chkCodeExist(BaseDto dto, String targetId, VoInterface vo) throws MospException {
        if (dto == null) {
            vo.addErrMessage(MospUtility.getMessage(this.msg, "WC1006", ""));
            vo.addErrField(targetId);
            throw new MospException(1006);
        }
    }

    protected void chkCodeExist(BaseDto dto, int rowNo, String targetId, VoInterface vo) throws MospException {
        if (dto == null) {
            vo.addErrMessage(MospUtility.getMessage(this.msg, "WC1006", ""));
            vo.addErrDetails(rowNo, targetId);
            throw new MospException(1006);
        }
    }

    protected void chkInstance(boolean isInstance) throws MospException {
        if (!isInstance) {
            throw new MospException(9002);
        }
    }

    protected String[][] getCodeArray(String tId) throws Exception {
        try {
            this.getConnection();
            CmCodeDao dao = new CmCodeDao(this.cfg, this.cmd, this.aspUser, this.user, this.conn);
            List<CmCodeDto> list = dao.findForCondition(tId);
            String[][] array = new String[list.size()][2];
            for (int i = 0; i < list.size(); ++i) {
                CmCodeDto dto = list.get(i);
                array[i][0] = dto.getTCode();
                array[i][1] = dto.getTName();
            }
            String[][] stringArray = array;
            return stringArray;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.rollback();
            this.releaseConnection();
        }
    }

    protected void addList(List list, Object obj) {
        list.add(obj);
    }

    protected void putMap(Map map, Object key, Object obj) {
        map.put(key, obj);
    }

    protected String getCsvData(String data) {
        if (data == null) {
            return "";
        }
        String newData = data.replaceAll("\"", "\"\"");
        return "\"" + newData + "\"";
    }

    protected String getCsvData(int data) {
        return "\"" + String.valueOf(data) + "\"";
    }

    protected String getCsvData(float data) {
        return "\"" + String.valueOf(data) + "\"";
    }

    protected String getCsvData(Date data, String format) {
        if (data == null) {
            return "";
        }
        String newData = MospUtility.getDateString(data, format);
        return "\"" + newData + "\"";
    }

    protected boolean hasMospSeJar() {
        String seVer = (String)this.ctx.getAttribute("seVer");
        return seVer != null && !seVer.equals("");
    }

    protected boolean hasMospLegalJar() {
        String legalVer = (String)this.ctx.getAttribute("legalVer");
        return legalVer != null && !legalVer.equals("");
    }

    protected boolean hasMospExpressJar() {
        String expressVer = (String)this.ctx.getAttribute("expressVer");
        return expressVer != null && !expressVer.equals("");
    }

    protected String getIndexCommand(boolean invalidProcSeq) {
        return "C1011";
    }

    protected void setNeedHeader(boolean needHeader) {
        this.needHeader = needHeader;
    }

    protected void setNeedSession(boolean needSession) {
        this.needSession = needSession;
    }

    protected void setNeedAspUser(boolean needAspUser) {
        this.needAspUser = needAspUser;
    }

    protected void setNeedUser(boolean needUser) {
        this.needUser = needUser;
    }

    protected void setCheckProcSeq(boolean checkProcSeq) {
        this.checkProcSeq = checkProcSeq;
    }

    protected void setNeedProcSeq(boolean needProcSeq) {
        this.needProcSeq = needProcSeq;
    }

    protected void setCheckAuth(boolean checkAuth) {
        this.checkAuth = checkAuth;
    }

    protected void setApplication(String application) {
        this.application = application;
    }

    public void setCtl(Properties ctl) {
        this.ctl = ctl;
    }

    public void setCfg(Properties cfg) {
        this.cfg = cfg;
    }

    public void setMsg(Properties msg) {
        this.msg = msg;
    }

    public void setAspUser(CmAspUserDto aspUser) {
        this.aspUser = aspUser;
    }

    public void setUser(CmUserDto user) {
        this.user = user;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public void setVo(VoInterface vo) {
        this.vo = vo;
    }

    public VoInterface getVo() {
        return this.vo;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setNextCmd(String nextCmd) {
        this.nextCmd = nextCmd;
    }

    public String getNextCmd() {
        return this.nextCmd;
    }
}

