/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.bean;

import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import jp.mosp.common.common.BaseAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.common.dao.CmUserDao;
import jp.mosp.common.dao.CtAccountDao;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.dto.CtAccountDto;

/**
 * F؏[eBeB
 * @since 3.0.2
 * @version 0.0.1
 * @author m.yoshida
 */
public class AuthBean {

	private Map<String, Object> authMap = new HashMap<String, Object>();

	private Properties cfg;
	private String cmd;
	private CmAspUserDto aspUser;
	private Connection conn;
	private boolean hasMospSeJar = false;

	private CmUserDto user;
	private CtAccountDto dto;

	public static final String KEY_MESSAGE_CODE 	= "msgCode";
	public static final String KEY_EXCEPTION_CODE 	= "exCode";
	public static final String KEY_USER 			= "user";

	/**
	 * RXgN^
	 */
	public AuthBean() {
		// 
	}

	/**
	 * RXgN^
	 * @param cfg			MosPAvP[Vݒ(/WEB-INF/mosp.properties)B 
	 * @param cmd			NGXgꂽCommandB
	 * @param aspUser		OCASP[U[B
	 * @param conn			DBRlNVB
	 * @param hasMospSeJar mosp-se.jarL<br>
	 * getConnection(String, String, String, String) ɂAݒ肳B
	 */
	public AuthBean(
			Properties cfg,
			String cmd,
			CmAspUserDto aspUser,
			Connection conn,
			boolean hasMospSeJar
	) {
		init(cfg, cmd, aspUser, conn, hasMospSeJar);
	}

	/**
	 * RXgN^iF؏sj
	 * <p>
	 * ʂ̎擾@́A{@link AuthBean#login(String, String)}QƂ邱ƁB
	 * </p>
	 * @param userId		Ώۃ[UID
	 * @param password		Ώۓ̓pX[h
	 * @param cfg			MosPAvP[Vݒ(/WEB-INF/mosp.properties)B 
	 * @param cmd			NGXgꂽCommandB
	 * @param aspUser		OCASP[U[B
	 * @param conn			DBRlNVB<br>
	 * getConnection(String, String, String, String) ɂAݒ肳B
	 * @throws Exception
	 */
	public AuthBean(
			String userId,
			String password,
			Properties cfg,
			String cmd,
			CmAspUserDto aspUser,
			Connection conn,
			boolean hasMospSeJar
	) throws Exception {
		init(cfg, cmd, aspUser, conn, hasMospSeJar);
		login(userId, password);
	}

	/**
	 * [eBeB̏
	 * @param cfg			MosPAvP[Vݒ(/WEB-INF/mosp.properties)B 
	 * @param cmd			NGXgꂽCommandB
	 * @param aspUser		OCASP[U[B
	 * @param conn			DBRlNVB<br>
	 * getConnection(String, String, String, String) ɂAݒ肳B
	 */
	public void init(
			Properties cfg,
			String cmd,
			CmAspUserDto aspUser,
			Connection conn,
			boolean hasMospSeJar
	) {
		this.cfg = cfg;
		this.cmd = cmd;
		this.aspUser = aspUser;
		this.conn = conn;
		this.hasMospSeJar = hasMospSeJar;
	}

	/**
	 * F؏
	 * @param userId			Ώۃ[UID
	 * @param password			Ώۓ̓pX[h
	 * @throws Exception
	 * <p>
	 * [U擾ɂ{@link AuthBean#getCmUserDto()}Ŏ擾B<br>
	 * F،ʂ擾ɂ{@link AuthBean#isErrMessage()}擾Aۂ𔻒fB<br>
	 * F؂sAKbZ[WR[h{@link AuthBean#getErrMessageCode()}
	 * OR[h{@link AuthBean#getMosPExceptionCode()}擾B<br>
	 * bZ[WR[hG[bZ[W𐶐AVÕG[bZ[WtB[hɃZbgB
	 * OR[h{@link MospException#MospException(int)}ɃZbgAthrowB
	 * </p>
	 */
	public void login(String userId, String password) throws Exception {
		// [U[̎擾
		CmUserDao userDao = new CmUserDao();
		userDao.initDao(cfg, cmd, aspUser, user, conn);
		user = userDao.findForKey(userId);
		// AJEg̎擾
		if (user != null) {
			// [U[擾łꍇ
			// 폜`FbN
			if (user.getDeleteFlag() == 1) {
				setAuthFailedMessage(MospConst.MSG_AUTH_FAILED, MospConst.EX_AUTH_DELETED);
			}
			// AJEg̎擾
			CtAccountDao dao = new CtAccountDao(cfg, cmd, aspUser, user, conn);
			dto = dao.findCtAccountForUserId(user.getUserId());
			if (dto == null) {
				// AJEg񂪎擾łȂꍇ
				// AJEg쐬
				dto = new CtAccountDto();
				dto.setUserId(user.getUserId());
				dto.setAttempt(1);
				dao.insert(dto);
			} else {
				// AJEg񂪎擾łꍇ
				// OCs񐔊mF
				int maxAttempt = Integer.parseInt(cfg.getProperty(MospConst.PPT_ACC_ATTEMPT));
				if (dto.getAttempt() >= maxAttempt) {
					// OCs񐔂ݒl傫ꍇ
					// ĎsC^[omF
					Date date = new Date(
							dto.getUpdateDate().getTime()
							+ Long.parseLong(cfg.getProperty(MospConst.PPT_ACC_INTERVAL)) * 1000
					);
					if (date.compareTo(new Date()) > 0) {
						// ĎsC^[ooɃOCsꍇ
						// s񐔂̃CNg
						dto.incrementAttempt();
						dao.update(dto);
						// AJEgbNO𔭍s
						setAuthFailedMessage(MospConst.MSG_ACCOUNT_LOCK, MospConst.EX_ACCOUNT_LOCK);
					}
				}
			}
			// pX[h`FbN
			checkPassWord(password);
		} else {
			// [U[擾łȂꍇ
			setAuthFailedMessage(MospConst.MSG_AUTH_FAILED, MospConst.EX_AUTH_NOT_EXIST);
		}
		// CmUserDtoZbgB
		authMap.put(KEY_USER, user);
	}

	/**
	 * pX[h`FbN
	 * @param mospUser		ΏMosPUserDto
	 * @param accountDto	ΏCtAccountDto
	 * @param user			ΏCmUserDto
	 * @param password		Ώۓ̓pX[h
	 * @return
	 * <p>
	 * pX[hꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	private void checkPassWord(
			String password
	) throws Exception {
		// DAȌ
		CtAccountDao ctAccountDao = new CtAccountDao(cfg, cmd, aspUser, user, conn);
		// pX[hF؎stO
		boolean passwordFailed = true;
		// pX[hɂF
		if (user.getPassword().equals(MospUtility.encrypt(password, hasMospSeJar))) {
			// Fؐ
			// pX[h̏󗓂ɂB
			user.setPassword("");
			// AJEg̍XV
			dto.setAttempt(0);
			ctAccountDao.update(dto);
			// [U[̐ݒ
			user.setCommonCss("");
			user.setMospAuthority(user.getAuthority());
			user.setPayrollAuthority("");
			user.setZaimuAuthority("");
			user.setSalesAuthority("");
			user.setExpenseAuthority("");
			user.setExt1Authority("");
			user.setExt2Authority("");
			user.setExt3Authority("");
			user.setExt4Authority("");
			user.setExt5Authority("");
			// Fؐ
			passwordFailed = false;
		} else {
			// F؎s
			// AJEg̍XV
			dto.incrementAttempt();
			ctAccountDao.update(dto);
		}
		// G[bZ[Wݒ
		if (passwordFailed) {
			setAuthFailedMessage(MospConst.MSG_AUTH_FAILED, MospConst.EX_AUTH_FAILED);
		}
	}

	/**
	 * F؎sbZ[Wݒ
	 * @param msgCode			\bZ[WR[h
	 * @param exCode			ΏۗOR[h
	 * @throws MospException
	 */
	public void setAuthFailedMessage(String msgCode , int exCode) {
		authMap.put(KEY_MESSAGE_CODE, msgCode);
		authMap.put(KEY_EXCEPTION_CODE, new Integer(exCode));
	}

	/**
	 * F؎sbZ[WL
	 * @return
	 * <p>
	 * F؎sbZ[WꍇtrueAłȂꍇfalse<br>
	 * F؂sAK{@link MospException#MospException(int)}ĂяoƁB<br>
	 * throwOɁAF؎sp{@link BaseAction#commit()}ĂяoƁB
	 * </p>
	 */
	public boolean isErrMessage() {
		return authMap.get(KEY_MESSAGE_CODE) != null ? true: false;
	}

	/**
	 * CmUserDto擾
	 * @return@CmUserDto
	 */
	public CmUserDto getCmUserDto() {
		Object obj = authMap.get(KEY_USER);
		return obj != null ? (CmUserDto)obj: null;
	}

	/**
	 * F؎sbZ[W擾
	 * @return	F؎sbZ[W
	 */
	public String getErrMessageCode() {
		Object obj = authMap.get(KEY_MESSAGE_CODE);
		return obj != null ? obj.toString(): "";
	}

	/**
	 * MosPExceptionR[h擾
	 * @return	MosPExceptionR[h
	 */
	public int getMosPExceptionCode() {
		Object obj = authMap.get(KEY_EXCEPTION_CODE);
		return obj != null ? ((Integer)obj).intValue(): 0;
	}

}
