/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.bean;

import java.io.File;
import java.io.IOException;

import jp.mosp.common.common.Controller;

import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SpreadSheet;

/**
 * jOpenDocumantɂ钠[쐬@\񋟂B<br>
 * <br>
 * OpenOffice.org CalcŒ[쐬ۂɗLpȃCu[
 * MosPt[[NŗpB<br>
 * pɂ́ACu[(jOpenDocument)KvƂȂB<br>
 * <br>
 * ActionłBeanCX^XSpreadSheet쐬A
 * {@link OdsBean#getSpreadSheet()}Ŏ擾IuWFNg
 * NGXgɐݒ肷邱ƂŁA{@link Controller}X|X
 * ƂODSt@Co͂B
 * 
 */
public class OdsBean {
	
	// tB[h
	private SpreadSheet spreadSheet;
	private Sheet sheet;
	
	/**
	 * Bean̏sB<br><br>
	 * ev[gt@CǍ݁Aŏ̃V[gIԂɂB<br>
	 * @param templatePath ev[gt@CpX
	 * @throws IOException 
	 */
	public OdsBean(String templatePath) throws IOException {
		spreadSheet = SpreadSheet.createFromFile(new File(templatePath));
		sheet = spreadSheet.getSheet(0);
	}
	
	/**
	 * Zɒlݒ肷B<br>
	 * @param col   ԍ
	 * @param row   sԍ
	 * @param value ݒl
	 */
	public void setValue(int col, int row, Object value) {
		sheet.getCellAt(col, row).setValue(value);
	}
	
	/**
	 * XvbhV[g擾B
	 * @return XvbhV[g
	 */
	public SpreadSheet getSpreadSheet() {
		return spreadSheet;
	}
	
}
