/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.mosp.common.dao.CmCodeDao;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmCodeDto;
import jp.mosp.common.dto.CmUserDto;

/**
 * Action̊{@\񋟂B<br>
 * <br>
 * MosPt[[Nł́AContorollerɂ萶ꂽActionNX
 * CX^XArWlXWbN̎sAView̑IsB<br>
 * <br>
 * eAvP[VɂāANXgActionNX
 * 쐬邱ƂŁAMosPt[[NLɗpłB<br>
 * <br>
 * gč쐬NXł{@link ActionInterface#action()}A
 * ̃\bhɃrWlXWbNLq邱ƂɂȂB
 * 
 */
public abstract class BaseAction extends DBConnBean implements ActionInterface {
	
	private boolean needHeader = true;
	private boolean needSession = true;
	private boolean needAspUser = true;
	private boolean needUser = true;
	private boolean checkProcSeq = true;
	private boolean needProcSeq = true;
	private boolean checkAuth = true;
	private String application = MospConst.APP_COMMON;
	private ArrayList<String> authorized;
	
	/**
	 * MHTTPNGXgB
	 */
	protected HttpServletRequest request;
	
	/**
	 * oHTTPX|XB
	 */
	protected HttpServletResponse response;
	
	/**
	 * NGXgɕRtHTTPZbVB
	 */
	protected HttpSession session;
	
	/**
	 * AvP[VŋLT[ubgReLXgB
	 */
	protected ServletContext ctx;
	
	/**
	 * Rg[[ݒ(/WEB-INF/controller.properties)B
	 */
	protected Properties ctl;
	
	/**
	 * MosPAvP[Vݒ(/WEB-INF/mosp.properties)B
	 */
	protected Properties cfg;
	
	/**
	 * bZ[Wݒ(/WEB-INF/message.properties)B
	 */
	protected Properties msg;
	
	/**
	 * ݒ(/WEB-INF/naming.properties)B
	 */
	protected Properties nam;
	
	/**
	 * OCASP[U[B
	 */
	protected CmAspUserDto aspUser;
	
	/**
	 * OC[U[B
	 */
	protected CmUserDto user;
	
	/**
	 * NGXgꂽCommandB
	 */
	protected String cmd;
	
	/**
	 * CommandƂƂɃNGXgꂽėpp[^B
	 */
	protected String key1;
	
	/**
	 * CommandƂƂɃNGXgꂽėpp[^B
	 */
	protected String key2;
	
	/**
	 * CommandƂƂɃNGXgꂽėpp[^B<br><br>
	 * NGXgMultiPart̏ꍇ́ApłȂB<br>
	 */
	protected String[] key;
	
	/**
	 * NGXgp[^Xg(multipartŃNGXgꂽꍇ)B
	 */
	protected List<?> multipartFieldList;
	
	private VoInterface vo;
	private String      url;
	private String      nextCmd;

	/**
	 * RXgN^B<br>
	 * DBRlNV̏sB
	 */
	public BaseAction() {
		super();
	}
	
	/**
	 * ANVB<br>
	 * etB[hɃIuWFNg蓖ĂB
	 * @param request  MHTTPNGXg
	 * @param response oHTTPX|X
	 */
	public void init(
			HttpServletRequest  request,
			HttpServletResponse response
	) throws Exception {
		// ̎擾
		this.request  = request;
		this.response = response;
		this.ctx      = (ServletContext)request.getAttribute(MospConst.ATT_CTX);
		this.ctl      = (Properties    )request.getAttribute(MospConst.ATT_CTL);
		this.cfg      = (Properties    )request.getAttribute(MospConst.ATT_CFG);
		this.msg      = (Properties    )request.getAttribute(MospConst.ATT_MSG);
		this.nam      = (Properties    )request.getAttribute(MospConst.ATT_NAM);
		this.cmd      = (String        )request.getAttribute(MospConst.ATT_CMD);
		this.key1     = request.getParameter      (MospConst.PRM_KEY1);
		this.key2     = request.getParameter      (MospConst.PRM_KEY2);
		this.multipartFieldList = (List<?>)request.getAttribute(MospConst.ATT_MULTIPART_LIST);
		if (this.key1 == null && this.multipartFieldList != null) {
			this.key1 = FileUploadUtility.getMultipartField(multipartFieldList, MospConst.PRM_KEY1);
		}
		if (this.key2 == null && this.multipartFieldList != null) {
			this.key2 = FileUploadUtility.getMultipartField(multipartFieldList, MospConst.PRM_KEY2);
		}
		this.key      = request.getParameterValues(MospConst.PRM_KEY );
	}
	
	/**
	 * ANVsB<br>
	 * ̏yу\bhsB
	 * <ul>
	 * <li>ANVO(e`FbNyѐݒ)</li>
	 * <li>action(eAvP[VŎ)</li>
	 * <li>p[^ݒ(Viewɑ΂̐ݒ)</li>
	 * <li>{@link #afterAction()}</li>
	 * </ul>
	 */
	public void doAction() throws Exception {
		try {
			// ANVOs
			preAction();
			// ANVsOo
			LogUtility.log(request, 1, MospConst.LOG_ACTION, MospConst.ACTION_START);
			// ANVs
			action();
			// ANVIOo
			LogUtility.log(request, 1, MospConst.LOG_ACTION, MospConst.ACTION_END);
			// ̐ݒ
			setParams();
		} catch(Exception e) {
			// ̐ݒ
			setParams();
			throw e;
		} finally {
			afterAction();
		}
	}
	
	/**
	 * ANVOB
	 * @throws Exception
	 */
	private void preAction() throws Exception {
		
		// X|X^Cv擾
		String responseType = (String)request.getAttribute(MospConst.ATT_RESPONSE_TYPE);
		// X|Xwb_[̐ݒ
		if (needHeader) {
			// LbVݒ
			if (!responseType.equals(MospConst.RESPONSE_TYPE_FILE)) {
				response.setHeader("Pragma", "no-cache");
				response.setHeader("Cache-Control", "no-cache");
				response.addHeader("Cache-Control", "no-store"); 
			}
			response.setDateHeader("Expires", 0);
			// ContentTypeݒ
			response.setContentType(MospConst.RESPONSE_CONT_TYPE_HTML);
		}
		
		// ZbV̎擾
		if (needSession) {
			session = request.getSession(false);
			if (session == null) {
				nextCmd = getIndexCommand(false);
				addList(bringErrMessage(),
						MospUtility.getMessage(msg, MospConst.MSG_SESSION_TIMEOUT, ""));
				throw new MospException(MospConst.EX_SESSION_TIMEOUT);
			}
			// ZbV^CAEgԂ̐ݒ
			int interval = Integer.parseInt(cfg.getProperty(MospConst.PPT_APP_INTERVAL));
			session.setMaxInactiveInterval(interval);
		}
		
		// ASP[U[̎擾
		if (needAspUser) {
			aspUser = (CmAspUserDto)session.getAttribute(MospConst.ATT_ASPUSER);
			if (aspUser == null) {
				nextCmd = getIndexCommand(false);
				throw new MospException(MospConst.EX_SESSION_INVALID);
			}
			request.setAttribute(MospConst.ATT_ASPUSER, aspUser);
		}
		
		// [U[̎擾
		if (needUser) {
			user = (CmUserDto)session.getAttribute(MospConst.ATT_USER);
			if (user == null) {
				nextCmd = getIndexCommand(false);
				throw new MospException(MospConst.EX_SESSION_INVALID);
			}
			request.setAttribute(MospConst.ATT_USER, user);
		}
		
		// V[PXmF
		if (checkProcSeq) {
			String procSeq = (String)request.getAttribute(MospConst.ATT_PROC_SEQ);
			if (procSeq == null) {
				procSeq = request.getParameter(MospConst.PRM_PROC_SEQ);
				if (procSeq == null && this.multipartFieldList != null) {
					procSeq = FileUploadUtility.getMultipartField(
							multipartFieldList, MospConst.PRM_PROC_SEQ);
				}
			}
			if (procSeq == null) {
				throw new MospException(MospConst.EX_PROCSEQ_NULL);
			}
			String storedProcSeq = (String)session.getAttribute(MospConst.ATT_PROC_SEQ);
			if (!procSeq.equals(storedProcSeq)) {
				String rep     = procSeq + MospConst.DATA_SEPARATOR + storedProcSeq;
				String message = MospUtility.replace(MospConst.LOG_MSG_PROC_SEQ, rep);
				LogUtility.log(request, 4, MospConst.LOG_MOSPINF, message);
				nextCmd = getIndexCommand(true);
				throw new MospException(MospConst.EX_PROCSEQ_INVALID);
			}
		}
		
		// mF
		if (checkAuth) {
			boolean hasAuth = false;
			String auth = null;
			if (application.equals(MospConst.APP_COMMON)) {
				auth = user.getMospAuthority();
			} else if (application.equals(MospConst.APP_PAYROLL)) {
				auth = user.getPayrollAuthority();
			} else if (application.equals(MospConst.APP_EXPENSE)) {
				auth = user.getExpenseAuthority();
			} else if (application.equals(MospConst.APP_SALES)) {
				auth = user.getSalesAuthority();
			} else if (application.equals(MospConst.APP_EXT1)) {
				auth = user.getExt1Authority();
			} else if (application.equals(MospConst.APP_EXT2)) {
				auth = user.getExt2Authority();
			} else if (application.equals(MospConst.APP_EXT3)) {
				auth = user.getExt3Authority();
			} else if (application.equals(MospConst.APP_EXT4)) {
				auth = user.getExt4Authority();
			} else if (application.equals(MospConst.APP_EXT5)) {
				auth = user.getExt5Authority();
			} else {
				throw new MospException(MospConst.EX_APP_PROPERTIES);
			}
			for(Iterator<String> it = authorized.iterator(); it.hasNext();) {
				if (it.next().equals(auth)) {
					hasAuth = true;
					break;
				}
			}
			if (!hasAuth) {
				throw new MospException(MospConst.EX_AUTHORITY);
			}
		}
		
	}
	
	/**
	 * ANV㏈B<br>
	 * {@link #rollback()}A{@link #releaseConnection()}sB<br>
	 * @throws SQLException
	 */
	protected void afterAction() throws SQLException {
		// DBRlNVj
		rollback();
		releaseConnection();
		// ZbVmF
		if (session == null) {
			return;
		}
		// V[PXs
		String procSeq = null;
		if (needProcSeq) {
			procSeq = MospUtility.generateProcSeq(hasMospSeJar(),
					(String)session.getAttribute(MospConst.ATT_PROC_SEQ));
		} else {
			// ۑĂ鏈V[PXp
			procSeq = (String)session.getAttribute(MospConst.ATT_PROC_SEQ);
		}
		// V[PXݒ
		request.setAttribute(MospConst.ATT_PROC_SEQ, procSeq);
		session.setAttribute(MospConst.ATT_PROC_SEQ, procSeq);
		if (vo != null) {
			vo.setProcSeq(procSeq);
		}
	}
	
	/**
	 * DBRlNV擾B<br>
	 * {@link #aspUser}ɐݒ肳ꂽpāA
	 * {@link #getConnection(String, String, String, String)}
	 * sB<br>
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 */
	protected void getConnection() throws ClassNotFoundException, SQLException{
		if (conn == null || conn.isClosed()) {
			super.getConnection(
					aspUser.getDbDriver(),
					aspUser.getDbUrl()   ,
					aspUser.getDbUser()  ,
					aspUser.getDbPass()
			);
		}
	}
	
	/**
	 * st^B<br>
	 * YAction̎st^B<br>
	 * {@link #setCheckAuth(boolean)}trueݒ肵Ăꍇ̂ݗLB<br>
	 * @param authority 
	 */
	protected void authorize(String authority) {
		authorized = authorized != null ? authorized : new ArrayList<String>();
		authorized.add(authority);
	}
	
	/**
	 * ̐ݒ
	 */
	private void setParams() {
		if (nextCmd == null) {
			// VOyуtH[h̐ݒ
			String message = (String)request.getAttribute(MospConst.ATT_MESSAGE); 
			List<String> errMessage = bringErrMessage();
			if (message != null && vo != null) {
				vo.setMessage(message);
			}
			if (errMessage != null && vo != null) {
				for (int i = 0; i < errMessage.size(); i++) {
					vo.addErrMessage(errMessage.get(i));
				}
			}
			request.setAttribute(MospConst.ATT_VO, vo);
			request.setAttribute(MospConst.ATT_URL, url);
		} else {
			// R}h̐ݒ
			request.setAttribute(MospConst.ATT_URL, MospConst.URL_SRV);
			request.setAttribute(MospConst.ATT_NEXTCMD, nextCmd);
		}
	}
	
	/**
	 * bZ[Wݒ肷B<br>
	 * {@link #request}ɃbZ[Wݒ肷B
	 * @param strMessage bZ[W
	 */
	protected void setMessage(String strMessage) {
		request.setAttribute(MospConst.ATT_MESSAGE, strMessage);
	}
	
	/**
	 * G[bZ[Wݒ肷B<br>
	 * {@link #request}Ɏ߂ꂽG[bZ[WXgɁA
	 * bZ[WǉB
	 * @param strErrMessage G[bZ[W
	 */
	protected void addErrMessage(String strErrMessage) {
		addList(bringErrMessage(), strErrMessage);
	}
	
	/**
	 * G[bZ[WXg擾B<br><br>
	 * {@link #request}A{@link MospConst#ATT_ERR_MESSAGE}L[ƂāA擾B<br>
	 * {@link #request}ɃG[bZ[WXg݂ȂꍇA
	 * ̃G[bZ[WXg{@link #request}ɐݒ肵ĕԒlƂB
	 * @return G[bZ[WXg
	 */
	@SuppressWarnings("unchecked")
	private List<String> bringErrMessage() {
		Object obj = request.getAttribute(MospConst.ATT_ERR_MESSAGE);
		if (obj != null && obj instanceof List) {
			return (List)obj;
		}
		List<String> list = new ArrayList<String>(); 
		request.setAttribute(MospConst.ATT_ERR_MESSAGE, list);
		return list;
	}
	
	/**
	 * Voۑ(ZbVɕۑ)B<br>
	 * {@link #session}VOi[B<br>
	 * ۑVóA{@link #getStoredVo(String)}Ŏ擾łB
	 * ̉ʂɂ킽ďێKvꍇɗpB<br>
	 * @param key ۑL[
	 * @param vo  ۑΏVo
	 */
	protected void storeVo(String key, VoInterface vo) {
		putMap(bringStoredVo(), key, vo);
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
	}
	
	/**
	 * ۑVO擾B<br>
	 * {@link #storeVo(String, VoInterface)}ŕۑVo擾B<br>
	 * @param key ۑL[
	 * @return 擾VO
	 */
	protected VoInterface getStoredVo(String key) {
		return bringStoredVo().get(key);
	}

	/**
	 * ۑVO(storeVoɂZbVɕۑVȌ)B<br>
	 * {@link #storeVo(String, VoInterface)}ŕۑVÔA
	 * svɂȂ̂B<br>
	 * @param key VONX
	 */
	protected void removeStoredVo(String key) {
		bringStoredVo().remove(key);
	}
	
	/**
	 * ۑVO擾B<br><br>
	 * {@link #session}A{@link MospConst#ATT_STORE_VO}L[ƂāA
	 * ۑVO擾B<br>
	 * {@link #session}ɕۑVO݂ȂꍇA̕ۑVO{@link #session}
	 * ݒ肵ĕԒlƂB
	 * @return ۑVO
	 */
	@SuppressWarnings("unchecked")
	private Map<String, VoInterface> bringStoredVo() {
		Object obj = session.getAttribute(MospConst.ATT_STORE_VO);
		if (obj != null && obj instanceof Map) {
			return (Map)obj;
		}
		Map<String, VoInterface> map = new HashMap<String, VoInterface>(); 
		session.setAttribute(MospConst.ATT_STORE_VO, map);
		return map;
	}
	
	/**
	 * VOCX^X̎擾yѐݒB<br><br>
	 * {@link BaseAction#prepareVo(boolean)}sBtrueB<br>
	 * @return 擾VOCX^X
	 * @throws MospException 
	 */
	protected BaseVo prepareVo() throws MospException {
		return prepareVo(true);
	}
	
	/**
	 * VOCX^X̎擾yѐݒB<br><br>
	 * <ul><li>
	 * VOCX^X擾<br>
	 * {@link #getSpecificVo()}ŁAΏVOCX^X擾B<br><br>
	 * </li><li>
	 * ۑVOmF<br>
	 * {@link #getStoredVo(String)}ŁAVOCX^X̃NXL[Ƃ
	 * ۑVO擾({@link #storeVo(String, VoInterface)}ŕۑ)B<br><br>
	 * <li>
	 * VO<br>
	 * {@link BaseVo#initVo(Properties, Properties, String, CmAspUserDto, CmUserDto)}A
	 * {@link BaseVo#clearMessage()}A{@link BaseVo#clearErrField()}sB<br><br>
	 * </li>
	 * <li>
	 * VOyуtH[hURL̐ݒ<br>
	 * {@link #setVo(VoInterface)}A{@link BaseVo#getRetUrl()}Ƃ
	 * {@link #setUrl(String)}sB<br><br>
	 * </li></ul>
	 * @param useStoredVo ێVOptO(trueFێVOgAfalseFێVO낤ƐVKVOg)
	 * @return 擾VOCX^X
	 * @throws MospException 
	 */
	protected BaseVo prepareVo(boolean useStoredVo) throws MospException {
		// VOCX^X擾
		BaseVo baseVo = getSpecificVo();
		if (baseVo == null) {
			return null;
		}
		// ۑVOmF
		Object storedVo = getStoredVo(baseVo.getClassName());
		if (storedVo != null && useStoredVo) {
			chkInstance(storedVo instanceof BaseVo);
			baseVo = (BaseVo)storedVo;
		}
		// VOۑ
		storeVo(baseVo.getClassName(), baseVo);
		// VO
		baseVo.initVo(cfg, msg, nam, cmd, aspUser, user);
		baseVo.clearMessage();
		baseVo.clearErrField();
		// VOyуtH[hURL̐ݒ
		setVo(baseVo);
		setUrl(baseVo.getRetUrl());
		return baseVo;
	}
	
	/**
	 * VO擾B<br><br>
	 * {@link #prepareVo()}ŗpB<br>
	 * {@link BaseAction}gNXł̃\bhI[o[Ch邱ƂŁA
	 * {@link #prepareVo()}p{@link BaseVo}gCӂVOCX^X
	 * 擾邱ƂłB
	 * @return VOCX^X
	 */
	protected BaseVo getSpecificVo() {
		return new BaseVo();
	}
	
	/**
	 * ۑf[^(ZbVɕۑf[^̏)B<br>
	 * AvP[V{@link #session}ɕۑeB<br>
	 * AAOC񓙂͏ȂB<br>
	 * @throws sO
	 */
	protected void initStoredData() {
		session.removeAttribute(MospConst.ATT_STORE_VO );
		session.removeAttribute(MospConst.ATT_FORMER_VO);
		session.removeAttribute(MospConst.ATT_DTO      );
		session.removeAttribute(MospConst.ATT_LIST     );
	}
	
	/**
	 * f[^݊mFB<br>
	 * dtonull̏ꍇA{@link MospException}𔭍sB<br>
	 * @param dto mFΏDTO
	 * @throws MospException
	 */
	protected void chkExist(BaseDto dto) throws MospException {
		if (dto == null) {
			throw new MospException(MospConst.EX_NO_DATA);
		}
	}
	
	/**
	 * XVmFB<br>
	 * dtonull̏ꍇA{@link MospException}𔭍sB<br>
	 * @param dto mFΏDTO
	 * @throws MospException
	 */
	protected void chkUpdate(BaseDto dto) throws MospException {
		if (dto == null) {
			throw new MospException(MospConst.EX_UPDATE_FAILED);
		}
	}
	
	/**
	 * }mFB<br>
	 * dtonull̏ꍇA{@link MospException}𔭍sB<br>
	 * @param dto mFΏDTO
	 * @throws MospException
	 */
	protected void chkInsert(BaseDto dto) throws MospException {
		if (dto == null) {
			throw new MospException(MospConst.EX_INSERT_FAILED);
		}
	}
	
	/**
	 * f[^dmFB<br>
	 * dtonullłȂꍇA{@link MospException}𔭍sB<br>
	 * @param dto mFΏDTO
	 * @param vo f[^ݎbZ[WݒVO
	 * @throws MospException
	 */
	protected void chkDuplicate(BaseDto dto, VoInterface vo) throws MospException {
		if (dto != null) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_DUPLICATE, ""));
			throw new MospException(MospConst.EX_DUPLICATE);
		}
	}
	
	/**
	 * XVɂrmFB<br>
	 * currentDtoɑ΂{@link #chkExist(BaseDto)}sA
	 * formerDtocurrentDto̍XVrB<br>
	 * XVłȂꍇA{@link MospException}𔭍sB<br>
	 * @param formerDto XVΏDTO(ҏWO)
	 * @param currentDto XVΏDTO(ŐV)
	 * @param vo XV᎞bZ[WݒVO
	 * @throws MospException
	 */
	protected void chkExclusive(BaseDto formerDto, BaseDto currentDto, VoInterface vo) throws MospException {
		chkExist(currentDto);
		if (formerDto.getUpdateDate().compareTo(currentDto.getUpdateDate()) != 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_EXCLUSIVE, ""));
			throw new MospException(MospConst.EX_EXCLUSIVE);
		}
	}
	
	/**
	 * R[h݊mFB<br>
	 * dtonull̏ꍇA{@link MospException}𔭍sA
	 * ΏۂG[tB[hɉB<br>
	 * @param dto mFΏDTO
	 * @param targetId mFΏۃtB[hID
	 * @param vo R[hsݎbZ[WݒVO
	 * @throws MospException
	 */
	protected void chkCodeExist(BaseDto dto, String targetId, VoInterface vo) throws MospException {
		if (dto == null) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_CODE, ""));
			vo.addErrField(targetId);
			throw new MospException(MospConst.EX_NO_CODE);
		}
	}
	
	/**
	 * R[h݊mF()B<br>
	 * dtonull̏ꍇA{@link MospException}𔭍sA
	 * ΏۂG[tB[hɉB<br>
	 * @param dto mFΏDTO
	 * @param rowNo sԍ
	 * @param targetId mFΏۃtB[hID
	 * @param vo R[hsݎbZ[WݒVO
	 * @throws MospException
	 */
	protected void chkCodeExist(BaseDto dto, int rowNo, String targetId, VoInterface vo) throws MospException {
		if (dto == null) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_CODE, ""));
			vo.addErrDetails(rowNo, targetId);
			throw new MospException(MospConst.EX_NO_CODE);
		}
	}
	
	/**
	 * CX^XmFB<br>
	 * isInstancefalsȅꍇAMospException𔭍sB
	 * @param isInstance instanceofɂ鉉Z
	 * @throws MospException 
	 */
	protected void chkInstance(boolean isInstance) throws MospException {
		if (!isInstance) {
			throw new MospException(MospConst.EX_WRONG_INSTANCE);
		}
	}
	
	/**
	 * R[hXg擾(CM_CODE)B<br>
	 * R[he[ũR[h敪̃Xg擾B<br>
	 * @param tId R[h敪
	 * @return R[hXg
	 * @throws Exception
	 */
	protected String[][] getCodeArray(String tId) throws Exception {
		try {
			// DBRlNV̎擾yDTȌ
			getConnection();
			// DAO̐錾
			CmCodeDao dao = new CmCodeDao(cfg, cmd, aspUser, user, conn);
			// f[^̎擾
			List<CmCodeDto> list = dao.findForCondition(tId);
			// f[^̐`
			String[][] array = new String[list.size()][2];
			for (int i = 0; i < list.size(); i++) {
				CmCodeDto dto = list.get(i);
				array[i][0] = dto.getTCode();
				array[i][1] = dto.getTName();
			}
			return array;
		} catch(Exception e) {
			throw e;
		} finally {
			// DBRlNVj
			rollback();
			releaseConnection();
		}
	}

	/**
	 * XgǉB<br>
	 * XgɃIuWFNgǉ邾̃\bhB<br>
	 * @param list Xg
	 * @param obj  ǉΏۃIuWFNg
	 */
	@SuppressWarnings("unchecked")
	protected void addList(List list, Object obj) {
		list.add(obj);
	}
	
	/**
	 * }bvǉB<br>
	 * }bvɃIuWFNgǉ邾̃\bhB<br>
	 * @param map }bv
	 * @param key L[IuWFNg
	 * @param obj  ǉΏۃIuWFNg
	 */
	@SuppressWarnings("unchecked")
	protected void putMap(Map map, Object key, Object obj) {
		map.put(key, obj);
	}
	
	/**
	 * ""t
	 * @param data tΏۃf[^
	 * @return t㕶
	 */
	protected String getCsvData(String data) {
		if (data == null) {
			return "";
		}
		String newData = data.replaceAll("\"", "\"\"");
		return "\"" + newData + "\"";
	}
	
	/**
	 * ""t
	 * @param data tΏۃf[^
	 * @return t㕶
	 */
	protected String getCsvData(int data) {
		return "\"" + String.valueOf(data) + "\"";
	}

	/**
	 * ""t
	 * @param data tΏۃf[^
	 * @return t㕶
	 */
	protected String getCsvData(float data) {
		return "\"" + String.valueOf(data) + "\"";
	}
	
	/**
	 * ""t
	 * @param data tΏۃf[^
	 * @return t㕶
	 */
	protected String getCsvData(Date data, String format) {
		if (data == null) {
			return "";
		}
		String newData = MospUtility.getDateString(data, format);
		return "\"" + newData + "\"";
	}
	
	/**
	 * MosPSE[eBeB[pێ擾B<br>
	 * @return MosPSE[eBeB[p(trueFAfalseFs)
	 */
	protected boolean hasMospSeJar() {
		String seVer = (String)ctx.getAttribute(MospConst.ATT_SE_VER);
		if (seVer == null || seVer.equals("")) {
			return false;
		}
		return true;
	}
	
	/**
	 * MosP@胆[eBeB[pێ擾B<br>
	 * @return MosP@胆[eBeB[p(trueFAfalseFs)
	 */
	protected boolean hasMospLegalJar() {
		String legalVer = (String)ctx.getAttribute(MospConst.ATT_LEGAL_VER);
		if (legalVer == null || legalVer.equals("")) {
			return false;
		}
		return true;
	}
	
	/**
	 * MosPvZ[eBeB[pێ擾B<br>
	 * @return MosPvZ[eBeB[p(trueFAfalseFs)
	 */
	protected boolean hasMospExpressJar() {
		String expressVer = (String)ctx.getAttribute(MospConst.ATT_EXPRESS_VER);
		if (expressVer == null || expressVer.equals("")) {
			return false;
		}
		return true;
	}
	
	/**
	 * R}h擾B<br>
	 * @param invalidProcSeq V[PXstO
	 * @return R}h
	 */
	@SuppressWarnings("unused")
	protected String getIndexCommand(boolean invalidProcSeq) {
		return MospConst.CMD_INDEX;
	}

	/**
	 * X|Xwb_[vېݒB<br>
	 * @param needHeader X|Xwb_[v
	 */
	protected void setNeedHeader(boolean needHeader) { this.needHeader = needHeader; }
	
	/**
	 * ZbVvېݒB<br>
	 * @param needSession ZbVv
	 */
	protected void setNeedSession(boolean needSession) { this.needSession = needSession; }
	
	/**
	 * ASP[U[vېݒB<br>
	 * @param needAspUser ASP[U[v
	 */
	protected void setNeedAspUser(boolean needAspUser) { this.needAspUser = needAspUser; }
	
	/**
	 * [U[vېݒB<br>
	 * @param needUser [U[v
	 */
	protected void setNeedUser(boolean needUser) { this.needUser = needUser; }
	
	/**
	 * V[PXmFvېݒB<br>
	 * @param checkProcSeq V[PXmFv
	 */
	protected void setCheckProcSeq(boolean checkProcSeq) { this.checkProcSeq = checkProcSeq; }
	
	/**
	 * V[PXsvېݒB<br>
	 * @param needProcSeq V[PXsv
	 */
	protected void setNeedProcSeq(boolean needProcSeq) { this.needProcSeq = needProcSeq; }
	
	/**
	 * mFvېݒB<br>
	 * @param checkAuth mFv
	 */
	protected void setCheckAuth(boolean checkAuth) { this.checkAuth = checkAuth; }
	
	/**
	 * AvP[Vݒ肷B<br>
	 * @param application AvP[V
	 */
	protected void setApplication(String application) { this.application = application; }
	
	/**
	 * Rg[[ݒ(/WEB-INF/controller.properties)ݒ肷B<br>
	 * @param ctl Rg[[ݒ
	 */
	public void setCtl(Properties ctl) { this.ctl = ctl; }
	
	/**
	 * MosPAvP[Vݒ(/WEB-INF/mosp.properties)ݒ肷B<br>
	 * @param cfg MosPAvP[Vݒ
	 */
	public void setCfg(Properties cfg) { this.cfg = cfg; }
	
	/**
	 * bZ[Wݒ(/WEB-INF/message.properties)ݒ肷B<br>
	 * @param msg bZ[Wݒ
	 */
	public void setMsg(Properties msg) { this.msg = msg; }
	
	/**
	 * ASP[U[ݒ肷B
	 * @param aspUser ASP[U[
	 */
	public void setAspUser(CmAspUserDto aspUser) { this.aspUser = aspUser; }
	
	/**
	 * [U[ݒ肷B
	 * @param user [U[
	 */
	public void setUser(CmUserDto user) { this.user = user; }
	
	/**
	 * Cpmmandݒ肷B
	 * @param cmd Command
	 */
	public void setCmd(String cmd) { this.cmd = cmd; }
	
	/**
	 * Voݒ肷B<br>
	 * Őݒ肵VóA{@link #doAction()}requestɐݒ肳A
	 * View(JSP)ŗp邱ƂłB<br>
	 * @param vo Vo
	 */
	public void setVo(VoInterface vo) { this.vo = vo; }
	
	/**
	 * Vo擾B<br>
	 * @return Vo
	 */
	public VoInterface getVo() { return vo; }
	
	/**
	 * tH[hURLݒ肷B<br>
	 * Őݒ肵URĹA{@link #doAction()}requestɐݒ肳A
	 * ControllerɂtH[hB<br>
	 * @param url tH[hURL
	 */
	public void setUrl(String url) { this.url = url; }
	
	/**
	 * tH[hURL擾B<br>
	 * @return tH[hURL
	 */
	public String getUrl() { return url; }
	
	/**
	 * AsCommandݒ肷B<br>
	 * Őݒ肵Command́A{@link #doAction()}requestɐݒ肳A
	 * ControllerɂAX|XԂƂȂsB<br>
	 * AsCommandݒ肵ꍇAVoyуtH[hURL̐ݒ
	 * ɂȂB<br>
	 * @param nextCmd AsCommand
	 */
	public void setNextCmd(String nextCmd) { this.nextCmd = nextCmd; }
	
	/**
	 * AsCommand擾B<br>
	 * @return AsCommand
	 */
	public String getNextCmd() { return nextCmd; }
	
}
