/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;

import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/**
 * ꗗ\ɗLpȋ@\񋟂B<br><br>
 * őA\[g񓙂ێÃANZT\bhLB<br>
 */
public class ListVo extends BaseVo {
	
	private static final long serialVersionUID = -3140198417848428433L;
	
	// tB[h
	protected int     count;
	private   int     start;
	private   int     end;
	private   boolean needFormer;
	private   boolean needNext;
	protected List<?> list;
	protected String  formerKey;
	protected boolean isAscending;
	protected int     listLength;
	
	/**
	 * ŌJR}hB<br>
	 * {@link HtmlUtility#getListInfoFlex(ListVo)}ŗpB
	 */
	protected String pageCommand;
	
	/**
	 * \[gL[B<br>
	 * {@link HtmlUtility#getListInfoFlex(ListVo)}ŗpB
	 */
	protected String selectKey;
	
	/**
	 * IŔԍB<br>
	 * {@link HtmlUtility#getListInfoFlex(ListVo)}ŗpB
	 */
	protected int selectIndex;
	
	/**
	 * B<br>
	 * {@link HtmlUtility#getListInfoFlex(ListVo)}ŗpB
	 */
	protected int countAllData;
	
	/**
	 * 1ł̕\B<br>
	 * {@link HtmlUtility#getListInfoFlex(ListVo)}ŗpB
	 */
	protected int dataPerPage;
	
	/**
	 * RXgN^B<br>
	 */
	public ListVo() {
		super();
		count = 0;
		start = 0;
		end   = -1;
		list  = new ArrayList<BaseDto>();
		formerKey = "";
		isAscending = true;
		listLength = 0;
		pageCommand  = "";
		selectKey    = "";
		selectIndex  = 1;
		countAllData = 0;
		dataPerPage  = 0;
	}
	
	/**
	 * VOB<br>
	 * MosPt[[Nŗpeݒ肷B<br>
	 * @param cfg        ݒt@C
	 * @param msg        bZ[Wt@C
	 * @param cmd        R}h
	 * @param aspUserDto ASP[U[
	 * @param userDto    [U[
	 */
	@Override
	public void initVo(
			Properties cfg,
			Properties msg,
			String cmd,
			CmAspUserDto aspUserDto,
			CmUserDto userDto
	) {
		super.initVo(cfg, msg, cmd, aspUserDto, userDto);
		if (dataPerPage > 0) {
			return;
		}
		String countList = cfg.getProperty(MospConst.PPT_APP_LIST);
		if (countList != null && !countList.equals("")) {
			dataPerPage = Integer.parseInt(countList);
		}
	}

	
	/**
	 * Xg񏉊B<br>
	 * @throws MospException
	 */
	public void initListInfo() throws MospException {
		try {
			start = 0;
			end =  - 1;
			setPageButton();
		} catch (NumberFormatException e) {
			throw new MospException(MospConst.EX_APP_PROPERTIES);
		}
	}
	
	
	/**
	 * XgőB<br>
	 */
	public void pageNext() {
		start = end + 1;
		end = start + getListLength() - 1;
		setPageButton();
	}
	
	
	/**
	 * XgŖ߂B<br>
	 */
	public void pageFormer() {
		start -= getListLength();
		end = start + getListLength() - 1;
		setPageButton();
	}
	
	
	/**
	 * Ń{^vېݒB<br>
	 */
	public void setPageButton() {
		int appList = getListLength();
		if (start >= count) {
			start = count - appList;
		}
		if (start > 0) {
			needFormer = true;
		} else {
			start = 0;
			needFormer = false;
		}
		if (end - start < getListLength()) {
			end = start + appList - 1;
		}
		if (end < count - 1) {
			needNext = true;
		} else {
			end = count - 1;
			needNext = false;
		}
	}
	
	
	/**
	 * Xg\[gB<br>
	 * @throws MospException
	 */
	public void sortList(String key, Comparator<Object> comp) throws MospException {
		if (key.equals(formerKey) && isAscending) {
			Collections.sort(list, Collections.reverseOrder(comp));
			isAscending = false;
		} else {
			Collections.sort(list, comp);
			isAscending = true;
		}
		initListInfo();
		formerKey = key;
	}
	
	
	/**
	 * Xg\[g(\[g̕ύX)B<br>
	 */
	public void sortList(Comparator<Object> comp) {
		if (isAscending) {
			Collections.sort(list, comp);
		} else {
			Collections.sort(list, Collections.reverseOrder(comp));
		}
	}
	
	/**
	 * \[g}[NóB<br>
	 * @param key \[gL[
	 * @return HTML\[g}[N̕
	 */
	public String getSortMark(String key) {
		String sortMark = "";
		if (key.equals(formerKey)) {
			if (isAscending) {
				sortMark = "";
			} else {
				sortMark = "";
			}
		}
		return sortMark;
	}
	
	/**
	 * Xg(ʕ\)擾B<br>
	 * @return Xg
	 */
	private int getListLength() {
		if (listLength == 0) {
			return Integer.parseInt(cfg.getProperty(MospConst.PPT_APP_LIST));
		}
		return listLength;
	}
	
	/**
	 * OFFSET擾B<br>
	 * @return OFFSET
	 */
	public int getOffset() {
		return (selectIndex - 1) * dataPerPage;
	}
	
	/**
	 * \[gL[ݒB<br>
	 * @param sortKey \[gL[
	 */
	public void setSortKey(String sortKey) {
		if (sortKey.equals(selectKey)) {
			if (isAscending) {
				isAscending = false;
			} else {
				isAscending = true;
			}
		} else {
			isAscending = true;
		}
		selectKey = sortKey;
		formerKey = sortKey;
	}
	
	// ANZT\bh
	public List<?> getList() { return list ; }
	public int getCount() { return count; }
	public int getStart() { return start; }
	public int getEnd  () { return end  ; }
	public boolean getNeedFormer () { return needFormer ; }
	public boolean getNeedNext   () { return needNext   ; }
	public boolean getIsAscending() { return isAscending; }
	public String  getFormerKey  () { return formerKey  ; }
	public void setCount      (int     count      ) { this.count       = count      ; }
	public void setFormerKey  (String  formerKey  ) { this.formerKey   = formerKey  ; }
	public void setIsAscending(boolean isAscending) { this.isAscending = isAscending; }
	
	public String getPageCommand () { return pageCommand ; }
	public String getSelectKey   () { return selectKey   ; }
	public int    getSelectIndex () { return selectIndex ; }
	public int    getCountAllData() { return countAllData; }
	public int    getDataPerPage () { return dataPerPage ; }
	public void setPageCommand (String pageCommand ) { this.pageCommand  = pageCommand ; }
	public void setSelectKey   (String selectKey   ) { this.selectKey    = selectKey   ; }
	public void setSelectIndex (int    selectIndex ) { this.selectIndex  = selectIndex ; }
	public void setCountAllData(int    countAllData) { this.countAllData = countAllData; }
	public void setDataPerPage (int    dataPerPage ) { this.dataPerPage  = dataPerPage ; }

}
