/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hssf.util.Region;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

/**
 * Poiɂ钠[쐬@\񋟂B<br><br>
 * ExcelŒ[쐬ۂɗLpȃCu[MosPt[[NŗpB
 */
public class PoiUtility {
	//****************************************************************************
	//ϐ錾0
	//****************************************************************************

	HSSFWorkbook workbook = null;
	FileInputStream in = null;
	POIFSFileSystem fs = null;
	FileOutputStream out = null;
	HSSFSheet sheet = null;
	HSSFCellStyle style = null;
	HSSFRow row;
	HSSFCell cell;

	HSSFFont font;

	//****************************************************************************
	//F錾
	//****************************************************************************
	public static final short AQUA 					= HSSFColor.AQUA.index;
	public static final short BLACK 					= HSSFColor.BLACK.index;
	public static final short BLUE 					= HSSFColor.BLUE.index;
	public static final short BLUE_GREY 				= HSSFColor.BLUE_GREY.index;
	public static final short BRIGHT_GREEN 			= HSSFColor.BRIGHT_GREEN.index;
	public static final short BROWN 					= HSSFColor.BROWN.index;
	public static final short CORAL 					= HSSFColor.CORAL.index;
	public static final short CORNFLOWER_BLUE 		= HSSFColor.CORNFLOWER_BLUE.index;
	public static final short DARK_BLUE 				= HSSFColor.DARK_BLUE.index;
	public static final short DARK_GREEN 				= HSSFColor.DARK_GREEN.index;
	public static final short DARK_RED 				= HSSFColor.DARK_RED.index;
	public static final short DARK_TEAL 				= HSSFColor.DARK_TEAL.index;
	public static final short DARK_YELLOW 			= HSSFColor.DARK_YELLOW.index;
	public static final short GOLD 					= HSSFColor.GOLD.index;
	public static final short GREEN 					= HSSFColor.GREEN.index;
	public static final short GREY_25_PERCENT 		= HSSFColor.GREY_25_PERCENT.index;
	public static final short GREY_40_PERCENT 		= HSSFColor.GREY_40_PERCENT.index;
	public static final short GREY_50_PERCENT 		= HSSFColor.GREY_50_PERCENT.index;
	public static final short GREY_80_PERCENT 		= HSSFColor.GREY_80_PERCENT.index;
	public static final short INDIGO 					= HSSFColor.INDIGO.index;
	public static final short LAVENDER 				= HSSFColor.LAVENDER.index;
	public static final short LEMON_CHIFFON 			= HSSFColor.LEMON_CHIFFON.index;
	public static final short LIGHT_BLUE 				= HSSFColor.LIGHT_BLUE.index;
	public static final short LIGHT_CORNFLOWER_BLUE 	= HSSFColor.LIGHT_CORNFLOWER_BLUE.index;
	public static final short LIGHT_GREEN 			= HSSFColor.LIGHT_GREEN.index;
	public static final short LIGHT_ORANGE 			= HSSFColor.LIGHT_ORANGE.index;
	public static final short LIGHT_TURQUOISE 		= HSSFColor.LIGHT_TURQUOISE.index;
	public static final short LIGHT_YELLOW 			= HSSFColor.LIGHT_YELLOW.index;
	public static final short LIME 					= HSSFColor.LIME.index;
	public static final short MAROON 					= HSSFColor.MAROON.index;
	public static final short OLIVE_GREEN 			= HSSFColor.OLIVE_GREEN.index;
	public static final short ORANGE 					= HSSFColor.ORANGE.index;
	public static final short ORCHID 					= HSSFColor.ORCHID.index;
	public static final short PALE_BLUE 				= HSSFColor.PALE_BLUE.index;
	public static final short PINK 					= HSSFColor.PINK.index;
	public static final short PLUM 					= HSSFColor.PLUM.index;
	public static final short RED 					= HSSFColor.RED.index;
	public static final short ROSE 					= HSSFColor.ROSE.index;
	public static final short ROYAL_BLUE 				= HSSFColor.ROYAL_BLUE.index;
	public static final short SEA_GREEN 				= HSSFColor.SEA_GREEN.index;
	public static final short SKY_BLUE 				= HSSFColor.SKY_BLUE.index;
	public static final short TAN 					= HSSFColor.TAN.index;
	public static final short TEAL 					= HSSFColor.TEAL.index;
	public static final short TURQUOISE 				= HSSFColor.TURQUOISE.index;
	public static final short VIOLET 					= HSSFColor.VIOLET.index;
	public static final short WHITE 					= HSSFColor.WHITE.index;
	public static final short YELLOW 					= HSSFColor.YELLOW.index;

	//****************************************************************************
	//hԂp^[錾
	//****************************************************************************
	public static final short NO_FILL 				= HSSFCellStyle.NO_FILL;
	public static final short SOLID_FOREGROUND 		= HSSFCellStyle.SOLID_FOREGROUND;
	public static final short FINE_DOTS 				= HSSFCellStyle.FINE_DOTS;
	public static final short ALT_BARS 				= HSSFCellStyle.ALT_BARS;
	public static final short SPARSE_DOTS 			= HSSFCellStyle.SPARSE_DOTS;
	public static final short THICK_HORZ_BANDS 		= HSSFCellStyle.THICK_HORZ_BANDS;
	public static final short THICK_VERT_BANDS 		= HSSFCellStyle.THICK_VERT_BANDS;
	public static final short THICK_BACKWARD_DIAG 	= HSSFCellStyle.THICK_BACKWARD_DIAG;
	public static final short THICK_FORWARD_DIAG 		= HSSFCellStyle.THICK_FORWARD_DIAG;
	public static final short BIG_SPOTS 				= HSSFCellStyle.BIG_SPOTS;
	public static final short BRICKS 					= HSSFCellStyle.BRICKS;
	public static final short THIN_HORZ_BANDS 		= HSSFCellStyle.THIN_HORZ_BANDS;
	public static final short THIN_VERT_BANDS 		= HSSFCellStyle.THIN_VERT_BANDS;
	public static final short THIN_BACKWARD_DIAG 		= HSSFCellStyle.THIN_BACKWARD_DIAG;
	public static final short THIN_FORWARD_DIAG 		= HSSFCellStyle.THIN_FORWARD_DIAG;
	public static final short SQUARES 				= HSSFCellStyle.SQUARES;
	public static final short DIAMONDS 				= HSSFCellStyle.DIAMONDS;

	//****************************************************************************
	//tHg錾
	//****************************************************************************
	public static final String MS_GOTHIC				= "lr SVbN";
	public static final String MS_P_MINTYO			= "lr o";
	public static final String MS_MINTYO				= "lr ";

	//****************************************************************************
	//{[_[錾
	//****************************************************************************
	public static final short BORDER_DOTTED			= HSSFCellStyle.BORDER_DOTTED;
	public static final short BORDER_THIN				= HSSFCellStyle.BORDER_THIN;

	//****************************************************************************
	//錾
	//****************************************************************************
	/**
	 * 	textA@
	 */
	public static final short DATA_FORMAT_TEXT 		= 0x31;

	/**
	 * 	h:mm AM/PM
	 */
	public static final short DATA_FORMAT_TIME1 		= 0x12;

	/**
	 * 	h:mm:ss AM/PM
	 */
	public static final short DATA_FORMAT_TIME2 		= 0x13;

	/**
	 * 	h:mm
	 */
	public static final short DATA_FORMAT_TIME3 		= 0x14;

	/**
	 * 	h:mm:ss
	 */
	public static final short DATA_FORMAT_TIME4 		= 0x15;

	/**
	 * 	mm:ss
	 */
	public static final short DATA_FORMAT_TIME5 		= 0x2d;

	/**
	 * 	[h]:mm:ss
	 */
	public static final short DATA_FORMAT_TIME6 		= 0x2e;

	/**
	 * 	mm:ss.0
	 */
	public static final short DATA_FORMAT_TIME7 		= 0x2f;

	/**
	 * 	yyyy mm dd
	 */
	public static final String DATA_FORMAT_DATE1		= "yyyy mm dd";

	/**
	 * 	yyyy/mm/dd
	 */
	public static final String DATA_FORMAT_DATE2		= "yyyy/mm/dd";

	/**
	 * 	yyyy-mm-dd
	 */
	public static final String DATA_FORMAT_DATE3		= "yyyy-mm-dd";

	/**
	 * 	0
	 */
	public static final short DATA_FORMAT_INTEGER		= 1;

	/**
	 * 	0.00
	 */
	public static final short DATA_FORMAT_DOUBLE 		= 2;

	/**
	 * 	0%
	 */
	public static final short DATA_FORMAT_PERSENT 	= 9;

	/**
	 * 	0.00%
	 */
	public static final short DATA_FORMAT_PERSENT1 	= 0xa;

	//****************************************************************************
	//f[^ϐ錾
	//****************************************************************************

	//****************************************************************************
	//RXgN^
	//****************************************************************************
	/**
	 * RXgN^B<br>
	 */
	public PoiUtility() {
		// 
	}

	//****************************************************************************
	//Vō쐬\bh  
	//****************************************************************************
	/**
	 *  Vō쐬\bhB<br>  
	 */
	public void crtNewDoc(int shno, String shname) throws Exception {
		try{
			workbook = new HSSFWorkbook();
			sheet = workbook.createSheet();
			workbook.setSheetName(shno, shname, HSSFWorkbook.ENCODING_UTF_16);
			sheet.setSelected(true);
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//Vō쐬\bh  QƂɂ
	//****************************************************************************
	/**
	 *  Vō쐬\bh  (QƗp)B<br>
	 */
	public void crtNewDocR(int shno, String file1) throws Exception {
		try{
			in = new FileInputStream(file1);
			fs = new POIFSFileSystem(in);
			workbook = new HSSFWorkbook(fs);
		} catch(IOException e) {
			e.printStackTrace();
			throw e;
		} finally {
			try {
				in.close();
			} catch (IOException e) {
				throw e;
			}
		}
		sheet = workbook.getSheetAt(shno);
		sheet.setSelected(true);
	}

	//****************************************************************************
	//VV[g쐬\bh
	//****************************************************************************
	/**
	 *  VV[g쐬\bhB<br>
	 */

	public void selSheet(int shno) throws Exception {
		sheet = workbook.getSheetAt(shno);
		sheet.setSelected(true);
	}

	//****************************************************************************
	//VV[g쐬\bh
	//****************************************************************************
	/**
	 *  VV[g쐬\bhB<br>
	 */
	public void crtSheet(int newno, String shnm) throws Exception {
		try{
			workbook.createSheet();
			workbook.setSheetName(newno, shnm);
		} catch(Exception e) {
			throw e;
		}
		sheet = workbook.getSheetAt(newno);
		sheet.setSelected(true);
	}

	//****************************************************************************
	//VV[g쐬\bh  QƂɂ
	//****************************************************************************
	/**
	 *  VV[g쐬\bh  (QƗp)B<br>
	 */

	public void clnSheet(int shno, int newno, String shnm) throws Exception {
		try{
			workbook.cloneSheet(shno);
			workbook.setSheetName(newno, shnm);
		} catch(Exception e) {
			throw e;
		}
		sheet = workbook.getSheetAt(newno);
		sheet.setSelected(true);
	}

	//****************************************************************************
	//V[g폜\bh
	//****************************************************************************
	/**
	 *  V[g폜\bhB<br>
	 */
	public void rmvSheet(int shno) throws Exception {
		try{
			workbook.removeSheetAt(shno);
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//V[gݒ胁\bh@
	//****************************************************************************
	/**
	 * Zݒ
	 * @param columnNo		columnԍ
	 * @param number		
	 */
	public void setColumnWidth(int columnNo, int number) {
		short width = (short)(number * 256);
		sheet.setColumnWidth((short)columnNo, width);
	}

	/**
	 * V[gftHgZݒ
	 * @param number	
	 */
	public void setDefaultColumnWidth(int number) {
		sheet.setDefaultColumnWidth((short)number);
	}

	/**
	 * \{ύX
	 * @param magnification		\{ij
	 */
	public void setZoom(int magnification) {
		if (magnification > 0) {
			sheet.setZoom(magnification, 100);
		}
	}

	/**
	 * V[gύX
	 * @param sheetno		V[gԍ
	 * @param sheetname		ύXV[g
	 */
	public void setSheetName(int sheetno, String sheetname) {
		workbook.setSheetName(sheetno, sheetname, HSSFWorkbook.ENCODING_UTF_16);
	}

	//****************************************************************************
	//hLgo̓\bh
	//****************************************************************************
	/**
	 *  hLgo̓\bhB<br>
	 */
	public void outputDoc(String file) throws Exception {
		// t@CJāChLgo͂
		try{
			out = new FileOutputStream(file);
			workbook.write(out);
		} catch(IOException e) {
			throw e;
		} finally {
			try {
				out.close();
			} catch (IOException e) {
				throw e;
			}
		}
	}   

	//****************************************************************************
	//ڏ\bh
	//****************************************************************************
	/**
	 *  ڏ\bhB<br>
	 */
	public void clrCell(int rr, int cc) throws Exception {
		try{
			row = sheet.getRow(rr);
			cell = row.getCell((short)cc);
		} catch(Exception e) {
			throw e;
		}
		cell.setCellValue("");
	}

	//****************************************************************************
	//sǍ\bh
	//****************************************************************************
	/**
	 *  sǍ\bhB<br>
	 */

	public void getRow(int rr) throws Exception {
		try{
			row = sheet.getRow(rr);
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//s쐬\bh
	//****************************************************************************
	/**
	 *  s쐬\bhB<br>
	 */
	public void crtRow(int rr) throws Exception {
		try{
			row = sheet.createRow(rr);
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//s폜\bh
	//****************************************************************************
	/**
	 *  s폜\bhB<br>
	 */
	public void dltRow(int rr) throws Exception {
		try{
			row = sheet.getRow(rr);
			if (row != null) {
				sheet.removeRow(row);
			}
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//s폜\bh
	//****************************************************************************
	/**
	 *  sVtg\bhB<br>
	 */
	public void shiftRows(int rr) throws Exception {
		try{
			sheet.shiftRows(rr,sheet.getLastRowNum(),-1);
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//Z\bh@r
	//****************************************************************************
	/**
	 *  Z\bh(String)B<br>
	 */
	public void prtItem(int rr, int cc, String sdata) throws Exception {
		try{
			row = sheet.getRow(rr);
			if (row == null) {
				crtRow(rr);    //sǉ
			}
			cell = row.getCell((short)cc);
			if (cell == null) {
				cell = row.createCell((short)cc);    //Zǉ
			}
			cell.setEncoding(HSSFCell.ENCODING_UTF_16);
			cell.setCellValue(sdata);
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//Z\bh@h
	//****************************************************************************
	/**
	 *  Z\bh(int)B<br>
	 */
	public void prtItem(int rr, int cc, int idata) throws Exception {
		try{
			row = sheet.getRow(rr);
			if (row == null) {
				crtRow(rr);    //sǉ
			}
			cell = row.getCell((short)cc);
			if (cell == null) {
				cell = row.createCell((short)cc);    //Zǉ
			}
			cell.setCellValue(idata);
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//Z\bh@c
	//****************************************************************************
	/**
	 *  Z\bh(double)B<br>
	 */
	public void prtItem(int rr, int cc, double ddata) throws Exception {
		try{
			row = sheet.getRow(rr);
			if (row == null) {
				crtRow(rr);    //sǉ
			}
			cell = row.getCell((short)cc);
			if (cell == null) {
				cell = row.createCell((short)cc);    //Zǉ
			}
			cell.setCellValue(ddata);
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//ZǍ\bh@r
	//****************************************************************************
	/**
	 *  ZǍ\bh(String)1B<br>
	 */
	public String getsItem(int cc){
		try{
			cell = row.getCell((short)cc);
			if (cell != null) {
				return cell.getStringCellValue();
			}
			return "*";
		} catch(Exception e) {
			return "*";
		}
	}

	//****************************************************************************
	//ZǍ\bh@r
	//****************************************************************************
	/**
	 *  ZǍ\bh(String)2B<br>
	 */
	public String getsItem(int rr, int cc){
		try{
			row = sheet.getRow(rr);
			if (row != null) {
				cell = row.getCell((short)cc);
				if (cell != null) {
					return cell.getStringCellValue();
				}
				return "*";
			}
			return "*";
		} catch(Exception e) {
			return "*";
		}
	}

	//****************************************************************************
	//ZǍ\bh@h
	//****************************************************************************
	/**
	 *  ZǍ\bh(int)B<br>
	 */

	public int getiItem(int rr, int cc){
		try{
			row = sheet.getRow(rr);
			if (row != null) {
				cell = row.getCell((short)cc);
				if (cell != null) {
					return (int)cell.getNumericCellValue();
				}
				return 0;
			}
			return 0;
		} catch(Exception e) {
			return 0;
		}
	}

	//****************************************************************************
	//ZǍ\bh@c
	//****************************************************************************
	/**
	 *  ZǍ\bh(double)B<br>
	 */
	public double getdItem(int rr, int cc){
		try{
			row = sheet.getRow(rr);
			if (row != null) {
				cell = row.getCell((short)cc);
				if (cell != null) {
					return cell.getNumericCellValue();
				}
				return 0;
			}
			return 0;
		} catch(Exception e) {
			return 0.0;
		}
	}

	//****************************************************************************
	//Z\bh@r
	//****************************************************************************
	/**
	 *  Z\bh(String)B<br>
	 */
	public void wrtItem(int cc, String sdata) throws Exception {
		try{
			cell = row.createCell((short)cc);
			cell.setEncoding(HSSFCell.ENCODING_UTF_16);
			cell.setCellValue(sdata);
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//Z\bh@h
	//****************************************************************************
	/**
	 *  Z\bh(int)B<br>
	 */
	public void wrtItem(int cc, int idata) throws Exception {
		try{
			cell = row.createCell((short)cc);
			cell.setCellValue(idata);
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//Z\bh@c
	//****************************************************************************
	/**
	 *  Z\bh(double)B<br>
	 */
	public void wrtItem(int cc, double ddata) throws Exception {
		try{
			cell = row.createCell((short)cc);
			cell.setCellValue(ddata);
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//ZX^Cʃ\bh@CellStyle
	//****************************************************************************
	/**
	 *  ZX^Cʃ\bhB<br>
	 */
	public void clnCellStyle(int rr, int cc, int tr, int tc) throws Exception {
		try{
			row = sheet.getRow(rr);
			if (row != null) {
				cell = row.getCell((short)cc);
				if (cell != null) {
					style = cell.getCellStyle();
					setCellStyle(tr, tc);
				}
			}
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//ZX^CZbg\bh@CellStyle
	//****************************************************************************
	/**
	 *  ZX^CZbg\bhB<br>
	 */
	public void setCellStyle(int rr, int cc) throws Exception {
		try{
			row = sheet.getRow(rr);
			if (row != null) {
				cell = row.getCell((short)cc);
				if (cell != null) {
					cell.setCellStyle(style);
				}
			}
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//Zr\bh@BorderTop
	//****************************************************************************
	/**
	 *  Zr\bhB<br>
	 */
	public void prtBorderTop(int rr, int cc) throws Exception {
		try{
			row = sheet.getRow(rr);
			if (row == null) {
				crtRow(rr);    //sǉ
			}
			cell = row.getCell((short)cc);
			if (cell == null) {
				cell = row.createCell((short)cc);    //Zǉ
			}
			style = workbook.createCellStyle();
			style.setBorderTop(HSSFCellStyle.BORDER_THIN);
			cell.setCellStyle(style);
			cell.setCellValue("");
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//Zr\bh@BorderBottom
	//****************************************************************************
	/**
	 *  Zr\bhB<br>
	 */
	public void prtBorderBottom(int rr, int cc) throws Exception {
		try{
			row = sheet.getRow(rr);
			if (row == null) {
				crtRow(rr);    //sǉ
			}
			cell = row.getCell((short)cc);
			if (cell == null) {
				cell = row.createCell((short)cc);    //Zǉ
			}
			style = workbook.createCellStyle();
			style.setBorderBottom(HSSFCellStyle.BORDER_DASHED);
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//Zz~\bh@Format("#,##0")
	//****************************************************************************
	/**
	 *  Zz~\bhB<br>
	 */
	public void setCellYen(int rr, int cc) throws Exception {
		try{
			row = sheet.getRow(rr);
			if (row == null) {
				crtRow(rr);    //sǉ
			}
			cell = row.getCell((short)cc);
			if (cell == null) {
				cell = row.createCell((short)cc);    //Zǉ
			}
			style = workbook.createCellStyle();
			style.setDataFormat(HSSFDataFormat.getBuiltinFormat("#,##0"));
			cell.setCellStyle(style);
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//Zt`\bh
	//****************************************************************************
	/**
	 *  Zt`\bhB<br>
	 */
	public void setCellStyleDateFormat(int rr, int cc) throws Exception {
		try{
			row = sheet.getRow(rr);
			if (row == null) {
				crtRow(rr);    //sǉ
			}
			cell = row.getCell((short)cc);
			if (cell == null) {
				cell = row.createCell((short)cc);    //Zǉ
			}
			style = workbook.createCellStyle();
//			style.setDataFormat(HSSFDataFormat.getBuiltinFormat("m/d/yy h:mm"));
			HSSFDataFormat dformat = workbook.createDataFormat();
//			style.setDataFormat(dformat.getFormat("yyyyNmmdd"));
			style.setDataFormat(dformat.getFormat("yyyy mm dd"));
			cell.setCellStyle(style);
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//Z\bh@addMergedRegion
	//****************************************************************************
	/**
	 * Z\bhB<br>
	 */
	public void addMergedRegion(int rrf, int ccf, int rrt, int cct) throws Exception {
		try{
			sheet.addMergedRegion(new Region(rrf, (short)ccf, rrt, (short)cct));
		} catch(Exception e) {
			throw e;
		}
	}

	//****************************************************************************
	//ZwiFݒ胁\bh@setCellBgColor
	//****************************************************************************
	/**
	 * Z̔wiFݒ
	 * @param bgColor	{@link PoiUtility}̐F
	 */
	public void setCellBgColor(short bgColor) {
		style.setFillForegroundColor(bgColor);
		style.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	}

	/**
	 * Z̔wiFݒihԂwj
	 * @param bgColor	{@link PoiUtility}̐F
	 * @param pattern	{@link PoiUtility}̃p^[
	 */
	public void setCellBgColor(short bgColor, short pattern) {
		style.setFillForegroundColor(bgColor);
		style.setFillPattern(pattern);
	}

	//****************************************************************************
	//tHgFݒ胁\bh@setCellFontColor
	//****************************************************************************
	/**
	 * tHgFݒ
	 * @param fontColor		{@link PoiUtility}̐F
	 */
	public void setCellFontColor(short fontColor) {
		font.setColor(fontColor);
	}

	//****************************************************************************
	//tHgݒ胁\bh@setFont
	//****************************************************************************
	/**
	 * 
	 */
	public void setFontHAlignCenter() {
		style.setAlignment(HSSFCellStyle.ALIGN_CENTER_SELECTION);
	}

	/**
	 * 
	 */
	public void setFontHAlignLeft() {
		style.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	}

	/**
	 * E
	 */
	public void setFontHAlignRight() {
		style.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
	}

	/**
	 * c
	 */
	public void setFontVAlighCenter() {
		style.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
	}

	/**
	 * Z̕܂ԂđŜ\
	 */
	public void setWrapText() {
		style.setWrapText(true);
	}

	/**
	 * tHgTCYݒ
	 * @param size	tHgTCY
	 */
	public void setFontSize(int size) {
		font.setFontHeightInPoints((short)size);
	}

	/**
	 * tHgސݒ
	 * @param fontName	tHg
	 */
	public void setFontType(String fontName) {
		font.setFontName(fontName);
	}

	/**
	 * ݒ
	 */
	public void setFontWeightBold() {
		font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	}

	//****************************************************************************
	//ZwiFEtHgFݒ胁\bh@setCellColorCoordinate
	//****************************************************************************
	/**
	 * ZƃtHg̐Fw
	 * @param bgColor		{@link PoiUtility}̐F
	 * @param fontColor		{@link PoiUtility}̐F
	 */
	public void setCellColorCoordinate(short bgColor, short fontColor) {
		setCellBgColor(bgColor);
		setCellFontColor(fontColor);
	}

	/**
	 * ZƃtHg̐FwihԂwj
	 * @param bgColor		{@link PoiUtility}̐F
	 * @param fontColor		{@link PoiUtility}̐F
	 * @param pattern		{@link PoiUtility}̃p^[
	 */
	public void setCellColorCoordinate(short bgColor, short fontColor, short pattern) {
		setCellBgColor(bgColor, pattern);
		setCellFontColor(fontColor);
	}

	//****************************************************************************
	//Z{[_[FEސݒ胁\bh@setBorder
	//****************************************************************************
	/**
	 * Z{[_[ݒ
	 * @param borderStyle	{[_[^Cv
	 * @param borderColor	{[_[F
	 */
	public void setBorderAround(short borderStyle, short borderColor) {
		setBorderTop(borderStyle, borderColor);
		setBorderRight(borderStyle, borderColor);
		setBorderBottom(borderStyle, borderColor);
		setBorderLeft(borderStyle, borderColor);
	}

	/**
	 * _{[_[Z
	 */
	public void setBorderAroundDotted() {
		setBorderAround(BORDER_DOTTED, BLACK);
	}

	/**
	 * 㑤{[_[ݒ
	 * @param borderStyle	{[_[^Cv
	 * @param borderColor	{[_[F
	 */
	public void setBorderTop(short borderStyle, short borderColor) {
		style.setBorderTop(borderStyle);		
		style.setTopBorderColor(borderColor);
	}

	/**
	 * E{[_[ݒ
	 * @param borderStyle	{[_[^Cv
	 * @param borderColor	{[_[F
	 */
	public void setBorderRight(short borderStyle, short borderColor) {
		style.setBorderRight(borderStyle);		
		style.setRightBorderColor(borderColor);
	}

	/**
	 * {[_[ݒ
	 * @param borderStyle	{[_[^Cv
	 * @param borderColor	{[_[F
	 */
	public void setBorderBottom(short borderStyle, short borderColor) {
		style.setBorderBottom(borderStyle);		
		style.setBottomBorderColor(borderColor);
	}

	/**
	 * {[_[ݒ
	 * @param borderStyle	{[_[^Cv
	 * @param borderColor	{[_[F
	 */
	public void setBorderLeft(short borderStyle, short borderColor) {
		style.setBorderLeft(borderStyle);		
		style.setLeftBorderColor(borderColor);
	}

	//****************************************************************************
	//\bh@
	//****************************************************************************
	/**
	 * X^Cݒ萶
	 * <p>
	 * \bhsA{@link PoiUtility#prtItem(int, int, String)}sA<br>
	 * K{@link PoiUtility#reflectCellStyleNoFont()}sĂB
	 * </p>
	 */
	public void createCellStyle() {
		style = workbook.createCellStyle();
	}

	/**
	 * tHgݒ萶
	 */
	private void createFont() {
		font = workbook.createFont();
	}

	/**
	 * X^CEtHgݒ萶
	 * <p>
	 * \bhsA{@link PoiUtility#prtItem(int, int, String)}sA<br>
	 * K{@link PoiUtility#reflectCellStyle()}sĂB
	 * </p>
	 */
	public void createCellStyleAndFont() {
		createCellStyle();
		createFont();
	}

	//****************************************************************************
	//X^C\bh@
	//****************************************************************************
	/**
	 * Zݒ
	 * @param rr			rowԍ
	 * @param cc			cellԍ
	 * @param sdata			Stringf[^
	 * @param isStyle		X^C̗pہitHgݒLj
	 * @throws Exception
	 * <p>
	 * isStyletruȅꍇAsX^Cݒ肵A<br>
	 * K{@link PoiUtility#reflectCellStyle()}sĂB
	 * </p>
	 */
	public void prtItem(int rr, int cc, String sdata, boolean isStyle) throws Exception {
		try{
			row = sheet.getRow(rr);
			if (row == null) {
				crtRow(rr);    //sǉ
			}
			cell = row.getCell((short)cc);
			if (cell == null) {
				cell = row.createCell((short)cc);    //Zǉ
			}
			cell.setEncoding(HSSFCell.ENCODING_UTF_16);
			cell.setCellValue(sdata);
			if (isStyle) {
				createCellStyleAndFont();
			}
		} catch(Exception e) {
			throw e;
		}
	}

	/**
	 * ݒ
	 * @param format	^Cv
	 */
	public void setDataFormat(short format) {
		style.setDataFormat(format);
	}

	/**
	 * ݒ
	 * @param type		^Cv
	 */
	public void setDataFormat(String type) {
		HSSFDataFormat dformat = workbook.createDataFormat();
		style.setDataFormat(dformat.getFormat(type));
	}

	/**
	 * X^Cf
	 * <p>
	 * X^Cݒ肵ꍇAK̃\bhsĂB
	 * </p>
	 */
	public void reflectCellStyle(){
		style.setFont(font);
		cell.setCellStyle(style);
	}

	/**
	 * X^Cf(tHgݒ薳)
	 * <p>
	 * X^Cݒ(tHgݒ薳)ꍇAK̃\bhsĂB
	 * </p>
	 */
	public void reflectCellStyleNoFont(){
		cell.setCellStyle(style);
	}

	//****************************************************************************
	//ŏs擾\bh@
	//****************************************************************************
	/**
	 * ŏs擾\bhB<br>
	 */
	public int getFirstRow(){
		return sheet.getFirstRowNum();      //ŏs擾
	}

	//****************************************************************************
	//ŏIs擾\bh@
	//****************************************************************************
	/**
	 *ŏIs擾\bhB<br>
	 */
	public int getLastRow(){
		return sheet.getLastRowNum();      //ŏIs擾
	}


	//****************************************************************************
	//͈͂̐ݒ胁\bh@
	//****************************************************************************
	/**
	 *͈͂̐ݒ胁\bhB<br>
	 */

	public void setPrintArea(int shno, int strcc,int endcc,int strrr,int endrr) {
		workbook.removePrintArea(shno);	  
		workbook.setPrintArea(shno, strcc, endcc, strrr, endrr);	  
	}
	//****************************************************************************


	//****************************************************************************
	//͈͂̐ݒ胁\bh@
	//****************************************************************************
	/**
	 *͈͂̐ݒ胁\bhB<br>
	 */
	public void setPrintArea(int shno, String printa) {
		workbook.removePrintArea(shno);	  
		workbook.setPrintArea(shno, printa);	  
	}
	//****************************************************************************

	//****************************************************************************
	//Workbookԋp郁\bh
	/**
	 * Workbookԋp郁\bhB<br>
	 */
	//****************************************************************************
	public HSSFWorkbook getWorkbook() {
		return workbook;
	}
	//****************************************************************************

}
