/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.util.DelegatePropertiesHolder;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.MaxFontSizeFinder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextMeasurer
implements JRTextMeasurer {
    private static final Log log = LogFactory.getLog(TextMeasurer.class);
    private static final FontRenderContext FONT_RENDER_CONTEXT = TextRenderer.LINE_BREAK_FONT_RENDER_CONTEXT;
    private JRCommonText textElement;
    private JRPropertiesHolder propertiesHolder;
    private MaxFontSizeFinder maxFontSizeFinder;
    private int width;
    private int height;
    private int topPadding;
    private int leftPadding;
    private int bottomPadding;
    private int rightPadding;
    private float lineSpacing;
    private float formatWidth;
    private int maxHeight;
    private boolean canOverflow;
    private Map globalAttributes;
    private TextMeasuredState measuredState;
    private TextMeasuredState prevMeasuredState;

    public TextMeasurer(JRCommonText textElement) {
        this.textElement = textElement;
        JRPropertiesHolder jRPropertiesHolder = this.propertiesHolder = textElement instanceof JRPropertiesHolder ? (JRPropertiesHolder)((Object)textElement) : null;
        if (textElement.getDefaultStyleProvider() instanceof JRPropertiesHolder) {
            this.propertiesHolder = new DelegatePropertiesHolder(this.propertiesHolder, (JRPropertiesHolder)((Object)textElement.getDefaultStyleProvider()));
        }
    }

    protected void initialize(JRStyledText styledText, int remainingTextStart, int availableStretchHeight, boolean canOverflow) {
        this.width = this.textElement.getWidth();
        this.height = this.textElement.getHeight();
        this.topPadding = this.textElement.getLineBox().getTopPadding();
        this.leftPadding = this.textElement.getLineBox().getLeftPadding();
        this.bottomPadding = this.textElement.getLineBox().getBottomPadding();
        this.rightPadding = this.textElement.getLineBox().getRightPadding();
        switch (this.textElement.getRotationValue()) {
            case LEFT: {
                this.width = this.textElement.getHeight();
                this.height = this.textElement.getWidth();
                int tmpPadding = this.topPadding;
                this.topPadding = this.leftPadding;
                this.leftPadding = this.bottomPadding;
                this.bottomPadding = this.rightPadding;
                this.rightPadding = tmpPadding;
                break;
            }
            case RIGHT: {
                this.width = this.textElement.getHeight();
                this.height = this.textElement.getWidth();
                int tmpPadding = this.topPadding;
                this.topPadding = this.rightPadding;
                this.rightPadding = this.bottomPadding;
                this.bottomPadding = this.leftPadding;
                this.leftPadding = tmpPadding;
                break;
            }
            case UPSIDE_DOWN: {
                int tmpPadding = this.topPadding;
                this.topPadding = this.bottomPadding;
                this.bottomPadding = tmpPadding;
                tmpPadding = this.leftPadding;
                this.leftPadding = this.rightPadding;
                this.rightPadding = tmpPadding;
                break;
            }
        }
        switch (this.textElement.getLineSpacingValue()) {
            case SINGLE: {
                this.lineSpacing = 1.0f;
                break;
            }
            case ONE_AND_HALF: {
                this.lineSpacing = 1.5f;
                break;
            }
            case DOUBLE: {
                this.lineSpacing = 2.0f;
                break;
            }
            default: {
                this.lineSpacing = 1.0f;
            }
        }
        this.maxFontSizeFinder = MaxFontSizeFinder.getInstance(!"none".equals(this.textElement.getMarkup()));
        this.formatWidth = this.width - this.leftPadding - this.rightPadding;
        this.formatWidth = this.formatWidth < 0.0f ? 0.0f : this.formatWidth;
        this.maxHeight = this.height + availableStretchHeight - this.topPadding - this.bottomPadding;
        this.maxHeight = this.maxHeight < 0 ? 0 : this.maxHeight;
        this.canOverflow = canOverflow;
        this.globalAttributes = styledText.getGlobalAttributes();
        boolean saveLineBreakOffsets = JRProperties.getBooleanProperty(this.propertiesHolder, "net.sf.jasperreports.text.save.line.breaks", false);
        this.measuredState = new TextMeasuredState(saveLineBreakOffsets);
        this.measuredState.lastOffset = remainingTextStart;
        this.prevMeasuredState = null;
    }

    public JRMeasuredText measure(JRStyledText styledText, int remainingTextStart, int availableStretchHeight, boolean canOverflow) {
        this.initialize(styledText, remainingTextStart, availableStretchHeight, canOverflow);
        AttributedCharacterIterator allParagraphs = styledText.getAwtAttributedString(JRProperties.getBooleanProperty(this.propertiesHolder, "net.sf.jasperreports.awt.ignore.missing.font", false)).getIterator();
        int tokenPosition = remainingTextStart;
        int lastParagraphStart = remainingTextStart;
        String lastParagraphText = null;
        String remainingText = styledText.getText().substring(remainingTextStart);
        StringTokenizer tkzer = new StringTokenizer(remainingText, "\n", true);
        boolean rendered = true;
        while (tkzer.hasMoreTokens() && rendered) {
            String token = tkzer.nextToken();
            if ("\n".equals(token)) {
                rendered = this.renderParagraph(allParagraphs, lastParagraphStart, lastParagraphText);
                lastParagraphStart = tokenPosition + (tkzer.hasMoreTokens() || tokenPosition == 0 ? 1 : 0);
                lastParagraphText = null;
            } else {
                lastParagraphStart = tokenPosition;
                lastParagraphText = token;
            }
            tokenPosition += token.length();
        }
        if (rendered && lastParagraphStart < remainingTextStart + remainingText.length()) {
            this.renderParagraph(allParagraphs, lastParagraphStart, lastParagraphText);
        }
        return this.measuredState;
    }

    protected boolean renderParagraph(AttributedCharacterIterator allParagraphs, int lastParagraphStart, String lastParagraphText) {
        AttributedCharacterIterator paragraph = null;
        paragraph = lastParagraphText == null ? new AttributedString(" ", new AttributedString(allParagraphs, lastParagraphStart, lastParagraphStart + 1).getIterator().getAttributes()).getIterator() : new AttributedString(allParagraphs, lastParagraphStart, lastParagraphStart + lastParagraphText.length()).getIterator();
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, FONT_RENDER_CONTEXT);
        this.measuredState.textOffset = lastParagraphStart;
        boolean rendered = true;
        boolean renderedLine = false;
        while (lineMeasurer.getPosition() < paragraph.getEndIndex() && rendered) {
            rendered = this.renderNextLine(lineMeasurer, paragraph);
            renderedLine = renderedLine || rendered;
        }
        if (!rendered && this.prevMeasuredState != null && !this.canOverflow) {
            this.processLastTruncatedRow(allParagraphs, lastParagraphText, lastParagraphStart, renderedLine);
        }
        return rendered;
    }

    protected void processLastTruncatedRow(AttributedCharacterIterator allParagraphs, String paragraphText, int paragraphOffset, boolean lineTruncated) {
        if (lineTruncated && this.isToTruncateAtChar()) {
            this.truncateLastLineAtChar(allParagraphs, paragraphText, paragraphOffset);
        }
        this.appendTruncateSuffix(allParagraphs);
    }

    protected void truncateLastLineAtChar(AttributedCharacterIterator allParagraphs, String paragraphText, int paragraphOffset) {
        this.measuredState = this.prevMeasuredState.cloneState();
        AttributedCharacterIterator lineParagraph = new AttributedString(allParagraphs, this.measuredState.textOffset, paragraphOffset + paragraphText.length()).getIterator();
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(lineParagraph, BreakIterator.getCharacterInstance(), FONT_RENDER_CONTEXT);
        this.renderNextLine(lineMeasurer, lineParagraph);
    }

    protected void appendTruncateSuffix(AttributedCharacterIterator allParagraphs) {
        String truncateSuffx = this.getTruncateSuffix();
        if (truncateSuffx == null) {
            return;
        }
        int lineStart = this.prevMeasuredState.textOffset;
        StringBuffer lineText = new StringBuffer();
        allParagraphs.setIndex(lineStart);
        while (allParagraphs.getIndex() < this.measuredState.textOffset && allParagraphs.current() != '\n') {
            lineText.append(allParagraphs.current());
            allParagraphs.next();
        }
        int linePosition = allParagraphs.getIndex() - lineStart;
        boolean done = false;
        do {
            this.measuredState = this.prevMeasuredState.cloneState();
            String text = lineText.substring(0, linePosition) + truncateSuffx;
            AttributedString attributedText = new AttributedString(text);
            AttributedCharacterIterator lineAttributes = new AttributedString(allParagraphs, this.measuredState.textOffset, this.measuredState.textOffset + linePosition).getIterator();
            this.setAttributes(attributedText, lineAttributes, 0);
            this.setAttributes(attributedText, this.globalAttributes, text.length() - truncateSuffx.length(), text.length());
            AttributedCharacterIterator lineParagraph = attributedText.getIterator();
            BreakIterator breakIterator = this.isToTruncateAtChar() ? BreakIterator.getCharacterInstance() : BreakIterator.getLineInstance();
            LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(lineParagraph, breakIterator, FONT_RENDER_CONTEXT);
            if (this.renderNextLine(lineMeasurer, lineParagraph)) {
                int lastPos = lineMeasurer.getPosition();
                if (lastPos == linePosition + truncateSuffx.length()) {
                    this.measuredState.textOffset -= truncateSuffx.length();
                    this.measuredState.textSuffix = truncateSuffx;
                    done = true;
                    continue;
                }
                if ((linePosition = breakIterator.preceding(linePosition)) != -1) continue;
                String actualSuffix = truncateSuffx.substring(0, this.measuredState.textOffset - this.prevMeasuredState.textOffset);
                if (this.prevMeasuredState.textOffset > 0 && allParagraphs.setIndex(this.prevMeasuredState.textOffset - 1) != '\n') {
                    actualSuffix = '\n' + actualSuffix;
                }
                this.measuredState.textSuffix = actualSuffix;
                this.measuredState.textOffset = this.prevMeasuredState.textOffset;
                done = true;
                continue;
            }
            done = true;
        } while (!done);
    }

    protected boolean isToTruncateAtChar() {
        return JRProperties.getBooleanProperty(this.propertiesHolder, "net.sf.jasperreports.text.truncate.at.char", false);
    }

    protected String getTruncateSuffix() {
        String truncateSuffx = JRProperties.getProperty(this.propertiesHolder, "net.sf.jasperreports.text.truncate.suffix");
        if (truncateSuffx != null && (truncateSuffx = truncateSuffx.trim()).length() == 0) {
            truncateSuffx = null;
        }
        return truncateSuffx;
    }

    protected boolean renderNextLine(LineBreakMeasurer lineMeasurer, AttributedCharacterIterator paragraph) {
        boolean fits;
        int lineStartPosition = lineMeasurer.getPosition();
        TextLayout layout = lineMeasurer.nextLayout(this.formatWidth);
        float newTextHeight = this.measuredState.textHeight + layout.getLeading() + this.lineSpacing * layout.getAscent();
        boolean bl = fits = newTextHeight + layout.getDescent() <= (float)this.maxHeight;
        if (fits) {
            this.prevMeasuredState = this.measuredState.cloneState();
            this.measuredState.isLeftToRight = this.measuredState.isLeftToRight && layout.isLeftToRight();
            this.measuredState.textHeight = newTextHeight;
            ++this.measuredState.lines;
            this.measuredState.fontSizeSum += this.maxFontSizeFinder.findMaxFontSize(new AttributedString(paragraph, lineStartPosition, lineStartPosition + layout.getCharacterCount()).getIterator(), this.textElement.getFontSize());
            if (this.measuredState.lines == 1) {
                this.measuredState.firstLineLeading = this.measuredState.textHeight;
                this.measuredState.firstLineMaxFontSize = this.measuredState.fontSizeSum;
            }
            this.measuredState.textHeight += layout.getDescent();
            this.measuredState.textOffset += lineMeasurer.getPosition() - lineStartPosition;
            if (lineMeasurer.getPosition() < paragraph.getEndIndex()) {
                this.measuredState.addLineBreak();
            }
        }
        return fits;
    }

    protected JRPropertiesHolder getTextPropertiesHolder() {
        return this.propertiesHolder;
    }

    protected void setAttributes(AttributedString string, AttributedCharacterIterator attributes, int stringOffset) {
        char c = attributes.first();
        while (c != '\uffff') {
            for (Map.Entry<AttributedCharacterIterator.Attribute, Object> attributeEntry : attributes.getAttributes().entrySet()) {
                AttributedCharacterIterator.Attribute attribute = attributeEntry.getKey();
                if (attributes.getRunStart(attribute) != attributes.getIndex()) continue;
                Object attributeValue = attributeEntry.getValue();
                string.addAttribute(attribute, attributeValue, attributes.getIndex() + stringOffset, attributes.getRunLimit(attribute) + stringOffset);
            }
            c = attributes.next();
        }
    }

    protected void setAttributes(AttributedString string, Map attributes, int startIndex, int endIndex) {
        for (Map.Entry entry : attributes.entrySet()) {
            AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)entry.getKey();
            Object attributeValue = entry.getValue();
            string.addAttribute(attribute, attributeValue, startIndex, endIndex);
        }
    }

    protected static class TextMeasuredState
    implements JRMeasuredText,
    Cloneable {
        private final boolean saveLineBreakOffsets;
        protected int textOffset;
        protected int lines;
        protected int fontSizeSum;
        protected int firstLineMaxFontSize;
        protected float textHeight;
        protected float firstLineLeading;
        protected boolean isLeftToRight = true;
        protected String textSuffix;
        protected int lastOffset;
        protected ArrayList lineBreakOffsets;

        public TextMeasuredState(boolean saveLineBreakOffsets) {
            this.saveLineBreakOffsets = saveLineBreakOffsets;
        }

        public boolean isLeftToRight() {
            return this.isLeftToRight;
        }

        public int getTextOffset() {
            return this.textOffset;
        }

        public float getTextHeight() {
            return this.textHeight;
        }

        public float getLineSpacingFactor() {
            if (this.lines > 0) {
                return this.textHeight / (float)this.fontSizeSum;
            }
            return 0.0f;
        }

        public float getLeadingOffset() {
            return this.firstLineLeading - (float)this.firstLineMaxFontSize * this.getLineSpacingFactor();
        }

        public String getTextSuffix() {
            return this.textSuffix;
        }

        public TextMeasuredState cloneState() {
            try {
                TextMeasuredState clone = (TextMeasuredState)super.clone();
                if (this.lineBreakOffsets != null) {
                    clone.lineBreakOffsets = (ArrayList)this.lineBreakOffsets.clone();
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new JRRuntimeException(e);
            }
        }

        protected void addLineBreak() {
            if (this.saveLineBreakOffsets) {
                if (this.lineBreakOffsets == null) {
                    this.lineBreakOffsets = new ArrayList();
                }
                int breakOffset = this.textOffset - this.lastOffset;
                this.lineBreakOffsets.add(breakOffset);
                this.lastOffset = this.textOffset;
            }
        }

        public short[] getLineBreakOffsets() {
            int exclude;
            if (!this.saveLineBreakOffsets) {
                return null;
            }
            int n = exclude = this.lastOffset == this.textOffset ? 1 : 0;
            if (this.lineBreakOffsets == null || this.lineBreakOffsets.size() <= exclude) {
                return JRPrintText.ZERO_LINE_BREAK_OFFSETS;
            }
            short[] offsets = new short[this.lineBreakOffsets.size() - exclude];
            boolean overflow = false;
            for (int i = 0; i < offsets.length; ++i) {
                int offset = (Integer)this.lineBreakOffsets.get(i);
                if (offset > Short.MAX_VALUE) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Line break offset value " + offset + " is bigger than the maximum supported value of" + Short.MAX_VALUE + ". Line break offsets will not be saved for this text."));
                    }
                    overflow = true;
                    break;
                }
                offsets[i] = (short)offset;
            }
            if (overflow) {
                return null;
            }
            return offsets;
        }
    }
}

