<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software: you can redistribute it and/or
modify it under the terms of the GNU Affero General Public License
as published by the Free Software Foundation, either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
--%>
<%@ page
language     = "java"
pageEncoding = "UTF-8"
buffer       = "64kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "java.lang.reflect.Field"
import = "jp.mosp.framework.utils.HtmlUtility"
import = "jp.mosp.framework.constant.MospConst"
import = "jp.mosp.framework.base.MospParams"
import = "jp.mosp.platform.base.PlatformVo"
import = "jp.mosp.platform.constant.PlatformConst"
%><%
MospParams params = (MospParams)request.getAttribute(MospConst.ATT_MOSP_PARAMS);
PlatformVo vo = (PlatformVo)params.getVo();
%>
<script type="text/javascript">
var procSeq = "<%= params.getProcSeq() %>";
<%
// VOから変数(modeXXX or jsXXX)を取得
Class<?> cls = vo.getClass();
while (cls != null) {
	Field[] fields = cls.getDeclaredFields();
	if (fields == null) {
		continue;
	}
	for (Field field : fields) {
		String fieldName = field.getName();
		if (fieldName.indexOf("mode") != 0 && fieldName.indexOf("js") != 0) {
			continue;
		}
		field.setAccessible(true);
		Object value = field.get(vo);
		// 有効日モード出力
		if (fieldName.indexOf("modeActivateDate") >= 0) {
%>
var MODE_ACTIVATE_DATE_FIXED = "<%= PlatformConst.MODE_ACTIVATE_DATE_FIXED %>";
var MODE_ACTIVATE_DATE_CHANGING = "<%= PlatformConst.MODE_ACTIVATE_DATE_CHANGING %>";
<%
		}
		// 編集モード出力
		if (fieldName.indexOf("modeCardEdit") >= 0) {
%>
var MODE_CARD_EDIT_INSERT = "<%= PlatformConst.MODE_CARD_EDIT_INSERT %>";
var MODE_CARD_EDIT_ADD = "<%= PlatformConst.MODE_CARD_EDIT_ADD %>";
var MODE_CARD_EDIT_EDIT = "<%= PlatformConst.MODE_CARD_EDIT_EDIT %>";
<%
		}
		if (value == null) {
			continue;
		}
		if (value instanceof String) {
%>
var <%= fieldName %> = "<%= value.toString() %>";
<%
		} else if (value instanceof String[]) {
%>
<%= HtmlUtility.getJsArray(fieldName, (String[])value) %>
<%
		} else if (value instanceof String[][]) {
%>
<%= HtmlUtility.getJsArray(fieldName, (String[][])value) %>
<%
		}
	}
	// 継承元クラス取得
	cls = cls.getSuperclass();
}
// MosP汎用パラメータから変数(jsXXX)を取得
for (String key : params.getGeneralParamKeySet()) {
	if (key.indexOf("js") != 0) {
		continue;
	}
	Object value = params.getGeneralParam(key);
	if (value instanceof String) {
%>
var <%= key %> = "<%= value.toString() %>";
<%
	} else if (value instanceof String[]) {
%>
<%= HtmlUtility.getJsArray(key, (String[])value) %>
<%
		} else if (value instanceof String[][]) {
%>
<%= HtmlUtility.getJsArray(key, (String[][])value) %>
<%
	}
}
if (params.getUser() != null) {
%>
<%= HtmlUtility.getMenuJs(params) %>
SELECT_MENU = "<%= HtmlUtility.getSelectMenu(params) %>";
<%
}
%>
</script>
