<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software: you can redistribute it and/or
modify it under the terms of the GNU Affero General Public License
as published by the Free Software Foundation, either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
--%>
<%@ page
language     = "java"
pageEncoding = "UTF-8"
buffer       = "32kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@page
import = "jp.mosp.framework.base.MospParams"
import = "jp.mosp.framework.constant.MospConst"
import = "jp.mosp.framework.utils.HtmlUtility"
import = "jp.mosp.platform.constant.PlatformConst"
import = "jp.mosp.time.constant.TimeMessageConst"
import = "jp.mosp.time.management.action.ApprovalCardAction"
import = "jp.mosp.time.management.vo.ApprovalCardVo"
%><%
MospParams params = (MospParams)request.getAttribute(MospConst.ATT_MOSP_PARAMS);
ApprovalCardVo vo = (ApprovalCardVo)params.getVo();
%>

<div class="ListHeader">
	<table class="EmployeeLabelTable">
		<jsp:include page="<%= TimeMessageConst.PATH_TIME_COMMON_INFO_JSP %>"flush="false" />
	</table>
	<table class="DateTable">
		<tr>
			<td>&nbsp; 
				<%= vo.getLblYear() %><%= params.getName("Year") %>
				<%= vo.getLblMonth() %><%= params.getName("Month") %>
				<%= vo.getLblDay() %><%= params.getName("Day") %>
			</td>
		</tr>
	</table>
</div>
<div class="List">
	<table class="InputTable" id="tblCorrection">
		<tr>
			<th class="ListTableTh" colspan="2"><span class="TitleTh"><%= params.getName("Correction") %><%= params.getName("Information") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd">
				<%= params.getName("Correction") %><%= params.getName("Reason") %>
			</td>
			<td class="InputTd"><%= vo.getLblCorrectionReason() %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Correction") %><%= params.getName("Information") %></td>
			<td class="InputTd"><%= vo.getLblCorrectionHistory() %></td>
		</tr>
	</table>
	<table class="InputTable" id="tblAttendance">
		<tr>
			<th class="ListTableTh" colspan="6"><span class="TitleTh"><%= params.getName("Attendance") %><%= params.getName("Information") %></span>				
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Work") %><%= params.getName("Form") %></td>
			<td class="InputTd" id="lblWorkType"><%= vo.getLblWorkType() %>
			</td>
			<td class="TitleTd"><%= params.getName("StartWork") %><%= params.getName("Moment") %></td>
			<td class="InputTd" id="lblStartTime"><%= vo.getLblStartTime() %>
			</td>
			<td class="TitleTd"><%= params.getName("EndWork") %><%= params.getName("Moment") %></td>
			<td class="InputTd" id="lblEndTime"><%= vo.getLblEndTime() %>
			</td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Work") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblWorkType"><%= vo.getLblWorkTime() %></td>
			<td class="TitleTd"><%= params.getName("DirectStart") %><%= params.getName("Slash") %><%= params.getName("DirectEnd") %></td>
			<td class="InputTd" id="lblApprovalState"><%= vo.getLblDirectWorkManage() %></td>
			<td class="Blank" colspan="2"></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("WorkManage") %><%= params.getName("Comment") %></td>
			<td class="InputTd" id="tdAttendanceComment" colspan="5"><%-- vo.getLblTimeComment() --%></td>
		</tr>
	</table>
</div>
<div class="List">
	<table class="InputTable" id="tblRest">
		<tr>
			<th class="ListTableTh" colspan="6"><span class="TitleTh"><%= params.getName("RestTime") %><%= params.getName("Information") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Legal") %><%= params.getName("Inside") %><%= params.getName("RestTime") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblRestTimeIn"><%= vo.getLblRestTime() %></td>
			<td class="TitleTd"><%= params.getName("RestTime") %><%= params.getName("No1") %></td>
			<td class="InputTd" id="lblRestTime1"><%= vo.getLblRestTime1() %></td>
			<td class="TitleTd"><%= params.getName("RestTime") %><%= params.getName("No2") %></td>
			<td class="InputTd" id="lblRestTime2"><%= vo.getLblRestTime2() %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Legal") %><%= params.getName("Outside") %><%= params.getName("RestTime") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblRestTimeOut"><%= vo.getLblOverRestTime() %></td>
			<td class="TitleTd"><%= params.getName("RestTime") %><%= params.getName("No3") %></td>
			<td class="InputTd" id="lblRestTime3"><%= vo.getLblRestTime3() %></td>
			<td class="TitleTd"><%= params.getName("RestTime") %><%= params.getName("No4") %></td>
			<td class="InputTd" id="lblRestTime4"><%= vo.getLblRestTime4() %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Midnight") %><%= params.getName("RestTime") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblLateRestTime"><%= vo.getLblNightRestTime() %></td>
			<td class="TitleTd"><%= params.getName("RestTime") %><%= params.getName("No5") %></td>
			<td class="InputTd" id="lblRestTime5"><%= vo.getLblRestTime5() %></td>
			<td class="TitleTd"><%= params.getName("RestTime") %><%= params.getName("No6") %></td>
			<td class="InputTd" id="lblRestTime6"><%= vo.getLblRestTime6() %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Official") %><%= params.getName("GoingOut") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblPublicTime"><%= vo.getLblPublicTime() %></td>
			<td class="TitleTd"><%= params.getName("Official") %><%= params.getName("GoingOut") %><%= params.getName("No1") %></td>
			<td class="InputTd" id="lblPublicTime1"><%= vo.getLblPublicTime1() %></td>
			<td class="TitleTd"><%= params.getName("Official") %><%= params.getName("GoingOut") %><%= params.getName("No2") %></td>
			<td class="InputTd" id="lblPublicTime2"><%= vo.getLblPublicTime2() %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Private") %><%= params.getName("GoingOut") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblPrivateTime"><%= vo.getLblPrivateTime() %></td>
			<td class="TitleTd"><%= params.getName("Private") %><%= params.getName("GoingOut") %><%= params.getName("No1") %></td>
			<td class="InputTd" id="lblPrivateTime1"><%= vo.getLblPrivateTime1() %></td>
			<td class="TitleTd"><%= params.getName("Private") %><%= params.getName("GoingOut") %><%= params.getName("No2") %></td>
			<td class="InputTd" id="lblPrivateTime2"><%= vo.getLblPrivateTime2() %></td>
		</tr>
	</table>
	<table class="InputTable" id="tblLateEarly">
		<tr>
			<th class="ListTableTh" colspan="6"><span class="TitleTh"><%= params.getName("Tardiness") %><%= params.getName("LeaveEarly") %><%= params.getName("Information") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Tardiness") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblLateTime"><%= vo.getLblLateTime() %></td>
			<td class="TitleTd"><%= params.getName("Tardiness") %><%= params.getName("Reason") %></td>
			<td class="InputTd" id="lblLateReason"><%= vo.getLblLateReason() %></td>
			<td class="TitleTd"><%= params.getName("Certificates") %></td>
			<td class="InputTd" id="lblLateCertificate"><%= vo.getLblLateCertificate() %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Comment") %></td>
			<td class="InputTd" id="lblLateComment" colspan="5"><%= vo.getLblLateComment() %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("LeaveEarly") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblLeaveEarlyTime"><%= vo.getLblLeaveEarlyTime() %></td>
			<td class="TitleTd"><%= params.getName("LeaveEarly") %><%= params.getName("Reason") %></td>
			<td class="InputTd" id="lblLeaveEarlyReason"><%= vo.getLblLeaveEarlyReason() %></td>
			<td class="TitleTd"><%= params.getName("Certificates") %></td>
			<td class="InputTd" id="lblLeaveEarlyCertificate"><%= vo.getLblLeaveEarlyCertificate() %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Comment") %></td>
			<td class="InputTd" id="lblLeaveEarlyComment" colspan="5"><%= vo.getLblLeaveEarlyComment() %></td>
		</tr>
	</table>
	<table class="InputTable" id="tblOverTime">
		<tr>
			<th class="ListTableTh" colspan="6"><span class="TitleTh"><%= params.getName("OvertimeWork") %><%= params.getName("Information") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("OvertimeWork") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblOverTimeIn"><%= vo.getLblOverTimeIn() %></td>
			<td class="TitleTd"><%= params.getName("Legal") %><%= params.getName("Outside") %><%= params.getName("OvertimeWork") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblOverTimeOut"><%= vo.getLblOverTimeOut() %></td>
			<td class="TitleTd"><%= params.getName("Midnight") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblLateNightTime"><%= vo.getLblLateNightTime() %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Prescribed") %><%= params.getName("Holiday") %><%= params.getName("Work") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblSpecificWorkTime"><%= vo.getLblSpecificWorkTimeIn() %></td>
			<td class="TitleTd"><%= params.getName("Legal") %><%= params.getName("Holiday") %><%= params.getName("Work") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblLegalWorkTime"><%= vo.getLblLegalWorkTime() %></td>
			<td class="TitleTd"><%= params.getName("Reduced") %><%= params.getName("Target") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblDecreaseTime"><%= vo.getLblDecreaseTime() %></td>
		</tr>
	</table>
	<table class="InputTable" id="tblAllowance">
		<tr>
			<th class="ListTableTh" colspan="10"><span class="TitleTh"><%= params.getName("Allowance") %><%= params.getName("Information") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Allowance") %><%= params.getName("No1") %></td>
			<td class="InputTd" id="lblAllowance1"><%= vo.getLblAllowance1() %></td>
			<td class="TitleTd"><%= params.getName("Allowance") %><%= params.getName("No2") %></td>
			<td class="InputTd" id="lblAllowance2"><%= vo.getLblAllowance2() %></td>
			<td class="TitleTd"><%= params.getName("Allowance") %><%= params.getName("No3") %></td>
			<td class="InputTd" id="lblAllowance3"><%= vo.getLblAllowance3() %></td>
			<td class="TitleTd"><%= params.getName("Allowance") %><%= params.getName("No4") %></td>
			<td class="InputTd" id="lblAllowance4"><%= vo.getLblAllowance4() %></td>
			<td class="TitleTd"><%= params.getName("Allowance") %><%= params.getName("No5") %></td>
			<td class="InputTd" id="lblAllowance5"><%= vo.getLblAllowance5() %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Allowance") %><%= params.getName("No6") %></td>
			<td class="InputTd" id="lblAllowance6"><%= vo.getLblAllowance6() %></td>
			<td class="TitleTd"><%= params.getName("Allowance") %><%= params.getName("No7") %></td>
			<td class="InputTd" id="lblAllowance7"><%= vo.getLblAllowance7() %></td>
			<td class="TitleTd"><%= params.getName("Allowance") %><%= params.getName("No8") %></td>
			<td class="InputTd" id="lblAllowance8"><%= vo.getLblAllowance8() %></td>
			<td class="TitleTd"><%= params.getName("Allowance") %><%= params.getName("No9") %></td>
			<td class="InputTd" id="lblAllowance9"><%= vo.getLblAllowance9() %></td>
			<td class="TitleTd"><%= params.getName("Allowance") %><%= params.getName("No10") %></td>
			<td class="InputTd" id="lblAllowance10"><%= vo.getLblAllowance10() %></td>
		</tr>
	</table>
</div>
<div class="FixList" id="ApprovalUpdate">
	<table class="LeftListTable">
		<tr>
			<th class="<%= vo.getClaAttendance() %>" colspan="6"><span class="TitleTh"><%= params.getName("WorkManage") %><%= params.getName("Information") %><%= params.getName("Approval") %><%= params.getName("Situation") %></span></th>
		</tr>
	
<%
if (vo.getLblAttendanceState().length() > 0) {
%>
		<tr>
			<td class="TitleTd">
<%
if ( params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_ATTENDANCE) ) {
%>
				<label for="txtAttendanceComment"><%=params.getName("Comment")%></label>
<%
} else {
%>
				<%= params.getName("Comment") %>
<%
}
%>
			</td>
			<td class="InputTd" id="tdApprovalComment" colspan="3">
				<%= HtmlUtility.getTextboxTag("Name30TextBox", "txtAttendanceComment", "txtAttendanceComment", vo.getTxtAttendanceComment(), !(params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_ATTENDANCE))) %>
			</td>
			<td class="TitleTd"><%= params.getName("State") %></td>
			<td class="InputTd" id="lblAttendanceState"><%= vo.getLblAttendanceState() %></td>
		</tr>
		<tr>
			<td class="Blank" colspan="4">
			<td class="TitleTd"><%= params.getName("Approver") %></td>
			<td class="InputTd" id="lblAttendanceApprover"><%= vo.getLblAttendanceApprover() %></td>
		</tr>
<%
}
%>
	</table>
	<table class="LeftListTable">
		<tr>
			<th class="<%= vo.getClaOverTime() %>" colspan="6"><span class="TitleTh"><%= params.getName("jp.mosp.time.input.vo.OvertimeRequestVo") %><%= params.getName("Situation") %></span></th>
		</tr>
<%
if (vo.getLblOverTimeType().length() > 0) {
%>
		<tr>
			<td class="TitleTd"><%= params.getName("OvertimeWork") %><%= params.getName("Type") %></td>
			<td class="InputTd" id="lblOverTimeType"><%= vo.getLblOverTimeType() %></td>
			<td class="TitleTd"><%= params.getName("Application") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblOverTimeSchedule"><%= vo.getLblOverTimeSchedule() %></td>
			<td class="TitleTd"><%= params.getName("Performance") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblOverTimeResult"><%= vo.getLblOverTimeResult() %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("OvertimeWork") %><%= params.getName("Reason") %></td>
			<td class="InputTd" id="lblOverTimeReason" colspan="3"><%= vo.getLblOverTimeReason() %></td>
			<td class="TitleTd"><%= params.getName("State") %></td>
			<td class="InputTd" id="lblOverTimeState"><%= vo.getLblOverTimeState() %></td>
		</tr>
		<tr>
			<td class="TitleTd">
<%
if ( params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_OVERTIME) ) {
%>
				<label for="txtOverTimeComment"><%= params.getName("Comment") %></label>
<%
} else {
%>
				<%= params.getName("Comment") %>
<%
}
%>
			</td>
			<td class="InputTd" id="tdApprovalComment" colspan="3">
				<%= HtmlUtility.getTextboxTag("Name30TextBox", "txtOverTimeComment", "txtOverTimeComment", vo.getTxtOverTimeComment(), !(params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_OVERTIME))) %>
			</td>
			<td class="TitleTd"><%= params.getName("Approver") %></td>
			<td class="InputTd" id="lblOverTimeApprover"><%= vo.getLblOverTimeApprover() %></td>
		</tr>
<%
}
%>
	</table>
	<table class="LeftListTable">
		<tr>
			<th class="<%= vo.getClaHoliday() %>" colspan="6"><span class="TitleTh"><%= params.getName("jp.mosp.time.input.vo.HolidayRequestVo") %><%= params.getName("Situation") %></span></th>
		</tr>
<%
if (vo.getLblHolidayType().length() > 0) {
%>
		<tr>
			<td class="TitleTd"><%= params.getName("Vacation") %><%= params.getName("Classification") %></td>
			<td class="InputTd" id="lblHolidayType"><%= vo.getLblHolidayType() %></td>
			<td class="TitleTd"><%= params.getName("Vacation") %><%= params.getName("Content") %></td>
			<td class="InputTd" id="lblHolidayLength"><%= vo.getLblHolidayLength() %></td>
			<td class="TitleTd"><%= params.getName("Vacation") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblHolidayTime"><%= vo.getLblHolidayTime() %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Vacation") %><%= params.getName("Reason") %></td>
			<td class="InputTd" id="lblHolidayReason" colspan="3"><%= vo.getLblHolidayReason() %></td>
			<td class="TitleTd"><%= params.getName("State") %></td>
			<td class="InputTd" id="lblHolidayState"><%= vo.getLblHolidayState() %></td>
		</tr>
		<tr>
			<td class="TitleTd">
<%
if ( params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_HOLIDAY) ) {
%>
				<label for="txtHolidayComment"><%= params.getName("Comment") %></label>
<%
} else {
%>
				<%= params.getName("Comment") %>
<%
}
%>
			</td>
			<td class="InputTd" id="tdApprovalComment" colspan="3">
				<%= HtmlUtility.getTextboxTag("Name30TextBox", "txtHolidayComment", "txtHolidayComment", vo.getTxtHolidayComment(), !(params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_HOLIDAY))) %>
			</td>
			<td class="TitleTd"><%= params.getName("Approver") %></td>
			<td class="InputTd" id="lblHolidayApprover"><%= vo.getLblHolidayApprover() %></td>
	
		</tr>
<%
}
%>
	</table>
	<table class="LeftListTable">
		<tr>
			<th class="<%= vo.getClaWorkOnHoliday() %>" colspan="6"><span class="TitleTh"><%= params.getName("jp.mosp.time.input.vo.WorkOnHolidayRequestVo") %><%= params.getName("Situation") %></span></th>
		</tr>
<%
if (vo.getLblWorkOnHolidayDate().length() > 0) {
%>
		<tr>
			<td class="TitleTd"><%= params.getName("GoingWork") %><%= params.getName("Day") %></td>
			<td class="InputTd" id="lblWorkOnHolidayDate"><%= vo.getLblWorkOnHolidayDate() %></td>
			<td class="TitleTd"><%= params.getName("GoingWork") %><%= params.getName("Schedule") %><%= params.getName("Moment") %></td>
			<td class="InputTd" id="lblWorkOnHolidayTime"><%= vo.getLblWorkOnHolidayTime() %></td>
			<td class="TitleTd"><%= params.getName("Transfer") %><%= params.getName("Day") %></td>
			<td class="InputTd" id="lblSubstituteDate"><%= vo.getLblSubHolidayDate() %></td>
	
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Application") %><%= params.getName("Reason") %></td>
			<td class="InputTd" id="lblWorkOnHolidayReason" colspan="3"><%= vo.getLblWorkOnHolidayReason() %></td>
			<td class="TitleTd"><%= params.getName("State") %></td>
			<td class="InputTd" id="lblWorkOnHolidayState"><%= vo.getLblWorkOnHolidayState() %></td>
		</tr>
		<tr>
			<td class="TitleTd">
<%
if ( params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_WORKONHOLIDAY) ) {
%>
				<label for="txtWorkOnHolidayComment"><%= params.getName("Comment") %></label>
<%
} else {
%>
				<%= params.getName("Comment") %>
<%
}
%>
			</td>
			<td class="InputTd" id="tdApprovalComment" colspan="3">
				<%= HtmlUtility.getTextboxTag("Name30TextBox", "txtWorkOnHolidayComment", "txtWorkOnHolidayComment", vo.getTxtWorkOnHolidayComment(), !(params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_WORKONHOLIDAY))) %>
			</td>
			<td class="TitleTd"><%= params.getName("Approver") %></td>
			<td class="InputTd" id="lblWorkOnHolidayApprover"><%= vo.getLblWorkOnHolidayApprover() %></td>
		</tr>
<%
}
%>
	</table>
	<table class="LeftListTable">
		<tr>
			<th class="<%= vo.getClaSubHoliday() %>" colspan="6"><span class="TitleTh"><%= params.getName("jp.mosp.time.input.vo.SubHolidayRequestVo") %><%= params.getName("Situation") %></span></th>
		</tr>
<%
if (vo.getLblSubHolidayDate().length() > 0) {
%>
		<tr>
			<td class="TitleTd"><%= params.getName("CompensatoryHoliday") %><%= params.getName("Day") %></td>
			<td class="InputTd" id="lblSubHolidayDate"><%= vo.getLblSubHolidayDate() %></td>
			<td class="TitleTd"><%= params.getName("GoingWork") %><%= params.getName("Day") %></td>
			<td class="InputTd" id="lblSubHolidayWorkDate"><%= vo.getLblSubHolidayWorkDate() %></td>
			<td class="TitleTd"><%= params.getName("State") %></td>
			<td class="InputTd" id="lblSubHolidayState"><%= vo.getLblSubHolidayState() %></td>
		</tr>
		<tr>
			<td class="TitleTd">
<%
if ( params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_SUBHOLIDAY) ) {
%>
				<label for="txtCompensationComment"><%= params.getName("Comment") %></label>
<%
} else {
%>
				<%= params.getName("Comment") %>
<%
}
%>
			</td>
			<td class="InputTd" id="tdApprovalComment" colspan="3">
				<%= HtmlUtility.getTextboxTag("Name30TextBox", "txtCompensationComment", "txtCompensationComment", vo.getTxtCompensationComment(), !(params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_SUBHOLIDAY))) %>
			</td>
			<td class="TitleTd"><%= params.getName("Approver") %></td>
			<td class="InputTd" id="lblSubHolidayApprover"><%= vo.getLblSubHolidayApprover() %></td>
		</tr>
<%
}
%>
	</table>
	<table class="LeftListTable">
		<tr>
			<th class="<%= vo.getClaDifference() %>" colspan="6"><span class="TitleTh"><%= params.getName("jp.mosp.time.input.vo.DifferenceRequestVo") %><%= params.getName("Situation") %></span></th>
		</tr>
<%
if (vo.getLblDifferenceDate().length() > 0) {
%>
		<tr>
			<td class="TitleTd"><%= params.getName("GoingWork") %><%= params.getName("Day") %></td>
			<td class="InputTd" id="lblDifferenceDate"><%= vo.getLblDifferenceDate() %></td>
			<td class="TitleTd"><%= params.getName("Application") %><%= params.getName("Ahead") %><%= params.getName("Work") %><%= params.getName("Form") %></td>
			<td class="InputTd" id="lblDifferenceWorkType"><%= vo.getLblDifferenceWorkType() %></td>
			<td class="TitleTd"><%= params.getName("Application") %><%= params.getName("Later") %><%= params.getName("Work") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblDifferenceWorkTime"><%= vo.getLblDifferenceWorkTime() %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Application") %><%= params.getName("Reason") %></td>
			<td class="InputTd" id="lblDifferenceReason" colspan="3"><%= vo.getLblDifferenceReason() %></td>
			<td class="TitleTd"><%= params.getName("State") %></td>
			<td class="InputTd" id="lblDifferenceState"><%= vo.getLblDifferenceState() %></td>
		</tr>
		<tr>
			<td class="TitleTd">
<%
if ( params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_DIFFERENCE) ) {
%>
				<label for="txtDifferenceComment"><%= params.getName("Comment") %></label>
<%
} else {
%>
				<%= params.getName("Comment") %>
<%
}
%>
			</td>
			<td class="InputTd" id="tdApprovalComment" colspan="3">
				<%= HtmlUtility.getTextboxTag("Name30TextBox", "txtDifferenceComment", "txtDifferenceComment", vo.getTxtDifferenceComment(), !(params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_DIFFERENCE))) %>
			</td>
			<td class="TitleTd"><%= params.getName("Approver") %></td>
			<td class="InputTd" id="lblDifferenceApprover"><%= vo.getLblDifferenceApprover() %></td>
		</tr>
<%
}
%>
	</table>
</div>
<div class="Button">
<% if( params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_CONFIRMATION_ATTENDANCE) ||
		params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_CONFIRMATION_OVERTIME) ||
		params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_CONFIRMATION_HOLIDAY) ||
		params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_CONFIRMATION_WORKONHOLIDAY) ||
		params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_CONFIRMATION_SUBHOLIDAY) ||
		params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_CONFIRMATION_DIFFERENCE) ) { %>
	<button type="button" id="btnDelete" class="Name4Button" onclick="submitDelete(event, null, null, '<%= ApprovalCardAction.CMD_DELETE %>');""><%= params.getName("Approval") %><%= params.getName("Release") %></button>
<% } else if( params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_ATTENDANCE) ||
		params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_OVERTIME) ||
		params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_HOLIDAY) ||
		params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_WORKONHOLIDAY) ||
		params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_SUBHOLIDAY) ||
		params.getCommand().equals(ApprovalCardAction.CMD_APPROVAL_DIFFERENCE) ) { %>
	<button type="button" class="Name4Button" onclick="submitRegist(event, 'ApprovalUpdate', null, '<%= ApprovalCardAction.CMD_APPROVAL %>');""><%= params.getName("Approval") %></button>
	<button type="button" class="Name4Button" onclick="submitRegist(event, 'ApprovalUpdate', checkRevert, '<%= ApprovalCardAction.CMD_REVERTING %>');""><%= params.getName("SendingBack") %></button>
<%
}
%>
</div>
