/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 時差出勤変更確認メッセージ。
 */
var MSG_FLEXTIME_CHANGE_CHECK	= "TMW0220";

/**
 * 画面読込時追加処理
 * @param 無し
 * @return 無し
 * @throws 実行時例外
 */
function onLoadExtra() {
	setOnChangeHandler("pltEditDifferenceType", checkEditDifferenceType);
	checkEditDifferenceType();
	setOnChangeHandler("pltEditRequestHour", checkEditRequestTime);
	setOnChangeHandler("pltEditRequestMinute", checkEditRequestTime);
	checkEditRequestTime();
	setOnClickHandler("ckbEndDate", checkCkbEndDate);
	checkCkbEndDate();
	setDisabled("lblEndTimeHour", true);
	setDisabled("lblEndTimeMinutes", true);
	// 未申請
	if (jsStatusApplication == "Unclaimed"){
		setDisabled("btnDelete", true);
	}
	// 未承認
	if (jsStatusApplication == "Unauthorized"){
		setDisabled("btnRegist", true);
		setDisabled("btnDraft", true);
		setDisabled("btnDelete", true);
	}
	
	if (jsEditActivateDateMode == "fixed"){
		setDisabled("pltEditRequestYear", true);
		setDisabled("pltEditRequestMonth", true);
		setDisabled("pltEditRequestDay", true);
		setDisabled("pltEditDifferenceType", false);
	} else {
		setDisabled("pltEditDifferenceType", true);
		setDisabled("btnRegist", true);
		setDisabled("btnDraft", true);
		setDisabled("ckbEndDate", true);
	}
	
	if (jsSearchActivateDateMode == "fixed"){
		setDisabled("pltSearchRequestYear", true);
		setDisabled("pltSearchRequestMonth", true);
		setDisabled("pltSearchWorkType", false);
		setDisabled("btnSearch", false);
	} else {
		setDisabled("pltSearchRequestYear", false);
		setDisabled("pltSearchRequestMonth", false);
		setDisabled("pltSearchWorkType", true);
		setDisabled("btnSearch", true);
	}
}

/**
 * 時差出勤区分のチェック処理
 * @param 無し
 * @return 無し
 */
function checkEditDifferenceType() {
	var differenceType = getFormValue("pltEditDifferenceType");
	if(differenceType == "a") {
		setDisabled("pltEditStartDate", true);
		setDisabled("pltEditRequestHour", true);
		setDisabled("pltEditRequestMinute", true);
		setDisabled("ckbEndDate", false);
	} else if(differenceType == "b") {
		setDisabled("pltEditStartDate", true);
		setDisabled("pltEditRequestHour", true);
		setDisabled("pltEditRequestMinute", true);
		setDisabled("ckbEndDate", false);
	} else if(differenceType == "c") {
		setDisabled("pltEditStartDate", true);
		setDisabled("pltEditRequestHour", true);
		setDisabled("pltEditRequestMinute", true);
		setDisabled("ckbEndDate", false);
	} else if(differenceType == "d") {
		setDisabled("pltEditStartDate", true);
		setDisabled("pltEditRequestHour", true);
		setDisabled("pltEditRequestMinute", true);
		setDisabled("ckbEndDate", false);
	} else if(differenceType == "s") {
		if(jsEditDifferenceTypeMode != "fixed"){
			// 更新系確認メッセージ
			if (confirm(getMessage(MSG_FLEXTIME_CHANGE_CHECK, null))) {
				setDisabled("pltEditStartDate", false);
				setDisabled("pltEditRequestHour", false);
				setDisabled("pltEditRequestMinute", false);
				setDisabled("ckbEndDate", true);
				setDisabled("pltEditEndYear", true);
				setDisabled("pltEditEndMonth", true);
				setDisabled("pltEditEndDay", true);
			} else {
				setFormValue("pltEditDifferenceType", "a")
				checkEditDifferenceType();
			}
		} else {
			setDisabled("ckbEndDate", true);
			setDisabled("pltEditEndYear", true);
			setDisabled("pltEditEndMonth", true);
			setDisabled("pltEditEndDay", true);
		}
	}
	doSubmit(document.form, "TM1006");
}

/**
 * 時差出勤開始時刻のチェック処理
 * @param 無し
 * @return 無し
 */
function checkEditRequestTime() {
	doSubmit(document.form, "TM1006");
}

/**
 * 終了日指定チェックボックスのチェック処理
 * @param 無し
 * @return 無し
 */
function checkCkbEndDate() {
	if (isCheckableChecked("ckbEndDate")) {
		setDisabled("pltEditEndYear", false);
		setDisabled("pltEditEndMonth", false);
		setDisabled("pltEditEndDay", false);
		setDisabled("btnDraft", true);
	} else {
		setDisabled("pltEditEndYear", true);
		setDisabled("pltEditEndMonth", true);
		setDisabled("pltEditEndDay", true);
		setDisabled("btnDraft", false);
	}
}

/**
 * 追加チェックを行う。<br>
 * @param aryMessage エラーメッセージ格納配列
 * @param event イベント
 * @return 無し
 */
function checkExtra(aryMessage, event) {
	// チェックボックス必須確認
	checkBoxRequired("ckbSelect", aryMessage);
}

/**
 * 追加チェックを行う。<br>
 * @param aryMessage エラーメッセージ格納配列
 * @param event イベント
 * @return 無し
 */
function checkDateExtra(aryMessage, event) {
	checkDate("pltEditRequestYear", "pltEditRequestMonth", "pltEditRequestDay", aryMessage); 
}
/**
 * 追加チェックを行う。<br>
 * @param aryMessage エラーメッセージ格納配列
 * @param event イベント
 * @return 無し
 */
function checkEndDateExtra(aryMessage, event) {
	checkDate("pltEditRequestYear", "pltEditRequestMonth", "pltEditRequestDay", aryMessage); 
}
