/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.platform.bean.workflow;

import java.util.List;

import jp.mosp.framework.base.MospException;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;

/**
 * ワークフロー参照インターフェース。
 */
public interface WorkflowReferenceBeanInterface {
	
	/**
	 * 最新のワークフロー取得。
	 * <p>
	 * ワークフロー番号から最新のワークフローを取得。
	 * </p>
	 * @param workflow ワークフロー番号
	 * @return ワークフローデータ
	 * @throws MospException インスタンスの取得或いはSQL実行に失敗した場合
	 */
	WorkflowDtoInterface getLatestWorkflowInfo(long workflow) throws MospException;
	
	/**
	 * 機能コードと承認者個人IDからワークフロー情報一覧を取得する。<br>
	 * @param functionCode 機能コード
	 * @param approverId 承認者個人ID
	 * @return ワークフローリスト
	 * @throws MospException SQLの作成に失敗した場合、或いはSQL例外が発生した場合
	 */
	List<WorkflowDtoInterface> getListForApproverId(String functionCode, String approverId) throws MospException;
	
	/**
	 * 段階、状況、ルートコード、機能コードからワークフロー情報一覧を取得する。<br>
	 * @param workflowStage 段階
	 * @param workflowStatus 状況
	 * @param routeCode ルートコード
	 * @param functionCode 機能コード
	 * @return ワークフローリスト
	 * @throws MospException SQLの作成に失敗した場合、或いはSQL例外が発生した場合
	 */
	List<WorkflowDtoInterface> getListForRoute(int workflowStage, String workflowStatus, String routeCode,
			String functionCode) throws MospException;
	
	/**
	 * 状況、ルートコード、機能コードからワークフロー情報一覧を取得する。<br>
	 * @param workflowStatus 状況
	 * @param routeCode ルートコード
	 * @param functionCode 機能コード
	 * @return ワークフローリスト
	 * @throws MospException SQLの作成に失敗した場合、或いはSQL例外が発生した場合
	 */
	List<WorkflowDtoInterface> getListForRoute(String workflowStatus, String routeCode, String functionCode)
			throws MospException;
	
	/**
	 * ワークフローデータを取得する。
	 * @param id レコード識別ID
	 * @return ワークフローデータ
	 * @throws MospException SQLの作成に失敗した場合、或いはSQL例外が発生した場合
	 */
	WorkflowDtoInterface findForId(long id) throws MospException;
	
}
