/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.entity;

import java.util.Date;
import java.util.List;

import jp.mosp.platform.dto.human.ConcurrentDtoInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.dto.human.SuspensionDtoInterface;
import jp.mosp.platform.dto.system.EmploymentContractDtoInterface;
import jp.mosp.platform.dto.system.PositionDtoInterface;
import jp.mosp.platform.dto.system.SectionDtoInterface;

/**
 * 社員情報クラス
 */
public class EmployeeEntity implements EmployeeEntityInterface {
	
	/**
	 * 有効日
	 */
	private Date							activateDate;
	/**
	 * 個人ID
	 */
	private String							personalId;
	/**
	 * 社員コード
	 */
	private String							employeeCode;
	/**
	 * 休退職区分
	 */
	private String							stateType;
	/**
	 * 休退職区分名称
	 */
	private String							stateName;
	/**
	 * 人事マスタ
	 */
	private HumanDtoInterface				humanDto;
	/**
	 * 所属マスタ
	 */
	private SectionDtoInterface				sectionDto;
	/**
	 * 職位マスタ
	 */
	private PositionDtoInterface			positionDto;
	/**
	 * 雇用契約マスタ
	 */
	private EmploymentContractDtoInterface	employmentContractDto;
	/**
	 * 人事入社情報
	 */
	private EntranceDtoInterface			entranceDto;
	/**
	 * 人事休職情報
	 */
	private SuspensionDtoInterface			suspensionDto;
	/**
	 * 人事退職情報
	 */
	private RetirementDtoInterface			retirementDto;
	/**
	 * 人事兼務情報
	 */
	private List<ConcurrentDtoInterface>	concurrentList;
	

	/**
	 * コンストラクタ
	 */
	public EmployeeEntity() {
		// 処理無し
	}
	
	public Date getActivateDate() {
		return activateDate == null ? null : (Date)activateDate.clone();
	}
	
	public String getPersonalId() {
		return personalId;
	}
	
	public String getEmployeeCode() {
		return employeeCode;
	}
	
	public String getStateType() {
		return stateType;
	}
	
	public String getStateName() {
		return stateName;
	}
	
	public HumanDtoInterface getHumanDto() {
		return humanDto;
	}
	
	public SectionDtoInterface getSectionDto() {
		return sectionDto;
	}
	
	public PositionDtoInterface getPositionDto() {
		return positionDto;
	}
	
	public EmploymentContractDtoInterface getEmploymentContractDto() {
		return employmentContractDto;
	}
	
	public EntranceDtoInterface getEntranceDto() {
		return entranceDto;
	}
	
	public SuspensionDtoInterface getSuspensionDto() {
		return suspensionDto;
	}
	
	public RetirementDtoInterface getRetirementDto() {
		return retirementDto;
	}
	
	public List<ConcurrentDtoInterface> getConcurrentList() {
		return concurrentList;
	}
	
	public void setActivateDate(Date activateDate) {
		this.activateDate = activateDate == null ? null : (Date)activateDate.clone();
	}
	
	public void setPersonalId(String personalId) {
		this.personalId = personalId;
	}
	
	public void setEmployeeCode(String employeeCode) {
		this.employeeCode = employeeCode;
	}
	
	public void setStateType(String stateType) {
		this.stateType = stateType;
	}
	
	public void setStateName(String stateName) {
		this.stateName = stateName;
	}
	
	public void setHumanDto(HumanDtoInterface humanDto) {
		this.humanDto = humanDto;
	}
	
	public void setSectionDto(SectionDtoInterface sectionDto) {
		this.sectionDto = sectionDto;
	}
	
	public void setPositionDto(PositionDtoInterface positionDto) {
		this.positionDto = positionDto;
	}
	
	public void setEmploymentContractDto(EmploymentContractDtoInterface employmentContractDto) {
		this.employmentContractDto = employmentContractDto;
	}
	
	public void setEntranceDto(EntranceDtoInterface entranceDto) {
		this.entranceDto = entranceDto;
	}
	
	public void setSuspensionDto(SuspensionDtoInterface suspensionDto) {
		this.suspensionDto = suspensionDto;
	}
	
	public void setRetirementDto(RetirementDtoInterface retirementDto) {
		this.retirementDto = retirementDto;
	}
	
	public void setConcurrentList(List<ConcurrentDtoInterface> concurrentList) {
		this.concurrentList = concurrentList;
	}
	
}
