/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.base;

import java.util.Date;

import jp.mosp.platform.base.PlatformVo;

/**
 * MosP勤怠管理におけるVOの基本となる情報を格納する。<br>
 */
public abstract class TimeVo extends PlatformVo {
	
	private static final long	serialVersionUID	= -296203972754983338L;
	
	/**
	 * 勤怠管理共通情報個人ID。<br>
	 */
	private String				personalId;
	
	/**
	 * 勤怠管理共通情報対象日。<br>
	 */
	private Date				targetDate;
	
	/**
	 * 勤怠管理共通情報社員コード。<br>
	 */
	private String				lblEmployeeCode;
	
	/**
	 * 勤怠管理共通情報社員名。<br>
	 */
	private String				lblEmployeeFirstName;
	
	/**
	 * 勤怠管理共通情報社員名。<br>
	 */
	private String				lblEmployeeLastName;
	
	/**
	 * 勤怠管理共通情報社員名。<br>
	 */
	private String				lblEmployeeName;
	
	/**
	 * 勤怠管理共通情報所属。<br>
	 */
	private String				lblSectionName;
	
	/**
	 * 勤怠管理共通情報検索有効年。<br>
	 */
	private String				txtSearchActivateYear;
	
	/**
	 * 勤怠管理共通情報検索有効月。<br>
	 */
	private String				txtSearchActivateMonth;
	
	/**
	 * 勤怠管理共通情報検索有効日。<br>
	 */
	private String				txtSearchActivateDay;
	
	/**
	 * 勤怠管理共通情報有効日。<br>
	 */
	private String				txtActivateYear;
	
	/**
	 * 勤怠管理共通情報有効日。<br>
	 */
	private String				txtActivateMonth;
	
	/**
	 * 勤怠管理共通情報有効日。<br>
	 */
	private String				txtActivateDay;
	
	/**
	 * 勤怠管理共通情報検索社員コード。<br>
	 */
	private String				txtSearchEmployeeCode;
	
	/**
	 * 勤怠管理共通情報編集有効年。<br>
	 */
	private String				txtEditActivateYear;
	
	/**
	 * 勤怠管理共通情報編集有効月。<br>
	 */
	private String				txtEditActivateMonth;
	
	/**
	 * 勤怠管理共通情報編集有効日。<br>
	 */
	private String				txtEditActivateDay;
	
	/**
	 * 勤怠管理共通情報更新有効年。<br>
	 */
	private String				txtUpdateActivateYear;
	
	/**
	 * 勤怠管理共通情報更新有効月。<br>
	 */
	private String				txtUpdateActivateMonth;
	
	/**
	 * 勤怠管理共通情報更新有効日。<br>
	 */
	private String				txtUpdateActivateDay;
	
	/**
	 * 勤怠管理共通情報更新有効日。<br>
	 */
	private String				jsStatusApplication;
	
	/**
	 * 勤怠管理共通承認者プルダウン。<br>
	 */
	private String[][][]		aryApproverInfo;
	
	/**
	 * 勤怠管理共通承認ラベル。<br>
	 */
	private String[]			aryPltLblApproverSetting;
	
	/**
	 * 勤怠管理共通承認プルダウン設定。<br>
	 */
	private String[]			aryPltApproverSetting;
	
	/**
	 * 勤怠管理共通承認者用クラス名。<br>
	 */
	private String[]			pltApproverSetting;
	
	/**
	 * 勤怠管理共通承認者用保存領域1。<br>
	 */
	private String				pltApproverSetting1;
	
	/**
	 * 勤怠管理共通承認者用保存領域2。<br>
	 */
	private String				pltApproverSetting2;
	
	/**
	 * 勤怠管理共通承認者用保存領域3。<br>
	 */
	private String				pltApproverSetting3;
	
	/**
	 * 勤怠管理共通承認者用保存領域4。<br>
	 */
	private String				pltApproverSetting4;
	
	/**
	 * 勤怠管理共通承認者用保存領域5。<br>
	 */
	private String				pltApproverSetting5;
	
	/**
	 * 勤怠管理共通承認者用保存領域6。<br>
	 */
	private String				pltApproverSetting6;
	
	/**
	 * 勤怠管理共通承認者用保存領域7。<br>
	 */
	private String				pltApproverSetting7;
	
	/**
	 * 勤怠管理共通承認者用保存領域8。<br>
	 */
	private String				pltApproverSetting8;
	
	/**
	 * 勤怠管理共通承認者用保存領域9。<br>
	 */
	private String				pltApproverSetting9;
	
	/**
	 * 勤怠管理共通承認者用保存領域10。<br>
	 */
	private String				pltApproverSetting10;
	
	/**
	 * 勤怠管理共通時差出勤有無領域1。<br>
	 */
	private String				jsModeDifferenceRequest1;
	
	/**
	 * 勤怠管理共通時差出勤有無領域2。<br>
	 */
	private String				jsModeDifferenceRequest2;
	
	/**
	 * 勤怠管理共通時差出勤日1。<br>
	 */
	private String				jsModeRequestDate1;
	
	/**
	 * 勤怠管理共通時差出勤日2。<br>
	 */
	private String				jsModeRequestDate2;
	

	/**
	 * VOの初期設定を行う。<br>
	 * <br>
	 */
	public TimeVo() {
		// 処理無し
	}
	
	/**
	 * @return personalId
	 */
	public String getPersonalId() {
		return personalId;
	}
	
	/**
	 * @param personalId セットする personalId
	 */
	public void setPersonalId(String personalId) {
		this.personalId = personalId;
	}
	
	/**
	 * @return targetDate
	 */
	public Date getTargetDate() {
		return getDateClone(targetDate);
	}
	
	/**
	 * @param targetDate セットする targetDate
	 */
	public void setTargetDate(Date targetDate) {
		this.targetDate = getDateClone(targetDate);
	}
	
	/**
	 * @return lblEmployeeCode
	 */
	public String getLblEmployeeCode() {
		return lblEmployeeCode;
	}
	
	/**
	 * @return lblEmployeeFirstName
	 */
	public String getLblEmployeeFirstName() {
		return lblEmployeeFirstName;
	}
	
	/**
	 * @return lblEmployeeLastName
	 */
	public String getLblEmployeeLastName() {
		return lblEmployeeLastName;
	}
	
	/**
	 * @return lblSectionName
	 */
	public String getLblSectionName() {
		return lblSectionName;
	}
	
	/**
	 * @param lblEmployeeCode セットする lblEmployeeCode
	 */
	public void setLblEmployeeCode(String lblEmployeeCode) {
		this.lblEmployeeCode = lblEmployeeCode;
	}
	
	/**
	 * @param lblEmployeeFirstName セットする lblEmployeeFirstName
	 */
	public void setLblEmployeeFirstName(String lblEmployeeFirstName) {
		this.lblEmployeeFirstName = lblEmployeeFirstName;
	}
	
	/**
	 * @param lblEmployeeLastName セットする lblEmployeeLastName
	 */
	public void setLblEmployeeLastName(String lblEmployeeLastName) {
		this.lblEmployeeLastName = lblEmployeeLastName;
	}
	
	/**
	 * @param lblSectionName セットする lblSectionName
	 */
	public void setLblSectionName(String lblSectionName) {
		this.lblSectionName = lblSectionName;
	}
	
	/**
	 * @return txtSearchActivateYear
	 */
	public String getTxtSearchActivateYear() {
		return txtSearchActivateYear;
	}
	
	/**
	 * @return txtSearchActivateMonth
	 */
	public String getTxtSearchActivateMonth() {
		return txtSearchActivateMonth;
	}
	
	/**
	 * @return txtSearchActivateDay
	 */
	public String getTxtSearchActivateDay() {
		return txtSearchActivateDay;
	}
	
	/**
	 * @return txtSearchEmployeeCode
	 */
	public String getTxtSearchEmployeeCode() {
		return txtSearchEmployeeCode;
	}
	
	/**
	 * @param txtSearchActivateYear セットする txtSearchActivateYear
	 */
	public void setTxtSearchActivateYear(String txtSearchActivateYear) {
		this.txtSearchActivateYear = txtSearchActivateYear;
	}
	
	/**
	 * @param txtSearchActivateMonth セットする txtSearchActivateMonth
	 */
	public void setTxtSearchActivateMonth(String txtSearchActivateMonth) {
		this.txtSearchActivateMonth = txtSearchActivateMonth;
	}
	
	/**
	 * @param txtSearchActivateDay セットする txtSearchActivateDay
	 */
	public void setTxtSearchActivateDay(String txtSearchActivateDay) {
		this.txtSearchActivateDay = txtSearchActivateDay;
	}
	
	/**
	 * @param txtSearchEmployeeCode セットする txtSearchEmployeeCode
	 */
	public void setTxtSearchEmployeeCode(String txtSearchEmployeeCode) {
		this.txtSearchEmployeeCode = txtSearchEmployeeCode;
	}
	
	/**
	 * @return lblEmployeeName
	 */
	public String getLblEmployeeName() {
		return lblEmployeeName;
	}
	
	/**
	 * @param lblEmployeeName セットする lblEmployeeName
	 */
	public void setLblEmployeeName(String lblEmployeeName) {
		this.lblEmployeeName = lblEmployeeName;
	}
	
	/**
	 * @return txtEditActivateYear
	 */
	public String getTxtEditActivateYear() {
		return txtEditActivateYear;
	}
	
	/**
	 * @return txtEditActivateMonth
	 */
	public String getTxtEditActivateMonth() {
		return txtEditActivateMonth;
	}
	
	/**
	 * @return txtEditActivateDay
	 */
	public String getTxtEditActivateDay() {
		return txtEditActivateDay;
	}
	
	/**
	 * @return txtUpdateActivateYear
	 */
	public String getTxtUpdateActivateYear() {
		return txtUpdateActivateYear;
	}
	
	/**
	 * @return txtUpdateActivateMonth
	 */
	public String getTxtUpdateActivateMonth() {
		return txtUpdateActivateMonth;
	}
	
	/**
	 * @return txtUpdateActivateDay
	 */
	public String getTxtUpdateActivateDay() {
		return txtUpdateActivateDay;
	}
	
	/**
	 * @param txtEditActivateYear セットする txtEditActivateYear
	 */
	public void setTxtEditActivateYear(String txtEditActivateYear) {
		this.txtEditActivateYear = txtEditActivateYear;
	}
	
	/**
	 * @param txtEditActivateMonth セットする txtEditActivateMonth
	 */
	public void setTxtEditActivateMonth(String txtEditActivateMonth) {
		this.txtEditActivateMonth = txtEditActivateMonth;
	}
	
	/**
	 * @param txtEditActivateDay セットする txtEditActivateDay
	 */
	public void setTxtEditActivateDay(String txtEditActivateDay) {
		this.txtEditActivateDay = txtEditActivateDay;
	}
	
	/**
	 * @param txtUpdateActivateYear セットする txtUpdateActivateYear
	 */
	public void setTxtUpdateActivateYear(String txtUpdateActivateYear) {
		this.txtUpdateActivateYear = txtUpdateActivateYear;
	}
	
	/**
	 * @param txtUpdateActivateMonth セットする txtUpdateActivateMonth
	 */
	public void setTxtUpdateActivateMonth(String txtUpdateActivateMonth) {
		this.txtUpdateActivateMonth = txtUpdateActivateMonth;
	}
	
	/**
	 * @param txtUpdateActivateDay セットする txtUpdateActivateDay
	 */
	public void setTxtUpdateActivateDay(String txtUpdateActivateDay) {
		this.txtUpdateActivateDay = txtUpdateActivateDay;
	}
	
	/**
	 * @return txtActivateYear
	 */
	public String getTxtActivateYear() {
		return txtActivateYear;
	}
	
	/**
	 * @return txtActivateMonth
	 */
	public String getTxtActivateMonth() {
		return txtActivateMonth;
	}
	
	/**
	 * @return txtActivateDay
	 */
	public String getTxtActivateDay() {
		return txtActivateDay;
	}
	
	/**
	 * @param txtActivateYear セットする txtActivateYear
	 */
	public void setTxtActivateYear(String txtActivateYear) {
		this.txtActivateYear = txtActivateYear;
	}
	
	/**
	 * @param txtActivateMonth セットする txtActivateMonth
	 */
	public void setTxtActivateMonth(String txtActivateMonth) {
		this.txtActivateMonth = txtActivateMonth;
	}
	
	/**
	 * @param txtActivateDay セットする txtActivateDay
	 */
	public void setTxtActivateDay(String txtActivateDay) {
		this.txtActivateDay = txtActivateDay;
	}
	
	/**
	 * @return jsStatusApplication
	 */
	public String getJsStatusApplication() {
		return jsStatusApplication;
	}
	
	/**
	 * @param jsStatusApplication セットする jsStatusApplication
	 */
	public void setJsStatusApplication(String jsStatusApplication) {
		this.jsStatusApplication = jsStatusApplication;
	}
	
	/**
	 * @return aryAryPltApproverSetting
	 */
	public String[][][] getAryApproverInfo() {
		return aryApproverInfo;
	}
	
	/**
	 * @param aryApproverInfo セットする aryApproverInfo
	 */
	public void setAryApproverInfo(String[][][] aryApproverInfo) {
		this.aryApproverInfo = aryApproverInfo;
	}
	
	/**
	 * @return aryPltLblApproverSetting
	 */
	public String[] getAryPltLblApproverSetting() {
		return getStringArrayClone(aryPltLblApproverSetting);
	}
	
	/**
	 * @param aryPltLblApproverSetting セットする aryPltLblApproverSetting
	 */
	public void setAryPltLblApproverSetting(String[] aryPltLblApproverSetting) {
		this.aryPltLblApproverSetting = getStringArrayClone(aryPltLblApproverSetting);
	}
	
	/**
	 * @return aryPltApproverSetting
	 */
	public String[] getAryPltApproverSetting() {
		return getStringArrayClone(aryPltApproverSetting);
	}
	
	/**
	 * @param aryPltApproverSetting セットする aryPltApproverSetting
	 */
	public void setAryPltApproverSetting(String[] aryPltApproverSetting) {
		this.aryPltApproverSetting = getStringArrayClone(aryPltApproverSetting);
	}
	
	/**
	 * @return pltApproverSetting
	 */
	public String[] getPltApproverSetting() {
		return getStringArrayClone(pltApproverSetting);
	}
	
	/**
	 * @param pltApproverSetting セットする pltApproverSetting
	 */
	public void setPltApproverSetting(String[] pltApproverSetting) {
		this.pltApproverSetting = getStringArrayClone(pltApproverSetting);
	}
	
	/**
	 * @return pltApproverSetting1
	 */
	public String getPltApproverSetting1() {
		return pltApproverSetting1;
	}
	
	/**
	 * @param pltApproverSetting1 セットする pltApproverSetting1
	 */
	public void setPltApproverSetting1(String pltApproverSetting1) {
		this.pltApproverSetting1 = pltApproverSetting1;
	}
	
	/**
	 * @return pltApproverSetting2
	 */
	public String getPltApproverSetting2() {
		return pltApproverSetting2;
	}
	
	/**
	 * @param pltApproverSetting2 セットする pltApproverSetting2
	 */
	public void setPltApproverSetting2(String pltApproverSetting2) {
		this.pltApproverSetting2 = pltApproverSetting2;
	}
	
	/**
	 * @return pltApproverSetting3
	 */
	public String getPltApproverSetting3() {
		return pltApproverSetting3;
	}
	
	/**
	 * @param pltApproverSetting3 セットする pltApproverSetting3
	 */
	public void setPltApproverSetting3(String pltApproverSetting3) {
		this.pltApproverSetting3 = pltApproverSetting3;
	}
	
	/**
	 * @return pltApproverSetting4
	 */
	public String getPltApproverSetting4() {
		return pltApproverSetting4;
	}
	
	/**
	 * @param pltApproverSetting4 セットする pltApproverSetting4
	 */
	public void setPltApproverSetting4(String pltApproverSetting4) {
		this.pltApproverSetting4 = pltApproverSetting4;
	}
	
	/**
	 * @return pltApproverSetting5
	 */
	public String getPltApproverSetting5() {
		return pltApproverSetting5;
	}
	
	/**
	 * @param pltApproverSetting5 セットする pltApproverSetting5
	 */
	public void setPltApproverSetting5(String pltApproverSetting5) {
		this.pltApproverSetting5 = pltApproverSetting5;
	}
	
	/**
	 * @return pltApproverSetting6
	 */
	public String getPltApproverSetting6() {
		return pltApproverSetting6;
	}
	
	/**
	 * @param pltApproverSetting6 セットする pltApproverSetting6
	 */
	public void setPltApproverSetting6(String pltApproverSetting6) {
		this.pltApproverSetting6 = pltApproverSetting6;
	}
	
	/**
	 * @return pltApproverSetting7
	 */
	public String getPltApproverSetting7() {
		return pltApproverSetting7;
	}
	
	/**
	 * @param pltApproverSetting7 セットする pltApproverSetting7
	 */
	public void setPltApproverSetting7(String pltApproverSetting7) {
		this.pltApproverSetting7 = pltApproverSetting7;
	}
	
	/**
	 * @return pltApproverSetting8
	 */
	public String getPltApproverSetting8() {
		return pltApproverSetting8;
	}
	
	/**
	 * @param pltApproverSetting8 セットする pltApproverSetting8
	 */
	public void setPltApproverSetting8(String pltApproverSetting8) {
		this.pltApproverSetting8 = pltApproverSetting8;
	}
	
	/**
	 * @return pltApproverSetting9
	 */
	public String getPltApproverSetting9() {
		return pltApproverSetting9;
	}
	
	/**
	 * @param pltApproverSetting9 セットする pltApproverSetting9
	 */
	public void setPltApproverSetting9(String pltApproverSetting9) {
		this.pltApproverSetting9 = pltApproverSetting9;
	}
	
	/**
	 * @return pltApproverSetting10
	 */
	public String getPltApproverSetting10() {
		return pltApproverSetting10;
	}
	
	/**
	 * @param pltApproverSetting10 セットする pltApproverSetting10
	 */
	public void setPltApproverSetting10(String pltApproverSetting10) {
		this.pltApproverSetting10 = pltApproverSetting10;
	}
	
	/**
	 * @return jsModeDifferenceRequest1
	 */
	public String getJsModeDifferenceRequest1() {
		return jsModeDifferenceRequest1;
	}
	
	/**
	 * @param jsModeDifferenceRequest1 セットする jsModeDifferenceRequest1
	 */
	public void setJsModeDifferenceRequest1(String jsModeDifferenceRequest1) {
		this.jsModeDifferenceRequest1 = jsModeDifferenceRequest1;
	}
	
	/**
	 * @return jsModeDifferenceRequest2
	 */
	public String getJsModeDifferenceRequest2() {
		return jsModeDifferenceRequest2;
	}
	
	/**
	 * @param jsModeDifferenceRequest2 セットする jsModeDifferenceRequest2
	 */
	public void setJsModeDifferenceRequest2(String jsModeDifferenceRequest2) {
		this.jsModeDifferenceRequest2 = jsModeDifferenceRequest2;
	}
	
	/**
	 * @return jsModeRequestDate1
	 */
	public String getJsModeRequestDate1() {
		return jsModeRequestDate1;
	}
	
	/**
	 * @param jsModeRequestDate1 セットする jsModeRequestDate1
	 */
	public void setJsModeRequestDate1(String jsModeRequestDate1) {
		this.jsModeRequestDate1 = jsModeRequestDate1;
	}
	
	/**
	 * @return jsModeRequestDate2
	 */
	public String getJsModeRequestDate2() {
		return jsModeRequestDate2;
	}
	
	/**
	 * @param jsModeRequestDate2 セットする jsModeRequestDate2
	 */
	public void setJsModeRequestDate2(String jsModeRequestDate2) {
		this.jsModeRequestDate2 = jsModeRequestDate2;
	}
	
}
