/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.bean;

import java.util.List;

import jp.mosp.framework.base.MospException;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.dto.settings.SubordinateListDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;

/**
 * 部下一覧検索インターフェース。
 */
public interface SubordinateSearchBeanInterface extends HumanSearchBeanInterface {
	
	/**
	 * 検索条件から部下リストを取得する。<br><br>
	 * 設定された条件で、検索を行う。
	 * @return 部下リスト
	 * @throws MospException インスタンスの取得、SQLの作成及び実行に失敗した場合
	 */
	List<SubordinateListDtoInterface> getSubordinateList() throws MospException;
	
	/**
	 * 検索条件から承認対象社員リストを取得する。<br><br>
	 * 設定された条件で、検索を行う。
	 * @return 承認対象社員リスト
	 * @throws MospException インスタンスの取得、SQLの作成及び実行に失敗した場合
	 */
	List<SubordinateListDtoInterface> getApprovableList() throws MospException;
	
	/**
	 * 部下一覧情報DTOを取得する。<br><br>
	 * @param humanDto 人事情報DTO
	 * @param totalTimeDataDto 勤怠集計情報DTO
	 * @param year 年
	 * @param month 月
	 * @return 部下一覧情報DTO
	 * @throws MospException インスタンスの取得或いはSQL実行に失敗した場合
	 */
	SubordinateListDtoInterface getSubordinateListDto(HumanDtoInterface humanDto,
			TotalTimeDataDtoInterface totalTimeDataDto, int year, int month) throws MospException;
	
	/**
	 * @param approval セットする 未承認。
	 */
	void setApproval(String approval);
	
	/**
	 * @param calc セットする 締状態。
	 */
	void setCalc(String calc);
	
}
