package jp.mosp.time.bean;

import jp.mosp.framework.base.MospException;

/**
 * 打刻クラスインターフェース。
 */
public interface TimeRecordBeanInterface {
	
	/**
	 * 始業を打刻する。<br>
	 * システム日付で、打刻する。<br>
	 * <br>
	 * 打刻した日の勤怠情報として、登録する。<br>
	 * 打刻した日の勤怠情報が既に存在する場合は、打刻しない。<br>
	 * <br>
	 * 打刻した勤怠情報は、下書き状態になる。<br>
	 * @throws MospException インスタンスの取得及びSQL実行に失敗した場合
	 */
	void recordStartWork() throws MospException;
	
	/**
	 * 終業を打刻する。<br>
	 * システム日付で、打刻する。<br>
	 * <br>
	 * 打刻した日の勤怠情報が存在し終業時間が登録されていない場合は、
	 * 打刻した日の勤怠情報として登録する。<br>
	 * <br>
	 * 打刻した日の勤怠情報が存在しない場合、前日の勤怠情報を確認する。<br>
	 * 前日の勤怠情報が存在し終業時間が登録されていない場合は、
	 * 前日の勤怠情報として登録する。<br>
	 * <br>
	 * 上記の場合以外は、打刻しない。<br>
	 * <br>
	 * 休憩入が入力されており休憩戻が入力されていない場合は、打刻しない。<br>
	 * <br>
	 * 打刻した勤怠情報は、申請状態になる。<br>
	 * @throws MospException インスタンスの取得及びSQL実行に失敗した場合
	 */
	void recordEndWork() throws MospException;
	
	/**
	 * 休憩入を打刻する。<br>
	 * システム日付で、打刻する。<br>
	 * @throws MospException インスタンスの取得及びSQL実行に失敗した場合
	 */
	void recordStartRest() throws MospException;
	
	/**
	 * 休憩戻を打刻する。<br>
	 * システム日付で、打刻する。<br>
	 * @throws MospException インスタンスの取得及びSQL実行に失敗した場合
	 */
	void recordEndRest() throws MospException;
	
}
