/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;

import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.AttendanceCorrectionReferenceBeanInterface;
import jp.mosp.time.bean.HolidayReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.constant.TimeConst;
import jp.mosp.time.dao.settings.AttendanceCorrectionDaoInterface;
import jp.mosp.time.dto.settings.AttendanceCorrectionDtoInterface;
import jp.mosp.time.dto.settings.GoOutDtoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeCorrectionDtoInterface;

/**
 * 勤怠データ修正情報参照クラス。
 */
public class AttendanceCorrectionReferenceBean extends PlatformBean implements
		AttendanceCorrectionReferenceBeanInterface {
	
	/**
	 * 勤怠データ修正情報DAOクラス。<br>
	 */
	AttendanceCorrectionDaoInterface	dao;
	/**
	 * 勤務形態管理DTOインターフェース。<br>
	 */
	WorkTypeReferenceBeanInterface		workTypeReference;
	
	HolidayReferenceBeanInterface		holidayReference;
	

	/**
	 * {@link PlatformBean#PlatformBean()}を実行する。<br>
	 */
	public AttendanceCorrectionReferenceBean() {
		super();
	}
	
	/**
	 * {@link PlatformBean#PlatformBean(MospParams, Connection)}を実行する。<br>
	 * @param mospParams MosPパラメータクラス
	 * @param connection DBコネクション
	 */
	public AttendanceCorrectionReferenceBean(MospParams mospParams, Connection connection) {
		super(mospParams, connection);
	}
	
	@Override
	public void initBean() throws MospException {
		dao = (AttendanceCorrectionDaoInterface)createDao(AttendanceCorrectionDaoInterface.class);
		workTypeReference = (WorkTypeReferenceBeanInterface)createBean(WorkTypeReferenceBeanInterface.class);
		holidayReference = (HolidayReferenceBeanInterface)createBean(HolidayReferenceBeanInterface.class);
	}
	
	@Override
	public AttendanceCorrectionDtoInterface getLatestAttendanceCorrectionInfo(String personalId, Date workDate,
			int works) throws MospException {
		return dao.findForLatestInfo(personalId, workDate, works);
	}
	
	@Override
	public List<AttendanceCorrectionDtoInterface> getAttendanceCorrectionHistory(String personalId, Date workDate,
			int works) throws MospException {
		return dao.findForHistory(personalId, workDate, works);
	}
	
	@Override
	public String getCorrectionValue(String code, String value, Date targetDate) throws MospException {
		// 値がハイフンの場合、ハイフンを返す
		if (value.equals(mospParams.getName("Hyphen"))) {
			return value;
		}
		
		// 勤務形態
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_WORKTYPECODE)) {
			if (workTypeReference != null) {
				return workTypeReference.getWorkTypeAbbr(value, targetDate);
			} else {
				return "";
			}
		}
		// 直行
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_DIRECTSTART)) {
			if (value.equals("1")) {
				return mospParams.getName("DirectStart");
			} else {
				return "";
			}
		}
		// 直帰
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_DIRECTEND)) {
			if (value.equals("1")) {
				return mospParams.getName("DirectEnd");
			} else {
				return "";
			}
		}
		// 遅刻証明書、早退証明書、手当1～10
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATECERTIFICATE)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYCERTIFICATE)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE1)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE2)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE3)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE4)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE5)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE6)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE7)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE8)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE9)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE10)) {
			if (value.equals("0")) {
				return mospParams.getName("Without");
			} else if (value.equals("1")) {
				return mospParams.getName("Yes");
			} else {
				return "";
			}
		}
		// 出勤時刻、退勤時刻、勤怠コメント、遅刻コメント、早退コメント、休暇1～6、公用外出1～2、私用外出1～2
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_STARTTIME)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ENDTIME)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_TIMECOMMENT)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATECOMMENT)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYCOMMENT)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK1)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK2)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK3)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK4)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK5)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK6)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_OFFICIAL_GOING_OUT1)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_OFFICIAL_GOING_OUT2)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_PRIVATE_GOING_OUT1)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_PRIVATE_GOING_OUT2)) {
			return value;
		}
		// 遅刻理由、早退理由
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATEREASON)
				|| code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYREASON)) {
			if (TimeConst.CODE_TARDINESS_WHY_INDIVIDU.equals(value)) {
				return mospParams.getName("Personal") + mospParams.getName("Convenience");
			} else if (TimeConst.CODE_TARDINESS_WHY_BAD_HEALTH.equals(value)) {
				return mospParams.getName("PhysicalCondition") + mospParams.getName("Bad");
			} else if (TimeConst.CODE_TARDINESS_WHY_OTHERS.equals(value)) {
				return mospParams.getName("Others");
			} else if (TimeConst.CODE_TARDINESS_WHY_TRAIN.equals(value)) {
				return mospParams.getName("Train") + mospParams.getName("Delay");
			} else if (TimeConst.CODE_TARDINESS_WHY_COMPANY.equals(value)) {
				return mospParams.getName("Company") + mospParams.getName("Directions");
			} else {
				return "";
			}
		}
		return code;
	}
	
	@Override
	public String getHistoryAttendanceMoreName(String code) {
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_WORKTYPECODE)) {
			return mospParams.getName("Work") + mospParams.getName("Form");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_STARTTIME)) {
			return mospParams.getName("GoingWork") + mospParams.getName("Moment");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ENDTIME)) {
			return mospParams.getName("RetireOffice") + mospParams.getName("Moment");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_DIRECTSTART)) {
			return mospParams.getName("DirectStart");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_DIRECTEND)) {
			return mospParams.getName("DirectEnd");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATEREASON)) {
			return mospParams.getName("Tardiness") + mospParams.getName("Reason");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATECERTIFICATE)) {
			return mospParams.getName("Tardiness") + mospParams.getName("Certificates");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATECOMMENT)) {
			return mospParams.getName("Tardiness") + mospParams.getName("Comment");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYREASON)) {
			return mospParams.getName("LeaveEarly") + mospParams.getName("Reason");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYCERTIFICATE)) {
			return mospParams.getName("LeaveEarly") + mospParams.getName("Certificates");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYCOMMENT)) {
			return mospParams.getName("LeaveEarly") + mospParams.getName("Comment");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_TIMECOMMENT)) {
			return mospParams.getName("WorkManage") + mospParams.getName("Comment");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE1)) {
			return mospParams.getName("Allowance") + mospParams.getName("No1");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE2)) {
			return mospParams.getName("Allowance") + mospParams.getName("No2");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE3)) {
			return mospParams.getName("Allowance") + mospParams.getName("No3");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE4)) {
			return mospParams.getName("Allowance") + mospParams.getName("No4");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE5)) {
			return mospParams.getName("Allowance") + mospParams.getName("No5");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE6)) {
			return mospParams.getName("Allowance") + mospParams.getName("No6");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE7)) {
			return mospParams.getName("Allowance") + mospParams.getName("No7");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE8)) {
			return mospParams.getName("Allowance") + mospParams.getName("No8");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE9)) {
			return mospParams.getName("Allowance") + mospParams.getName("No9");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE10)) {
			return mospParams.getName("Allowance") + mospParams.getName("No10");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK1)) {
			return mospParams.getName("RestTime") + mospParams.getName("No1");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK2)) {
			return mospParams.getName("RestTime") + mospParams.getName("No2");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK3)) {
			return mospParams.getName("RestTime") + mospParams.getName("No3");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK4)) {
			return mospParams.getName("RestTime") + mospParams.getName("No4");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK5)) {
			return mospParams.getName("RestTime") + mospParams.getName("No5");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK6)) {
			return mospParams.getName("RestTime") + mospParams.getName("No6");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_OFFICIAL_GOING_OUT1)) {
			return mospParams.getName("Official") + mospParams.getName("GoingOut") + mospParams.getName("No1");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_OFFICIAL_GOING_OUT2)) {
			return mospParams.getName("Official") + mospParams.getName("GoingOut") + mospParams.getName("No2");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_PRIVATE_GOING_OUT1)) {
			return mospParams.getName("Private") + mospParams.getName("GoingOut") + mospParams.getName("No1");
		}
		if (code.equals(TimeConst.CODE_ATTENDANCE_ITEM_NAME_PRIVATE_GOING_OUT2)) {
			return mospParams.getName("Private") + mospParams.getName("GoingOut") + mospParams.getName("No2");
		}
		return code;
	}
	
	public String getHistoryAttendanceAggregateName(TotalTimeCorrectionDtoInterface dto) throws MospException {
		Date date = DateUtility.getLastDateOfMonth(dto.getCalculationYear(), dto.getCalculationMonth());
		String correctionType = dto.getCorrectionType();
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_WORKTIME)) {
			return mospParams.getName("Work") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_SPECIFICWORKTIME)) {
			return mospParams.getName("Prescribed") + mospParams.getName("Work") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESWORKDATE)) {
			return mospParams.getName("GoingWork") + mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESWORK)) {
			return mospParams.getName("GoingWork") + mospParams.getName("Frequency");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_LEGALWORKONHOLIDAY)) {
			return mospParams.getName("Legal") + mospParams.getName("Holiday") + mospParams.getName("GoingWork")
					+ mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_SPECIFICWORKONHOLIDAY)) {
			return mospParams.getName("Prescribed") + mospParams.getName("Holiday") + mospParams.getName("GoingWork")
					+ mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_DIRECTSTART)) {
			return mospParams.getName("DirectStart") + mospParams.getName("Frequency");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_DIRECTEND)) {
			return mospParams.getName("DirectEnd") + mospParams.getName("Frequency");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_RESTTIME)) {
			return mospParams.getName("RestTime") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_RESTLATENIGHT)) {
			return mospParams.getName("Midnight") + mospParams.getName("RestTime") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_RESTWORKONSPECIFICHOLIDAY)) {
			return mospParams.getName("Midnight") + mospParams.getName("RestTime") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_RESTWORKONHOLIDAY)) {
			return mospParams.getName("Legal") + mospParams.getName("WorkingHoliday") + mospParams.getName("RestTime")
					+ mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_PUBLICTIME)) {
			return mospParams.getName("Official") + mospParams.getName("GoingOut") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_PRIVATETIME)) {
			return mospParams.getName("Private") + mospParams.getName("GoingOut") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESOVERTIME)) {
			return mospParams.getName("OvertimeWork") + mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_OVERTIMEIN)) {
			return mospParams.getName("OvertimeWork") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_OVERTIMEOUT)) {
			return mospParams.getName("Legal") + mospParams.getName("Outside") + mospParams.getName("OvertimeWork")
					+ mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_LATENIGHT)) {
			return mospParams.getName("Midnight") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_WORKONSPECIFICHOLIDAY)) {
			return mospParams.getName("Prescribed") + mospParams.getName("WorkingHoliday") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_WORKONHOLIDAY)) {
			return mospParams.getName("Legal") + mospParams.getName("WorkingHoliday") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_DECREASETIME)) {
			return mospParams.getName("Reduced") + mospParams.getName("Target") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_FORTYFIVEHOUROVERTIME)) {
			return mospParams.getName("No45") + mospParams.getName("Time") + mospParams.getName("Exceed")
					+ mospParams.getName("OvertimeWork") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESLATE)) {
			return mospParams.getName("Tardiness") + mospParams.getName("Frequency");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_LATEDEDUCTION)) {
			return mospParams.getName("Tardiness") + mospParams.getName("Deduction") + mospParams.getName("Yes")
					+ mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_LATENODEDUCTION)) {
			return mospParams.getName("Tardiness") + mospParams.getName("Deduction") + mospParams.getName("Without")
					+ mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_LATEOTHER)) {
			return mospParams.getName("Tardiness") + mospParams.getName("Others") + mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_LATETIME)) {
			return mospParams.getName("Tardiness") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_LATEDEDUCTIONTIME)) {
			return mospParams.getName("Tardiness") + mospParams.getName("Deduction") + mospParams.getName("Yes")
					+ mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_LATENODEDUCTIONTIME)) {
			return mospParams.getName("Tardiness") + mospParams.getName("Deduction") + mospParams.getName("Without")
					+ mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_LATEOTHERTIME)) {
			return mospParams.getName("Tardiness") + mospParams.getName("Others") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESLEAVEEARLY)) {
			return mospParams.getName("LeaveEarly") + mospParams.getName("Frequency");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYDEDUCTION)) {
			return mospParams.getName("LeaveEarly") + mospParams.getName("Deduction") + mospParams.getName("Yes")
					+ mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYNODEDUCTION)) {
			return mospParams.getName("LeaveEarly") + mospParams.getName("Deduction") + mospParams.getName("Without")
					+ mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYOTHER)) {
			return mospParams.getName("LeaveEarly") + mospParams.getName("Others") + mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYTIME)) {
			return mospParams.getName("LeaveEarly") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYDEDUCTIONTIME)) {
			return mospParams.getName("LeaveEarly") + mospParams.getName("Deduction") + mospParams.getName("Yes")
					+ mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYNODEDUCTIONTIME)) {
			return mospParams.getName("LeaveEarly") + mospParams.getName("Deduction") + mospParams.getName("Without")
					+ mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYOTHERTIME)) {
			return mospParams.getName("LeaveEarly") + mospParams.getName("Others") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESHOLIDAY)) {
			return mospParams.getName("Vacation") + mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESLEGALHOLIDAY)) {
			return mospParams.getName("Legal") + mospParams.getName("Holiday") + mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESSPECIFICHOLIDAY)) {
			return mospParams.getName("Prescribed") + mospParams.getName("Holiday") + mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESPAIDHOLIDAY)) {
			return mospParams.getName("Salaried") + mospParams.getName("Vacation") + mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_PAIDHOLIDAYHOUR)) {
			return mospParams.getName("Salaried") + mospParams.getName("Vacation") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESSTOCKHOLIDAY)) {
			return mospParams.getName("Stock") + mospParams.getName("Vacation") + mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESCOMPENSATION)) {
			return mospParams.getName("CompensatoryHoliday") + mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESLEGALCOMPENSATION)) {
			return mospParams.getName("Legal") + mospParams.getName("CompensatoryHoliday") + mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESSPECIFICCOMPENSATION)) {
			return mospParams.getName("Prescribed") + mospParams.getName("CompensatoryHoliday")
					+ mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESLATECOMPENSATION)) {
			return mospParams.getName("Midnight") + mospParams.getName("CompensatoryHoliday")
					+ mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESHOLIDAYSUBSTITUTE)) {
			return mospParams.getName("Transfer") + mospParams.getName("Holiday") + mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESLEGALHOLIDAYSUBSTITUTE)) {
			return mospParams.getName("Legal") + mospParams.getName("Transfer") + mospParams.getName("Holiday")
					+ mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESSPECIFICHOLIDAYSUBSTITUTE)) {
			return mospParams.getName("Prescribed") + mospParams.getName("Transfer") + mospParams.getName("Holiday")
					+ mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TOTALSPECIALHOLIDAY)) {
			return mospParams.getName("Specially") + mospParams.getName("Vacation") + mospParams.getName("SumTotal")
					+ mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TOTALOTHERHOLIDAY)) {
			return mospParams.getName("Others") + mospParams.getName("Vacation") + mospParams.getName("SumTotal")
					+ mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TOTALABSENCE)) {
			return mospParams.getName("Absence") + mospParams.getName("SumTotal") + mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TOTALALLOWANCE)) {
			return mospParams.getName("Allowance") + mospParams.getName("SumTotal");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_SIXTYHOUROVERTIME)) {
			return mospParams.getName("No60") + mospParams.getName("Time") + mospParams.getName("Exceed")
					+ mospParams.getName("OvertimeWork") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_WEEKDAYOVERTIME)) {
			return mospParams.getName("Weekday") + mospParams.getName("Time") + mospParams.getName("Outside")
					+ mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_SPECIFICOVERTIME)) {
			return mospParams.getName("Prescribed") + mospParams.getName("Holiday") + mospParams.getName("Time")
					+ mospParams.getName("Outside") + mospParams.getName("Time");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESALTERNATIVE)) {
			return mospParams.getName("Substitute") + mospParams.getName("Vacation") + mospParams.getName("Days");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE1)) {
			return mospParams.getName("Allowance") + mospParams.getName("No1");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE2)) {
			return mospParams.getName("Allowance") + mospParams.getName("No2");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE3)) {
			return mospParams.getName("Allowance") + mospParams.getName("No3");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE4)) {
			return mospParams.getName("Allowance") + mospParams.getName("No4");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE5)) {
			return mospParams.getName("Allowance") + mospParams.getName("No5");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE6)) {
			return mospParams.getName("Allowance") + mospParams.getName("No6");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE7)) {
			return mospParams.getName("Allowance") + mospParams.getName("No7");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE8)) {
			return mospParams.getName("Allowance") + mospParams.getName("No8");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE9)) {
			return mospParams.getName("Allowance") + mospParams.getName("No9");
		}
		if (correctionType.equals(TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE10)) {
			return mospParams.getName("Allowance") + mospParams.getName("No10");
		}
		if (TimeConst.CODE_TOTALTIME_ITEM_NAME_LATEDAYS.equals(correctionType)) {
			return mospParams.getName("Tardiness") + mospParams.getName("Days");
		}
		if (TimeConst.CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYDAYS.equals(correctionType)) {
			return mospParams.getName("LeaveEarly") + mospParams.getName("Days");
		}
		if (TimeConst.CODE_TOTALTIME_ITEM_NAME_LEGALCOMPENSATIONUNUSED.equals(correctionType)) {
			return mospParams.getName("Legal") + mospParams.getName("CompensatoryHoliday") + mospParams.getName("Ram")
					+ mospParams.getName("Use");
		}
		if (TimeConst.CODE_TOTALTIME_ITEM_NAME_SPECIFICCOMPENSATIONUNUSED.equals(correctionType)) {
			return mospParams.getName("Prescribed") + mospParams.getName("CompensatoryHoliday")
					+ mospParams.getName("Ram") + mospParams.getName("Use");
		}
		if (TimeConst.CODE_TOTALTIME_ITEM_NAME_LATECOMPENSATIONUNUSED.equals(correctionType)) {
			return mospParams.getName("Midnight") + mospParams.getName("CompensatoryHoliday")
					+ mospParams.getName("Ram") + mospParams.getName("Use");
		}
		String[] codeArray = correctionType.split(",");
		if (codeArray.length >= 2) {
			if (TimeConst.CODE_TOTALTIME_ITEM_NAME_TOTALLEAVE.equals(codeArray[0])) {
				// 特別休暇
				return holidayReference.getHolidayAbbr(codeArray[1], date, 2);
			} else if (TimeConst.CODE_TOTALTIME_ITEM_NAME_OTHERVACATION.equals(codeArray[0])) {
				// その他休暇
				return holidayReference.getHolidayAbbr(codeArray[1], date, 3);
			} else if (TimeConst.CODE_TOTALTIME_ITEM_NAME_ABSENCE.equals(codeArray[0])) {
				// 欠勤
				return holidayReference.getHolidayAbbr(codeArray[1], date, 4);
			}
		}
		return correctionType;
	}
	
	@Override
	public boolean chkRest(RestDtoInterface newRest, RestDtoInterface oldRest) {
		if (newRest.getRestStart().equals(oldRest.getRestStart()) == false
				|| newRest.getRestEnd().equals(oldRest.getRestEnd()) == false) {
			return true;
		}
		return false;
	}
	
	@Override
	public boolean chkGoOut(GoOutDtoInterface newGoOut, GoOutDtoInterface oldGoOut) {
		if (newGoOut.getGoOutStart().equals(oldGoOut.getGoOutStart()) == false
				|| newGoOut.getGoOutEnd().equals(oldGoOut.getGoOutEnd()) == false) {
			return true;
		}
		return false;
	}
}
