/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.List;

import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.TotalTimeCorrectionReferenceBeanInterface;
import jp.mosp.time.constant.TimeConst;
import jp.mosp.time.dao.settings.TotalTimeCorrectionDaoInterface;
import jp.mosp.time.dto.settings.TotalTimeCorrectionDtoInterface;

/**
 * 勤怠集計修正情報参照クラス。
 */
public class TotalTimeCorrectionReferenceBean extends PlatformBean implements TotalTimeCorrectionReferenceBeanInterface {
	
	/**
	 * 勤怠データ修正情報DAOクラス。<br>
	 */
	TotalTimeCorrectionDaoInterface	dao;
	

	/**
	 * {@link PlatformBean#PlatformBean()}を実行する。<br>
	 */
	public TotalTimeCorrectionReferenceBean() {
		super();
	}
	
	/**
	 * {@link PlatformBean#PlatformBean(MospParams, Connection)}を実行する。<br>
	 * @param mospParams MosPパラメータクラス
	 * @param connection DBコネクション
	 */
	public TotalTimeCorrectionReferenceBean(MospParams mospParams, Connection connection) {
		super(mospParams, connection);
	}
	
	@Override
	public void initBean() throws MospException {
		dao = (TotalTimeCorrectionDaoInterface)createDao(TotalTimeCorrectionDaoInterface.class);
	}
	
	@Override
	public TotalTimeCorrectionDtoInterface getLatestTotalTimeCorrectionInfo(String personalId, int calculationYear,
			int calculationMonth) throws MospException {
		return dao.findForLatestInfo(personalId, calculationYear, calculationMonth);
	}
	
	@Override
	public List<TotalTimeCorrectionDtoInterface> getTotalTimeCorrectionHistory(String personalId, int calculationYear,
			int calculationMonth) throws MospException {
		return dao.findForHistory(personalId, calculationYear, calculationMonth);
	}
	
	@Override
	public String getCorrectionValue(String correctionType, String correctionValue) {
		if (TimeConst.CODE_TOTALTIME_ITEM_NAME_WORKTIME.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_RESTTIME.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_RESTLATENIGHT.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_RESTWORKONSPECIFICHOLIDAY.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_RESTWORKONHOLIDAY.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_PUBLICTIME.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_PRIVATETIME.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_OVERTIMEIN.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_OVERTIMEOUT.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_LATENIGHT.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_WORKONSPECIFICHOLIDAY.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_WORKONHOLIDAY.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_DECREASETIME.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_FORTYFIVEHOUROVERTIME.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_LATETIME.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_LATEDEDUCTIONTIME.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_LATENODEDUCTIONTIME.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_LATEOTHERTIME.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYTIME.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYDEDUCTIONTIME.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYNODEDUCTIONTIME.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYOTHERTIME.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_SIXTYHOUROVERTIME.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_WEEKDAYOVERTIME.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_SPECIFICOVERTIME.equals(correctionType)) {
			// 勤務時間・休憩時間・深夜休憩時間・所定休日出勤休憩時間・法定休日出勤労働時間
			// 公用外出時間・私用外出時間・残業時間・法定外残業時間・深夜時間
			// 所定休日出勤時間・法定休日出勤時間・減額対象時間・45時間超残業時間
			// 遅刻時間・遅刻控除有り時間・遅刻控除無し時間・遅刻その他時間
			// 早退時間・早退控除有り時間・早退控除無し時間・早退その他時間
			// 60時間超残業時間・平日時間外時間・所定休日時間外時間
			int work = 0;
			StringBuffer sb = new StringBuffer();
			try {
				work = Integer.parseInt(correctionValue);
			} catch (NumberFormatException e) {
				sb.append("00");
				sb.append(mospParams.getName("Minutes"));
				return sb.toString();
			}
			if (work <= 0) {
				sb.append("00");
				sb.append(mospParams.getName("Minutes"));
				return sb.toString();
			}
			sb.append(work / 60);
			sb.append(mospParams.getName("Time"));
			int minute = work % 60;
			if (minute < 10) {
				sb.append(0);
			}
			sb.append(minute);
			sb.append(mospParams.getName("Minutes"));
			return sb.toString();
		} else if (
//				TimeConst.CODE_TOTALTIME_ITEM_NAME_SPECIFICWORKTIME.equals(correctionType) ||
		TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESWORKDATE.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESWORK.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_LEGALWORKONHOLIDAY.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_SPECIFICWORKONHOLIDAY.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_DIRECTSTART.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_DIRECTEND.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESOVERTIME.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESLATE.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_LATEDEDUCTION.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_LATENODEDUCTION.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_LATEOTHER.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESLEAVEEARLY.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYDEDUCTION.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYNODEDUCTION.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYOTHER.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESHOLIDAY.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESLEGALHOLIDAY.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESSPECIFICHOLIDAY.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESPAIDHOLIDAY.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_PAIDHOLIDAYHOUR.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESSTOCKHOLIDAY.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESCOMPENSATION.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESLEGALCOMPENSATION.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESSPECIFICCOMPENSATION.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESLATECOMPENSATION.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESHOLIDAYSUBSTITUTE.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESLEGALHOLIDAYSUBSTITUTE.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESSPECIFICHOLIDAYSUBSTITUTE.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TOTALSPECIALHOLIDAY.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TOTALOTHERHOLIDAY.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TOTALABSENCE.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TOTALALLOWANCE.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TIMESALTERNATIVE.equals(correctionType)
//				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_TOTALLEAVE.equals(correctionType)
//				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_OTHERVACATION.equals(correctionType)
//				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_ABSENCE.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE1.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE2.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE3.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE4.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE5.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE6.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE7.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE8.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE9.equals(correctionType)
				|| TimeConst.CODE_TOTALTIME_ITEM_NAME_ALLOWANCE10.equals(correctionType)) {
			return correctionValue;
		}
		return correctionValue;
	}
}
