/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.constant;

/**
 * MosPプラットフォームで用いる定数を宣言する。<br>
 * <br>
 */
public final class TimeConst {
	
	/**
	 * チェックボックス用定数。（ON）<br>
	 */
	@Deprecated
	public static final String	CHECK_ON												= "on";
	
	/**
	 * チェックボックス用定数。（OFF）<br>
	 */
	@Deprecated
	public static final String	CHECK_OFF												= "off";
	
	/**
	 * コードキー(締日)。
	 */
	public static final String	CODE_KEY_CUTOFF_DATE									= "CutoffDate";
	
	/**
	 * コードキー(付与区分)。
	 */
	public static final String	CODE_KEY_PAID_HOLIDAY_TYPE								= "PaidHolidayType";
	
	/**
	 * コードキー(有休単位時間)。
	 */
	public static final String	CODE_KEY_PAID_HOLIDAY_TIME								= "PaidHolidayTime";
	
	/**
	 * コードキー(時間限度日数)。
	 */
	public static final String	CODE_KEY_TIME_UNIT_PAID_HOLIDAY							= "TimeUnitPaidHoliday";
	
	/**
	 * コードキー(最大繰越年数)。
	 */
	public static final String	CODE_KEY_MAX_CARRY_OVER_YEARS							= "MaxCarryOverYears";
	
	/**
	 * コードキー(休暇区分)。
	 */
	public static final String	CODE_KEY_HOLIDAY_TYPE									= "HolidayType";
	
	/**
	 * コードキー(休暇マスタ区分)。
	 */
	public static final String	CODE_KEY_HOLIDAY_MASTER_TYPE							= "HolidayMasterType";
	
	/**
	 * コードキー(連続取得)。
	 */
	public static final String	CODE_KEY_CONTINUE										= "Continue";
	
	/**
	 * コードキー(給与区分)。
	 */
	public static final String	CODE_KEY_SALARY_PAY_TYPE								= "SalaryPayType";
	
	/**
	 * コードキー(出勤時刻)。
	 */
	public static final String	CODE_WORKSTART											= "WorkStart";
	
	/**
	 * コードキー(退勤時刻)。
	 */
	public static final String	CODE_WORKEND											= "WorkEnd";
	
	/**
	 * コードキー(勤務時間)。
	 */
	public static final String	CODE_WORKTIME											= "WorkTime";
	
	/**
	 * コードキー(休憩時間)。
	 */
	public static final String	CODE_RESTTIME											= "RestTime";
	
	/**
	 * コードキー(休憩1(開始))。
	 */
	public static final String	CODE_RESTSTART1											= "RestStart1";
	
	/**
	 * コードキー(休憩1(終了))。
	 */
	public static final String	CODE_RESTEND1											= "RestEnd1";
	
	/**
	 * コードキー(休憩2(開始))。
	 */
	public static final String	CODE_RESTSTART2											= "RestStart2";
	
	/**
	 * コードキー(休憩2(終了))。
	 */
	public static final String	CODE_RESTEND2											= "RestEnd2";
	
	/**
	 * コードキー(休憩3(開始))。
	 */
	public static final String	CODE_RESTSTART3											= "RestStart3";
	
	/**
	 * コードキー(休憩3(終了))。
	 */
	public static final String	CODE_RESTEND3											= "RestEnd3";
	
	/**
	 * コードキー(休憩4(開始))。
	 */
	public static final String	CODE_RESTSTART4											= "RestStart4";
	
	/**
	 * コードキー(休憩4(終了))。
	 */
	public static final String	CODE_RESTEND4											= "RestEnd4";
	
	/**
	 * コードキー(前半休(開始))。
	 */
	public static final String	CODE_FRONTSTART											= "FrontStart";
	
	/**
	 * コードキー(前半休(終了))。
	 */
	public static final String	CODE_FRONTEND											= "FrontEnd";
	
	/**
	 * コードキー(後半休(開始))。
	 */
	public static final String	CODE_BACKSTART											= "BackStart";
	
	/**
	 * コードキー(後半休(終了))。
	 */
	public static final String	CODE_BACKEND											= "BackEnd";
	
	/**
	 * コードキー(残前休憩)。
	 */
	public static final String	CODE_OVERBEFORE											= "OverBefore";
	
	/**
	 * コードキー(残業休憩時間(毎))。
	 */
	public static final String	CODE_OVERPER											= "OverPer";
	
	/**
	 * コードキー(残業休憩時間)。
	 */
	public static final String	CODE_OVERREST											= "OverRest";
	
	/**
	 * コードキー(半休休憩対象時間)。
	 */
	public static final String	CODE_HALFREST											= "HalfRest";
	
	/**
	 * コードキー(半休休憩開始時刻)。
	 */
	public static final String	CODE_HALFRESTSTART										= "HalfRestStart";
	
	/**
	 * コードキー(半休休憩終了時刻)。
	 */
	public static final String	CODE_HALFRESTEND										= "HalfRestEnd";
	
	/**
	 * コードキー(丸め)。
	 */
	public static final String	CODE_ROUNDING_ITEMS										= "RoundingItems";
	
	/**
	 * コードキー(曜日)。
	 */
	public static final String	CODE_KEY_DAY_OF_THE_WEEK								= "DayOfTheWeek";
	
	/**
	 * コードキー(所定休日取扱)。
	 */
	public static final String	CODE_KEY_SPECIFIC_HOLIDAY								= "SpecificHoliday";
	
	/**
	 * コードキー(出勤率計算)。
	 */
	public static final String	CODE_KEY_PAID_HOLIDAY_CALC								= "PaidHolidayCalc";
	
	/**
	 * コードキー(締状態)。
	 */
	public static final String	CODE_WELL_SET_STATE										= "WellSetState";
	
	/**
	 * コードキー(半休入替取得)。
	 */
	public static final String	CODE_HALF_TIME_EXCHANGE									= "HalfTimeExchange";
	
	/**
	 * コードキー(所定/法定休日)。
	 */
	public static final String	CODE_PRESCRIBED_LEGAL_HOLIDAY							= "PrescribedLegalHoliday";
	
	/**
	 * コードキー(休暇区分)。
	 */
	public static final String	CODE_KEY_HOLIDAY_TYPE_MASTER							= "HolidayTypeMaster";
	
	/**
	 * 表示月コード(1月)。
	 */
	public static final String	CODE_DISPLAY_JANUARY									= "1";
	
	/**
	 * 表示月コード(2月)。
	 */
	public static final String	CODE_DISPLAY_FEBRUARY									= "2";
	
	/**
	 * 表示月コード(3月)。
	 */
	public static final String	CODE_DISPLAY_MARCH										= "3";
	
	/**
	 * 表示月コード(4月)。
	 */
	public static final String	CODE_DISPLAY_APRIL										= "4";
	
	/**
	 * 表示月コード(5月)。
	 */
	public static final String	CODE_DISPLAY_MAY										= "5";
	
	/**
	 * 表示月コード(6月)。
	 */
	public static final String	CODE_DISPLAY_JUNE										= "6";
	
	/**
	 * 表示月コード(7月)。
	 */
	public static final String	CODE_DISPLAY_JULY										= "7";
	
	/**
	 * 表示月コード(8月)。
	 */
	public static final String	CODE_DISPLAY_AUGUST										= "8";
	
	/**
	 * 表示月コード(9月)。
	 */
	public static final String	CODE_DISPLAY_SEPTEMBER									= "9";
	
	/**
	 * 表示月コード(10月)。
	 */
	public static final String	CODE_DISPLAY_OCTOBER									= "10";
	
	/**
	 * 表示月コード(11月)。
	 */
	public static final String	CODE_DISPLAY_NOVEMBER									= "11";
	
	/**
	 * 表示月コード(12月)。
	 */
	public static final String	CODE_DISPLAY_DECEMBER									= "12";
	
	/**
	 * 表示ステータスコード。
	 */
	public static final String	CODE_APPROVAL_STATE										= "ApprovalState";
	
	/**
	 * 表示ステータスコード。
	 */
	public static final String	CODE_NOT_APPROVED										= "NotApproved";
	
	/**
	 * 表示ステータスコード。
	 */
	public static final String	CODE_SCHEDULE_OVER										= "ScheduleOver";
	
	/**
	 * 表示ステータスコード。
	 */
	public static final String	CODE_OVER_TIME_TYPE										= "OverTimeType";
	
	/**
	 * 表示ステータス(申請)。
	 */
	public static final String	CODE_SUBSTITUTE											= "Substitute";
	
	/**
	 * 表示ステータス(申請範囲1)。
	 */
	public static final String	CODE_SUBSTITUTE1_RANGE									= "Substitute1Range";
	
	/**
	 * 表示ステータス(申請範囲2)。
	 */
	public static final String	CODE_SUBSTITUTE2_RANGE									= "Substitute2Range";
	
	/**
	 * 表示ステータス(時差出勤区分)。
	 */
	public static final String	CODE_DIFFERENCE_TYPE									= "DifferenceType";
	
	/**
	 * 表示ステータス（ヘッダー有無）
	 */
	public static final String	CODE_HEARDER											= "Header";
	
	/**
	 * 表示ステータス（休日出勤区分）
	 */
	public static final String	CODE_WORK_ON_HOLIDAY									= "WorkOnHoliday";
	
	/**
	 * 表示ステータス(時差出勤区分)。
	 */
	public static final String	CODE_START_DATE											= "StartDate";
	
	/**
	 * 表示ステータス(休暇申請区分)。
	 */
	public static final String	CODE_HOLIDAY_TYPE										= "HolidayType";
	
	/**
	 * 表示ステータス(休暇申請区分)。
	 */
	public static final String	CODE_HOLIDAY_TYPE3_RANGE1								= "HolidayType3Range1";
	
	/**
	 * 表示ステータス(休暇申請区分)。
	 */
	public static final String	CODE_HOLIDAY_TYPE3_RANGE2								= "HolidayType3Range2";
	
	/**
	 * ラジオコード(曜日指定)。
	 */
	public static final String	CODE_RADIO_WEEK											= "week";
	
	/**
	 * ラジオコード(期間指定)。
	 */
	public static final String	CODE_RADIO_PERIOD										= "period";
	
	/**
	 * ラジオコード(日付指定)。
	 */
	public static final String	CODE_RADIO_CHECK										= "check";
	
	/**
	 * デフォルトコード（月）。
	 */
	public static final int		CODE_DEFAULT_MONTH										= 4;
	
	/**
	 * 年計算用コード。
	 */
	public static final int		CODE_DEFINITION_YEAR									= 12;
	
	/**
	 * 時間計算用コード。
	 */
	public static final int		CODE_DEFINITION_HOUR									= 60;
	
	/**
	 * コードキー(連続取得)。
	 */
	public static final String	CODE_APPROVAL_TYPE										= "ApprovalType";
	
	/**
	 * コードキー(連続取得)。
	 */
	public static final String	CODE_STATE												= "State";
	
	/**
	 * コードキー(締状態)。
	 */
	public static final String	CODE_CUTOFFSTATE										= "CutoffState";
	
	/**
	 * コードキー(勤怠情報データ区分)。
	 */
	@Deprecated
	public static final String	CODE_KEY_TIME_TABLE_TYPE								= "TimeTableType";
	
	/**
	 * コードキー(勤怠情報データインポート区分)。
	 */
	public static final String	CODE_KEY_TIME_IMPORT_TABLE_TYPE							= "TimeImportTableType";
	
	/**
	 * コードキー(勤怠情報データエクスポート区分)。
	 */
	public static final String	CODE_KEY_TIME_EXPORT_TABLE_TYPE							= "TimeExportTableType";
	
	/**
	 * コードキー(手当区分)。
	 */
	public static final String	CODE_ALLOWANCE											= "Allowance";
	
	/**
	 * コードキー(有給休暇の休暇種別)。
	 */
	public static final String	CODE_HOLIDAY_TYPE2_WITHPAY								= "HolidayType2WithPay";
	
	/**
	 * コードキー(有給休暇の休暇種別)。
	 */
	public static final String	CODE_GIVING_TYPE										= "GivingType";
	
	/**
	 * コードキー(振替申請)。
	 */
	public static final String	CODE_WORKONHOLIDAY_SUBSTITUTE							= "WorkOnHolidaySubstitute";
	
	/**
	 * コードキー（特別休暇）。
	 */
	public static final int		CODE_HOLIDAYTYPE_SPECIAL								= 2;
	
	/**
	 * コードキー（その他休暇）。
	 */
	public static final int		CODE_HOLIDAYTYPE_OTHER									= 3;
	
	/**
	 * コードキー（欠勤）。
	 */
	public static final int		CODE_HOLIDAYTYPE_ABSENCE								= 4;
	/**
	 * 前年度残日数コード。
	 */
	public static final String	CODE_FORMER_YEAR_DATE									= "FormerYear";
	
	/**
	 * 前年度残時間コード。
	 */
	public static final String	CODE_FORMER_YEAR_TIME									= "FormerTime";
	
	/**
	 * 今年度残日数コード。
	 */
	public static final String	CODE_CURRENT_YEAR_DATE									= "CurrentYear";
	
	/**
	 * 支給日数コード。
	 */
	public static final String	CODE_GIVING_DATE										= "GivingDate";
	
	/**
	 * 支給時間コード。
	 */
	public static final String	CODE_GIVING_TIME										= "GivingTime";
	
	/**
	 * 廃棄日数コード。
	 */
	public static final String	CODE_CANCEL_DATE										= "CancelDate";
	
	/**
	 * 廃棄時間コード。
	 */
	public static final String	CODE_CANCEL_TIME										= "CancelTime";
	
	/**
	 * 利用日数コード。
	 */
	public static final String	CODE_USE_DATE											= "UseDate";
	
	/**
	 * 利用時間コード。
	 */
	public static final String	CODE_USE_TIME											= "UseTime";
	
	/**
	 * 今年度残時間コード。
	 */
	public static final String	CODE_CURRENT_TIME										= "CurrentTime";
	
	/**
	 * 有効日コード。
	 */
	public static final String	CODE_ACTIVATE_DATE										= "ActivateDate";
	
	/**
	 * 今年度取得日。
	 */
	public static final String	CODE_CURRENT_ACQUISITION_DATE_DATE						= "CurrentAcquisitionDate";
	
	/**
	 * 前年度取得日。
	 */
	public static final String	CODE_FORMER_ACQUISITION_DATE_DATE						= "FormerAcquisitionDate";
	
	/**
	 * 合計勤務時間コード。
	 */
	public static final String	CODE_TOTAL_WORK_TIME									= "TotalWorkTime";
	
	/**
	 * 合計休憩時間コード。
	 */
	public static final String	CODE_TOTAL_REST_TIME									= "TotalRestTime";
	
	/**
	 * 合計遅刻時間コード。
	 */
	public static final String	CODE_TOTAL_LATE_TIME									= "TotalLateTime";
	
	/**
	 * 合計早退時間コード。
	 */
	public static final String	CODE_TOTAL_LEAVE_EARLY									= "TotalLeaveEarly";
	
	/**
	 * 合計残業時間コード。
	 */
	public static final String	CODE_TOTAL_OVER_TIMEIN									= "TotalOverTimeIn";
	
	/**
	 * 合計外残時間コード。
	 */
	public static final String	CODE_TOTAL_OVER_TIMEOUT									= "TotalOverTimeOut";
	
	/**
	 * 合計休日出勤時間コード。
	 */
	public static final String	CODE_TOTAL_WORK_ON_HOLIDAY								= "TotalWorkOnHoliday";
	
	/**
	 * 合計深夜勤務時間コード。
	 */
	public static final String	CODE_TOTAL_LATE_NIGHT									= "TotalLateNight";
	
	/**
	 * 合計出勤回数コード。
	 */
	public static final String	CODE_TOTAL_TIMES_WORK									= "TotalTimesWork";
	
	/**
	 * 合計遅刻回数コード。
	 */
	public static final String	CODE_TOTAL_TIMES_LATE									= "TotalTimesLate";
	
	/**
	 * 合計早退回数コード。
	 */
	public static final String	CODE_TOTAL_TIMES_LEAVE_EARLY							= "TotalTimesLeaveEarly";
	
	/**
	 * 合計残業回数コード。
	 */
	public static final String	CODE_TOTAL_TIMES_OVERTIMEWORK							= "TotalTimesOverTimeWork";
	
	/**
	 * 合計休出回数コード。
	 */
	public static final String	CODE_TOTAL_TIMES_WORKONHOLIDAY							= "TotalTimesWorkOnHoliday";
	
	/**
	 *合計法定休日回数
	 */
	public static final String	CODE_TOTAL_TIMES_LEGALHOLIDAY							= "TotalTimesLegalHoliday";
	
	/**
	 *合計所定休日回数
	 */
	public static final String	CODE_TOTAL_TIMES_SPECIFICHOLIDAY						= "TotalTimesSpecificHoliday";
	
	/**
	 *合計有休回数
	 */
	public static final String	CODE_TOTAL_TIMES_PAIDHOLIDAY							= "TotalTimesPaidHoliday";
	
	/**
	 *合計有休時間
	 */
	public static final String	CODE_TOTAL_TIMES_PAIDHOLIDAY_TIME						= "TotalTimesPaidHolidayTime";
	
	/**
	 *合計特別休暇回数
	 */
	public static final String	CODE_TOTAL_TIMES_SPECIALHOLIDAY							= "TotalTimesSpecialHoloiday";
	
	/**
	 *合計その他休暇回数
	 */
	public static final String	CODE_TOTAL_TIMES_OTHERHOLIDAY							= "TotalTimesOtherHoloiday";
	
	/**
	 *合計振替休暇回数
	 */
	public static final String	CODE_TOTAL_TIMES_SUBSTITUTE								= "TotalTimesSubstitute";
	
	/**
	 *合計代休回数
	 */
	public static final String	CODE_TOTAL_TIMES_SUBHOLIDAY								= "TotalTimesSubHoliday";
	
	/**
	 *合計欠勤回数
	 */
	public static final String	CODE_TOTAL_TIMES_ABSENCE								= "TotalTimesAbsence";
	
	/**
	 *手当情報
	 */
	public static final String	CODE_ALLOWANCE_INFO										= "AllowanceInfo";
	
	/**
	 *手当情報1
	 */
	public static final String	CODE_ALLOWANCE_INFO1									= "AllowanceInfo1";
	
	/**
	 *手当情報2
	 */
	public static final String	CODE_ALLOWANCE_INFO2									= "AllowanceInfo2";
	
	/**
	 *手当情報3
	 */
	public static final String	CODE_ALLOWANCE_INFO3									= "AllowanceInfo3";
	
	/**
	 *手当情報4
	 */
	public static final String	CODE_ALLOWANCE_INFO4									= "AllowanceInfo4";
	
	/**
	 *手当情報5
	 */
	public static final String	CODE_ALLOWANCE_INFO5									= "AllowanceInfo5";
	
	/**
	 *手当情報6
	 */
	public static final String	CODE_ALLOWANCE_INFO6									= "AllowanceInfo6";
	
	/**
	 *手当情報7
	 */
	public static final String	CODE_ALLOWANCE_INFO7									= "AllowanceInfo7";
	
	/**
	 *手当情報8
	 */
	public static final String	CODE_ALLOWANCE_INFO8									= "AllowanceInfo8";
	
	/**
	 *手当情報9
	 */
	public static final String	CODE_ALLOWANCE_INFO9									= "AllowanceInfo9";
	
	/**
	 *手当情報10
	 */
	public static final String	CODE_ALLOWANCE_INFO10									= "AllowanceInfo10";
	
	/**
	 *手当コード1
	 */
	public static final String	CODE_ALLOWANCE_CODE_INFO1								= "1";
	
	/**
	 *手当コード2
	 */
	public static final String	CODE_ALLOWANCE_CODE_INFO2								= "2";
	
	/**
	 *手当コード3
	 */
	public static final String	CODE_ALLOWANCE_CODE_INFO3								= "3";
	
	/**
	 *手当コード4
	 */
	public static final String	CODE_ALLOWANCE_CODE_INFO4								= "4";
	
	/**
	 *手当コード5
	 */
	public static final String	CODE_ALLOWANCE_CODE_INFO5								= "5";
	
	/**
	 *手当コード6
	 */
	public static final String	CODE_ALLOWANCE_CODE_INFO6								= "6";
	
	/**
	 *手当コード7
	 */
	public static final String	CODE_ALLOWANCE_CODE_INFO7								= "7";
	
	/**
	 *手当コード8
	 */
	public static final String	CODE_ALLOWANCE_CODE_INFO8								= "8";
	
	/**
	 *手当コード9
	 */
	public static final String	CODE_ALLOWANCE_CODE_INFO9								= "9";
	
	/**
	 *手当コード10
	 */
	public static final String	CODE_ALLOWANCE_CODE_INF10								= "10";
	
	/**
	 * 申請、承認済み、使用済みの合計日数
	 */
	public static final String	CODE_REQUEST_DAY										= "requestDay";
	
	/**
	 * 申請、承認済み、使用済みの合計時間
	 */
	public static final String	CODE_REQUEST_HOUR										= "requestHour";
	
	/**
	 * 承認済みの合計日数
	 */
	public static final String	CODE_APPROVED_DAY										= "approvedDay";
	
	/**
	 * 承認済みの合計時間
	 */
	public static final String	CODE_APPROVED_HOUR										= "approvedHour";
	
	/**
	 * 勤怠集計時エラー発生
	 */
	public static final String	CODE_TOTALTIME_ERROR									= "TotalTimeError";
	
	/**
	 * 表示ステータス（遅刻理由区分）
	 */
	public static final String	CODE_REASON_OF_LATE										= "ReasonOfLate";
	
	/**
	 * 表示ステータス（早退理由区分）
	 */
	public static final String	CODE_REASON_OF_LEAVE_EARLY								= "ReasonOfLeaveEarly";
	
	/**
	 * 付与区分コード(基準日)。
	 */
	public static final String	PRM_GIVINGDIVISION_STANDARD_CODE						= "0";
	
	/**
	 * パラメータID(対象個人ID)。
	 */
	public static final String	PRM_TARGET_PERSONAL_ID									= "prmTargetPersonalId";
	
	/**
	 * パラメータID(対象日)。
	 */
	public static final String	PRM_TARGET_DATE											= "prmTargetDate";
	
	/**
	 * パラメータID(ワークフロー番号)。
	 */
	public static final String	PRM_TARGET_WORKFLOW										= "prmTargetWorkflow";
	
	/**
	 * パラメータID(譲渡Actionクラス名)(連続実行コマンド判定用)。
	 */
	public static final String	PRM_TRANSFERRED_ACTION									= "transferredAction";
	
	/**
	 * パラメータID(譲渡インデックス)。
	 */
	public static final String	PRM_TRANSFERRED_INDEX									= "transferredIndex";
	
	/**
	 * パラメータID(譲渡汎用区分)。
	 */
	public static final String	PRM_TRANSFERRED_TYPE									= "transferredType";
	
	/**
	 * パラメータID(譲渡汎用月)。
	 */
	public static final String	PRM_TRANSFERRED_MONTH									= "transferredMonth";
	
	/**
	 * パラメータID(譲渡承認段階)。
	 */
	public static final String	PRM_TRANSFERRED_STAGE									= "transferredStage";
	
	/**
	 * パラメータID(譲渡承認状況)。
	 */
	public static final String	PRM_TRANSFERRED_STATE									= "transferredState";
	
	/**
	 * パラメータID(譲渡年)。
	 */
	public static final String	PRM_TRANSFERRED_YEAR									= "transferredYear";
	
	/**
	 * パラメータID(休暇種別1)。
	 */
	public static final String	PRM_TRANSFERRED_HOLIDAY_TYPE1							= "holidayType1";
	
	/**
	 * パラメータID(休暇種別2)。
	 */
	public static final String	PRM_TRANSFERRED_HOLIDAY_TYPE2							= "holidayType2";
	
	/**
	 * パラメータID(休暇範囲)。
	 */
	public static final String	PRM_TRANSFERRED_HOLIDAY_RANGE							= "holidayRange";
	
	/**
	 * パラメータID(時休開始時刻)。
	 */
	public static final String	PRM_TRANSFERRED_START_TIME								= "StartTime";
	
	/**
	 * パラメータID(譲渡汎用コード)。
	 */
	public static final String	PRM_TRANSFERRED_GENERIC_CODE							= "transferredGenericCode";
	
	/**
	 * パラメータID(譲渡汎用日)。
	 */
	public static final String	PRM_TRANSFERRED_DAY										= "transferredDay";
	
	/**
	 * パラメータID(時間)
	 */
	public static final String	PRM_TRANSFERRED_HOUR									= "transferredHour";
	
	/**
	 * パラメータID(分)
	 */
	public static final String	PRM_TRANSFERRED_MINUTE									= "transferredMinute";
	
	/**
	 * パラメータID(開始時間)
	 */
	public static final String	PRM_TRANSFERRED_START_HOUR								= "transferredStartHour";
	
	/**
	 * パラメータID(開始分)
	 */
	public static final String	PRM_TRANSFERRED_START_MINUTE							= "transferredStartMinute";
	
	/**
	 * パラメータID(終了時間)
	 */
	public static final String	PRM_TRANSFERRED_END_HOUR								= "transferredEndHour";
	
	/**
	 * パラメータID(終了分)
	 */
	public static final String	PRM_TRANSFERRED_END_MINUTE								= "transferredEndMinute";
	
	/**
	 * パラメータID(直行)。
	 */
	public static final String	PRM_TRANSFERRED_DIRECT_START							= "transferredDirectStart";
	
	/**
	 * パラメータID(直帰)。
	 */
	public static final String	PRM_TRANSFERRED_DIRECT_END								= "transferredDirectEnd";
	
	/**
	 * 休暇最大登録数(特別休暇)。
	 */
	public static final int		PRM_HOLIDAYTYPE_SPECIAL_MAX								= 30;
	
	/**
	 * 休暇最大登録数(その他休暇)。
	 */
	public static final int		PRM_HOLIDAYTYPE_OTHER_MAX								= 50;
	
	/**
	 * 休暇最大登録数(欠勤)。
	 */
	public static final int		PRM_HOLIDAYTYPE_ABSENCE_MAX								= 20;
	
	/**
	 * ステータスコード(未申請)。
	 */
	public static final String	CODE_APPLICATION_STATUS_UNCLAIMED						= "Unclaimed";
	
	/**
	 * ステータスコード(下書)。
	 */
	public static final String	CODE_APPLICATION_STATUS_DRAFT							= "Draft";
	
	/**
	 * ステータスコード(未承認)。
	 */
	public static final String	CODE_APPLICATION_STATUS_UNAUTHORIZED					= "Unauthorized";
	
	/**
	 * 休日出勤申請の勤務予定の表示(申請する)。<br>
	 */
	public static final String	MODE_WORK_PLAN_APPLICATION_ON							= "1";
	
	/**
	 * 休日出勤申請の勤務予定の表示(申請しない)。<br>
	 */
	public static final String	MODE_WORK_PLAN_APPLICATION_OFF							= "2";
	
	/**
	 * 残業申請の予定超過の有り。<br>
	 */
	public static final String	SCHEDULE_OVER_FLAG_ON									= "1";
	
	/**
	 * 残業申請の予定超過の無し。<br>
	 */
	public static final String	SCHEDULE_OVER_FLAG_OFF									= "2";
	
	/**
	 * 機能コード(勤怠)。
	 */
	public static final String	CODE_FUNCTION_WORK_MANGE								= "1";
	
	/**
	 * 機能コード(残業)。
	 */
	public static final String	CODE_FUNCTION_OVER_WORK									= "2";
	
	/**
	 * 機能コード(休暇)。
	 */
	public static final String	CODE_FUNCTION_VACATION									= "3";
	
	/**
	 * 機能コード(休出)。
	 */
	public static final String	CODE_FUNCTION_WORK_HOLIDAY								= "4";
	
	/**
	 * 機能コード(代休)。
	 */
	public static final String	CODE_FUNCTION_COMPENSATORY_HOLIDAY						= "5";
	
	/**
	 * 機能コード(時差出勤)。
	 */
	public static final String	CODE_FUNCTION_DIFFERENCE								= "6";
	
	/**
	 * 有給休暇設定詳細の付与区分（基準日）。
	 */
	public static final int		CODE_PAID_HOLIDAY_TYPE_STANDARDSDAY						= 1;
	
	/**
	 * 勤怠詳細(勤怠形態の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_WORKTYPECODE					= "1";
	/**
	 * 勤怠詳細(出勤時刻の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_STARTTIME						= "2";
	/**
	 * 勤怠詳細(退勤時刻の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_ENDTIME						= "3";
	/**
	 * 勤怠詳細(直行の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_DIRECTSTART					= "4";
	/**
	 * 勤怠詳細(直帰の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_DIRECTEND						= "5";
	/**
	 * 勤怠詳細(遅刻理由の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_LATEREASON					= "6";
	/**
	 * 勤怠詳細(遅刻証明書の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_LATECERTIFICATE				= "7";
	/**
	 * 勤怠詳細(遅刻コメントの名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_LATECOMMENT					= "8";
	/**
	 * 勤怠詳細(早退理由の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYREASON				= "9";
	/**
	 * 勤怠詳細(早退証明書の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYCERTIFICATE			= "10";
	/**
	 * 勤怠詳細(早退コメントの名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYCOMMENT				= "11";
	/**
	 * 勤怠詳細(勤怠コメントの名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_TIMECOMMENT					= "12";
	/**
	 * 勤怠詳細(手当1の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE1					= "13";
	/**
	 * 勤怠詳細(手当2の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE2					= "14";
	/**
	 * 勤怠詳細(手当3の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE3					= "15";
	/**
	 * 勤怠詳細(手当4の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE4					= "16";
	/**
	 * 勤怠詳細(手当5の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE5					= "17";
	/**
	 * 勤怠詳細(手当6の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE6					= "18";
	/**
	 * 勤怠詳細(手当7の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE7					= "19";
	/**
	 * 勤怠詳細(手当8の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE8					= "20";
	/**
	 * 勤怠詳細(手当9の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE9					= "21";
	/**
	 * 勤怠詳細(手当10の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE10					= "22";
	/**
	 * 勤怠詳細(休憩1の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_BREAK1						= "23";
	/**
	 * 勤怠詳細(休憩2の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_BREAK2						= "24";
	/**
	 * 勤怠詳細(休憩3の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_BREAK3						= "25";
	/**
	 * 勤怠詳細(休憩4の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_BREAK4						= "26";
	/**
	 * 勤怠詳細(休憩5の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_BREAK5						= "27";
	/**
	 * 勤怠詳細(休憩6の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_BREAK6						= "28";
	/**
	 * 勤怠詳細(公用外出1の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_OFFICIAL_GOING_OUT1			= "29";
	/**
	 * 勤怠詳細(公用外出2の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_OFFICIAL_GOING_OUT2			= "30";
	/**
	 * 勤怠詳細(私用外出1の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_PRIVATE_GOING_OUT1			= "31";
	/**
	 * 勤怠詳細(私用外出2の名前)。
	 */
	public static final String	CODE_ATTENDANCE_ITEM_NAME_PRIVATE_GOING_OUT2			= "32";
	
	/**
	 * 承認詳細(処理対象タイトルの色を変える)。
	 */
	public static final String	NAME_CLASS_COLOR										= "EditTableTh";
	
	/**
	 * ファイルパス(MosP勤怠管理勤怠設定編集領域ヘッダJSP)。
	 */
	public static final String	PATH_SETTINGS_EDIT_HEADER_JSP							= "/jsp/time/settings/settingsEditHeader.jsp";
	
	/**
	 *  勤怠修正(勤務時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_WORKTIME						= "1";
	
	/**
	 *  勤怠修正(所定勤務時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_SPECIFICWORKTIME				= "2";
	
	/**
	 *  勤怠修正(出勤日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESWORKDATE					= "3";
	
	/**
	 *  勤怠修正(出勤回数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESWORK						= "4";
	
	/**
	 *  勤怠修正(法定休日出勤日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LEGALWORKONHOLIDAY				= "5";
	
	/**
	 *  勤怠修正(所定休日出勤日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_SPECIFICWORKONHOLIDAY			= "6";
	
	/**
	 *  勤怠修正(直行回数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_DIRECTSTART					= "7";
	
	/**
	 *  勤怠修正(直帰回数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_DIRECTEND						= "8";
	
	/**
	 *  勤怠修正(休憩時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_RESTTIME						= "9";
	
	/**
	 *  勤怠修正(深夜休憩時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_RESTLATENIGHT					= "10";
	
	/**
	 *  勤怠修正(深夜休憩時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_RESTWORKONSPECIFICHOLIDAY		= "11";
	
	/**
	 *  勤怠修正(法定休出休憩時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_RESTWORKONHOLIDAY				= "12";
	
	/**
	 *  勤怠修正(公用外出時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_PUBLICTIME						= "13";
	
	/**
	 *  勤怠修正(私用外出時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_PRIVATETIME					= "14";
	
	/**
	 *  勤怠修正(残業回数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESOVERTIME					= "15";
	
	/**
	 *  勤怠修正(残業時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_OVERTIMEIN						= "16";
	
	/**
	 *  勤怠修正(法定外残業時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_OVERTIMEOUT					= "17";
	
	/**
	 *  勤怠修正(深夜時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LATENIGHT						= "18";
	
	/**
	 *  勤怠修正(所定休出時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_WORKONSPECIFICHOLIDAY			= "19";
	
	/**
	 *  勤怠修正(法定休出時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_WORKONHOLIDAY					= "20";
	
	/**
	 *  勤怠修正(減額対象時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_DECREASETIME					= "21";
	
	/**
	 *  勤怠修正(45時間超残業時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_FORTYFIVEHOUROVERTIME			= "22";
	
	/**
	 *  勤怠修正(遅刻回数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESLATE						= "23";
	
	/**
	 *  勤怠修正(遅刻控除有り日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LATEDEDUCTION					= "24";
	
	/**
	 *  勤怠修正(遅刻控除無し日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LATENODEDUCTION				= "25";
	
	/**
	 *  勤怠修正(遅刻その他日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LATEOTHER						= "26";
	
	/**
	 *  勤怠修正(遅刻時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LATETIME						= "27";
	
	/**
	 *  勤怠修正(遅刻控除有り時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LATEDEDUCTIONTIME				= "28";
	
	/**
	 *  勤怠修正(遅刻控除無し時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LATENODEDUCTIONTIME			= "29";
	
	/**
	 *  勤怠修正(遅刻その他時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LATEOTHERTIME					= "30";
	
	/**
	 *  勤怠修正(早退回数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESLEAVEEARLY				= "31";
	
	/**
	 *  勤怠修正(早退控除有り日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYDEDUCTION			= "32";
	
	/**
	 *  勤怠修正(早退控除無し日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYNODEDUCTION			= "33";
	
	/**
	 *  勤怠修正(早退その他日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYOTHER				= "34";
	
	/**
	 *  勤怠修正(早退時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYTIME					= "35";
	
	/**
	 *  勤怠修正(早退控除有り時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYDEDUCTIONTIME		= "36";
	
	/**
	 *  勤怠修正(早退控除無し時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYNODEDUCTIONTIME		= "37";
	
	/**
	 *  勤怠修正(早退その他時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYOTHERTIME			= "38";
	
	/**
	 *  勤怠修正(休日日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESHOLIDAY					= "39";
	
	/**
	 *  勤怠修正(法定休日日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESLEGALHOLIDAY				= "40";
	
	/**
	 *  勤怠修正(所定休日日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESSPECIFICHOLIDAY			= "41";
	
	/**
	 *  勤怠修正(有給休暇日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESPAIDHOLIDAY				= "42";
	
	/**
	 *  勤怠修正(有給休暇時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_PAIDHOLIDAYHOUR				= "43";
	
	/**
	 *  勤怠修正(ストック休暇日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESSTOCKHOLIDAY				= "44";
	
	/**
	 *  勤怠修正(代休日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESCOMPENSATION				= "45";
	
	/**
	 *  勤怠修正(法定代休日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESLEGALCOMPENSATION			= "46";
	
	/**
	 *  勤怠修正(所定代休日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESSPECIFICCOMPENSATION		= "47";
	
	/**
	 *  勤怠修正(深夜代休日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESLATECOMPENSATION			= "48";
	
	/**
	 *  勤怠修正(振替休日日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESHOLIDAYSUBSTITUTE			= "49";
	
	/**
	 *  勤怠修正(法定振替休日日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESLEGALHOLIDAYSUBSTITUTE	= "50";
	
	/**
	 *  勤怠修正(所定振替休日日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESSPECIFICHOLIDAYSUBSTITUTE	= "51";
	
	/**
	 *  勤怠修正(特別休暇合計日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TOTALSPECIALHOLIDAY			= "52";
	
	/**
	 *  勤怠修正(その他休暇合計日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TOTALOTHERHOLIDAY				= "53";
	
	/**
	 *  勤怠修正(欠勤合計日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TOTALABSENCE					= "54";
	
	/**
	 *  勤怠修正(手当合計)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TOTALALLOWANCE					= "55";
	
	/**
	 *  勤怠修正(60時間超残業時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_SIXTYHOUROVERTIME				= "56";
	
	/**
	 *  勤怠修正(平日時間外時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_WEEKDAYOVERTIME				= "57";
	
	/**
	 *  勤怠修正(所定休日時間外時間)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_SPECIFICOVERTIME				= "58";
	
	/**
	 *  勤怠修正(代替休暇日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TIMESALTERNATIVE				= "59";
	
	/**
	 *  勤怠修正(特別休暇)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_TOTALLEAVE						= "61";
	
	/**
	 *  勤怠修正(その他休暇)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_OTHERVACATION					= "71";
	
	/**
	 *  勤怠修正(欠勤)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_ABSENCE						= "81";
	
	/**
	 *  勤怠修正(手当1)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_ALLOWANCE1						= "91";
	
	/**
	 *  勤怠修正(手当2)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_ALLOWANCE2						= "92";
	
	/**
	 *  勤怠修正(手当3)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_ALLOWANCE3						= "93";
	
	/**
	 *  勤怠修正(手当4)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_ALLOWANCE4						= "94";
	
	/**
	 *  勤怠修正(手当5)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_ALLOWANCE5						= "95";
	
	/**
	 *  勤怠修正(手当6)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_ALLOWANCE6						= "96";
	
	/**
	 *  勤怠修正(手当7)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_ALLOWANCE7						= "97";
	
	/**
	 *  勤怠修正(手当8)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_ALLOWANCE8						= "98";
	
	/**
	 *  勤怠修正(手当9)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_ALLOWANCE9						= "99";
	
	/**
	 *  勤怠修正(手当10)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_ALLOWANCE10					= "100";
	
	/**
	 * 勤怠修正(遅刻日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LATEDAYS						= "101";
	
	/**
	 * 勤怠修正(早退日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LEAVEEARLYDAYS					= "102";
	
	/**
	 * 勤怠修正(法定代休未使用日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LEGALCOMPENSATIONUNUSED		= "103";
	
	/**
	 * 勤怠修正(所定代休未使用日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_SPECIFICCOMPENSATIONUNUSED		= "104";
	
	/**
	 * 勤怠修正(深夜代休未使用日数)。
	 */
	public static final String	CODE_TOTALTIME_ITEM_NAME_LATECOMPENSATIONUNUSED			= "105";
	
	/**
	 *  集計項目1
	 */
	public static final String	CODE_COMMON_ITEMS_NUMBER1								= "1";
	
	/**
	 *  集計項目2
	 */
	public static final String	CODE_COMMON_ITEMS_NUMBER2								= "2";
	
	/**
	 *  集計項目3
	 */
	public static final String	CODE_COMMON_ITEMS_NUMBER3								= "3";
	
	/**
	 *  集計項目4
	 */
	public static final String	CODE_COMMON_ITEMS_NUMBER4								= "4";
	
	/**
	 *  集計項目5
	 */
	public static final String	CODE_COMMON_ITEMS_NUMBER5								= "5";
	
	/**
	 *  集計項目6
	 */
	public static final String	CODE_COMMON_ITEMS_NUMBER6								= "6";
	
	/**
	 *  集計項目7
	 */
	public static final String	CODE_COMMON_ITEMS_NUMBER7								= "7";
	
	/**
	 *  集計項目8
	 */
	public static final String	CODE_COMMON_ITEMS_NUMBER8								= "8";
	
	/**
	 *  集計項目9
	 */
	public static final String	CODE_COMMON_ITEMS_NUMBER9								= "9";
	
	/**
	 *  集計項目10
	 */
	public static final String	CODE_COMMON_ITEMS_NUMBER10								= "10";
	
	/**
	 *  表示日付更新用コード（一日進める）
	 */
	public static final String	CODE_DATE_INCREMENT										= "Increment";
	
	/**
	 *  表示日付更新用コード（一日戻る）
	 */
	public static final String	CODE_DATE_DECREMENT										= "Decrement";
	
	/**
	 *  表示日付更新用コード（日付リセット）
	 */
	public static final String	CODE_DATE_RESET											= "Reset";
	
	/**
	 *  代休種別コード（所定代休）
	 */
	public static final int		CODE_PRESCRIBED_SUBHOLIDAY_CODE							= 1;
	
	/**
	 *  代休種別コード（法定代休）
	 */
	public static final int		CODE_LEGAL_SUBHOLIDAY_CODE								= 2;
	
	/**
	 *  代休種別コード（深夜代休）
	 */
	public static final int		CODE_MIDNIGHT_SUBHOLIDAY_CODE							= 3;
	
	/**
	 *  勤怠設定の勤務前残業コード（有効）
	 */
	public static final int		CODE_BEFORE_OVERTIME_VALID								= 0;
	
	/**
	 *  勤怠設定の勤務前残業コード（無効）
	 */
	public static final int		CODE_BEFORE_OVERTIME_INVALID							= 1;
	
	/**
	 *  残業申請（勤務前残業）
	 */
	public static final int		CODE_OVERTIME_WORK_BEFORE								= 1;
	
	/**
	 * 残業申請（勤務後残業）
	 */
	public static final int		CODE_OVERTIME_WORK_AFTER								= 2;
	
	/**
	 * 検索条件（下書き）
	 */
	public static final String	CODE_SEARCH_STATUS_DRAFT								= "1";
	
	/**
	 * 検索条件（未承認）
	 */
	public static final String	CODE_SEARCH_STATUS_APPLY								= "2";
	
	/**
	 * 検索条件（承認済）
	 */
	public static final String	CODE_SEARCH_STATUS_COMPLETE								= "3";
	
	/**
	 * 検索条件（差戻）
	 */
	public static final String	CODE_SEARCH_STATUS_REVERT								= "4";
	
	/**
	 * 遅刻理由（個人都合）
	 */
	public static final String	CODE_TARDINESS_WHY_INDIVIDU								= "individu";
	
	/**
	 * 遅刻理由（体調不良）
	 */
	public static final String	CODE_TARDINESS_WHY_BAD_HEALTH							= "bad_health";
	
	/**
	 * 遅刻理由（その他）
	 */
	public static final String	CODE_TARDINESS_WHY_OTHERS								= "others";
	
	/**
	 * 遅刻理由（電車遅延）
	 */
	public static final String	CODE_TARDINESS_WHY_TRAIN								= "train";
	
	/**
	 * 遅刻理由（会社指示）
	 */
	public static final String	CODE_TARDINESS_WHY_COMPANY								= "company";
	
	/**
	 * 早退理由（個人都合）
	 */
	public static final String	CODE_LEAVEEARLY_WHY_INDIVIDU							= "individu";
	
	/**
	 * 早退理由（体調不良）
	 */
	public static final String	CODE_LEAVEEARLY_WHY_BAD_HEALTH							= "bad_health";
	
	/**
	 * 早退理由（その他）
	 */
	public static final String	CODE_LEAVEEARLY_WHY_OTHERS								= "others";
	
	/**
	 * 早退理由（会社指示）
	 */
	public static final String	CODE_LEAVEEARLY_WHY_COMPANY								= "company";
	
	/**
	 * 法定休日
	 */
	public static final String	CODE_HOLIDAY_LEGAL_HOLIDAY								= "legal_holiday";
	
	/**
	 * 所定休日
	 */
	public static final String	CODE_HOLIDAY_PRESCRIBED_HOLIDAY							= "prescribed_holiday";
	
	/**
	 * 法定休出
	 */
	public static final String	CODE_WORK_ON_LEGAL_HOLIDAY								= "work_on_legal";
	
	/**
	 * 所定休出
	 */
	public static final String	CODE_WORK_ON_PRESCRIBED_HOLIDAY							= "work_on_prescribed";
	
	/**
	 * 締日マスタ 月の末締
	 */
	public static final String	CODE_CUTOFF_TYPE_MONTH_END_CLOSING						= "month";
	
	/**
	 * 休日出勤申請 振替申請する。<br>
	 */
	public static final int		CODE_WORK_ON_HOLIDAY_SUBSTITUTE_ON						= 1;
	
	/**
	 * 休日出勤申請 振替申請しない。<br>
	 */
	public static final int		CODE_WORK_ON_HOLIDAY_SUBSTITUTE_OFF						= 2;
	/**
	 * 時差出勤申請 時差出勤区分A<br>
	 */
	public static final String	CODE_DIFFERENCE_TYPE_A									= "a";
	/**
	 * 時差出勤申請 時差出勤区分B<br>
	 */
	public static final String	CODE_DIFFERENCE_TYPE_B									= "b";
	/**
	 * 時差出勤申請 時差出勤区分C<br>
	 */
	public static final String	CODE_DIFFERENCE_TYPE_C									= "c";
	/**
	 * 時差出勤申請 時差出勤区分D<br>
	 */
	public static final String	CODE_DIFFERENCE_TYPE_D									= "d";
	/**
	 * 時差出勤申請 時差出勤区分S<br>
	 */
	public static final String	CODE_DIFFERENCE_TYPE_S									= "s";
	/**
	 * 休暇の範囲 全休<br>
	 */
	public static final int		CODE_HOLIDAY_RANGE_ALL									= 1;
	/**
	 * 休暇の範囲 午前休<br>
	 */
	public static final int		CODE_HOLIDAY_RANGE_AM									= 2;
	/**
	 * 休暇の範囲 午後休<br>
	 */
	public static final int		CODE_HOLIDAY_RANGE_PM									= 3;
	
	/**
	 * スタイル 背景黄色<br>
	 */
	public static final String	STYLE_BACKGROUND_YELLOW									= "style=\"background-color: yellow\"";
	
	/**
	 * 締日(月末締)。<br>
	 */
	public static final int		CUTOFF_DATE_LAST_DAY									= 0;
	
	/**
	 * 翌月締日の最大値。<br>
	 * この日よりも小さな締日は、翌月締となる。<br>
	 * 但し、月末締はこの限りでない。
	 */
	public static final int		CUTOFF_DATE_THIS_MONTH_MAX								= 15;
	
}
