/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.time.dao.settings.impl;

import java.util.ArrayList;
import java.util.List;

import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.time.dao.settings.TotalTimeDataDaoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdTotalTimeDataDto;

/**
 * 勤怠集計データDAOクラス。
 */
public class TmdTotalTimeDao extends PlatformDao implements TotalTimeDataDaoInterface {
	
	/**
	 * 勤怠集計データ。
	 */
	public static final String	TABLE									= "tmd_total_time";
	
	/**
	 * レコード識別ID。
	 */
	public static final String	COL_TMD_TOTAL_TIME_ID					= "tmd_total_time_id";
	
	/**
	 * 個人ID。
	 */
	public static final String	COL_PERSONAL_ID							= "personal_id";
	
	/**
	 * 年。
	 */
	public static final String	COL_CALCULATION_YEAR					= "calculation_year";
	
	/**
	 * 月。
	 */
	public static final String	COL_CALCULATION_MONTH					= "calculation_month";
	
	/**
	 * 集計日。
	 */
	public static final String	COL_CALCULATION_DATE					= "calculation_date";
	
	/**
	 * 勤務時間。
	 */
	public static final String	COL_WORK_TIME							= "work_time";
	
	/**
	 * 所定勤務時間。
	 */
	public static final String	COL_SPECIFIC_WORK_TIME					= "specific_work_time";
	
	/**
	 * 出勤日数。
	 */
	public static final String	COL_TIMES_WORK_DATE						= "times_work_date";
	
	/**
	 * 出勤回数。
	 */
	public static final String	COL_TIMES_WORK							= "times_work";
	
	/**
	 * 法定休日出勤日数。
	 */
	public static final String	COL_LEGAL_WORK_ON_HOLIDAY				= "legal_work_on_holiday";
	
	/**
	 * 所定休日出勤日数。
	 */
	public static final String	COL_SPECIFIC_WORK_ON_HOLIDAY			= "specific_work_on_holiday";
	
	/**
	 * 出勤実績日数。
	 */
	public static final String	COL_TIMES_ACHIEVEMENT					= "times_achievement";
	
	/**
	 *  出勤対象日数。
	 */
	public static final String	COL_TIMES_TOTAL_WORK_DATE				= "times_total_work_date";
	
	/**
	 * 直行回数。
	 */
	public static final String	COL_DIRECT_START						= "direct_start";
	
	/**
	 * 直帰回数。
	 */
	public static final String	COL_DIRECT_END							= "direct_end";
	
	/**
	 * 休憩時間。
	 */
	public static final String	COL_REST_TIME							= "rest_time";
	
	/**
	 * 深夜休憩時間。
	 */
	public static final String	COL_REST_LATE_NIGHT						= "rest_late_night";
	
	/**
	 * 所定休出休憩時間。
	 */
	public static final String	COL_REST_WORK_ON_SPECIFIC_HOLIDAY		= "rest_work_on_specific_holiday";
	
	/**
	 * 法定休出休憩時間。
	 */
	public static final String	COL_REST_WORK_ON_HOLIDAY				= "rest_work_on_holiday";
	
	/**
	 * 公用外出時間。
	 */
	public static final String	COL_PUBLIC_TIME							= "public_time";
	
	/**
	 * 私用外出時間。
	 */
	public static final String	COL_PRIVATE_TIME						= "private_time";
	
	/**
	 * 残業時間。
	 */
	public static final String	COL_OVERTIME							= "overtime";
	
	/**
	 * 法定内残業時間。
	 */
	public static final String	COL_OVERTIME_IN							= "overtime_in";
	
	/**
	 * 法定外残業時間。
	 */
	public static final String	COL_OVERTIME_OUT						= "overtime_out";
	
	/**
	 * 深夜時間。
	 */
	public static final String	COL_LATE_NIGHT							= "late_night";
	
	/**
	 * 所定休出時間。
	 */
	public static final String	COL_WORK_ON_SPECIFIC_HOLIDAY			= "work_on_specific_holiday";
	
	/**
	 * 法定休出時間。
	 */
	public static final String	COL_WORK_ON_HOLIDAY						= "work_on_holiday";
	
	/**
	 * 減額対象時間。
	 */
	public static final String	COL_DECREASE_TIME						= "decrease_time";
	
	/**
	 * 45時間超残業時間。
	 */
	public static final String	COL_FORTY_FIVE_HOUR_OVERTIME			= "forty_five_hour_overtime";
	
	/**
	 * 残業回数。
	 */
	public static final String	COL_TIMES_OVERTIME						= "times_overtime";
	
	/**
	 * 休日出勤回数。
	 */
	public static final String	COL_TIMES_WORKING_HOLIDAY				= "times_working_holiday";
	
	/**
	 * 遅刻日数。
	 */
	public static final String	COL_LATE_DAYS							= "late_days";
	
	/**
	 * 遅刻控除有り日数。
	 */
	public static final String	COL_LATE_DEDUCTION						= "late_deduction";
	
	/**
	 * 遅刻控除無し日数。
	 */
	public static final String	COL_LATE_NO_DEDUCTION					= "late_no_deduction";
	
	/**
	 * 遅刻その他日数。
	 */
	public static final String	COL_LATE_OTHER							= "late_other";
	
	/**
	 * 遅刻時間。
	 */
	public static final String	COL_LATE_TIME							= "late_time";
	
	/**
	 * 遅刻控除有り時間。
	 */
	public static final String	COL_LATE_DEDUCTION_TIME					= "late_deduction_time";
	
	/**
	 * 遅刻控除無し時間。
	 */
	public static final String	COL_LATE_NO_DEDUCTION_TIME				= "late_no_deduction_time";
	
	/**
	 * 遅刻その他時間。
	 */
	public static final String	COL_LATE_OTHER_TIME						= "late_other_time";
	
	/**
	 * 遅刻回数。
	 */
	public static final String	COL_TIMES_LATE							= "times_late";
	
	/**
	 * 早退日数。
	 */
	public static final String	COL_LEAVE_EARLY_DAYS					= "leave_early_days";
	
	/**
	 * 早退控除有り日数。
	 */
	public static final String	COL_LEAVE_EARLY_DEDUCTION				= "leave_early_deduction";
	
	/**
	 * 早退控除無し日数。
	 */
	public static final String	COL_LEAVE_EARLY_NO_DEDUCTION			= "leave_early_no_deduction";
	
	/**
	 * 早退その他日数。
	 */
	public static final String	COL_LEAVE_EARLY_OTHER					= "leave_early_other";
	
	/**
	 * 早退時間。
	 */
	public static final String	COL_LEAVE_EARLY_TIME					= "leave_early_time";
	
	/**
	 * 早退控除有り時間。
	 */
	public static final String	COL_LEAVE_EARLY_DEDUCTION_TIME			= "leave_early_deduction_time";
	
	/**
	 * 早退控除無し時間。
	 */
	public static final String	COL_LEAVE_EARLY_NO_DEDUCTION_TIME		= "leave_early_no_deduction_time";
	
	/**
	 * 早退その他時間。
	 */
	public static final String	COL_LEAVE_EARLY_OTHER_TIME				= "leave_early_other_time";
	
	/**
	 * 早退回数。
	 */
	public static final String	COL_TIMES_LEAVE_EARLY					= "times_leave_early";
	
	/**
	 * 休日日数。
	 */
	public static final String	COL_TIMES_HOLIDAY						= "times_holiday";
	
	/**
	 * 法定休日日数。
	 */
	public static final String	COL_TIMES_LEGAL_HOLIDAY					= "times_legal_holiday";
	
	/**
	 * 所定休日日数。
	 */
	public static final String	COL_TIMES_SPECIFIC_HOLIDAY				= "times_specific_holiday";
	
	/**
	 * 有給休暇日数。
	 */
	public static final String	COL_TIMES_PAID_HOLIDAY					= "times_paid_holiday";
	
	/**
	 * 有給休暇時間。
	 */
	public static final String	COL_PAID_HOLIDAY_HOUR					= "paid_holiday_hour";
	
	/**
	 * ストック休暇日数。
	 */
	public static final String	COL_TIMES_STOCK_HOLIDAY					= "times_stock_holiday";
	
	/**
	 * 代休日数。
	 */
	public static final String	COL_TIMES_COMPENSATION					= "times_compensation";
	
	/**
	 * 法定代休日数。
	 */
	public static final String	COL_TIMES_LEGAL_COMPENSATION			= "times_legal_compensation";
	
	/**
	 * 所定代休日数。
	 */
	public static final String	COL_TIMES_SPECIFIC_COMPENSATION			= "times_specific_compensation";
	
	/**
	 * 深夜代休日数。
	 */
	public static final String	COL_TIMES_LATE_COMPENSATION				= "times_late_compensation";
	
	/**
	 * 振替休日日数。
	 */
	public static final String	COL_TIMES_HOLIDAY_SUBSTITUTE			= "times_holiday_substitute";
	
	/**
	 * 法定振替休日日数。
	 */
	public static final String	COL_TIMES_LEGAL_HOLIDAY_SUBSTITUTE		= "times_legal_holiday_substitute";
	
	/**
	 * 所定振替休日日数。
	 */
	public static final String	COL_TIMES_SPECIFIC_HOLIDAY_SUBSTITUTE	= "times_specific_holiday_substitute";
	
	/**
	 * 特別休暇合計日数。
	 */
	public static final String	COL_TOTAL_SPECIAL_HOLIDAY				= "total_special_holiday";
	
	/**
	 * その他休暇合計日数。
	 */
	public static final String	COL_TOTAL_OTHER_HOLIDAY					= "total_other_holiday";
	
	/**
	 * 欠勤合計日数。
	 */
	public static final String	COL_TOTAL_ABSENCE						= "total_absence";
	
	/**
	 * 手当合計。
	 */
	public static final String	COL_TOTAL_ALLOWANCE						= "total_allowance";
	
	/**
	 * 60時間超残業時間。
	 */
	public static final String	COL_SIXTY_HOUR_OVERTIME					= "sixty_hour_overtime";
	
	/**
	 * 平日時間外時間。
	 */
	public static final String	COL_WEEK_DAY_OVERTIME					= "week_day_overtime";
	
	/**
	 * 所定休日時間外時間。
	 */
	public static final String	COL_SPECIFIC_OVERTIME					= "specific_overtime";
	
	/**
	 * 代替休暇日数。
	 */
	public static final String	COL_TIMES_ALTERNATIVE					= "times_alternative";
	
	/**
	 * 法定代休未使用日数。
	 */
	public static final String	COL_LEGAL_COMPENSATION_UNUSED			= "legal_compensation_unused";
	
	/**
	 * 所定代休未使用日数。
	 */
	public static final String	COL_SPECIFIC_COMPENSATION_UNUSED		= "specific_compensation_unused";
	
	/**
	 * 深夜代休未使用日数。
	 */
	public static final String	COL_LATE_COMPENSATION_UNUSED			= "late_compensation_unused";
	
	/**
	 * キー。
	 */
	public static final String	KEY_1									= COL_TMD_TOTAL_TIME_ID;
	

	/**
	 * コンストラクタ。
	 */
	public TmdTotalTimeDao() {
		// 処理無し
	}
	
	@Override
	public void initDao() {
		// 処理無し
	}
	
	@Override
	public BaseDto mapping() throws MospException {
		TmdTotalTimeDataDto dto = new TmdTotalTimeDataDto();
		dto.setTmdTotalTimeId(getLong(COL_TMD_TOTAL_TIME_ID));
		dto.setPersonalId(getString(COL_PERSONAL_ID));
		dto.setCalculationYear(getInt(COL_CALCULATION_YEAR));
		dto.setCalculationMonth(getInt(COL_CALCULATION_MONTH));
		dto.setCalculationDate(getDate(COL_CALCULATION_DATE));
		dto.setWorkTime(getInt(COL_WORK_TIME));
		dto.setSpecificWorkTime(getInt(COL_SPECIFIC_WORK_TIME));
		dto.setTimesWorkDate(getDouble(COL_TIMES_WORK_DATE));
		dto.setTimesWork(getInt(COL_TIMES_WORK));
		dto.setLegalWorkOnHoliday(getDouble(COL_LEGAL_WORK_ON_HOLIDAY));
		dto.setSpecificWorkOnHoliday(getDouble(COL_SPECIFIC_WORK_ON_HOLIDAY));
		dto.setTimesAchievement(getInt(COL_TIMES_ACHIEVEMENT));
		dto.setTimesTotalWorkDate(getInt(COL_TIMES_TOTAL_WORK_DATE));
		dto.setDirectStart(getInt(COL_DIRECT_START));
		dto.setDirectEnd(getInt(COL_DIRECT_END));
		dto.setRestTime(getInt(COL_REST_TIME));
		dto.setRestLateNight(getInt(COL_REST_LATE_NIGHT));
		dto.setRestWorkOnSpecificHoliday(getInt(COL_REST_WORK_ON_SPECIFIC_HOLIDAY));
		dto.setRestWorkOnHoliday(getInt(COL_REST_WORK_ON_HOLIDAY));
		dto.setPublicTime(getInt(COL_PUBLIC_TIME));
		dto.setPrivateTime(getInt(COL_PRIVATE_TIME));
		dto.setOvertime(getInt(COL_OVERTIME));
		dto.setOvertimeIn(getInt(COL_OVERTIME_IN));
		dto.setOvertimeOut(getInt(COL_OVERTIME_OUT));
		dto.setLateNight(getInt(COL_LATE_NIGHT));
		dto.setWorkOnSpecificHoliday(getInt(COL_WORK_ON_SPECIFIC_HOLIDAY));
		dto.setWorkOnHoliday(getInt(COL_WORK_ON_HOLIDAY));
		dto.setDecreaseTime(getInt(COL_DECREASE_TIME));
		dto.setFortyFiveHourOvertime(getInt(COL_FORTY_FIVE_HOUR_OVERTIME));
		dto.setTimesOvertime(getInt(COL_TIMES_OVERTIME));
		dto.setTimesWorkingHoliday(getInt(COL_TIMES_WORKING_HOLIDAY));
		dto.setLateDays(getInt(COL_LATE_DAYS));
		dto.setLateDeduction(getInt(COL_LATE_DEDUCTION));
		dto.setLateNoDeduction(getInt(COL_LATE_NO_DEDUCTION));
		dto.setLateOther(getInt(COL_LATE_OTHER));
		dto.setLateTime(getInt(COL_LATE_TIME));
		dto.setLateDeductionTime(getInt(COL_LATE_DEDUCTION_TIME));
		dto.setLateNoDeductionTime(getInt(COL_LATE_NO_DEDUCTION_TIME));
		dto.setLateOtherTime(getInt(COL_LATE_OTHER_TIME));
		dto.setTimesLate(getInt(COL_TIMES_LATE));
		dto.setLeaveEarlyDays(getInt(COL_LEAVE_EARLY_DAYS));
		dto.setLeaveEarlyDeduction(getInt(COL_LEAVE_EARLY_DEDUCTION));
		dto.setLeaveEarlyNoDeduction(getInt(COL_LEAVE_EARLY_NO_DEDUCTION));
		dto.setLeaveEarlyOther(getInt(COL_LEAVE_EARLY_OTHER));
		dto.setLeaveEarlyTime(getInt(COL_LEAVE_EARLY_TIME));
		dto.setLeaveEarlyDeductionTime(getInt(COL_LEAVE_EARLY_DEDUCTION_TIME));
		dto.setLeaveEarlyNoDeductionTime(getInt(COL_LEAVE_EARLY_NO_DEDUCTION_TIME));
		dto.setLeaveEarlyOtherTime(getInt(COL_LEAVE_EARLY_OTHER_TIME));
		dto.setTimesLeaveEarly(getInt(COL_TIMES_LEAVE_EARLY));
		dto.setTimesHoliday(getInt(COL_TIMES_HOLIDAY));
		dto.setTimesLegalHoliday(getInt(COL_TIMES_LEGAL_HOLIDAY));
		dto.setTimesSpecificHoliday(getInt(COL_TIMES_SPECIFIC_HOLIDAY));
		dto.setTimesPaidHoliday(getDouble(COL_TIMES_PAID_HOLIDAY));
		dto.setPaidHolidayHour(getInt(COL_PAID_HOLIDAY_HOUR));
		dto.setTimesStockHoliday(getDouble(COL_TIMES_STOCK_HOLIDAY));
		dto.setTimesCompensation(getDouble(COL_TIMES_COMPENSATION));
		dto.setTimesLegalCompensation(getDouble(COL_TIMES_LEGAL_COMPENSATION));
		dto.setTimesSpecificCompensation(getDouble(COL_TIMES_SPECIFIC_COMPENSATION));
		dto.setTimesLateCompensation(getDouble(COL_TIMES_LATE_COMPENSATION));
		dto.setTimesHolidaySubstitute(getDouble(COL_TIMES_HOLIDAY_SUBSTITUTE));
		dto.setTimesLegalHolidaySubstitute(getDouble(COL_TIMES_LEGAL_HOLIDAY_SUBSTITUTE));
		dto.setTimesSpecificHolidaySubstitute(getDouble(COL_TIMES_SPECIFIC_HOLIDAY_SUBSTITUTE));
		dto.setTotalSpecialHoliday(getDouble(COL_TOTAL_SPECIAL_HOLIDAY));
		dto.setTotalOtherHoliday(getDouble(COL_TOTAL_OTHER_HOLIDAY));
		dto.setTotalAbsence(getInt(COL_TOTAL_ABSENCE));
		dto.setTotalAllowance(getInt(COL_TOTAL_ALLOWANCE));
		dto.setSixtyHourOvertime(getInt(COL_SIXTY_HOUR_OVERTIME));
		dto.setWeekDayOvertime(getInt(COL_WEEK_DAY_OVERTIME));
		dto.setSpecificOvertime(getInt(COL_SPECIFIC_OVERTIME));
		dto.setTimesAlternative(getDouble(COL_TIMES_ALTERNATIVE));
		dto.setLegalCompensationUnused(getDouble(COL_LEGAL_COMPENSATION_UNUSED));
		dto.setSpecificCompensationUnused(getDouble(COL_SPECIFIC_COMPENSATION_UNUSED));
		dto.setLateCompensationUnused(getDouble(COL_LATE_COMPENSATION_UNUSED));
		mappingCommonInfo(dto);
		return dto;
	}
	
	@Override
	public List<TotalTimeDataDtoInterface> mappingAll() throws MospException {
		List<TotalTimeDataDtoInterface> all = new ArrayList<TotalTimeDataDtoInterface>();
		while (next()) {
			all.add((TotalTimeDataDtoInterface)mapping());
		}
		return all;
	}
	
	@Override
	public TotalTimeDataDtoInterface findForKey(String personalId, int calculationYear, int calculationMonth)
			throws MospException {
		try {
			index = 1;
			StringBuffer sb = getSelectQuery(getClass());
			sb.append(where());
			sb.append(deleteFlagOff());
			sb.append(and());
			sb.append(equal(COL_PERSONAL_ID));
			sb.append(and());
			sb.append(equal(COL_CALCULATION_YEAR));
			sb.append(and());
			sb.append(equal(COL_CALCULATION_MONTH));
			prepareStatement(sb.toString());
			setParam(index++, personalId);
			setParam(index++, calculationYear);
			setParam(index++, calculationMonth);
			executeQuery();
			TotalTimeDataDtoInterface dto = null;
			if (next()) {
				dto = (TotalTimeDataDtoInterface)mapping();
			}
			return dto;
		} catch (Throwable e) {
			throw new MospException(e);
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	@Override
	public int update(BaseDtoInterface baseDto) throws MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(baseDto, false);
			TotalTimeDataDtoInterface dto = (TotalTimeDataDtoInterface)baseDto;
			setParam(index++, dto.getTmdTotalTimeId());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (Throwable e) {
			throw new MospException(e);
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	@Override
	public int delete(BaseDtoInterface baseDto) throws MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			TotalTimeDataDtoInterface dto = (TotalTimeDataDtoInterface)baseDto;
			setParam(index++, dto.getTmdTotalTimeId());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (Throwable e) {
			throw new MospException(e);
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	@Override
	public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
		TotalTimeDataDtoInterface dto = (TotalTimeDataDtoInterface)baseDto;
		setParam(index++, dto.getTmdTotalTimeId());
		setParam(index++, dto.getPersonalId());
		setParam(index++, dto.getCalculationYear());
		setParam(index++, dto.getCalculationMonth());
		setParam(index++, dto.getCalculationDate());
		setParam(index++, dto.getWorkTime());
		setParam(index++, dto.getSpecificWorkTime());
		setParam(index++, dto.getTimesWorkDate());
		setParam(index++, dto.getTimesWork());
		setParam(index++, dto.getLegalWorkOnHoliday());
		setParam(index++, dto.getSpecificWorkOnHoliday());
		setParam(index++, dto.getTimesAchievement());
		setParam(index++, dto.getTimesTotalWorkDate());
		setParam(index++, dto.getDirectStart());
		setParam(index++, dto.getDirectEnd());
		setParam(index++, dto.getRestTime());
		setParam(index++, dto.getRestLateNight());
		setParam(index++, dto.getRestWorkOnSpecificHoliday());
		setParam(index++, dto.getRestWorkOnHoliday());
		setParam(index++, dto.getPublicTime());
		setParam(index++, dto.getPrivateTime());
		setParam(index++, dto.getOvertime());
		setParam(index++, dto.getOvertimeIn());
		setParam(index++, dto.getOvertimeOut());
		setParam(index++, dto.getLateNight());
		setParam(index++, dto.getWorkOnSpecificHoliday());
		setParam(index++, dto.getWorkOnHoliday());
		setParam(index++, dto.getDecreaseTime());
		setParam(index++, dto.getFortyFiveHourOvertime());
		setParam(index++, dto.getTimesOvertime());
		setParam(index++, dto.getTimesWorkingHoliday());
		setParam(index++, dto.getLateDays());
		setParam(index++, dto.getLateDeduction());
		setParam(index++, dto.getLateNoDeduction());
		setParam(index++, dto.getLateOther());
		setParam(index++, dto.getLateTime());
		setParam(index++, dto.getLateDeductionTime());
		setParam(index++, dto.getLateNoDeductionTime());
		setParam(index++, dto.getLateOtherTime());
		setParam(index++, dto.getTimesLate());
		setParam(index++, dto.getLeaveEarlyDays());
		setParam(index++, dto.getLeaveEarlyDeduction());
		setParam(index++, dto.getLeaveEarlyNoDeduction());
		setParam(index++, dto.getLeaveEarlyOther());
		setParam(index++, dto.getLeaveEarlyTime());
		setParam(index++, dto.getLeaveEarlyDeductionTime());
		setParam(index++, dto.getLeaveEarlyNoDeductionTime());
		setParam(index++, dto.getLeaveEarlyOtherTime());
		setParam(index++, dto.getTimesLeaveEarly());
		setParam(index++, dto.getTimesHoliday());
		setParam(index++, dto.getTimesLegalHoliday());
		setParam(index++, dto.getTimesSpecificHoliday());
		setParam(index++, dto.getTimesPaidHoliday());
		setParam(index++, dto.getPaidHolidayHour());
		setParam(index++, dto.getTimesStockHoliday());
		setParam(index++, dto.getTimesCompensation());
		setParam(index++, dto.getTimesLegalCompensation());
		setParam(index++, dto.getTimesSpecificCompensation());
		setParam(index++, dto.getTimesLateCompensation());
		setParam(index++, dto.getTimesHolidaySubstitute());
		setParam(index++, dto.getTimesLegalHolidaySubstitute());
		setParam(index++, dto.getTimesSpecificHolidaySubstitute());
		setParam(index++, dto.getTotalSpecialHoliday());
		setParam(index++, dto.getTotalOtherHoliday());
		setParam(index++, dto.getTotalAbsence());
		setParam(index++, dto.getTotalAllowance());
		setParam(index++, dto.getSixtyHourOvertime());
		setParam(index++, dto.getWeekDayOvertime());
		setParam(index++, dto.getSpecificOvertime());
		setParam(index++, dto.getTimesAlternative());
		setParam(index++, dto.getLegalCompensationUnused());
		setParam(index++, dto.getSpecificCompensationUnused());
		setParam(index++, dto.getLateCompensationUnused());
		setCommonParams(baseDto, isInsert);
	}
	
	@Override
	public List<TotalTimeDataDtoInterface> findForList(String[] personalIdArray, int calculationYear,
			int calculationMonth) throws MospException {
		try {
			index = 1;
			StringBuffer sb = getSelectQuery(getClass());
			sb.append(where());
			sb.append(deleteFlagOff());
			sb.append(and());
			sb.append(equal(COL_CALCULATION_YEAR));
			sb.append(and());
			sb.append(equal(COL_CALCULATION_MONTH));
			if (personalIdArray != null && personalIdArray.length > 0) {
				sb.append(and());
				sb.append(COL_PERSONAL_ID);
				sb.append(in());
				sb.append(leftParenthesis());
				for (int i = 0; i < personalIdArray.length; i++) {
					if (i != 0) {
						sb.append(", ");
					}
					sb.append("?");
				}
				sb.append(rightParenthesis());
			}
			prepareStatement(sb.toString());
			setParam(index++, calculationYear);
			setParam(index++, calculationMonth);
			if (personalIdArray != null) {
				for (String personalId : personalIdArray) {
					setParam(index++, personalId);
				}
			}
			executeQuery();
			return mappingAll();
		} catch (Throwable e) {
			throw new MospException(e);
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
}
