/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.portal.bean.impl;

import java.sql.Connection;
import java.util.List;
import java.util.Map;

import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.portal.PortalBeanInterface;
import jp.mosp.platform.bean.portal.impl.PortalBean;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.constant.TimeConst;
import jp.mosp.time.dto.settings.ManagementRequestListDtoInterface;

/**
 * ポータル画面未承認一覧表示クラス。
 * 勤怠管理権限者にしか表示しない。
 * 表示を押下すると検索一覧を表示した未承認管理一覧へ遷移。
 */
public class PortalApprovalListBean extends PortalBean implements PortalBeanInterface {
	
	/**
	 * パス(ポータル用メッセージJSP)。
	 */
	protected static final String		PATH_PORTAL_VIEW							= "/jsp/time/portal/portalApprovalList.jsp";
	
	/**
	 * 承認情報参照インターフェース。
	 */
	ApprovalInfoReferenceBeanInterface	approvalInfoReference;
	
	/**
	 * ポータルパラメータキー(勤怠承認)
	 */
	public static final String			PRM_APPROVAL_LIST_WORK_MANAGE				= "Attendance";
	
	/**
	 * 
	 * ポータルパラメータキー(残業承認)
	 */
	public static final String			PRM_APPROVAL_LIST_OVERTIME_WORK				= "Overtime";
	
	/**
	 * ポータルパラメータキー(休暇承認)
	 */
	public static final String			PRM_APPROVAL_LIST_VACATION					= "Holiday";
	
	/**
	 * ポータルパラメータキー(休日出勤承認)
	 */
	public static final String			PRM_APPROVAL_LIST_HOLIDAY_GOINGWORK			= "WorkOnHoliday";
	
	/**
	 * ポータルパラメータキー(代休承認)
	 */
	public static final String			PRM_APPROVAL_LIST_COMPENSATORY_HOLIDAY		= "SubHoliday";
	
	/**
	 * ポータルパラメータキー(時差出勤承認)
	 */
	public static final String			PRM_APPROVAL_LIST_TIME_DIFFERENCE_GOINGWORK	= "ApprovedDifference";
	
	/**
	 * ポータルパラメータキー(全承認)
	 */
	public static final String			PRM_APPROVAL_LIST_ALL_APPROVAL				= "AllApproval";
	

	/**
	 * {@link PortalBean#PortalBean()}を実行する。<br>
	 */
	public PortalApprovalListBean() {
		super();
	}
	
	/**
	 * {@link PortalBean#PortalBean(MospParams, Connection)}を実行する。<br>
	 * @param mospParams MosP処理情報
	 * @param connection DBコネクション
	 */
	protected PortalApprovalListBean(MospParams mospParams, Connection connection) {
		super(mospParams, connection);
	}
	
	@Override
	public void initBean() throws MospException {
		// 参照クラス準備
		approvalInfoReference = (ApprovalInfoReferenceBeanInterface)createBean(ApprovalInfoReferenceBeanInterface.class);
	}
	
	/**
	 * 初期表示処理を行う。<br>
	 * @throws MospException 例外処理発生時
	 */
	@Override
	public void show() throws MospException {
		
		// 承認権限確認
		if (mospParams.getProperties().getRoleProperties().get(mospParams.getUser().getRole()).isApprover() == false) {
			return;
		}
		// ポータル用JSPパス追加
		addPortalViewList(PATH_PORTAL_VIEW);
		setVoList();
	}
	
	/**
	 *  
	 */
	@Override
	public void regist() {
		// 処理なし
		
	}
	
	/**
	 * 画面上部に出力する各未承認件数の取得を行う。<br>
	 * @throws MospException 未承認情報の取得に失敗した場合
	 */
	protected void setVoList() throws MospException {
		
		// 各承認件数の取得
		Map<String, List<ManagementRequestListDtoInterface>> map = approvalInfoReference.getNonApprovedMap(mospParams
			.getUser().getPersonalId(), "");
		List<ManagementRequestListDtoInterface> listAttendance = map.get(TimeConst.CODE_FUNCTION_WORK_MANGE);
		List<ManagementRequestListDtoInterface> listOverTime = map.get(TimeConst.CODE_FUNCTION_OVER_WORK);
		List<ManagementRequestListDtoInterface> listHoliday = map.get(TimeConst.CODE_FUNCTION_VACATION);
		List<ManagementRequestListDtoInterface> listWorkOnHoliday = map.get(TimeConst.CODE_FUNCTION_WORK_HOLIDAY);
		List<ManagementRequestListDtoInterface> listSubHoilday = map.get(TimeConst.CODE_FUNCTION_COMPENSATORY_HOLIDAY);
		List<ManagementRequestListDtoInterface> listDifference = map.get(TimeConst.CODE_FUNCTION_DIFFERENCE);
		
		int attendanceCount = listAttendance.size();
		int overTimeCount = listOverTime.size();
		int holidayCount = listHoliday.size();
		int workOnHolidayCount = listWorkOnHoliday.size();
		int subHolidayCount = listSubHoilday.size();
		int differenceCount = listDifference.size();
		
		// データをVOに設定
		putPortalParameter(PRM_APPROVAL_LIST_WORK_MANAGE, String.valueOf(attendanceCount));
		putPortalParameter(PRM_APPROVAL_LIST_OVERTIME_WORK, String.valueOf(overTimeCount));
		putPortalParameter(PRM_APPROVAL_LIST_VACATION, String.valueOf(holidayCount));
		putPortalParameter(PRM_APPROVAL_LIST_HOLIDAY_GOINGWORK, String.valueOf(workOnHolidayCount));
		putPortalParameter(PRM_APPROVAL_LIST_COMPENSATORY_HOLIDAY, String.valueOf(subHolidayCount));
		putPortalParameter(PRM_APPROVAL_LIST_TIME_DIFFERENCE_GOINGWORK, String.valueOf(differenceCount));
		putPortalParameter(PRM_APPROVAL_LIST_ALL_APPROVAL, String.valueOf(attendanceCount + overTimeCount
				+ holidayCount + workOnHolidayCount + subHolidayCount + differenceCount));
	}
	
}
