/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;
import jp.sf.orangesignal.csv.filters.CsvValueFilter;
import jp.sf.orangesignal.csv.handlers.AbstractCsvListHandler;

public class ColumnPositionMapListHandler
extends AbstractCsvListHandler<Map<Integer, String>, ColumnPositionMapListHandler> {
    private CsvValueFilter valueFilter;

    public ColumnPositionMapListHandler filter(CsvValueFilter filter) {
        this.valueFilter = filter;
        return this;
    }

    @Override
    public List<Map<Integer, String>> load(CsvReader reader, boolean ignoreScalar) throws IOException {
        List<String> values;
        ArrayList<Map<Integer, String>> results = new ArrayList<Map<Integer, String>>();
        int offset = 0;
        while ((values = reader.readValues()) != null && (ignoreScalar || this.limit <= 0 || results.size() < this.limit)) {
            if (this.valueFilter != null && !this.valueFilter.accept(values)) continue;
            if (!ignoreScalar && offset < this.offset) {
                ++offset;
                continue;
            }
            TreeMap<Integer, String> map = new TreeMap<Integer, String>();
            int len = values.size();
            for (int pos = 0; pos < len; ++pos) {
                map.put(pos, values.get(pos));
            }
            results.add(map);
        }
        return results;
    }

    @Override
    public void save(List<Map<Integer, String>> list, CsvWriter writer) throws IOException {
        for (Map<Integer, String> map : list) {
            if (map == null) {
                writer.writeValues(null);
                continue;
            }
            String[] values = new String[ColumnPositionMapListHandler.getMaxColumnPosition(map) + 1];
            for (Map.Entry<Integer, String> e : map.entrySet()) {
                int pos = e.getKey();
                if (pos < 0) continue;
                values[pos] = e.getValue();
            }
            List<String> _values = Arrays.asList(values);
            if (this.valueFilter != null && !this.valueFilter.accept(_values)) continue;
            writer.writeValues(_values);
        }
    }

    private static int getMaxColumnPosition(Map<Integer, String> map) {
        TreeMap<Integer, String> m = map instanceof SortedMap ? (TreeMap<Integer, String>)map : new TreeMap<Integer, String>(map);
        return Math.max((Integer)m.lastKey(), 0);
    }
}

