/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.SplitTypeEnum;

public class JRBaseBand
extends JRBaseElementGroup
implements JRBand,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_SPLIT_ALLOWED = "splitAllowed";
    public static final String PROPERTY_SPLIT_TYPE = "splitType";
    protected int height;
    protected SplitTypeEnum splitTypeValue;
    protected JRExpression printWhenExpression;
    private transient JRPropertyChangeSupport eventSupport;
    private int PSEUDO_SERIAL_VERSION_UID = 30705;
    private boolean isSplitAllowed = true;
    private Byte splitType;

    protected JRBaseBand(JRBand band, JRBaseObjectFactory factory) {
        super(band, factory);
        this.height = band.getHeight();
        this.splitTypeValue = band.getSplitTypeValue();
        this.printWhenExpression = factory.getExpression(band.getPrintWhenExpression());
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isSplitAllowed() {
        return !JRBand.SPLIT_TYPE_PREVENT.equals(this.getSplitType());
    }

    public void setSplitAllowed(boolean isSplitAllowed) {
        this.setSplitType(isSplitAllowed ? JRBand.SPLIT_TYPE_STRETCH : JRBand.SPLIT_TYPE_PREVENT);
    }

    public Byte getSplitType() {
        return this.getSplitTypeValue() == null ? null : this.getSplitTypeValue().getValueByte();
    }

    public SplitTypeEnum getSplitTypeValue() {
        return this.splitTypeValue;
    }

    public void setSplitType(Byte splitType) {
        this.setSplitType(SplitTypeEnum.getByValue(splitType));
    }

    public void setSplitType(SplitTypeEnum splitTypeValue) {
        SplitTypeEnum old = this.splitTypeValue;
        this.splitTypeValue = splitTypeValue;
        this.getEventSupport().firePropertyChange(PROPERTY_SPLIT_TYPE, old, this.splitTypeValue);
    }

    public JRExpression getPrintWhenExpression() {
        return this.printWhenExpression;
    }

    public Object clone() {
        JRBaseBand clone = (JRBaseBand)super.clone();
        if (this.printWhenExpression != null) {
            clone.printWhenExpression = (JRExpression)this.printWhenExpression.clone();
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseBand jRBaseBand = this;
        synchronized (jRBaseBand) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30502) {
            Byte by = this.splitType = this.isSplitAllowed ? JRBand.SPLIT_TYPE_STRETCH : JRBand.SPLIT_TYPE_PREVENT;
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.splitTypeValue = SplitTypeEnum.getByValue(this.splitType);
            this.splitType = null;
        }
    }
}

