/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.bean.human;

import java.util.Date;
import java.util.List;

import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.entity.EmployeeEntityInterface;

/**
 * 社員情報参照インターフェース
 */
public interface EmployeeReferenceBeanInterface {
	
	/**
	 * 社員情報。
	 * <p>
	 * 個人IDと対象年月日から人事マスタDTOを取得し、社員情報Entityを生成する。
	 * </p>
	 * @param personalId 個人ID
	 * @param targetDate 対象年月日
	 * @return 社員情報
	 * @throws Exception 例外処理が発生した場合。
	 */
	EmployeeEntityInterface getEntity(String personalId, Date targetDate) throws Exception;
	
	/**
	 * 社員情報。
	 * <p>
	 * 人事マスタDTOと対象年月日から社員情報Entityを生成する。
	 * </p>
	 * @param dto 対象人事マスタDTO
	 * @param targetDate 対象年月日
	 * @return 社員情報
	 * @throws Exception 例外処理が発生した場合。
	 */
	EmployeeEntityInterface getEntity(HumanDtoInterface dto, Date targetDate) throws Exception;
	
	/**
	 * 社員情報一覧。
	 * <p>
	 * 人事マスタリストと対象年月日から、社員情報リストを生成する。
	 * </p>
	 * @param humanlist 人事マスタリスト
	 * @param targetDate 対象年月日
	 * @return 社員情報リスト
	 * @throws Exception 例外処理が発生した場合。
	 */
	List<EmployeeEntityInterface> getEntityList(List<HumanDtoInterface> humanlist, Date targetDate) throws Exception;
	
}
