/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.setup.action;

import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformAction;
import jp.mosp.platform.portal.action.IndexAction;
import jp.mosp.setup.bean.DbCreateBean;
import jp.mosp.setup.vo.DbConfirmVo;

/**
 * 
 * DBの接続先とポート番号を取得。<br>
 * DBと接続する。<br>
 */
public class DbConfirmAction extends PlatformAction {
	
	/**
	 *  表示コマンド。<br>
	 *  <br>
	 *  初期表示を行う。<br>
	 */
	public static final String		CMD_SHOW	= "SU1000";
	
	/**
	 *  確認コマンド。<br>
	 *  <br>
	 *  DBと接続が可能か確認を行う。<br>
	 */
	public static final String		CMD_CHECK	= "SU1001";
	
	/**
	 * あらかじめ表示させるサーバ名。<br>
	 */
	protected static final String	SN			= "localhost";
	
	/**
	 * あらかじめ表示させるポート番号。<br>
	 */
	protected static final String	PB			= "5432";
	

	/**
	 * 各コマンドの処理を実行する。<br>
	 * 
	 */
	@Override
	public void action() throws MospException {
		// コマンド毎の処理
		if (mospParams.getCommand().equals(CMD_SHOW)) {
			// 表示
			prepareVo(false, false);
			show();
		} else if (mospParams.getCommand().equals(CMD_CHECK)) {
			// 接続確認
			prepareVo();
			conection();
		}
	}
	
	/**
	 * 初期表示処理を行う。<br>
	 * @throws MospException 表示に失敗した場合
	 */
	protected void show() throws MospException {
		// Beanを呼び出す
		DbCreateBean bean = new DbCreateBean();
		// DBcreateBeanにmospParamsをセット
		bean.setMospParams(mospParams);
		// 初めてではなかったらMosP画面へ
		if (bean.confirmDbCreation()) {
			// 繋がったらMosPへ
			mospParams.setNextCommand(IndexAction.CMD_SHOW);
			return;
		}
		// VOを呼び出す
		DbConfirmVo vo = (DbConfirmVo)mospParams.getVo();
		// あらかじめ項目に表示させる
		vo.setTxtServer(SN);
		vo.setTxtPort(PB);
	}
	
	/**
	 * DBに接続できるか確認し、接続する。<br>
	 * @throws MospException インスタンスの取得或いはSQL実行に失敗した場合
	 */
	protected void conection() throws MospException {
		// VOを呼び出す
		DbConfirmVo vo = (DbConfirmVo)mospParams.getVo();
		// Beanを呼び出す
		DbCreateBean bean = new DbCreateBean();
		// DBcreateBeanにmospParamsをセット
		bean.setMospParams(mospParams);
		// 初めてではなかったらMosP画面へ
		if (bean.confirmDbCreation()) {
			// 繋がったらMosPへ
			mospParams.setNextCommand(IndexAction.CMD_SHOW);
			return;
		}
		// 接続確認のための値を代入
		String serverName = vo.getTxtServer();
		String port = vo.getTxtPort();
		String dbName = DbCreateBean.NAME_POSTGRES;
		String user = DbCreateBean.NAME_POSTGRES;
		String pass = vo.getTxtPostgresPass();
		// 接続確認
		bean.createConectionn(serverName, port, dbName, user, pass);
		if (mospParams.hasErrorMessage()) {
			return;
		}
		// Connection開放
		bean.connEnd();
		// 次画面へ
		mospParams.setNextCommand(DbCreateAction.CMD_SHOW);
	}
	
	/**
	 * この画面で使うVOを決めている。<br>
	 * @return 取得したVOインスタンス
	 */
	@Override
	protected DbConfirmVo getSpecificVo() {
		return new DbConfirmVo();
	}
	
}
