/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.time.dto.settings;

import java.util.Date;

import jp.mosp.framework.base.BaseDtoInterface;

/**
 * 勤怠データDTOインターフェース
 */
public interface AttendanceDtoInterface extends BaseDtoInterface {
	
	/**
	 * @return レコード識別ID。
	 */
	long getTmdAttendanceId();
	
	/**
	 * @return 個人ID。
	 */
	String getPersonalId();
	
	/**
	 * @return 勤務日。
	 */
	Date getWorkDate();
	
	/**
	 * @return 勤務回数。
	 */
	int getTimesWork();
	
	/**
	 * @return 勤務形態コード。
	 */
	String getWorkTypeCode();
	
	/**
	 * @return 直行。
	 */
	int getDirectStart();
	
	/**
	 * @return 直帰。
	 */
	int getDirectEnd();
	
	/**
	 * @return 出勤時刻。
	 */
	Date getStartTime();
	
	/**
	 * @return 退勤時刻。
	 */
	Date getEndTime();
	
	/**
	 * @return 遅刻時間。
	 */
	int getLateTime();
	
	/**
	 * @return 遅刻理由。
	 */
	String getLateReason();
	
	/**
	 * @return 遅刻証明書。
	 */
	String getLateCertificate();
	
	/**
	 * @return 遅刻コメント。
	 */
	String getLateComment();
	
	/**
	 * @return 早退時間。
	 */
	int getLeaveEarlyTime();
	
	/**
	 * @return 早退理由。
	 */
	String getLeaveEarlyReason();
	
	/**
	 * @return 早退証明書。
	 */
	String getLeaveEarlyCertificate();
	
	/**
	 * @return 早退コメント。
	 */
	String getLeaveEarlyComment();
	
	/**
	 * @return 勤務時間。
	 */
	int getWorkTime();
	
	/**
	 * @return 所定労働時間。
	 */
	int getGeneralWorkTime();
	
	/**
	 * @return 休憩時間。
	 */
	int getRestTime();
	
	/**
	 * @return 法定外休憩時間。
	 */
	int getOverRestTime();
	
	/**
	 * @return 深夜休憩時間。
	 */
	int getNightRestTime();
	
	/**
	 * @return 公用外出時間。
	 */
	int getPublicTime();
	
	/**
	 * @return 私用外出時間。
	 */
	int getPrivateTime();
	
	/**
	 * @return 残業時間。
	 */
	int getOvertime();
	
	/**
	 * @return 前残業時間。
	 */
	int getOvertimeBefore();
	
	/**
	 * @return 後残業時間。
	 */
	int getOvertimeAfter();
	
	/**
	 * @return 法定内残業時間。
	 */
	int getOvertimeIn();
	
	/**
	 * @return 法定外残業時間。
	 */
	int getOvertimeOut();
	
	/**
	 * @return 深夜勤務時間。
	 */
	int getLateNightTime();
	
	/**
	 * @return 所定休日勤務時間。
	 */
	int getSpecificWorkTime();
	
	/**
	 * @return 法定休日勤務時間。
	 */
	int getLegalWorkTime();
	
	/**
	 * @return 減額対象時間。
	 */
	int getDecreaseTime();
	
	/**
	 * @return 勤怠コメント。
	 */
	String getTimeComment();
	
	/**
	 * @return ワークフロー番号。
	 */
	long getWorkflow();
	
	/**
	 * @param tmdAttendanceId セットする レコード識別ID。
	 */
	void setTmdAttendanceId(long tmdAttendanceId);
	
	/**
	 * @param personalId セットする 個人ID。
	 */
	void setPersonalId(String personalId);
	
	/**
	 * @param workDate セットする 勤務日。
	 */
	void setWorkDate(Date workDate);
	
	/**
	 * @param timesWork セットする 勤務回数。
	 */
	void setTimesWork(int timesWork);
	
	/**
	 * @param workTypeCode セットする 勤務形態コード。
	 */
	void setWorkTypeCode(String workTypeCode);
	
	/**
	 * @param directStart セットする 直行。
	 */
	void setDirectStart(int directStart);
	
	/**
	 * @param directEnd セットする 直帰。
	 */
	void setDirectEnd(int directEnd);
	
	/**
	 * @param startTime セットする 出勤時刻。
	 */
	void setStartTime(Date startTime);
	
	/**
	 * @param endTime セットする 退勤時刻。
	 */
	void setEndTime(Date endTime);
	
	/**
	 * @param lateTime セットする 遅刻時間。
	 */
	void setLateTime(int lateTime);
	
	/**
	 * @param lateReason セットする 遅刻理由。
	 */
	void setLateReason(String lateReason);
	
	/**
	 * @param lateCertificate セットする 遅刻証明書。
	 */
	void setLateCertificate(String lateCertificate);
	
	/**
	 * @param lateComment セットする 遅刻コメント。
	 */
	void setLateComment(String lateComment);
	
	/**
	 * @param leaveEarlyTime セットする 早退時間。
	 */
	void setLeaveEarlyTime(int leaveEarlyTime);
	
	/**
	 * @param leaveEarlyReason セットする 早退理由。
	 */
	void setLeaveEarlyReason(String leaveEarlyReason);
	
	/**
	 * @param leaveEarlyCertificate セットする 早退証明書。
	 */
	void setLeaveEarlyCertificate(String leaveEarlyCertificate);
	
	/**
	 * @param leaveEarlyComment セットする 早退コメント。
	 */
	void setLeaveEarlyComment(String leaveEarlyComment);
	
	/**
	 * @param workTime セットする 勤務時間。
	 */
	void setWorkTime(int workTime);
	
	/**
	 * @param generalWorkTime セットする 所定労働時間。
	 */
	void setGeneralWorkTime(int generalWorkTime);
	
	/**
	 * @param restTime セットする 休憩時間。
	 */
	void setRestTime(int restTime);
	
	/**
	 * @param overtimeIn セットする 法定内残業時間。
	 */
	void setOvertimeIn(int overtimeIn);
	
	/**
	 * @param overRestTime セットする 法定外休憩時間。
	 */
	void setOverRestTime(int overRestTime);
	
	/**
	 * @param nightRestTime セットする 深夜休憩時間。
	 */
	void setNightRestTime(int nightRestTime);
	
	/**
	 * @param publicTime セットする 公用外出時間。
	 */
	void setPublicTime(int publicTime);
	
	/**
	 * @param privateTime セットする 私用外出時間。
	 */
	void setPrivateTime(int privateTime);
	
	/**
	 * @param overtime セットする 残業時間。
	 */
	void setOvertime(int overtime);
	
	/**
	 * @param overtimeBefore セットする 前残業時間。
	 */
	void setOvertimeBefore(int overtimeBefore);
	
	/**
	 * @param overtimeAfter セットする 後残業時間。
	 */
	void setOvertimeAfter(int overtimeAfter);
	
	/**
	 * @param overtimeOut セットする 法定外残業時間。
	 */
	void setOvertimeOut(int overtimeOut);
	
	/**
	 * @param lateNightTime セットする 深夜勤務時間。
	 */
	void setLateNightTime(int lateNightTime);
	
	/**
	 * @param specificWorkTime セットする 所定休日勤務時間。
	 */
	void setSpecificWorkTime(int specificWorkTime);
	
	/**
	 * @param legalWorkTime セットする 法定休日勤務時間。
	 */
	void setLegalWorkTime(int legalWorkTime);
	
	/**
	 * @param decreaseTime セットする 減額対象時間。
	 */
	void setDecreaseTime(int decreaseTime);
	
	/**
	 * @param timeComment セットする 勤怠コメント。
	 */
	void setTimeComment(String timeComment);
	
	/**
	 * @param workflow セットする ワークフロー番号。
	 */
	void setWorkflow(long workflow);
}
