/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.management.vo;

import jp.mosp.time.base.TimeVo;

/**
 * 未承認情報を格納する。
 */
public class ApprovalCardVo extends TimeVo {
	
	private static final long	serialVersionUID	= -4422335989484227811L;
	
	// ワークフローコメント
	private String				txtAttendanceComment;
	private String				txtOverTimeComment;
	private String				txtHolidayComment;
	private String				txtWorkOnHolidayComment;
	private String				txtCompensationComment;
	private String				txtDifferenceComment;
	
	// 日付情報
	private String				lblYear;
	private String				lblMonth;
	private String				lblDay;
	
	// 勤怠データ修正情報
	private String				lblCorrectionHistory;
	
	// 出退勤情報
	private String				lblStartTime;
	private String				lblEndTime;
	private String				lblWorkTime;
	private String				lblWorkType;
	private String				lblDirectWorkManage;
	private String				lblTimeComment;
	
	// 勤怠休憩情報
	private String				lblRestTime;
	private String				lblOverRestTime;
	private String				lblNightRestTime;
	private String				lblRestTime1;
	private String				lblRestTime2;
	private String				lblRestTime3;
	private String				lblRestTime4;
	private String				lblRestTime5;
	private String				lblRestTime6;
	private String				lblPublicTime;
	private String				lblPublicTime1;
	private String				lblPublicTime2;
	private String				lblPrivateTime;
	private String				lblPrivateTime1;
	private String				lblPrivateTime2;
	
	// 勤怠遅刻早退情報
	private String				lblLateTime;
	private String				lblLateReason;
	private String				lblLateCertificate;
	private String				lblLateComment;
	private String				lblLeaveEarlyTime;
	private String				lblLeaveEarlyReason;
	private String				lblLeaveEarlyCertificate;
	private String				lblLeaveEarlyComment;
	
	// 勤怠残業情報
	private String				lblOverTimeIn;
	private String				lblOverTimeOut;
	private String				lblLateNightTime;
	private String				lblSpecificWorkTimeIn;
	private String				lblSpecificWorkTimeOver;
	private String				lblLegalWorkTime;
	private String				lblDecreaseTime;
	
	// 勤怠情報承認状況
	private String				lblAttendanceState;
	private String				lblAttendanceApprover;
	private String				lblAttendanceComment;
	
	// 残業申請関連情報
	private String				lblOverTimeType;
	private String				lblOverTimeSchedule;
	private String				lblOverTimeResult;
	private String				lblOverTimeReason;
	private String				lblOverTimeState;
	private String				lblOverTimeApprover;
	private String				lblOverTimeComment;
	
	// 休暇申請関連情報
	private String				lblHolidayType;
	private String				lblHolidayLength;
	private String				lblHolidayTime;
	private String				lblHolidayReason;
	private String				lblHolidayState;
	private String				lblHolidayApprover;
	private String				lblHolidayComment;
	
	// 休出振休申請関連情報
	private String				lblWorkOnHolidayDate;
	private String				lblWorkOnHolidayTime;
	private String				lblWorkOnHolidayTransferDate;
	private String				lblWorkOnHolidayReason;
	private String				lblWorkOnHolidayState;
	private String				lblWorkOnHolidayApprover;
	private String				lblWorkOnHolidayComment;
	
	// 代休申請関連情報
	private String				lblSubHolidayDate;
	private String				lblSubHolidayWorkDate;
	private String				lblSubHolidayState;
	private String				lblSubHolidayApprover;
	private String				lblSubHolidayComment;
	
	// 時差出勤申請関連情報
	private String				lblDifferenceDate;
	private String				lblDifferenceState;
	private String				lblDifferenceWorkType;
	private String				lblDifferenceReason;
	private String				lblDifferenceWorkTime;
	private String				lblDifferenceApprover;
	private String				lblDifferenceComment;
	
	/**
	 * 申請確認詳細フラグ。<br>
	 * true：申請確認詳細、false：未承認情報詳細。<br>
	 */
	private boolean				isConfirmation;
	
	/**
	 * 申請カテゴリフラグ(勤怠)。
	 */
	private boolean				isAttendance;
	
	/**
	 * 申請カテゴリフラグ(残業)。
	 */
	private boolean				isOvertime;
	
	/**
	 * 申請カテゴリフラグ(休暇)。
	 */
	private boolean				isHoliday;
	
	/**
	 * 申請カテゴリフラグ(休出)。
	 */
	private boolean				isWorkOnHoliday;
	
	/**
	 * 申請カテゴリフラグ(代休)。
	 */
	private boolean				isSubHoliday;
	
	/**
	 * 申請カテゴリフラグ(時差出勤)。
	 */
	private boolean				isDifference;
	
	/**
	 * ワークフロー番号。<br>
	 * 承認、差戻、解除の対象となるワークフローを保持する。<br>
	 */
	private Long				workflow;
	
	/**
	 * 承認、差戻ボタン要否。<br>
	 */
	private boolean				needApproveButton;
	
	/**
	 * 承認解除ボタン要否。<br>
	 */
	private boolean				needCancelButton;
	

	/**
	 * @return txtAttendanceComment
	 */
	public String getTxtAttendanceComment() {
		return txtAttendanceComment;
	}
	
	/**
	 * @param txtAttendanceComment セットする txtAttendanceComment
	 */
	public void setTxtAttendanceComment(String txtAttendanceComment) {
		this.txtAttendanceComment = txtAttendanceComment;
	}
	
	/**
	 * @return txtOverTimeComment
	 */
	public String getTxtOverTimeComment() {
		return txtOverTimeComment;
	}
	
	/**
	 * @param txtOverTimeComment セットする txtOverTimeComment
	 */
	public void setTxtOverTimeComment(String txtOverTimeComment) {
		this.txtOverTimeComment = txtOverTimeComment;
	}
	
	/**
	 * @return txtHolidayComment
	 */
	public String getTxtHolidayComment() {
		return txtHolidayComment;
	}
	
	/**
	 * @param txtHolidayComment セットする txtHolidayComment
	 */
	public void setTxtHolidayComment(String txtHolidayComment) {
		this.txtHolidayComment = txtHolidayComment;
	}
	
	/**
	 * @return txtWorkOnHolidayComment
	 */
	public String getTxtWorkOnHolidayComment() {
		return txtWorkOnHolidayComment;
	}
	
	/**
	 * @param txtWorkOnHolidayComment セットする txtWorkOnHolidayComment
	 */
	public void setTxtWorkOnHolidayComment(String txtWorkOnHolidayComment) {
		this.txtWorkOnHolidayComment = txtWorkOnHolidayComment;
	}
	
	/**
	 * @return txtCompensationComment
	 */
	public String getTxtCompensationComment() {
		return txtCompensationComment;
	}
	
	/**
	 * @param txtCompensationComment セットする txtCompensationComment
	 */
	public void setTxtCompensationComment(String txtCompensationComment) {
		this.txtCompensationComment = txtCompensationComment;
	}
	
	/**
	 * @return lblStartTime
	 */
	public String getLblStartTime() {
		return lblStartTime;
	}
	
	/**
	 * @param lblStartTime セットする lblStartTime
	 */
	public void setLblStartTime(String lblStartTime) {
		this.lblStartTime = lblStartTime;
	}
	
	/**
	 * @return lblEndTime
	 */
	public String getLblEndTime() {
		return lblEndTime;
	}
	
	/**
	 * @param lblEndTime セットする lblEndTime
	 */
	public void setLblEndTime(String lblEndTime) {
		this.lblEndTime = lblEndTime;
	}
	
	/**
	 * @return lblWorkTime
	 */
	public String getLblWorkTime() {
		return lblWorkTime;
	}
	
	/**
	 * @param lblWorkTime セットする lblWorkTime
	 */
	public void setLblWorkTime(String lblWorkTime) {
		this.lblWorkTime = lblWorkTime;
	}
	
	/**
	 * @return lblWorkType
	 */
	public String getLblWorkType() {
		return lblWorkType;
	}
	
	/**
	 * @param lblWorkType セットする lblWorkType
	 */
	public void setLblWorkType(String lblWorkType) {
		this.lblWorkType = lblWorkType;
	}
	
	/**
	 * @return lblCorrectionHistory
	 */
	public String getLblCorrectionHistory() {
		return lblCorrectionHistory;
	}
	
	/**
	 * @param lblCorrectionHistory セットする lblCorrectionHistory
	 */
	public void setLblCorrectionHistory(String lblCorrectionHistory) {
		this.lblCorrectionHistory = lblCorrectionHistory;
	}
	
	/**
	 * @return lblRestTime
	 */
	public String getLblRestTime() {
		return lblRestTime;
	}
	
	/**
	 * @param lblRestTime セットする lblRestTime
	 */
	public void setLblRestTime(String lblRestTime) {
		this.lblRestTime = lblRestTime;
	}
	
	/**
	 * @return lblOverRestTime
	 */
	public String getLblOverRestTime() {
		return lblOverRestTime;
	}
	
	/**
	 * @param lblOverRestTime セットする lblOverRestTime
	 */
	public void setLblOverRestTime(String lblOverRestTime) {
		this.lblOverRestTime = lblOverRestTime;
	}
	
	/**
	 * @return lblNightRestTime
	 */
	public String getLblNightRestTime() {
		return lblNightRestTime;
	}
	
	/**
	 * @param lblNightRestTime セットする lblNightRestTime
	 */
	public void setLblNightRestTime(String lblNightRestTime) {
		this.lblNightRestTime = lblNightRestTime;
	}
	
	/**
	 * @return lblRestTime1
	 */
	public String getLblRestTime1() {
		return lblRestTime1;
	}
	
	/**
	 * @param lblRestTime1 セットする lblRestTime1
	 */
	public void setLblRestTime1(String lblRestTime1) {
		this.lblRestTime1 = lblRestTime1;
	}
	
	/**
	 * @return lblRestTime2
	 */
	public String getLblRestTime2() {
		return lblRestTime2;
	}
	
	/**
	 * @param lblRestTime2 セットする lblRestTime2
	 */
	public void setLblRestTime2(String lblRestTime2) {
		this.lblRestTime2 = lblRestTime2;
	}
	
	/**
	 * @return lblRestTime3
	 */
	public String getLblRestTime3() {
		return lblRestTime3;
	}
	
	/**
	 * @param lblRestTime3 セットする lblRestTime3
	 */
	public void setLblRestTime3(String lblRestTime3) {
		this.lblRestTime3 = lblRestTime3;
	}
	
	/**
	 * @return lblRestTime4
	 */
	public String getLblRestTime4() {
		return lblRestTime4;
	}
	
	/**
	 * @param lblRestTime4 セットする lblRestTime4
	 */
	public void setLblRestTime4(String lblRestTime4) {
		this.lblRestTime4 = lblRestTime4;
	}
	
	/**
	 * @return lblRestTime5
	 */
	public String getLblRestTime5() {
		return lblRestTime5;
	}
	
	/**
	 * @param lblRestTime5 セットする lblRestTime5
	 */
	public void setLblRestTime5(String lblRestTime5) {
		this.lblRestTime5 = lblRestTime5;
	}
	
	/**
	 * @return lblRestTime6
	 */
	public String getLblRestTime6() {
		return lblRestTime6;
	}
	
	/**
	 * @param lblRestTime6 セットする lblRestTime6
	 */
	public void setLblRestTime6(String lblRestTime6) {
		this.lblRestTime6 = lblRestTime6;
	}
	
	/**
	 * @return lblPublicTime
	 */
	public String getLblPublicTime() {
		return lblPublicTime;
	}
	
	/**
	 * @param lblPublicTime セットする lblPublicTime
	 */
	public void setLblPublicTime(String lblPublicTime) {
		this.lblPublicTime = lblPublicTime;
	}
	
	/**
	 * @return lblPublicTime1
	 */
	public String getLblPublicTime1() {
		return lblPublicTime1;
	}
	
	/**
	 * @param lblPublicTime1 セットする lblPublicTime1
	 */
	public void setLblPublicTime1(String lblPublicTime1) {
		this.lblPublicTime1 = lblPublicTime1;
	}
	
	/**
	 * @return lblPublicTime2
	 */
	public String getLblPublicTime2() {
		return lblPublicTime2;
	}
	
	/**
	 * @param lblPublicTime2 セットする lblPublicTime2
	 */
	public void setLblPublicTime2(String lblPublicTime2) {
		this.lblPublicTime2 = lblPublicTime2;
	}
	
	/**
	 * @return lblPrivateTime
	 */
	public String getLblPrivateTime() {
		return lblPrivateTime;
	}
	
	/**
	 * @param lblPrivateTime セットする lblPrivateTime
	 */
	public void setLblPrivateTime(String lblPrivateTime) {
		this.lblPrivateTime = lblPrivateTime;
	}
	
	/**
	 * @return lblPrivateTime1
	 */
	public String getLblPrivateTime1() {
		return lblPrivateTime1;
	}
	
	/**
	 * @param lblPrivateTime1 セットする lblPrivateTime1
	 */
	public void setLblPrivateTime1(String lblPrivateTime1) {
		this.lblPrivateTime1 = lblPrivateTime1;
	}
	
	/**
	 * @return lblPrivateTime2
	 */
	public String getLblPrivateTime2() {
		return lblPrivateTime2;
	}
	
	/**
	 * @param lblPrivateTime2 セットする lblPrivateTime2
	 */
	public void setLblPrivateTime2(String lblPrivateTime2) {
		this.lblPrivateTime2 = lblPrivateTime2;
	}
	
	/**
	 * @return lblLateTime
	 */
	public String getLblLateTime() {
		return lblLateTime;
	}
	
	/**
	 * @param lblLateTime セットする lblLateTime
	 */
	public void setLblLateTime(String lblLateTime) {
		this.lblLateTime = lblLateTime;
	}
	
	/**
	 * @return lblLateReason
	 */
	public String getLblLateReason() {
		return lblLateReason;
	}
	
	/**
	 * @param lblLateReason セットする lblLateReason
	 */
	public void setLblLateReason(String lblLateReason) {
		this.lblLateReason = lblLateReason;
	}
	
	/**
	 * @return lblLateCertificate
	 */
	public String getLblLateCertificate() {
		return lblLateCertificate;
	}
	
	/**
	 * @param lblLateCertificate セットする lblLateCertificate
	 */
	public void setLblLateCertificate(String lblLateCertificate) {
		this.lblLateCertificate = lblLateCertificate;
	}
	
	/**
	 * @return lblLateComment
	 */
	public String getLblLateComment() {
		return lblLateComment;
	}
	
	/**
	 * @param lblLateComment セットする lblLateComment
	 */
	public void setLblLateComment(String lblLateComment) {
		this.lblLateComment = lblLateComment;
	}
	
	/**
	 * @return lblLeaveEarlyTime
	 */
	public String getLblLeaveEarlyTime() {
		return lblLeaveEarlyTime;
	}
	
	/**
	 * @param lblLeaveEarlyTime セットする lblLeaveEarlyTime
	 */
	public void setLblLeaveEarlyTime(String lblLeaveEarlyTime) {
		this.lblLeaveEarlyTime = lblLeaveEarlyTime;
	}
	
	/**
	 * @return lblLeaveEarlyReason
	 */
	public String getLblLeaveEarlyReason() {
		return lblLeaveEarlyReason;
	}
	
	/**
	 * @param lblLeaveEarlyReason セットする lblLeaveEarlyReason
	 */
	public void setLblLeaveEarlyReason(String lblLeaveEarlyReason) {
		this.lblLeaveEarlyReason = lblLeaveEarlyReason;
	}
	
	/**
	 * @return lblLeaveEarlyCertificate
	 */
	public String getLblLeaveEarlyCertificate() {
		return lblLeaveEarlyCertificate;
	}
	
	/**
	 * @param lblLeaveEarlyCertificate セットする lblLeaveEarlyCertificate
	 */
	public void setLblLeaveEarlyCertificate(String lblLeaveEarlyCertificate) {
		this.lblLeaveEarlyCertificate = lblLeaveEarlyCertificate;
	}
	
	/**
	 * @return lblLeaveEarlyComment
	 */
	public String getLblLeaveEarlyComment() {
		return lblLeaveEarlyComment;
	}
	
	/**
	 * @param lblLeaveEarlyComment セットする lblLeaveEarlyComment
	 */
	public void setLblLeaveEarlyComment(String lblLeaveEarlyComment) {
		this.lblLeaveEarlyComment = lblLeaveEarlyComment;
	}
	
	/**
	 * @return lblOverTimeIn
	 */
	public String getLblOverTimeIn() {
		return lblOverTimeIn;
	}
	
	/**
	 * @param lblOverTimeIn セットする lblOverTimeIn
	 */
	public void setLblOverTimeIn(String lblOverTimeIn) {
		this.lblOverTimeIn = lblOverTimeIn;
	}
	
	/**
	 * @return lblOverTimeOut
	 */
	public String getLblOverTimeOut() {
		return lblOverTimeOut;
	}
	
	/**
	 * @param lblOverTimeOut セットする lblOverTimeOut
	 */
	public void setLblOverTimeOut(String lblOverTimeOut) {
		this.lblOverTimeOut = lblOverTimeOut;
	}
	
	/**
	 * @return lblLateNightTime
	 */
	public String getLblLateNightTime() {
		return lblLateNightTime;
	}
	
	/**
	 * @param lblLateNightTime セットする lblLateNightTime
	 */
	public void setLblLateNightTime(String lblLateNightTime) {
		this.lblLateNightTime = lblLateNightTime;
	}
	
	/**
	 * @return lblSpecificWorkTimeIn
	 */
	public String getLblSpecificWorkTimeIn() {
		return lblSpecificWorkTimeIn;
	}
	
	/**
	 * @param lblSpecificWorkTimeIn セットする lblSpecificWorkTimeIn
	 */
	public void setLblSpecificWorkTimeIn(String lblSpecificWorkTimeIn) {
		this.lblSpecificWorkTimeIn = lblSpecificWorkTimeIn;
	}
	
	/**
	 * @return lblSpecificWorkTimeOver
	 */
	public String getLblSpecificWorkTimeOver() {
		return lblSpecificWorkTimeOver;
	}
	
	/**
	 * @param lblSpecificWorkTimeOver セットする lblSpecificWorkTimeOver
	 */
	public void setLblSpecificWorkTimeOver(String lblSpecificWorkTimeOver) {
		this.lblSpecificWorkTimeOver = lblSpecificWorkTimeOver;
	}
	
	/**
	 * @return lblLegalWorkTime
	 */
	public String getLblLegalWorkTime() {
		return lblLegalWorkTime;
	}
	
	/**
	 * @param lblLegalWorkTime セットする lblLegalWorkTime
	 */
	public void setLblLegalWorkTime(String lblLegalWorkTime) {
		this.lblLegalWorkTime = lblLegalWorkTime;
	}
	
	/**
	 * @return lblDecreaseTime
	 */
	public String getLblDecreaseTime() {
		return lblDecreaseTime;
	}
	
	/**
	 * @param lblDecreaseTime セットする lblDecreaseTime
	 */
	public void setLblDecreaseTime(String lblDecreaseTime) {
		this.lblDecreaseTime = lblDecreaseTime;
	}
	
	/**
	 * @return lblAttendanceState
	 */
	public String getLblAttendanceState() {
		return lblAttendanceState;
	}
	
	/**
	 * @param lblAttendanceState セットする lblAttendanceState
	 */
	public void setLblAttendanceState(String lblAttendanceState) {
		this.lblAttendanceState = lblAttendanceState;
	}
	
	/**
	 * @return lblAttendanceApprover
	 */
	public String getLblAttendanceApprover() {
		return lblAttendanceApprover;
	}
	
	/**
	 * @param lblAttendanceApprover セットする lblAttendanceApprover
	 */
	public void setLblAttendanceApprover(String lblAttendanceApprover) {
		this.lblAttendanceApprover = lblAttendanceApprover;
	}
	
	/**
	 * @return lblAttendanceComment
	 */
	public String getLblAttendanceComment() {
		return lblAttendanceComment;
	}
	
	/**
	 * @param lblAttendanceComment セットする lblAttendanceComment
	 */
	public void setLblAttendanceComment(String lblAttendanceComment) {
		this.lblAttendanceComment = lblAttendanceComment;
	}
	
	/**
	 * @return lblOverTimeType
	 */
	public String getLblOverTimeType() {
		return lblOverTimeType;
	}
	
	/**
	 * @param lblOverTimeType セットする lblOverTimeType
	 */
	public void setLblOverTimeType(String lblOverTimeType) {
		this.lblOverTimeType = lblOverTimeType;
	}
	
	/**
	 * @return lblOverTimeSchedule
	 */
	public String getLblOverTimeSchedule() {
		return lblOverTimeSchedule;
	}
	
	/**
	 * @param lblOverTimeSchedule セットする lblOverTimeSchedule
	 */
	public void setLblOverTimeSchedule(String lblOverTimeSchedule) {
		this.lblOverTimeSchedule = lblOverTimeSchedule;
	}
	
	/**
	 * @return lblOverTimeResult
	 */
	public String getLblOverTimeResult() {
		return lblOverTimeResult;
	}
	
	/**
	 * @param lblOverTimeResult セットする lblOverTimeResult
	 */
	public void setLblOverTimeResult(String lblOverTimeResult) {
		this.lblOverTimeResult = lblOverTimeResult;
	}
	
	/**
	 * @return lblOverTimeReason
	 */
	public String getLblOverTimeReason() {
		return lblOverTimeReason;
	}
	
	/**
	 * @param lblOverTimeReason セットする lblOverTimeReason
	 */
	public void setLblOverTimeReason(String lblOverTimeReason) {
		this.lblOverTimeReason = lblOverTimeReason;
	}
	
	/**
	 * @return lblOverTimeState
	 */
	public String getLblOverTimeState() {
		return lblOverTimeState;
	}
	
	/**
	 * @param lblOverTimeState セットする lblOverTimeState
	 */
	public void setLblOverTimeState(String lblOverTimeState) {
		this.lblOverTimeState = lblOverTimeState;
	}
	
	/**
	 * @return lblOverTimeApprover
	 */
	public String getLblOverTimeApprover() {
		return lblOverTimeApprover;
	}
	
	/**
	 * @param lblOverTimeApprover セットする lblOverTimeApprover
	 */
	public void setLblOverTimeApprover(String lblOverTimeApprover) {
		this.lblOverTimeApprover = lblOverTimeApprover;
	}
	
	/**
	 * @return lblOverTimeComment
	 */
	public String getLblOverTimeComment() {
		return lblOverTimeComment;
	}
	
	/**
	 * @param lblOverTimeComment セットする lblOverTimeComment
	 */
	public void setLblOverTimeComment(String lblOverTimeComment) {
		this.lblOverTimeComment = lblOverTimeComment;
	}
	
	/**
	 * @return lblHolidayType
	 */
	public String getLblHolidayType() {
		return lblHolidayType;
	}
	
	/**
	 * @param lblHolidayType セットする lblHolidayType
	 */
	public void setLblHolidayType(String lblHolidayType) {
		this.lblHolidayType = lblHolidayType;
	}
	
	/**
	 * @return lblHolidayLength
	 */
	public String getLblHolidayLength() {
		return lblHolidayLength;
	}
	
	/**
	 * @param lblHolidayLength セットする lblHolidayLength
	 */
	public void setLblHolidayLength(String lblHolidayLength) {
		this.lblHolidayLength = lblHolidayLength;
	}
	
	/**
	 * @return lblHolidayTime
	 */
	public String getLblHolidayTime() {
		return lblHolidayTime;
	}
	
	/**
	 * @param lblHolidayTime セットする lblHolidayTime
	 */
	public void setLblHolidayTime(String lblHolidayTime) {
		this.lblHolidayTime = lblHolidayTime;
	}
	
	/**
	 * @return lblHolidayReason
	 */
	public String getLblHolidayReason() {
		return lblHolidayReason;
	}
	
	/**
	 * @param lblHolidayReason セットする lblHolidayReason
	 */
	public void setLblHolidayReason(String lblHolidayReason) {
		this.lblHolidayReason = lblHolidayReason;
	}
	
	/**
	 * @return lblHolidayState
	 */
	public String getLblHolidayState() {
		return lblHolidayState;
	}
	
	/**
	 * @param lblHolidayState セットする lblHolidayState
	 */
	public void setLblHolidayState(String lblHolidayState) {
		this.lblHolidayState = lblHolidayState;
	}
	
	/**
	 * @return lblHolidayApprover
	 */
	public String getLblHolidayApprover() {
		return lblHolidayApprover;
	}
	
	/**
	 * @param lblHolidayApprover セットする lblHolidayApprover
	 */
	public void setLblHolidayApprover(String lblHolidayApprover) {
		this.lblHolidayApprover = lblHolidayApprover;
	}
	
	/**
	 * @return lblHolidayComment
	 */
	public String getLblHolidayComment() {
		return lblHolidayComment;
	}
	
	/**
	 * @param lblHolidayComment セットする lblHolidayComment
	 */
	public void setLblHolidayComment(String lblHolidayComment) {
		this.lblHolidayComment = lblHolidayComment;
	}
	
	/**
	 * @return lblWorkOnHolidayDate
	 */
	public String getLblWorkOnHolidayDate() {
		return lblWorkOnHolidayDate;
	}
	
	/**
	 * @param lblWorkOnHolidayDate セットする lblWorkOnHolidayDate
	 */
	public void setLblWorkOnHolidayDate(String lblWorkOnHolidayDate) {
		this.lblWorkOnHolidayDate = lblWorkOnHolidayDate;
	}
	
	/**
	 * @return lblWorkOnHolidayTime
	 */
	public String getLblWorkOnHolidayTime() {
		return lblWorkOnHolidayTime;
	}
	
	/**
	 * @param lblWorkOnHolidayTime セットする lblWorkOnHolidayTime
	 */
	public void setLblWorkOnHolidayTime(String lblWorkOnHolidayTime) {
		this.lblWorkOnHolidayTime = lblWorkOnHolidayTime;
	}
	
	/**
	 * @return lblWorkOnHolidayTransferDate
	 */
	public String getLblWorkOnHolidayTransferDate() {
		return lblWorkOnHolidayTransferDate;
	}
	
	/**
	 * @param lblWorkOnHolidayTransferDate セットする lblWorkOnHolidayTransferDate
	 */
	public void setLblWorkOnHolidayTransferDate(String lblWorkOnHolidayTransferDate) {
		this.lblWorkOnHolidayTransferDate = lblWorkOnHolidayTransferDate;
	}
	
	/**
	 * @return lblWorkOnHolidayReason
	 */
	public String getLblWorkOnHolidayReason() {
		return lblWorkOnHolidayReason;
	}
	
	/**
	 * @param lblWorkOnHolidayReason セットする lblWorkOnHolidayReason
	 */
	public void setLblWorkOnHolidayReason(String lblWorkOnHolidayReason) {
		this.lblWorkOnHolidayReason = lblWorkOnHolidayReason;
	}
	
	/**
	 * @return lblWorkOnHolidayState
	 */
	public String getLblWorkOnHolidayState() {
		return lblWorkOnHolidayState;
	}
	
	/**
	 * @param lblWorkOnHolidayState セットする lblWorkOnHolidayState
	 */
	public void setLblWorkOnHolidayState(String lblWorkOnHolidayState) {
		this.lblWorkOnHolidayState = lblWorkOnHolidayState;
	}
	
	/**
	 * @return lblWorkOnHolidayApprover
	 */
	public String getLblWorkOnHolidayApprover() {
		return lblWorkOnHolidayApprover;
	}
	
	/**
	 * @param lblWorkOnHolidayApprover セットする lblWorkOnHolidayApprover
	 */
	public void setLblWorkOnHolidayApprover(String lblWorkOnHolidayApprover) {
		this.lblWorkOnHolidayApprover = lblWorkOnHolidayApprover;
	}
	
	/**
	 * @return lblWorkOnHolidayComment
	 */
	public String getLblWorkOnHolidayComment() {
		return lblWorkOnHolidayComment;
	}
	
	/**
	 * @param lblWorkOnHolidayComment セットする lblWorkOnHolidayComment
	 */
	public void setLblWorkOnHolidayComment(String lblWorkOnHolidayComment) {
		this.lblWorkOnHolidayComment = lblWorkOnHolidayComment;
	}
	
	/**
	 * @return lblSubHolidayDate
	 */
	public String getLblSubHolidayDate() {
		return lblSubHolidayDate;
	}
	
	/**
	 * @param lblSubHolidayDate セットする lblSubHolidayDate
	 */
	public void setLblSubHolidayDate(String lblSubHolidayDate) {
		this.lblSubHolidayDate = lblSubHolidayDate;
	}
	
	/**
	 * @return lblSubHolidayWorkDate
	 */
	public String getLblSubHolidayWorkDate() {
		return lblSubHolidayWorkDate;
	}
	
	/**
	 * @param lblSubHolidayWorkDate セットする lblSubHolidayWorkDate
	 */
	public void setLblSubHolidayWorkDate(String lblSubHolidayWorkDate) {
		this.lblSubHolidayWorkDate = lblSubHolidayWorkDate;
	}
	
	/**
	 * @return lblSubHolidayState
	 */
	public String getLblSubHolidayState() {
		return lblSubHolidayState;
	}
	
	/**
	 * @param lblSubHolidayState セットする lblSubHolidayState
	 */
	public void setLblSubHolidayState(String lblSubHolidayState) {
		this.lblSubHolidayState = lblSubHolidayState;
	}
	
	/**
	 * @return lblSubHolidayApprover
	 */
	public String getLblSubHolidayApprover() {
		return lblSubHolidayApprover;
	}
	
	/**
	 * @param lblSubHolidayApprover セットする lblSubHolidayApprover
	 */
	public void setLblSubHolidayApprover(String lblSubHolidayApprover) {
		this.lblSubHolidayApprover = lblSubHolidayApprover;
	}
	
	/**
	 * @return lblSubHolidayComment
	 */
	public String getLblSubHolidayComment() {
		return lblSubHolidayComment;
	}
	
	/**
	 * @param lblSubHolidayComment セットする lblSubHolidayComment
	 */
	public void setLblSubHolidayComment(String lblSubHolidayComment) {
		this.lblSubHolidayComment = lblSubHolidayComment;
	}
	
	/**
	 * @return lblDifferenceDate
	 */
	public String getLblDifferenceDate() {
		return lblDifferenceDate;
	}
	
	/**
	 * @param lblDifferenceDate セットする lblDifferenceDate
	 */
	public void setLblDifferenceDate(String lblDifferenceDate) {
		this.lblDifferenceDate = lblDifferenceDate;
	}
	
	/**
	 * @return lblDifferenceState
	 */
	public String getLblDifferenceState() {
		return lblDifferenceState;
	}
	
	/**
	 * @param lblDifferenceState セットする lblDifferenceState
	 */
	public void setLblDifferenceState(String lblDifferenceState) {
		this.lblDifferenceState = lblDifferenceState;
	}
	
	/**
	 * @return lblDifferenceWorkType
	 */
	public String getLblDifferenceWorkType() {
		return lblDifferenceWorkType;
	}
	
	/**
	 * @param lblDifferenceWorkType セットする lblDifferenceWorkType
	 */
	public void setLblDifferenceWorkType(String lblDifferenceWorkType) {
		this.lblDifferenceWorkType = lblDifferenceWorkType;
	}
	
	/**
	 * @return lblDifferenceReason
	 */
	public String getLblDifferenceReason() {
		return lblDifferenceReason;
	}
	
	/**
	 * @param lblDifferenceReason セットする lblDifferenceReason
	 */
	public void setLblDifferenceReason(String lblDifferenceReason) {
		this.lblDifferenceReason = lblDifferenceReason;
	}
	
	/**
	 * @return lblDifferenceWorkTime
	 */
	public String getLblDifferenceWorkTime() {
		return lblDifferenceWorkTime;
	}
	
	/**
	 * @param lblDifferenceWorkTime セットする lblDifferenceWorkTime
	 */
	public void setLblDifferenceWorkTime(String lblDifferenceWorkTime) {
		this.lblDifferenceWorkTime = lblDifferenceWorkTime;
	}
	
	/**
	 * @return lblDifferenceApprover
	 */
	public String getLblDifferenceApprover() {
		return lblDifferenceApprover;
	}
	
	/**
	 * @param lblDifferenceApprover セットする lblDifferenceApprover
	 */
	public void setLblDifferenceApprover(String lblDifferenceApprover) {
		this.lblDifferenceApprover = lblDifferenceApprover;
	}
	
	/**
	 * @return lblDifferenceComment
	 */
	public String getLblDifferenceComment() {
		return lblDifferenceComment;
	}
	
	/**
	 * @param lblDifferenceComment セットする lblDifferenceComment
	 */
	public void setLblDifferenceComment(String lblDifferenceComment) {
		this.lblDifferenceComment = lblDifferenceComment;
	}
	
	/**
	 * @return isConfirmation
	 */
	public boolean isConfirmation() {
		return isConfirmation;
	}
	
	/**
	 * @param isConfirmation セットする isConfirmation
	 */
	public void setConfirmation(boolean isConfirmation) {
		this.isConfirmation = isConfirmation;
	}
	
	/**
	 * @return isAttendance
	 */
	public boolean isAttendance() {
		return isAttendance;
	}
	
	/**
	 * @param isAttendance セットする isAttendance
	 */
	public void setAttendance(boolean isAttendance) {
		this.isAttendance = isAttendance;
	}
	
	/**
	 * @return isOvertime
	 */
	public boolean isOvertime() {
		return isOvertime;
	}
	
	/**
	 * @param isOvertime セットする isOvertime
	 */
	public void setOvertime(boolean isOvertime) {
		this.isOvertime = isOvertime;
	}
	
	/**
	 * @return isHoliday
	 */
	public boolean isHoliday() {
		return isHoliday;
	}
	
	/**
	 * @param isHoliday セットする isHoliday
	 */
	public void setHoliday(boolean isHoliday) {
		this.isHoliday = isHoliday;
	}
	
	/**
	 * @return isWorkOnHoliday
	 */
	public boolean isWorkOnHoliday() {
		return isWorkOnHoliday;
	}
	
	/**
	 * @param isWorkOnHoliday セットする isWorkOnHoliday
	 */
	public void setWorkOnHoliday(boolean isWorkOnHoliday) {
		this.isWorkOnHoliday = isWorkOnHoliday;
	}
	
	/**
	 * @return isSubHoliday
	 */
	public boolean isSubHoliday() {
		return isSubHoliday;
	}
	
	/**
	 * @param isSubHoliday セットする isSubHoliday
	 */
	public void setSubHoliday(boolean isSubHoliday) {
		this.isSubHoliday = isSubHoliday;
	}
	
	/**
	 * @return isDifference
	 */
	public boolean isDifference() {
		return isDifference;
	}
	
	/**
	 * @param isDifference セットする isDifference
	 */
	public void setDifference(boolean isDifference) {
		this.isDifference = isDifference;
	}
	
	/**
	 * @return txtDifferenceComment
	 */
	public String getTxtDifferenceComment() {
		return txtDifferenceComment;
	}
	
	/**
	 * @param txtDifferenceComment セットする txtDifferenceComment
	 */
	public void setTxtDifferenceComment(String txtDifferenceComment) {
		this.txtDifferenceComment = txtDifferenceComment;
	}
	
	/**
	 * @return lblDirectWorkManage
	 */
	public String getLblDirectWorkManage() {
		return lblDirectWorkManage;
	}
	
	/**
	 * @param lblDirectWorkManage セットする lblDirectWorkManage
	 */
	public void setLblDirectWorkManage(String lblDirectWorkManage) {
		this.lblDirectWorkManage = lblDirectWorkManage;
	}
	
	/**
	 * @return lblTimeComment
	 */
	public String getLblTimeComment() {
		return lblTimeComment;
	}
	
	/**
	 * @param lblTimeComment セットする lblTimeComment
	 */
	public void setLblTimeComment(String lblTimeComment) {
		this.lblTimeComment = lblTimeComment;
	}
	
	/**
	 * @return lblYear
	 */
	public String getLblYear() {
		return lblYear;
	}
	
	/**
	 * @param lblYear セットする lblYear
	 */
	public void setLblYear(String lblYear) {
		this.lblYear = lblYear;
	}
	
	/**
	 * @return lblMonth
	 */
	public String getLblMonth() {
		return lblMonth;
	}
	
	/**
	 * @param lblMonth セットする lblMonth
	 */
	public void setLblMonth(String lblMonth) {
		this.lblMonth = lblMonth;
	}
	
	/**
	 * @return lblDay
	 */
	public String getLblDay() {
		return lblDay;
	}
	
	/**
	 * @param lblDay セットする lblDay
	 */
	public void setLblDay(String lblDay) {
		this.lblDay = lblDay;
	}
	
	/**
	 * @return workflow
	 */
	public Long getWorkflow() {
		return workflow;
	}
	
	/**
	 * @param workflow セットする workflow
	 */
	public void setWorkflow(Long workflow) {
		this.workflow = workflow;
	}
	
	/**
	 * @return needApproveButton
	 */
	public boolean isNeedApproveButton() {
		return needApproveButton;
	}
	
	/**
	 * @param needApproveButton セットする needApproveButton
	 */
	public void setNeedApproveButton(boolean needApproveButton) {
		this.needApproveButton = needApproveButton;
	}
	
	/**
	 * @return needCancelButton
	 */
	public boolean isNeedCancelButton() {
		return needCancelButton;
	}
	
	/**
	 * @param needCancelButton セットする needCancelButton
	 */
	public void setNeedCancelButton(boolean needCancelButton) {
		this.needCancelButton = needCancelButton;
	}
	
}
